/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.form;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Vector;

class PostData
implements net.hizlab.kagetaka.rendering.PostData {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] CONTENT_DISPOSITION = "Content-Disposition: form-data; name=\"".getBytes();
    private static final byte[] FILENAME = "; filename=\"".getBytes();
    private static final byte[] CONTENT_TYPE = "Content-Type: ".getBytes();
    private static final int BUFFER_SIZE = 512;
    private String data;
    private Vector items;
    private String boundary;
    private int length;
    private String encoding;

    PostData(String data) {
        this.data = data;
        this.length = data.length();
    }

    PostData(Vector items, String boundary, int length, String encoding) {
        this.items = items;
        this.boundary = boundary;
        this.length = length;
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(HttpURLConnection connection) throws IOException {
        block14: {
            connection.setRequestMethod("POST");
            if (this.boundary != null) {
                connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            }
            connection.setRequestProperty("Content-Length", String.valueOf(this.length));
            connection.setDoOutput(true);
            OutputStream os = connection.getOutputStream();
            try {
                if (this.boundary == null) {
                    if (this.data.length() == 0) {
                        return;
                    }
                    os.write(this.data.getBytes());
                    break block14;
                }
                BufferedOutputStream bos = new BufferedOutputStream(os, 512);
                int size = this.items.size();
                Object values = null;
                String[] v1 = new String[1];
                byte[] bboundary = this.boundary.getBytes();
                for (int i = 0; i < size; ++i) {
                    Item item = (Item)this.items.elementAt(i);
                    bos.write(bboundary);
                    bos.write(CRLF);
                    bos.write(CONTENT_DISPOSITION);
                    this.write(bos, item.name, this.encoding);
                    bos.write(34);
                    if (item.type == null) {
                        bos.write(CRLF);
                        bos.write(CRLF);
                        this.write(bos, item.value, this.encoding);
                        bos.write(CRLF);
                        continue;
                    }
                    bos.write(FILENAME);
                    this.write(bos, new File(item.value).getName(), this.encoding);
                    bos.write(34);
                    bos.write(CRLF);
                    bos.write(CONTENT_TYPE);
                    this.write(bos, item.type, this.encoding);
                    bos.write(CRLF);
                    bos.write(CRLF);
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(item.value), 512);
                    byte[] buffer = new byte[512];
                    int readlen = 0;
                    try {
                        while ((readlen = is.read(buffer, 0, 512)) != -1) {
                            bos.write(buffer, 0, readlen);
                        }
                    }
                    finally {
                        ((FilterInputStream)is).close();
                    }
                    bos.write(CRLF);
                }
                if (this.boundary != null) {
                    bos.write(bboundary);
                    bos.write(45);
                    bos.write(45);
                    bos.write(CRLF);
                }
                bos.flush();
            }
            finally {
                os.close();
            }
        }
    }

    private void write(OutputStream os, String value, String encoding) throws IOException {
        try {
            if (encoding == null) {
                os.write(value.getBytes());
            } else {
                os.write(value.getBytes(encoding));
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    static class Item {
        private String name;
        private String value;
        private String type;

        Item(String name, String value, String type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }
    }
}

