/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.form;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageButton;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.image.RotateFilter;
import net.hizlab.kagetaka.awt.tate.Button;
import net.hizlab.kagetaka.awt.tate.Checkbox;
import net.hizlab.kagetaka.awt.tate.CheckboxGroup;
import net.hizlab.kagetaka.awt.tate.Choice;
import net.hizlab.kagetaka.awt.tate.FileField;
import net.hizlab.kagetaka.awt.tate.List;
import net.hizlab.kagetaka.awt.tate.TextArea;
import net.hizlab.kagetaka.awt.tate.TextField;
import net.hizlab.kagetaka.form.ActionSubmit;
import net.hizlab.kagetaka.form.Item;
import net.hizlab.kagetaka.form.ItemButton;
import net.hizlab.kagetaka.form.ItemCheckbox;
import net.hizlab.kagetaka.form.ItemChoice;
import net.hizlab.kagetaka.form.ItemFileField;
import net.hizlab.kagetaka.form.ItemHidden;
import net.hizlab.kagetaka.form.ItemImage;
import net.hizlab.kagetaka.form.ItemList;
import net.hizlab.kagetaka.form.ItemSelect;
import net.hizlab.kagetaka.form.ItemText;
import net.hizlab.kagetaka.form.PostData;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.form.FormAttribute;
import net.hizlab.kagetaka.token.form.InputAttribute;
import net.hizlab.kagetaka.token.form.OptionAttribute;
import net.hizlab.kagetaka.token.form.SelectAttribute;
import net.hizlab.kagetaka.token.form.TextareaAttribute;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.URLEncoder;

class Form {
    private static final String RESOURCE = "net.hizlab.kagetaka.form.Resource";
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_GIF = 1;
    private static final int TYPE_JPEG = 2;
    final HawkContext context;
    final Document document;
    final Option option;
    private StartToken token;
    private Vector items = new Vector();
    private Hashtable radios;
    private ItemSelect select;

    Form(HawkContext context, Document document, StartToken token) {
        this.context = context;
        this.document = document;
        this.option = context.getOption();
        this.token = token;
    }

    Item addItem(StartToken token) {
        Item item = null;
        InputAttribute attr = (InputAttribute)token.getAttribute();
        String type = null;
        String name = null;
        String value = null;
        boolean disabled = false;
        boolean readonly = false;
        if (attr != null) {
            type = attr.getType();
            name = attr.getName();
            value = attr.getValue();
            disabled = attr.getDisabled();
            readonly = attr.getReadonly();
        }
        if (type != null) {
            type = type.toLowerCase();
        }
        if (type == null || type.compareTo("text") == 0 || type.compareTo("password") == 0) {
            int typeInt = type != null && type.compareTo("password") == 0 ? 2 : 1;
            int size = attr != null && attr.getSize() != null ? attr.getSize() : 20;
            TextField c = new TextField(this.option, this.context, value, size);
            if (disabled) {
                c.setEnabled(false);
            }
            if (readonly) {
                c.setLocked(true);
            }
            if (attr != null && attr.getMaxlength() != null) {
                c.setMaxLength(attr.getMaxlength());
            }
            if (typeInt == 2) {
                c.setEchoChar('*');
            }
            item = new ItemText(this, typeInt, name, value, c);
        } else if (type.compareTo("checkbox") == 0) {
            Checkbox c = new Checkbox(this.option, this.context, null, attr != null ? attr.getChecked() : false);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemCheckbox(this, 3, name, value, c);
        } else if (type.compareTo("radio") == 0) {
            CheckboxGroup group = null;
            if (name != null) {
                if (this.radios == null) {
                    this.radios = new Hashtable();
                } else {
                    group = (CheckboxGroup)this.radios.get(name);
                }
            }
            if (group == null) {
                group = new CheckboxGroup();
                if (name != null) {
                    this.radios.put(name, group);
                }
            }
            Checkbox c = new Checkbox(this.option, this.context, null, attr != null ? attr.getChecked() : false, group);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemCheckbox(this, 4, name, value, c);
        } else if (type.compareTo("submit") == 0) {
            String label = value;
            if (label == null) {
                label = Resource.getMessage(RESOURCE, "submit.default", null);
            }
            Button c = new Button(this.option, this.context, label);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemButton(this, 5, name, value, c);
        } else if (type.compareTo("reset") == 0) {
            String label = value;
            if (label == null) {
                label = Resource.getMessage(RESOURCE, "reset.default", null);
            }
            Button c = new Button(this.option, this.context, label);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemButton(this, 6, name, value, c);
        } else if (type.compareTo("file") == 0) {
            FileField c = new FileField(this.option, this.context, value);
            if (disabled) {
                c.setEnabled(false);
            }
            item = new ItemFileField(this, 7, name, value, c);
        } else if (type.compareTo("hidden") == 0) {
            item = new ItemHidden(this, 8, name, value, !disabled);
        } else if (type.compareTo("image") == 0) {
            String src = attr != null ? attr.getSrc() : null;
            String alt = attr != null ? attr.getAlt() : null;
            Image image = null;
            try {
                if (src != null) {
                    Object content;
                    boolean spin = false;
                    URLConnection connection = this.context.getURLConnection(new Request(this.document.createURL(src), null, this.document.url, null, false, false, 2));
                    if (connection != null && (content = connection.getContent()) instanceof ImageProducer) {
                        image = this.context.createImage((ImageProducer)content);
                        image = this.context.createImage(new FilteredImageSource(image.getSource(), new RotateFilter()));
                    }
                }
            }
            catch (SecurityException e) {
                System.out.println(e + "[" + src + "]");
            }
            catch (MalformedURLException e) {
                System.out.println(e + "[" + src + "]");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (image == null && (image = Resource.getImageResource("render.image.notfound", this.context.getToolkit())) == null) {
                return null;
            }
            ImageButton c = new ImageButton(false, image, image, image, image, null, null, null, null);
            if (disabled) {
                c.setEnabled(false);
            } else {
                c.setCursor(Cursor.getPredefinedCursor(12));
            }
            item = new ItemImage(this, 9, name, value, c);
        }
        if (item == null) {
            return null;
        }
        this.items.addElement(item);
        return item.isVisible() ? item : null;
    }

    void beginSelect(StartToken token) {
        SelectAttribute attr = (SelectAttribute)token.getAttribute();
        String name = null;
        Integer size = null;
        boolean multiple = false;
        boolean disabled = false;
        if (attr != null) {
            name = attr.getName();
            size = attr.getSize();
            multiple = attr.getMultiple();
            disabled = attr.getDisabled();
        }
        if (size == null || size == 1) {
            Choice c = new Choice(this.option, this.context);
            if (disabled) {
                c.setEnabled(false);
            }
            c.select(0);
            this.select = new ItemChoice(this, 11, name, c);
        } else {
            List c = new List(this.option, this.context, size, multiple);
            if (disabled) {
                c.setEnabled(false);
            }
            this.select = new ItemList(this, 10, name, c);
        }
    }

    Item endSelect() {
        if (this.select == null) {
            return null;
        }
        this.items.addElement(this.select);
        ItemSelect item = this.select;
        this.select = null;
        return item;
    }

    void addOption(StartToken token) {
        if (this.select == null) {
            return;
        }
        OptionAttribute attr = (OptionAttribute)token.getAttribute();
        String value = null;
        String label = null;
        boolean selected = false;
        if (attr != null) {
            value = attr.getValue();
            label = attr.getLabel();
            selected = attr.getSelected();
        }
        if (label == null && (label = token.getContent()) == null) {
            label = "";
        }
        if (value == null) {
            value = label;
        }
        this.select.addValue(value, label, selected);
    }

    Item addTextarea(StartToken token) {
        String value;
        TextareaAttribute attr = (TextareaAttribute)token.getAttribute();
        String name = null;
        String wrap = null;
        Integer rows = null;
        Integer cols = null;
        boolean disabled = false;
        boolean readonly = false;
        if (attr != null) {
            name = attr.getName();
            rows = attr.getRows();
            cols = attr.getCols();
            disabled = attr.getDisabled();
            readonly = attr.getReadonly();
            wrap = attr.getWrap();
        }
        if (wrap != null) {
            wrap = wrap.toLowerCase();
        }
        if ((value = token.getContent()) != null) {
            int start = 0;
            int end = value.length() - 1;
            if (end >= start && value.charAt(start) == '\r') {
                ++start;
            }
            if (end >= start && value.charAt(start) == '\n') {
                ++start;
            }
            if (end > start && value.charAt(end) == '\n') {
                --end;
            }
            if (end > start && value.charAt(end) == '\r') {
                --end;
            }
            if (start > 0 || end < value.length() - 1) {
                value = value.substring(start, end + 1);
            }
        }
        boolean wordwrap = wrap != null && wrap.compareTo("off") != 0;
        TextArea c = new TextArea(this.option, (ImageCreator)this.context, value, rows == null || rows <= 0 ? 2 : rows, cols == null || cols <= 0 ? 30 : cols, wordwrap ? 2 : 0);
        if (disabled) {
            c.setEnabled(false);
        }
        if (readonly) {
            c.setLocked(true);
        }
        if (wordwrap) {
            c.setWordwrap(true);
        }
        ItemText item = new ItemText(this, 12, name, value, c);
        this.items.addElement(item);
        return item.isVisible() ? item : null;
    }

    void close() {
        int type = 0;
        ItemText it = null;
        for (int i = this.items.size() - 1; i >= 0; --i) {
            type = ((Item)this.items.elementAt((int)i)).type;
            if (type != 1 && type != 2) continue;
            if (it != null) {
                it = null;
                break;
            }
            it = (ItemText)this.items.elementAt(i);
        }
        if (it != null) {
            it.addAction(new ActionSubmit(this, it, false));
        }
    }

    void submit(Item origin) {
        this.submit(origin, 0, 0, false);
    }

    void submit(Item origin, int x, int y, boolean location) {
        PostData pd;
        URL url;
        URL actionUrl = this.document.getBaseURL();
        boolean methodGet = true;
        String encoding = this.document.getEncoding();
        String boundary = null;
        FormAttribute attr = (FormAttribute)this.token.getAttribute();
        if (attr != null) {
            String s = null;
            s = attr.getAction();
            if (s != null) {
                try {
                    actionUrl = this.document.createURL(s);
                }
                catch (SecurityException e) {
                    System.out.println(e + "[" + actionUrl + "],[" + s + "]");
                }
                catch (MalformedURLException e) {
                    System.out.println(e + "[" + actionUrl + "],[" + s + "]");
                }
            }
            if ((s = attr.getMethod()) != null) {
                boolean bl = methodGet = s.toUpperCase().compareTo("POST") != 0;
            }
            if ((s = attr.getEnctype()) != null && s.toLowerCase().compareTo("multipart/form-data") == 0) {
                DecimalFormat df = new DecimalFormat("00000000000000");
                ((NumberFormat)df).setMaximumIntegerDigits(14);
                ((NumberFormat)df).setMinimumIntegerDigits(14);
                boundary = "-----------------------------" + df.format(Math.random() * 1.0E14);
            }
            if ((s = attr.getAcceptCharset()) != null) {
                StringTokenizer st = new StringTokenizer(s, " ");
                while (st.hasMoreTokens()) {
                    s = Charset.toEncoding(st.nextToken());
                    if (s == null) continue;
                    encoding = s;
                    break;
                }
            }
        }
        int size = this.items.size();
        int nameLen = 0;
        String[] values = null;
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        String[] v1 = new String[1];
        Vector<PostData.Item> bitems = new Vector<PostData.Item>();
        int blen = boundary != null ? boundary.length() + 2 : 0;
        int blength = blen + 2;
        for (int i = 0; i < size; ++i) {
            Item item = (Item)this.items.elementAt(i);
            if (item.name == null && item.type != 9 || !item.isEnabled() || item.type == 6 || (item.type == 5 || item.type == 13 || item.type == 9) && item != origin) continue;
            if (item.type == 9) {
                values = new String[]{String.valueOf(x), String.valueOf(y), item.getValue()};
            } else if (item.getMultipleMode()) {
                values = item.getValues();
                if (values == null) {
                    continue;
                }
            } else {
                v1[0] = item.getValue();
                if (v1[0] == null) continue;
                values = v1;
            }
            String name = null;
            block12: for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                if (value == null) continue;
                if (name == null || item.type == 9) {
                    if (item.type == 9) {
                        switch (j) {
                            case 0: {
                                name = item.name != null ? item.name + ".x" : "x";
                                break;
                            }
                            case 1: {
                                name = item.name != null ? item.name + ".y" : "y";
                                break;
                            }
                            case 2: {
                                if (item.name == null) continue block12;
                                name = item.name;
                            }
                        }
                    } else {
                        name = item.name;
                    }
                    if (boundary == null) {
                        name = URLEncoder.encode(name, encoding);
                    } else {
                        nameLen = this.calculateLength(name, encoding);
                    }
                }
                if (boundary == null) {
                    if (!first) {
                        sb.append('&');
                    } else {
                        first = false;
                    }
                    sb.append(name);
                    sb.append('=');
                    sb.append(URLEncoder.encode(value, encoding));
                    continue;
                }
                blength += blen;
                blength += 45;
                blength += nameLen;
                if (item instanceof ItemFileField) {
                    ItemFileField iff = (ItemFileField)item;
                    String type = iff.getContentType();
                    File file = new File(value);
                    blength += 13;
                    blength += file.getName().length();
                    blength += 16;
                    blength += type.length();
                    blength = (int)((long)blength + file.length());
                    bitems.addElement(new PostData.Item(name, value, type));
                    continue;
                }
                blength += this.calculateLength(value, encoding);
                bitems.addElement(new PostData.Item(name, value, null));
            }
        }
        if (methodGet) {
            url = actionUrl;
            try {
                url = new URL(actionUrl.toExternalForm() + "?" + sb.toString());
            }
            catch (MalformedURLException e) {
                System.out.println(e + "[" + actionUrl.toExternalForm() + "?" + sb.toString() + "]");
            }
            pd = null;
        } else if (boundary == null) {
            url = actionUrl;
            pd = new PostData(sb.toString());
        } else {
            url = actionUrl;
            pd = new PostData(bitems, boundary, blength, encoding);
        }
        this.context.openHawk(new Request(url, pd, this.document.url, null, false, false, 1));
    }

    void reset() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            ((Item)this.items.elementAt(i)).reset();
        }
    }

    private int calculateLength(String value, String encoding) {
        try {
            if (encoding == null) {
                return value.getBytes().length;
            }
            return value.getBytes(encoding).length;
        }
        catch (UnsupportedEncodingException e) {
            return 0;
        }
    }
}

