/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.download;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.text.ParseException;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.AWTEventMulticaster;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.ProgressBar;
import net.hizlab.kagetaka.awt.QuietPanel;
import net.hizlab.kagetaka.awt.SizedButton;
import net.hizlab.kagetaka.awt.event.StateEvent;
import net.hizlab.kagetaka.awt.event.StateListener;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.io.CounterInputStream;
import net.hizlab.kagetaka.io.CounterListener;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.util.ContentHeaderParser;
import net.hizlab.kagetaka.util.StringUtils;
import net.hizlab.kagetaka.viewer.HawkWindow;
import net.hizlab.kagetaka.viewer.WindowManager;

public class Download
extends Frame
implements HawkWindow {
    private static final String RESOURCE = "net.hizlab.kagetaka.download.Resource";
    private static final int MARGIN = 10;
    private static final int BUTTON_LENGTH = 8;
    public static final int START = 1;
    public static final int STOP = 2;
    public static final int COMPLETE = 3;
    public static final int ERRORED = 4;
    public static final int SUSPEND = 5;
    public static final int RESUME = 6;
    private TextField textUrl;
    private TextField textPath;
    private Label labelState;
    private Label labelRemain;
    private Label labelProcess;
    private Label labelProgress;
    private ProgressBar progressBar;
    private Checkbox checkKeepOpen;
    private Button buttonClose;
    private MessageFormat mfTitle;
    private MessageFormat mfState;
    private MessageFormat mfRemain;
    private MessageFormat mfProcess;
    private MessageFormat mfProgress;
    private ViewerOption option;
    private URLConnection connection;
    private File filePath;
    private WindowManager wm;
    private DownloadThread thread;
    private boolean complete;
    private int resumeLength;
    private transient StateListener stateListener;

    public static File show(Frame owner, ViewerOption option, URLConnection connection, StateListener l) {
        File path = null;
        String fileName = null;
        String cd = connection.getHeaderField("Content-Disposition");
        if (cd != null) {
            try {
                ContentHeaderParser.Data data = ContentHeaderParser.parse(cd);
                fileName = (String)data.parameters.get("filename");
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (fileName == null) {
            fileName = StringUtils.getFile(connection.getURL());
        }
        FileDialog fd = new FileDialog(owner, Resource.getMessage(RESOURCE, "download.savedialog.title", null), 1);
        File dir = option.getPropertyFile("download.save.path");
        if (dir != null) {
            fd.setDirectory(dir.toString());
        }
        fd.setFile(fileName);
        fd.show();
        String pathName = fd.getFile();
        if (pathName == null) {
            fd.dispose();
            return null;
        }
        String newDir = fd.getDirectory();
        if (newDir != null) {
            dir = new File(newDir);
            Setter setter = option.getSetter();
            try {
                setter.putPropertyFile("download.save.path", dir);
                setter.commit();
            }
            catch (InvalidValueException e) {
                // empty catch block
            }
        }
        path = dir != null ? new File(dir, pathName) : new File(pathName);
        fd.dispose();
        Download dialog = new Download(option, connection, path);
        dialog.addStateListener(l);
        dialog.show();
        dialog.start();
        return path;
    }

    public Download(ViewerOption option, URLConnection connection, File path) {
        this.option = option;
        this.connection = connection;
        this.filePath = path;
        this.wm = WindowManager.getInstance();
        this.mfTitle = new MessageFormat(this.getMessage("title.format"));
        this.mfState = new MessageFormat(this.getMessage("state.format"));
        this.mfRemain = new MessageFormat(this.getMessage("remain.format"));
        this.mfProcess = new MessageFormat(this.getMessage("process.format"));
        this.mfProgress = new MessageFormat(this.getMessage("progressbar.format"));
        this.thread = new DownloadThread();
        ((Component)this).setFont(new Font("Dialog", 0, 12));
        this.setForeground(SystemColor.textText);
        ((Component)this).setBackground(SystemColor.control);
        this.setResizable(false);
        Image image = Resource.getImageResource(RESOURCE, "download.icon", this.getToolkit());
        if (image != null) {
            this.setIconImage(image);
        }
        String pathString = path.getAbsolutePath();
        try {
            pathString = path.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(10, 10, 10, 10);
        this.setLayout(gbl);
        QuietPanel mainPanel = new QuietPanel();
        QuietPanel buttonPanel = new QuietPanel();
        LayoutUtils.addGridBag(this, mainPanel, gbl, 0, 0, 1, 1, 0.0, 0.0, 1, 17, insets);
        insets.top = 0;
        LayoutUtils.addGridBag(this, buttonPanel, gbl, 0, 1, 1, 0, 0.0, 0.0, 0, 13, insets);
        gbl = new GridBagLayout();
        insets = new Insets(0, 0, 2, 0);
        mainPanel.setLayout(gbl);
        LayoutUtils.addGridBag(mainPanel, new Label(this.getMessage("from.label")), gbl, 0, 0, 1, 1, 0.0, 0.0, 0, 13, insets);
        this.textUrl = new TextField(connection.getURL().toString(), 30);
        LayoutUtils.addGridBag(mainPanel, this.textUrl, gbl, 1, 0, 2, 1, 1.0, 0.0, 2, 17, insets);
        LayoutUtils.addGridBag(mainPanel, new Label(this.getMessage("to.label")), gbl, 0, 1, 1, 1, 0.0, 0.0, 0, 13, insets);
        this.textPath = new TextField(pathString, 30);
        LayoutUtils.addGridBag(mainPanel, this.textPath, gbl, 1, 1, 2, 1, 1.0, 0.0, 2, 17, insets);
        LayoutUtils.addGridBag(mainPanel, new Label(this.getMessage("state.label")), gbl, 0, 2, 1, 1, 0.0, 0.0, 0, 13, insets);
        this.labelState = new Label();
        LayoutUtils.addGridBag(mainPanel, this.labelState, gbl, 1, 2, 2, 1, 1.0, 0.0, 2, 17, insets);
        LayoutUtils.addGridBag(mainPanel, new Label(this.getMessage("remain.label")), gbl, 0, 3, 1, 1, 0.0, 0.0, 0, 13, insets);
        this.labelRemain = new Label();
        LayoutUtils.addGridBag(mainPanel, this.labelRemain, gbl, 1, 3, 2, 1, 1.0, 0.0, 2, 17, insets);
        LayoutUtils.addGridBag(mainPanel, new Label(this.getMessage("process.label")), gbl, 0, 4, 1, 1, 0.0, 0.0, 0, 13, insets);
        this.labelProcess = new Label();
        LayoutUtils.addGridBag(mainPanel, this.labelProcess, gbl, 1, 4, 2, 1, 1.0, 0.0, 2, 17, insets);
        LayoutUtils.addGridBag(mainPanel, new Label(this.getMessage("progressbar.label")), gbl, 0, 5, 1, 1, 0.0, 0.0, 0, 13, insets);
        this.progressBar = new ProgressBar();
        LayoutUtils.addGridBag(mainPanel, this.progressBar, gbl, 1, 5, 1, 1, 1.0, 0.0, 2, 17, insets);
        this.labelProgress = new Label(this.mfProgress.format(new Object[]{new Integer(-1)}));
        LayoutUtils.addGridBag(mainPanel, this.labelProgress, gbl, 2, 5, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.checkKeepOpen = new Checkbox(this.getMessage("keepopen"));
        LayoutUtils.addGridBag(mainPanel, this.checkKeepOpen, gbl, 0, 6, 3, 1, 1.0, 0.0, 0, 17, insets);
        buttonPanel.setLayout(new FlowLayout(2, 10, 0));
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Dimension bs = new Dimension(Math.max(fm.stringWidth(this.getMessage("button.close")), fm.stringWidth(this.getMessage("button.cancel"))) + 8, fm.getHeight() + 8);
        this.buttonClose = new SizedButton(this.getMessage("button.close"), bs);
        buttonPanel.add(this.buttonClose);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                Download.this.wm.addWindow(Download.this);
            }

            public void windowClosing(WindowEvent e) {
                Download.this.dispose();
            }

            public void windowClosed(WindowEvent e) {
                Download.this.wm.removeWindow(Download.this);
                Download.this.thread.interrupt();
                Point position = Download.this.getLocation();
                if (position.x >= 0 || position.y >= 0) {
                    Setter setter = Download.this.option.getSetter();
                    try {
                        setter.putPropertyPoint("download.window.position", position);
                        setter.commit();
                    }
                    catch (InvalidValueException ex) {
                        // empty catch block
                    }
                }
            }
        });
        this.buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Download.this.dispose();
            }
        });
        this.checkKeepOpen.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Setter setter = Download.this.option.getSetter();
                try {
                    setter.putPropertyBoolean("download.window.close", Download.this.checkKeepOpen.getState());
                    setter.commit();
                }
                catch (InvalidValueException invalidValueException) {
                    // empty catch block
                }
            }
        });
        this.pack();
        Point position = option.getPropertyPoint("download.window.position");
        if (position != null) {
            ((Component)this).setLocation(position);
        } else {
            Dimension size = this.getSize();
            Dimension desktopSize = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((desktopSize.width - size.width) / 2, (desktopSize.height - size.height) / 2);
        }
        this.setTitle(this.mfTitle.format(new Object[]{new Integer(-1), this.filePath.getName()}));
        this.textUrl.setEditable(false);
        this.textPath.setEditable(false);
        ((Component)this.textUrl).setBackground(((Component)this).getBackground());
        ((Component)this.textPath).setBackground(((Component)this).getBackground());
        this.checkKeepOpen.setState(option.getPropertyBoolean("download.window.close", false));
    }

    public synchronized void setTitle(String title) {
        super.setTitle(title);
        this.wm.changeWindow(this);
    }

    public synchronized void addStateListener(StateListener l) {
        this.enableEvents(0L);
        this.stateListener = AWTEventMulticaster.add(this.stateListener, l);
    }

    public synchronized void removeStateListener(StateListener l) {
        this.stateListener = AWTEventMulticaster.remove(this.stateListener, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof StateEvent) {
            this.processStateEvent((StateEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processStateEvent(StateEvent e) {
        if (this.stateListener == null) {
            return;
        }
        switch (e.getID()) {
            case 3010: {
                this.stateListener.stateChanged(e);
            }
        }
    }

    private String getMessage(String key) {
        if (key == null) {
            return "";
        }
        return Resource.getMessage(RESOURCE, "download." + key, null);
    }

    public synchronized void start() {
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread.interrupt();
    }

    public synchronized void suspend() {
    }

    public synchronized void resume() {
    }

    public synchronized boolean isAlive() {
        return this.thread.isAlive();
    }

    public synchronized boolean isSuspended() {
        return false;
    }

    public synchronized boolean isCompleted() {
        return this.complete;
    }

    public void closeWindow() {
        this.dispose();
    }

    public void addWindowMenu(HawkWindow window) {
    }

    public void removeWindowMenu(int index) {
    }

    public void changeWindowMenu(int index, HawkWindow window) {
    }

    public void addToBookmark(Bookmark parent, Bookmark bookmark) {
    }

    public void bookmarkChanged() {
    }

    private class Chatty
    implements CounterListener {
        private long start = System.currentTimeMillis();
        private long fileLength;
        private int percent = -1;
        private long ltime;
        private long lpersec = -1000L;
        private long totalLength;
        private long lenPerSec;
        private long oddLength;
        private long oddTime;
        private Object[] oTitle;
        private Object[] oState;
        private Object[] oRemain;
        private Object[] oProcess;
        private Object[] oProgress;
        private int n;
        private int p;

        private Chatty(long length) {
            this.fileLength = length;
            if (this.fileLength >= 0L) {
                this.oTitle = new Object[]{null, Download.this.filePath.getName()};
                this.oState = new Object[]{null, new Double((double)this.fileLength / 1024.0), new Double(0.0)};
                this.oRemain = new Object[3];
                this.oProgress = new Object[1];
            } else {
                this.oState = new Object[]{null, new Integer(-1), new Double(0.0)};
            }
            this.oProcess = new Object[3];
        }

        public void changeLength(long length) {
            this.ltime = System.currentTimeMillis() - this.start;
            this.totalLength = length + (long)Download.this.resumeLength;
            this.lenPerSec = length / Math.max(this.ltime / 1000L, 1L);
            this.oState[0] = new Double((double)this.totalLength / 1024.0);
            if (this.lpersec + 1000L < this.ltime) {
                this.oState[2] = new Double((double)this.lenPerSec / 1024.0);
                this.lpersec = this.ltime;
            }
            this.n = (int)(this.ltime / 1000L);
            this.oProcess[2] = new Integer(this.n % 60);
            this.n /= 60;
            this.oProcess[1] = new Integer(this.n % 60);
            this.oProcess[0] = new Integer(this.n / 60);
            Download.this.labelState.setText(Download.this.mfState.format(this.oState));
            Download.this.labelProcess.setText(Download.this.mfProcess.format(this.oProcess));
            if (this.fileLength >= 0L) {
                this.p = (int)(this.totalLength * 100L / this.fileLength);
                if (this.p != this.percent) {
                    this.percent = this.p;
                    Download.this.progressBar.setValue(this.percent);
                    this.oProgress[0] = this.oTitle[0] = new Integer(this.percent);
                    Download.this.setTitle(Download.this.mfTitle.format(this.oTitle));
                    Download.this.labelProgress.setText(Download.this.mfProgress.format(this.oProgress));
                }
                this.n = (int)((this.fileLength - this.totalLength) / this.lenPerSec);
                this.oRemain[2] = new Integer(this.n % 60);
                this.n /= 60;
                this.oRemain[1] = new Integer(this.n % 60);
                this.oRemain[0] = new Integer(this.n / 60);
                Download.this.labelRemain.setText(Download.this.mfRemain.format(this.oRemain));
            }
            this.ltime = this.ltime;
        }
    }

    private class DownloadThread
    extends Thread {
        private static final int BUFFER_SIZE = 512;

        private DownloadThread() {
        }

        public void run() {
            Download.this.buttonClose.setLabel(Download.this.getMessage("button.cancel"));
            Download.this.getToolkit().getSystemEventQueue().postEvent(new StateEvent(Download.this, 3010, 1));
            int stopState = this.download();
            Download.this.buttonClose.setLabel(Download.this.getMessage("button.close"));
            Download.this.getToolkit().getSystemEventQueue().postEvent(new StateEvent(Download.this, 3010, stopState));
            if (stopState == 3) {
                Download.this.progressBar.setValue(100);
                Download.this.labelProgress.setText(Download.this.mfProgress.format(new Object[]{new Integer(100)}));
            }
            if (!Download.this.checkKeepOpen.getState()) {
                Download.this.dispose();
            }
        }

        private int download() {
            BufferedOutputStream os;
            CounterInputStream is;
            int stopState;
            block11: {
                stopState = 2;
                is = null;
                os = null;
                try {
                    is = new CounterInputStream(Download.this.connection.getInputStream(), new Chatty(Download.this.connection.getContentLength()));
                    os = new BufferedOutputStream(new FileOutputStream(Download.this.filePath), 512);
                }
                catch (IOException e) {
                    return 4;
                }
                try {
                    int len;
                    byte[] buffer = new byte[512];
                    while ((len = ((InputStream)is).read(buffer, 0, 512)) != -1) {
                        if (!this.isInterrupted()) {
                            ((OutputStream)os).write(buffer, 0, len);
                            continue;
                        }
                        break block11;
                    }
                    Download.this.complete = true;
                    stopState = 3;
                }
                catch (IOException e) {
                    stopState = 4;
                }
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (os != null) {
                try {
                    ((OutputStream)os).flush();
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return stopState;
        }
    }
}

