/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.cookie;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Enumeration;
import net.hizlab.kagetaka.cookie.Cookie;
import net.hizlab.kagetaka.cookie.CookieFactory;
import net.hizlab.kagetaka.option.ViewerOption;

public class CookieManager
extends CookieFactory {
    private static final String ENCODING = "UTF-8";
    private static final int LF = 10;
    public static final String YES = "yes";
    public static final String ASC = "asc";
    public static final String NO = "no";
    private ViewerOption option;
    private File cookieFile;

    public CookieManager(ViewerOption option) {
        this.option = option;
        this.strict = option.getPropertyBoolean("cookie.accept.strict", false);
        this.load(option.getPropertyFile("cookie.path"));
    }

    private synchronized void load(File file) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
            this.cookieFile = file;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                try {
                    this.appendCookie(new Cookie(line));
                }
                catch (InvalidObjectException e) {}
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }

    public synchronized void save() {
        if (!this.option.getPropertyBoolean("cookie.save", true)) {
            return;
        }
        File file = this.option.getPropertyFile("cookie.path");
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
            long now = System.currentTimeMillis();
            bw.write("# HTTP Cookie File");
            bw.write(10);
            bw.write("# http://www.netscape.com/newsref/std/cookie_spec.html");
            bw.write(10);
            bw.write("# This is a generated file!  Do not edit.");
            bw.write(10);
            bw.write("# To delete cookies, use the Cookie Manager.");
            bw.write(10);
            bw.write(10);
            Enumeration e = this.hash.keys();
            while (e.hasMoreElements()) {
                Cookie c = (Cookie)this.hash.get(e.nextElement());
                while (c != null) {
                    if (c.getExpires() != -1L && c.getExpires() > now) {
                        c.write(bw);
                        bw.write(10);
                    }
                    c = c.next;
                }
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }

    public Cookie createCookie(String data, URL url) {
        return super.createCookie(data, url);
    }

    public void setCookie(Cookie cookie) {
        this.appendCookie(cookie);
    }

    public synchronized Cookie[] getCookies(boolean reverse) {
        return null;
    }

    public synchronized void showEditor() {
    }
}

