/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.cookie;

import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.cookie.Cookie;
import net.hizlab.kagetaka.cookie.CookieStore;

public class CookieFactory
extends CookieStore {
    protected Hashtable hash = new Hashtable();
    protected boolean strict;

    public synchronized String getCookie(URL url) {
        Vector<Cookie> list = null;
        String host = url.getHost();
        Cookie c = (Cookie)this.hash.get(host);
        if (c != null) {
            list = new Vector<Cookie>();
            do {
                list.addElement(c);
            } while ((c = c.next) != null);
        }
        int count = 0;
        for (int i = host.length() - 1; i >= 0; --i) {
            if (host.charAt(i) != '.') continue;
            ++count;
        }
        for (int i = count - 2; i >= 0; --i) {
            c = (Cookie)this.hash.get(host = host.substring(host.indexOf(46, 1)));
            if (c == null) continue;
            if (list == null) {
                list = new Vector();
            }
            do {
                list.addElement(c);
            } while ((c = c.next) != null);
        }
        return list == null ? null : this.getCookieString(list, url);
    }

    protected Cookie createCookie(String data, URL url) {
        if (url.getProtocol().compareTo("file") == 0 || url.getHost() == null || url.getHost().length() == 0) {
            return null;
        }
        try {
            return new Cookie(data, url, this.strict);
        }
        catch (ParseException e) {
            System.out.println(e);
            return null;
        }
    }

    public void setCookie(String data, URL url) {
        Cookie cookie = this.createCookie(data, url);
        if (cookie == null) {
            return;
        }
        this.appendCookie(cookie);
    }

    protected synchronized void appendCookie(Cookie cookie) {
        String domain = cookie.getDomain();
        Cookie parent = (Cookie)this.hash.get(domain);
        if (parent == null) {
            this.hash.put(domain, cookie);
        } else {
            String name = cookie.getName();
            String path = cookie.getPath();
            Cookie c = parent;
            while (true) {
                if (name.compareTo(c.getName()) == 0 && path.compareTo(c.getPath()) == 0) {
                    long expires = c.getExpires();
                    if (expires == -1L || expires >= System.currentTimeMillis()) {
                        if (c.prev == null) {
                            if (c.next != null) {
                                cookie.next = c.next;
                                cookie.next.prev = cookie;
                            }
                            this.hash.put(domain, cookie);
                        } else {
                            cookie.prev = c.prev;
                            cookie.prev.next = cookie;
                            if (c.next != null) {
                                cookie.next = c.next;
                                cookie.next.prev = cookie;
                            }
                        }
                    } else if (c.prev == null) {
                        if (c.next != null) {
                            c = c.next;
                            c.prev.next = null;
                            c.prev = null;
                            this.hash.put(domain, c);
                        } else {
                            this.hash.remove(domain);
                        }
                    } else if (c.next != null) {
                        c.prev.next = c.next;
                        c.next.prev = c.prev;
                        c.next = null;
                        c.prev = null;
                    } else {
                        c.prev.next = null;
                        c.prev = null;
                    }
                    return;
                }
                if (c.next == null) break;
                c = c.next;
            }
            c.next = cookie;
            cookie.prev = c;
        }
    }

    private String getCookieString(Vector list, URL url) {
        Cookie c;
        int size;
        int good = size = list.size();
        long now = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            c = (Cookie)list.elementAt(i);
            if (c.getExpires() == -1L || c.getExpires() >= now) continue;
            if (--good == 0) {
                return null;
            }
            list.setElementAt(null, i);
        }
        String path = url.getFile();
        Hashtable<String, String> pathHash = null;
        for (int i = 0; i < size; ++i) {
            c = (Cookie)list.elementAt(i);
            if (c == null) continue;
            if (!c.isTargetPath(path)) {
                if (--good == 0) {
                    return null;
                }
                list.setElementAt(null, i);
            }
            if (pathHash == null) {
                pathHash = new Hashtable<String, String>();
            }
            pathHash.put(c.getPath(), "");
        }
        if (pathHash == null) {
            return null;
        }
        int pathNum = pathHash.size();
        int length = -1;
        int index = 0;
        String[] pathList = new String[pathNum];
        int[] pathLen = new int[pathNum];
        int pathIndex = 0;
        Enumeration e = pathHash.keys();
        while (e.hasMoreElements()) {
            pathList[pathIndex] = path = (String)e.nextElement();
            pathLen[pathIndex] = path.length();
            if (length < pathLen[pathIndex]) {
                length = pathLen[pathIndex];
                index = pathIndex;
            }
            ++pathIndex;
        }
        StringBuffer sb = null;
        block3: while (true) {
            int i;
            path = pathList[index];
            for (i = 0; i < size; ++i) {
                c = (Cookie)list.elementAt(i);
                if (c == null || path.compareTo(c.getPath()) != 0) continue;
                if (sb == null) {
                    sb = new StringBuffer();
                } else {
                    sb.append("; ");
                }
                sb.append(c.getFullValue());
                if (--good == 0) {
                    return sb.toString();
                }
                list.setElementAt(null, i);
            }
            pathLen[index] = -1;
            length = -1;
            i = 0;
            while (true) {
                if (i >= pathList.length) continue block3;
                if (length < pathLen[i]) {
                    length = pathLen[i];
                    index = i;
                }
                ++i;
            }
            break;
        }
    }
}

