/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.io.IOException;
import java.util.Stack;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.FilterParser;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.build.Parser;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.MiscToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TextToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenManager;
import net.hizlab.kagetaka.token.TokenTypes;

public class TokenCoordinator {
    private Document document = null;
    private Parser parser = null;
    private Reporter reporter = null;

    public TokenCoordinator(Document document, Parser parser, Reporter reporter) {
        Abbreviation p = null;
        p = new Abbreviation();
        p.setParser(document, parser, reporter);
        parser = p;
        this.document = document;
        this.parser = parser;
        this.reporter = reporter;
    }

    public synchronized Token next() {
        return this.nextToken(this.parser);
    }

    private Token nextToken(Parser parser) {
        try {
            return parser.next();
        }
        catch (IOException e) {
            this.reportMessage(10, "tc.error.ioerror", new String[]{e.toString()}, null);
        }
        catch (ParseException e) {
            this.reportMessage(10, "tc.error.parseerror", new String[]{e.toString()}, null);
        }
        catch (Exception e) {
            this.reportMessage(10, "tc.error.unknownerror", new String[]{e.toString()}, null);
            e.printStackTrace();
        }
        return null;
    }

    private void reportMessage(int type, String key, String[] args, Token token) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(type, Resource.getMessage(key, args), token == null ? 0 : token.getLineNumber(), token == null ? 0 : token.getColumnNumber());
    }

    private class Abbreviation
    extends FilterParser {
        private Queue fixedTokenQueue = new Queue();
        private Queue unfixedTokenQueue = new Queue();
        private boolean alreadyEnd = false;
        private boolean isFrameset = false;
        private StartToken bottomToken = null;
        private Stack createToken = new Stack();

        private Abbreviation() {
        }

        public String getParserName() {
            return "AbbreviationCoordinator";
        }

        public String getParserDescription() {
            return "\u7701\u7565\u3055\u308c\u305f\u30c8\u30fc\u30af\u30f3\u3092\u88dc\u3044\u307e\u3059";
        }

        public Token next() throws ParseException, IOException {
            if (this.alreadyEnd) {
                return null;
            }
            Token token = null;
            block3: while ((token = (Token)this.fixedTokenQueue.get()) == null) {
                token = this.readNextToken();
                if (token == null) {
                    return null;
                }
                switch (token.getType()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        continue block3;
                    }
                }
                if (this.bottomToken == null) {
                    TextToken textToken;
                    if (token instanceof TextToken && !(textToken = (TextToken)token).hasCharacters()) continue;
                    if (token.getType() == 1001) {
                        this.bottomToken = (StartToken)token;
                        return token;
                    }
                    this.unfixedTokenQueue.put(token);
                    this.bottomToken = TokenManager.createStartToken(TokenCoordinator.this.document, TokenCoordinator.this.reporter, 0, 0, 1001, true);
                    TokenCoordinator.this.reportMessage(7, "tc.warning.nohtml", new String[]{this.bottomToken.getName()}, this.bottomToken);
                    return this.bottomToken;
                }
                if (token.getType() == 2045) {
                    this.skipToken(2045, 2046);
                    continue;
                }
                if (token instanceof TextToken) {
                    token = this.fixedTextToken((TextToken)token);
                } else if (token instanceof StartToken) {
                    token = this.fixedStartToken((StartToken)token);
                } else if (token instanceof EndToken) {
                    token = this.fixedEndToken((EndToken)token);
                } else {
                    if (token instanceof MiscToken) continue;
                    TokenCoordinator.this.reportMessage(7, "tc.warning.unknowntoken", new String[]{token.toString()}, token);
                    continue;
                }
                if (token == null) continue;
            }
            if (token instanceof EndToken) {
                this.bottomToken = this.bottomToken.getParent();
                if (this.bottomToken == null) {
                    this.alreadyEnd = true;
                    return token;
                }
            }
            this.bottomToken.includeToken(token);
            if (token instanceof StartToken && !TokenTypes.isEmpty(token.getType())) {
                this.bottomToken = (StartToken)token;
            }
            return token;
        }

        private Token readNextToken() throws ParseException, IOException {
            Token token = (Token)this.unfixedTokenQueue.get();
            if (token != null) {
                return token;
            }
            return TokenCoordinator.this.nextToken(this.parser);
        }

        private Token fixedTextToken(TextToken currentToken) {
            StartToken token = null;
            StartToken parentToken = this.bottomToken;
            if (TokenTypes.canHaveText(parentToken.getType())) {
                return currentToken;
            }
            if (!currentToken.hasCharacters()) {
                return null;
            }
            int completeType = 3191;
            int parentType = parentToken.getType();
            if (parentType == 3301) {
                completeType = 3303;
            } else if (parentType == 3115 || parentType == 3117) {
                completeType = 3123;
            }
            token = TokenManager.createStartToken(TokenCoordinator.this.document, TokenCoordinator.this.reporter, currentToken.getLineNumber(), currentToken.getColumnNumber(), completeType, true);
            if (token != null && parentToken.isContents(token)) {
                TokenCoordinator.this.reportMessage(7, "tc.warning.completestart", new String[]{token.getName()}, token);
                this.fixedTokenQueue.put(currentToken);
                return token;
            }
            TokenCoordinator.this.reportMessage(7, "tc.warning.invalidposition", new String[]{currentToken.getName()}, currentToken);
            return null;
        }

        private Token fixedStartToken(StartToken currentToken) {
            StartToken token = currentToken;
            StartToken parentToken = null;
            int popLevel = 0;
            StartToken createLi = null;
            block3: while (true) {
                parentToken = this.bottomToken;
                popLevel = -1;
                block4: while (true) {
                    ++popLevel;
                    if (parentToken.isContents(token)) break block3;
                    if (parentToken.getType() == 3115 || parentToken.getType() == 3117) {
                        if (createLi == null) {
                            createLi = TokenManager.createStartToken(TokenCoordinator.this.document, TokenCoordinator.this.reporter, currentToken.getLineNumber(), currentToken.getColumnNumber(), 3123, true);
                        }
                        if (createLi.isContents(token)) {
                            this.createToken.push(createLi);
                            break block3;
                        }
                    }
                    if (token != currentToken) continue;
                    switch (token.getType()) {
                        case 3431: 
                        case 3433: {
                            StartToken st = token.getDefaultParentToken();
                            if (parentToken.isContents(st)) {
                                this.createToken.push(st);
                                break block3;
                            }
                        }
                        default: {
                            if ((parentToken = parentToken.getParent()) != null) continue block4;
                            if ((token = token.getDefaultParentToken()) == null) {
                                TokenCoordinator.this.reportMessage(7, "tc.warning.invalidposition", new String[]{currentToken.getName()}, currentToken);
                                if (!this.createToken.empty()) {
                                    this.createToken.removeAllElements();
                                }
                                return null;
                            }
                            this.createToken.push(token);
                            continue block3;
                        }
                    }
                    break;
                }
                break;
            }
            Token topToken = null;
            if (popLevel > 0) {
                topToken = this.complementEndToken(popLevel, currentToken);
            }
            if (!this.createToken.empty()) {
                while (!this.createToken.empty()) {
                    token = (StartToken)this.createToken.pop();
                    TokenCoordinator.this.reportMessage(7, "tc.warning.completestart", new String[]{token.getName()}, token);
                    if (topToken == null) {
                        topToken = token;
                        continue;
                    }
                    this.fixedTokenQueue.put(token);
                }
                this.createToken.removeAllElements();
            }
            if (topToken == null) {
                topToken = currentToken;
            } else {
                this.fixedTokenQueue.put(currentToken);
            }
            return topToken;
        }

        private Token fixedEndToken(EndToken currentToken) {
            StartToken parentToken = this.bottomToken;
            int type = currentToken.getType();
            int popLevel = 0;
            while (parentToken.getEndTokenType() != type) {
                if (this.isTopContainer(parentToken.getType(), type) || (parentToken = parentToken.getParent()) == null) {
                    TokenCoordinator.this.reportMessage(7, "tc.warning.nostart", new String[]{currentToken.getName()}, currentToken);
                    return null;
                }
                ++popLevel;
            }
            if (popLevel > 0) {
                Token topToken = this.complementEndToken(popLevel, currentToken);
                this.fixedTokenQueue.put(currentToken);
                return topToken;
            }
            return currentToken;
        }

        private Token complementEndToken(int level, Token currentToken) {
            EndToken topToken = null;
            StartToken parentToken = this.bottomToken;
            EndToken endToken = null;
            while (level-- > 0) {
                endToken = parentToken.getEndToken(currentToken);
                TokenCoordinator.this.reportMessage(7, "tc.warning.completeend", new String[]{endToken.getName()}, endToken);
                if (topToken == null) {
                    topToken = endToken;
                } else {
                    this.fixedTokenQueue.put(endToken);
                }
                if ((parentToken = parentToken.getParent()) != null) continue;
                break;
            }
            return topToken;
        }

        private boolean isTopContainer(int parentToken, int token) {
            if (parentToken == 3301 && TokenTypes.isRubyItem(token)) {
                return true;
            }
            if (parentToken == 3401 && TokenTypes.isTableItem(token)) {
                return true;
            }
            return parentToken == 3501 && TokenTypes.isFormItem(token);
        }

        private void skipToken(int start, int end) throws ParseException, IOException {
            Token token;
            int level = 1;
            while ((token = (Token)this.fixedTokenQueue.get()) != null || (token = this.readNextToken()) != null) {
                int type = token.getType();
                if (type == start) {
                    ++level;
                    continue;
                }
                if (type != end || --level != 0) continue;
                return;
            }
        }
    }
}

