/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.io.BufferedReader;
import java.io.IOException;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.build.Tag;

public class TagReader {
    private BufferedReader br = null;
    private Reporter reporter = null;
    private String line = "";
    private int offset = 0;
    private int length = 0;
    private int lineNumber = 0;
    private int columnNumber = 1;
    private Tag nextTag = null;

    public TagReader(BufferedReader br, Reporter reporter) {
        this.br = br;
        this.reporter = reporter;
    }

    public Tag readTag() throws ParseException, IOException {
        String end;
        String start;
        if (this.nextTag != null) {
            Tag tag = this.nextTag;
            this.nextTag = null;
            return tag;
        }
        if (this.line == null) {
            return null;
        }
        StringBuffer sb = null;
        String data = null;
        int startLineNumber = this.lineNumber;
        int startColumnNumber = this.columnNumber;
        int type = 0;
        int endPosition = 0;
        int nextPosition = 0;
        if (this.startsWith("<![CDATA[")) {
            type = 2;
            start = "<![CDATA[";
            end = "]]>";
            nextPosition = 3;
        } else if (this.startsWith("<!--")) {
            type = 4;
            start = "<!--";
            end = "-->";
            endPosition = 3;
        } else if (this.startsWith("<?")) {
            type = 5;
            start = "<?";
            end = "?>";
            endPosition = 2;
        } else if (this.startsWith("<!")) {
            type = 3;
            start = "<!";
            end = ">";
            endPosition = 1;
        } else if (this.startsWith("<")) {
            type = 1;
            start = "<";
            end = ">";
            endPosition = 1;
        } else {
            type = 2;
            start = null;
            end = "<";
        }
        do {
            int p;
            if (this.offset < this.length && (p = this.line.indexOf(end, this.offset)) != -1) {
                p += endPosition;
                if (sb == null) {
                    data = this.line.substring(this.offset, p);
                } else {
                    sb.append(this.line.substring(this.offset, p));
                    data = sb.toString();
                }
                this.calculateColumnNumber(p + nextPosition);
                this.offset = p + nextPosition;
                break;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            if (this.offset < this.length) {
                sb.append(this.line.substring(this.offset));
            }
            sb.append('\n');
        } while (this.readLine());
        if (data == null) {
            data = sb.toString();
            if (start != null && this.reporter != null) {
                this.reporter.report(7, Resource.getMessage("tagreader.warning.bracket.notclose", new String[]{start, end}), startLineNumber, startColumnNumber);
            }
        }
        return new Tag(this.reporter, startLineNumber, startColumnNumber, type, data);
    }

    public String readContent(String name, boolean pair) throws ParseException, IOException {
        if (this.line == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int startLineNumber = 0;
        int startColumnNumber = 0;
        String end = null;
        do {
            if (this.offset < this.length) {
                int p = pair ? this.line.indexOf("</", this.offset) : this.line.indexOf(60, this.offset);
                if (p != -1) {
                    this.calculateColumnNumber(p);
                    startLineNumber = this.lineNumber;
                    startColumnNumber = this.columnNumber;
                    sb.append(this.line.substring(this.offset, p));
                    if (!pair) {
                        this.offset = p;
                        return sb.toString();
                    }
                    this.columnNumber += 2;
                    this.offset = p + 2;
                    p = this.line.indexOf(">", this.offset);
                    if (p != -1) {
                        end = this.line.substring(this.offset, p);
                        this.calculateColumnNumber(p + 1);
                        this.offset = p + 1;
                    } else {
                        StringBuffer endb = new StringBuffer();
                        endb.append(this.line.substring(this.offset));
                        endb.append('\n');
                        while (this.readLine()) {
                            p = this.line.indexOf(">");
                            if (p != -1) {
                                endb.append(this.line.substring(0, p));
                                this.calculateColumnNumber(p + 1);
                                this.offset = p + 1;
                                break;
                            }
                            endb.append(this.line);
                            endb.append('\n');
                        }
                        end = endb.toString();
                    }
                    if (end.trim().toLowerCase().compareTo(name) == 0) {
                        this.nextTag = new Tag(this.reporter, startLineNumber, startColumnNumber, 1, "</" + end + ">");
                        return sb.toString();
                    }
                    sb.append("</");
                    sb.append(end);
                    sb.append('>');
                }
                sb.append(this.line.substring(this.offset));
            }
            sb.append('\n');
        } while (this.readLine());
        return sb.toString();
    }

    private boolean readLine() throws IOException {
        this.line = this.br.readLine();
        if (this.line == null) {
            this.offset = 0;
            this.length = 0;
            return false;
        }
        ++this.lineNumber;
        this.columnNumber = 1;
        this.offset = 0;
        this.length = this.line.length();
        return true;
    }

    private void calculateColumnNumber(int end) {
        for (int i = this.offset; i < end; ++i) {
            char c = this.line.charAt(i);
            if (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f') {
                ++this.columnNumber;
                continue;
            }
            this.columnNumber += 2;
        }
    }

    private boolean startsWith(String value) {
        return this.offset < this.length && this.line.startsWith(value, this.offset);
    }

    public void close() throws IOException {
        this.br.close();
    }
}

