/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.util.Hashtable;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.util.TextFormat;

public class Tag {
    public static final int TAG = 1;
    public static final int TEXT = 2;
    public static final int DTD = 3;
    public static final int COMMENT = 4;
    public static final int PI = 5;
    public static final int MISC = 0;
    private Reporter reporter = null;
    private int lineNumber = 0;
    private int columnNumber = 0;
    private int type = 0;
    private String rawData = null;
    private int dataStart = 0;
    private int dataEnd = 1;
    private String element = null;
    private boolean isEndTag = false;
    private boolean isEmpty = false;
    private Hashtable attributes = null;

    public Tag(Reporter reporter, int line, int column, int type, String value) throws ParseException {
        this.reporter = reporter;
        this.lineNumber = line;
        this.columnNumber = column;
        this.type = type;
        this.rawData = value;
        int start = 0;
        int end = value.length();
        if (type == 1) {
            if (value.compareTo("<>") == 0) {
                return;
            }
            if (value.compareTo("</>") == 0) {
                this.isEndTag = true;
                return;
            }
            ++start;
            if (end > 1 && value.charAt(1) == '/') {
                ++start;
                this.isEndTag = true;
            }
            if (value.charAt(end - 1) == '>') {
                --end;
            } else {
                this.addWarning("tag.warning.bracket.notclose", end);
            }
        } else if (type == 5 && this.startsWordWith(value, "<?xml", 2)) {
            start += 2;
            end -= 2;
        } else {
            this.dataEnd = value.length();
            switch (type) {
                case 3: {
                    this.dataStart = 2;
                    --this.dataEnd;
                    break;
                }
                case 4: {
                    this.dataStart = 4;
                    this.dataEnd -= 3;
                    break;
                }
                case 5: {
                    this.dataStart = 2;
                    this.dataEnd -= 2;
                    break;
                }
                case 0: {
                    this.dataStart = 2;
                    this.dataEnd -= 2;
                }
            }
            return;
        }
        this.dataStart = start;
        this.dataEnd = end;
        String attribute = null;
        boolean removeCrlf = false;
        boolean existEquals = false;
        boolean moveCurrent = false;
        int current = start;
        block6: while (current < end) {
            block39: {
                while (value.charAt(current) <= ' ') {
                    if (++current < end) continue;
                    break block6;
                }
                start = current;
                char c = value.charAt(start);
                if (c == '\"' || c == '\'') {
                    if ((current = value.indexOf(c, ++start)) == -1) {
                        current = end;
                        if (c == '\"') {
                            this.addWarning("tag.warning.doublequotation.notclose", current);
                        } else {
                            this.addWarning("tag.warning.apostrophe.notclose", current);
                        }
                    } else {
                        moveCurrent = true;
                        removeCrlf = true;
                    }
                } else {
                    if (c == '=') {
                        if (attribute == null || existEquals) {
                            this.addWarning("tag.warning.equals.invalidposition", current);
                        } else {
                            existEquals = true;
                        }
                        ++current;
                        continue;
                    }
                    while (++current < end) {
                        c = value.charAt(current);
                        if (c > ' ' && (existEquals || c != '=')) continue;
                        break block39;
                    }
                    if (start + 1 == current && attribute == null && value.charAt(start) == '/') {
                        this.isEmpty = true;
                        break;
                    }
                }
            }
            String s = value.substring(start, current);
            if (removeCrlf) {
                int p2;
                StringBuffer sb = new StringBuffer();
                int p1 = 0;
                for (p2 = 0; p2 < s.length(); ++p2) {
                    if (s.charAt(p2) >= ' ') continue;
                    if (p1 < p2) {
                        sb.append(s.substring(p1, p2));
                    }
                    p1 = p2 + 1;
                }
                if (p1 < p2) {
                    sb.append(s.substring(p1, p2));
                }
                s = sb.toString();
                removeCrlf = false;
            }
            String keyword = TextFormat.convertXhtml(reporter, this.lineNumber, this.columnNumber, s, true, true, false, true);
            if (this.element == null) {
                this.element = keyword;
            } else if (attribute == null) {
                attribute = keyword;
            } else {
                if (existEquals) {
                    this.addAttribute(attribute, keyword);
                    attribute = null;
                } else {
                    this.addAttribute(attribute, attribute);
                    attribute = keyword;
                }
                existEquals = false;
            }
            if (!moveCurrent) continue;
            ++current;
            moveCurrent = false;
        }
        if (attribute != null) {
            this.addAttribute(attribute, attribute);
        }
    }

    private boolean startsWordWith(String src, String word, int end) {
        if (!src.startsWith(word)) {
            return false;
        }
        int wordLength = word.length();
        if (src.length() <= wordLength + end) {
            return true;
        }
        char c = src.charAt(word.length());
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u200b': {
                return true;
            }
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        return this.rawData;
    }

    public String getInnerText() {
        return this.rawData.substring(this.dataStart, this.dataEnd);
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public boolean isEndTag() {
        return this.isEndTag;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private void addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(key, value);
    }

    public Hashtable getAttribute() {
        return this.attributes;
    }

    public String toString() {
        return this.rawData;
    }

    private void addWarning(String key, int offset) {
        if (this.reporter == null) {
            return;
        }
        int line = this.lineNumber;
        int column = this.columnNumber;
        int length = this.rawData.length();
        for (int i = 0; i < offset; ++i) {
            char c = this.rawData.charAt(i);
            if (c == '\n') {
                ++line;
                column = 1;
                continue;
            }
            if (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f') {
                ++column;
                continue;
            }
            column += 2;
        }
        this.reporter.report(7, Resource.getMessage(key, null), line, column);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

