/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.FilterParser;
import net.hizlab.kagetaka.build.InputStreamParser;
import net.hizlab.kagetaka.build.Parser;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.util.Environment;

public class ParserManager {
    private static Hashtable parsers;

    private ParserManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParserInfo[] getParserList() {
        Hashtable hashtable = parsers;
        synchronized (hashtable) {
            ParserInfo[] list = new ParserInfo[parsers.size()];
            int index = 0;
            Enumeration e = parsers.elements();
            while (e.hasMoreElements()) {
                list[index++] = (ParserInfo)e.nextElement();
            }
            return list;
        }
    }

    public static ParserInfo getParser(String name) {
        ParserInfo pi = (ParserInfo)parsers.get(name);
        if (pi != null) {
            return pi;
        }
        if (ParserManager.addParser(name)) {
            return (ParserInfo)parsers.get(name);
        }
        return null;
    }

    public static boolean addParser(String className) {
        try {
            if (parsers.containsKey(className)) {
                return true;
            }
            Parser parser = (Parser)Class.forName(className).newInstance();
            if (!(parser instanceof InputStreamParser) && !(parser instanceof FilterParser)) {
                return false;
            }
            ParserInfo info = new ParserInfo(className, parser.getParserName(), parser.getParserDescription(), parser instanceof FilterParser);
            parsers.put(className, info);
            return true;
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (SecurityException e) {
        }
        catch (ClassCastException e) {
        }
        catch (ClassFormatError classFormatError) {
            // empty catch block
        }
        return false;
    }

    public static InputStreamParser createInstance(String className, Document document, InputStream is, Reporter reporter) {
        try {
            InputStreamParser parser = (InputStreamParser)Class.forName(className).newInstance();
            parser.setInputStream(document, is, reporter);
            return parser;
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (SecurityException e) {
        }
        catch (ClassCastException e) {
        }
        catch (ClassFormatError e) {
            // empty catch block
        }
        return null;
    }

    public static FilterParser createInstance(String className, Document document, Parser parser, Reporter reporter) {
        try {
            FilterParser filter = (FilterParser)Class.forName(className).newInstance();
            filter.setParser(document, parser, reporter);
            return filter;
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (SecurityException e) {
        }
        catch (ClassCastException e) {
        }
        catch (ClassFormatError e) {
            // empty catch block
        }
        return null;
    }

    static {
        StringTokenizer st;
        parsers = new Hashtable();
        String names = null;
        names = Resource.getMessage("parser.list", null);
        if (names != null) {
            st = new StringTokenizer(names, ",; ");
            while (st.hasMoreTokens()) {
                ParserManager.addParser(st.nextToken());
            }
        }
        if (!Environment.isApplet) {
            try {
                names = System.getProperty("net.hizlab.kagetaka.parsers", null);
                if (names != null) {
                    st = new StringTokenizer(names, ",; ");
                    while (st.hasMoreTokens()) {
                        ParserManager.addParser(st.nextToken());
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static class ParserInfo {
        private String className = null;
        private String name = null;
        private String description = null;
        private boolean filter = false;

        private ParserInfo(String className, String name, String description, boolean filter) {
            this.className = className;
            this.name = name;
            this.description = description;
            this.filter = filter;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isFilter() {
            return this.filter;
        }
    }
}

