/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Reporter;

class CacheReporter
implements Reporter {
    private Reporter reporter = null;
    private Queue reportQueue = null;
    private boolean run = true;

    CacheReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public synchronized void report(int level, String message, int line, int column) {
        if (this.run) {
            this.reporter.report(level, message, line, column);
        } else {
            if (this.reportQueue == null) {
                this.reportQueue = new Queue();
            }
            this.reportQueue.put(new Report(level, message, line, column));
        }
    }

    public int getLevel() {
        return this.reporter.getLevel();
    }

    synchronized void restart(boolean junk) {
        this.run = true;
        if (!junk && this.reportQueue != null) {
            Report report = null;
            while ((report = (Report)this.reportQueue.get()) != null) {
                this.reporter.report(report.level, report.message, report.line, report.column);
            }
        }
        this.reportQueue = null;
    }

    synchronized void pause() {
        this.run = false;
    }

    private class Report {
        private int level;
        private String message;
        private int line;
        private int column;

        private Report(int level, String message, int line, int column) {
            this.level = level;
            this.message = message;
            this.line = line;
            this.column = column;
        }
    }
}

