/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.bookmarks;

import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.net.MalformedURLException;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.MessageBox;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;

public class Detail
extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.bookmarks.Resource";
    private static final int MARGIN = 3;
    private Frame owner;
    private BookmarkManager bm;
    private TextField text;
    private TextField urlText;
    private TextField shorCut;
    private Bookmark bookmark;

    public static Bookmark show(Frame owner, BookmarkManager bm, Bookmark bookmark) {
        Detail dialog = new Detail(owner, bm);
        dialog.setBookmark(bookmark);
        dialog.show();
        if (dialog.getResult() != 0) {
            return null;
        }
        return dialog.getBookmark();
    }

    public Detail(Frame owner, BookmarkManager bm) {
        super(owner, 1);
        this.setResizable(false);
        this.setModal(true);
        this.owner = owner;
        this.bm = bm;
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(3, 3, 3, 3);
        this.mainPanel.setLayout(gbl);
        this.addToPanel(new Label(this.getMessage("label.text")), gbl, 0, 0, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.text = new TextField(40);
        this.addToPanel(this.text, gbl, 1, 0, 2, 1, 1.0, 0.0, 2, 10, insets);
        this.addToPanel(new Label(this.getMessage("label.url")), gbl, 0, 1, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.urlText = new TextField(40);
        this.addToPanel(this.urlText, gbl, 1, 1, 2, 1, 1.0, 0.0, 2, 10, insets);
        this.addToPanel(new Label(this.getMessage("label.sc")), gbl, 0, 2, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.shorCut = new TextField(40);
        this.addToPanel(this.shorCut, gbl, 1, 2, 2, 1, 1.0, 0.0, 2, 10, insets);
        this.setBookmark(null);
        this.pack();
    }

    private String getMessage(String key) {
        return this.getMessage(key, null);
    }

    private String getMessage(String key, String[] args) {
        if (key == null) {
            return "";
        }
        return Resource.getMessage(RESOURCE, "detail." + key, args);
    }

    public void show() {
        ((TextComponent)this.text).setText(this.bookmark.getText());
        ((TextComponent)this.urlText).setText(this.bookmark.getURLText());
        ((TextComponent)this.shorCut).setText(this.bookmark.getShortcutURL());
        super.show();
    }

    public synchronized Bookmark getBookmark() {
        return this.bookmark;
    }

    public synchronized void setBookmark(Bookmark bookmark) {
        if (bookmark == null) {
            this.bookmark = new Bookmark("", "");
            this.setTitle(this.getMessage("title.new"));
        } else {
            this.bookmark = bookmark;
            this.setTitle(this.getMessage("title.edit"));
        }
    }

    protected boolean dialogClosing(int result) {
        if (result == 0) {
            return this.saveBookmark();
        }
        return true;
    }

    private boolean saveBookmark() {
        if (!this.bm.changeShortcut(this.bookmark.getShortcutURL(), this.shorCut.getText(), this.bookmark)) {
            MessageBox.show(this.owner, this.getMessage("message.invalidsc.text"), this.getMessage("message.invalidsc.title"), 65536);
            return false;
        }
        try {
            this.bookmark.setURLText(this.urlText.getText());
        }
        catch (MalformedURLException e) {
            MessageBox.show(this.owner, this.getMessage("message.invalidurl.text", new String[]{this.urlText.getText(), e.toString()}), this.getMessage("message.invalidurl.title"), 65536);
            return false;
        }
        this.bookmark.setText(this.text.getText());
        this.bookmark.setShortcutURL(this.shorCut.getText());
        return true;
    }
}

