/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.bookmarks;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.build.Tag;
import net.hizlab.kagetaka.util.StringUtils;
import net.hizlab.kagetaka.util.TextFormat;

public class Bookmark
implements Cloneable {
    private static final int LF = 10;
    public static final int FOLDER = 1;
    public static final int BOOKMARK = 2;
    public static final int SEPARATOR = 3;
    private int type;
    private Vector bookmarks;
    private String text;
    private String urlText;
    private URL url;
    private long addDate;
    private long lastVisit;
    private long lastModified;
    private String lastCharset;
    private String shortcuturl;
    private boolean folderGroup;
    private boolean ptFolder;
    Bookmark parent = null;

    public Bookmark(String text, URL url) {
        this.type = 2;
        this.text = text;
        this.urlText = url.toString();
        this.url = url;
        this.addDate = System.currentTimeMillis();
    }

    public Bookmark(String text, String url) {
        this.type = 2;
        this.text = text;
        this.urlText = url;
        this.addDate = System.currentTimeMillis();
    }

    public Bookmark(String text) {
        this.type = 1;
        this.bookmarks = new Vector();
        this.text = text;
        this.addDate = System.currentTimeMillis();
    }

    public Bookmark() {
        this.type = 3;
    }

    Bookmark(String text, Tag tag) {
        String element = tag.getElement();
        Hashtable param = tag.getAttribute();
        if (element.compareTo("A") == 0) {
            this.type = 2;
            if (param != null) {
                this.lastVisit = this.toLong(param.get("LAST_VISIT"));
                this.lastCharset = (String)param.get("LAST_CHARSET");
                this.shortcuturl = (String)param.get("SHORTCUTURL");
            }
        } else {
            this.type = 1;
            this.bookmarks = new Vector();
            if (param != null) {
                this.folderGroup = this.toBoolean(param.get("FOLDER_GROUP"));
                this.ptFolder = this.toBoolean(param.get("PERSONAL_TOOLBAR_FOLDER"));
            }
        }
        this.text = text;
        if (param != null) {
            this.urlText = (String)param.get("HREF");
            this.addDate = this.toLong(param.get("ADD_DATE"));
            this.lastModified = this.toLong(param.get("LAST_MODIFIED"));
        }
    }

    private long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        return Long.parseLong((String)value);
    }

    private boolean toBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.valueOf((String)value);
    }

    public int getType() {
        return this.type;
    }

    public Bookmark getParentFolder() {
        return this.parent;
    }

    public Vector getBookmarks() {
        return this.bookmarks;
    }

    public void addBookmark(Bookmark bookmark) {
        this.addBookmark(bookmark, -1);
    }

    public void addBookmark(Bookmark bookmark, int index) {
        if (this.type != 1) {
            throw new IllegalArgumentException("not folder");
        }
        if (index < 0) {
            this.bookmarks.addElement(bookmark);
        } else {
            this.bookmarks.insertElementAt(bookmark, index);
        }
        bookmark.parent = this;
    }

    public void removeBookmark(Bookmark bookmark) {
        if (this.type != 1) {
            throw new IllegalArgumentException("not folder");
        }
        if (bookmark.parent == null) {
            return;
        }
        bookmark.parent = null;
        this.bookmarks.removeElement(bookmark);
    }

    public int getNumber() {
        return this.parent.bookmarks.indexOf(this);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.type == 3) {
            throw new IllegalArgumentException("separator");
        }
        this.text = text;
    }

    public URL getURL() {
        if (this.type != 2) {
            return null;
        }
        if (this.url != null) {
            return this.url;
        }
        try {
            this.url = StringUtils.toURL(TextFormat.convertXhtml(this.urlText, true, true, true, true));
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.url;
    }

    public void setURL(URL url) {
        if (this.type != 2) {
            throw new IllegalArgumentException("not bookmark");
        }
        this.urlText = url.toString();
        this.url = url;
    }

    public String getURLText() {
        if (this.type != 2) {
            return null;
        }
        return this.urlText;
    }

    public void setURLText(String url) throws MalformedURLException {
        if (this.type != 2) {
            throw new IllegalArgumentException("not bookmark");
        }
        this.url = StringUtils.toURL(url);
        this.urlText = url;
    }

    public String getShortcutURL() {
        return this.shortcuturl;
    }

    public void setShortcutURL(String text) {
        if (this.type != 2) {
            throw new IllegalArgumentException("not bookmark");
        }
        this.shortcuturl = text;
    }

    public String getLastCharset() {
        return this.lastCharset;
    }

    public void visited(long lastModified, String charset) {
        if (this.type != 2) {
            throw new IllegalArgumentException("not bookmark");
        }
        this.lastVisit = System.currentTimeMillis();
        this.lastModified = lastModified;
        this.lastCharset = charset;
    }

    public boolean getPersonalToolbarFolder() {
        return this.ptFolder;
    }

    void setPersonalToolbarFolder(boolean b) {
        this.ptFolder = b;
    }

    void write(Writer w, int level) throws IOException {
        String s;
        int i;
        int space = level * 4;
        for (i = 0; i < space; ++i) {
            w.write(32);
        }
        switch (this.type) {
            case 1: {
                w.write("<DT><H3");
                break;
            }
            case 2: {
                w.write("<DT><A HREF=\"");
                s = this.urlText;
                s = StringUtils.replace(s, "#", "#x23;");
                s = StringUtils.replace(s, "\"", "#x22;");
                w.write(s);
                w.write(34);
                break;
            }
            case 3: {
                w.write("<HR");
            }
        }
        if (this.addDate > 0L) {
            w.write(" ADD_DATE=\"");
            w.write(String.valueOf(this.addDate));
            w.write(34);
        }
        if (this.lastVisit > 0L) {
            w.write(" LAST_VISIT=\"");
            w.write(String.valueOf(this.lastVisit));
            w.write(34);
        }
        if (this.lastModified > 0L) {
            w.write(" LAST_MODIFIED=\"");
            w.write(String.valueOf(this.lastModified));
            w.write(34);
        }
        if (this.lastCharset != null) {
            w.write(" LAST_CHARSET=\"");
            w.write(this.lastCharset);
            w.write(34);
        }
        if (this.shortcuturl != null) {
            w.write(" SHORTCUTURL=\"");
            w.write(this.shortcuturl);
            w.write(34);
        }
        if (this.folderGroup) {
            w.write(" FOLDER_GROUP=\"true\"");
        }
        if (this.ptFolder) {
            w.write(" PERSONAL_TOOLBAR_FOLDER=\"true\"");
        }
        w.write(62);
        if (this.type != 3) {
            s = this.text;
            s = StringUtils.replace(s, "&", "&amp;");
            s = StringUtils.replace(s, "<", "&lt;");
            s = StringUtils.replace(s, ">", "&gt;");
            s = StringUtils.replace(s, "\"", "&quot;");
            w.write(s);
        }
        switch (this.type) {
            case 1: {
                w.write("</H3>");
                break;
            }
            case 2: {
                w.write("</A>");
            }
        }
        w.write(10);
        if (this.type == 1) {
            for (i = 0; i < space; ++i) {
                w.write(32);
            }
            w.write("<DL><p>");
            w.write(10);
            ++level;
            for (i = 0; i < this.bookmarks.size(); ++i) {
                ((Bookmark)this.bookmarks.elementAt(i)).write(w, level);
            }
            for (i = 0; i < space; ++i) {
                w.write(32);
            }
            w.write("</DL><p>");
            w.write(10);
        }
        w.flush();
    }

    public Object clone() {
        try {
            Bookmark base = (Bookmark)super.clone();
            base.parent = null;
            if (base.bookmarks != null) {
                int size = this.bookmarks.size();
                Vector<Object> v = new Vector<Object>(size);
                for (int i = 0; i < size; ++i) {
                    v.addElement(((Bookmark)base.bookmarks.elementAt(i)).clone());
                }
                base.bookmarks = v;
            }
            return base;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        StringWriter w = new StringWriter();
        try {
            this.write(w, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return w.toString();
    }
}

