/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.java2.DnDListener;
import net.hizlab.kagetaka.java2.DnDWrapper;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

public abstract class TextComponent
extends Component {
    private static final Font DEFAULT_FONT = Font.decode("Monospaced-plain-12");
    private static final int INPUT_FIX = 5;
    private static final int BLINK_INTERVAL = 700;
    static final int INSET_H = 4;
    static final int INSET_V = 4;
    String value = "";
    Text text;
    private boolean locked;
    private boolean multiline;
    private int cols;
    private int rows;
    private boolean wordwrap;
    private Point viewPosition = new Point(0, 0);
    private Dimension textSize = new Dimension(0, 0);
    private Insets frameSize = new Insets(0, 0, 0, 0);
    private int lineHeight;
    private Blink blink;
    private boolean viewCursor;
    private boolean calcSize;
    private boolean openWindow;
    private long lastClose;

    public TextComponent(Option option, ImageCreator ic, String text, int rows, int columns, boolean multiline) {
        super(option, ic);
        this.multiline = multiline;
        this.setText(text);
        this.setRows(rows);
        this.setColumns(columns);
        this.setFrameSize(4, 4, 4, 4);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!TextComponent.this.isEnabled()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 32: {
                        e.consume();
                        TextComponent.this.showInputBox(0, 0, false);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!TextComponent.this.isEnabled()) {
                    return;
                }
                e.consume();
                if ((e.getModifiers() & 0x10) != 0) {
                    TextComponent.this.showInputBox(e.getX(), e.getY(), true);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusGained(FocusEvent e) {
                TextComponent textComponent = TextComponent.this;
                synchronized (textComponent) {
                    if (TextComponent.this.blink == null) {
                        TextComponent.this.blink = new Blink(700);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusLost(FocusEvent e) {
                TextComponent textComponent = TextComponent.this;
                synchronized (textComponent) {
                    if (TextComponent.this.blink != null) {
                        TextComponent.this.blink.interrupt();
                        TextComponent.this.blink = null;
                    }
                }
            }
        });
        DnDWrapper dndWrapper = DnDWrapper.getInstance();
        if (dndWrapper != null) {
            dndWrapper.addDnDListener(this, new DnDListener(){

                public boolean isActive() {
                    return TextComponent.this.isEnabled() && !TextComponent.this.locked;
                }

                public void drop(String data) {
                    if (TextComponent.this.getText() == null) {
                        TextComponent.this.setText(data);
                    } else {
                        TextComponent.this.setText(TextComponent.this.getText() + data);
                    }
                }
            });
        }
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.textText);
        if (Environment.javaVersion < 102) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            if (this.text == null && this.value.length() > 0) {
                this.resetText();
            }
            if (!this.calcSize) {
                this.calculateSize();
            }
        }
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean b) {
        if (!b) {
            TextComponent textComponent = this;
            synchronized (textComponent) {
                if (this.blink != null) {
                    this.blink.interrupt();
                    this.blink = null;
                }
            }
        }
        super.setEnabled(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics g, Dimension size, int state, boolean focus) {
        Border border;
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        Text text = null;
        Insets insets = null;
        TextComponent textComponent = this;
        synchronized (textComponent) {
            if (this.text == null && this.value.length() > 0) {
                this.resetText();
            }
            text = this.text;
            insets = (Insets)this.frameSize.clone();
        }
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
        if (text != null) {
            Color color = fg;
            if (state == 4) {
                color = new Color(new GrayFilter(bg).filterRGB(0, 0, color.getRGB()));
            }
            g.setColor(color);
            g.setFont(this.getFont());
            text.draw(g, size.width - insets.right + this.viewPosition.x, insets.top - this.viewPosition.y, this.wordwrap ? size.height - insets.top - insets.bottom : 0);
        }
        if ((border = this.getBorder()) != null) {
            border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
        } else {
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, 0, size.width - 1, 0);
            g.drawLine(0, 0, 0, size.height - 1);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(1, 1, size.width - 2, 1);
            g.drawLine(1, 1, 1, size.height - 2);
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(size.width - 2, 2, size.width - 2, size.height - 2);
            g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(size.width - 1, 1, size.width - 1, size.height - 1);
            g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
        }
        if (focus && this.viewCursor) {
            this.paintCursor(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCursor(Graphics g) {
        Dimension size;
        if (this.viewPosition.x >= this.lineHeight || this.viewPosition.y >= 1) {
            return;
        }
        g.setColor(Color.white);
        g.setXORMode(this.getBackground());
        int x = 0;
        int y = 0;
        TextComponent textComponent = this;
        synchronized (textComponent) {
            size = this.getSize();
            x = size.width + this.viewPosition.x - this.frameSize.right - 1;
            y = this.viewPosition.y + this.frameSize.top;
        }
        g.drawLine(Math.min(size.width - this.frameSize.right + 1, x), y, x - this.lineHeight, y);
        g.setPaintMode();
    }

    public String getText() {
        return this.value;
    }

    public synchronized void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!this.multiline) {
            int p1 = text.indexOf(13);
            int p2 = text.indexOf(10);
            if (p1 != -1 || p2 != -1) {
                text = text.substring(0, p1 != -1 && p2 != -1 ? Math.min(p1, p2) : Math.max(p1, p2));
            }
        }
        if (this.value.compareTo(text) == 0) {
            return;
        }
        this.value = text;
        this.text = null;
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    void resetText() {
        this.text = null;
        if (this.value.length() > 0) {
            try {
                this.text = super.getText(this.value);
                Insets insets = (Insets)this.frameSize.clone();
                Dimension size = this.text.getSize(this.wordwrap ? this.getSize().height - insets.top - insets.bottom : 0);
                this.setTextSize(size.width, size.height);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.setPreferredSize(0, 0);
        }
    }

    private void calculateSize() {
        this.calcSize = true;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cols; ++i) {
            sb.append('y');
        }
        try {
            Text text = super.getText(sb.toString());
            Dimension size = text.getSize(0);
            this.lineHeight = size.width;
            if (this.rows > 0) {
                size.width *= this.rows;
            }
            this.setPreferredSize(size.width + this.frameSize.left + this.frameSize.right, size.height + this.frameSize.top + this.frameSize.bottom);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.setPreferredSize(0, 0);
            return;
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean b) {
        this.locked = b;
    }

    int getColumns() {
        return this.cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setColumns(int columns) {
        if (columns <= 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.cols = columns;
            this.calcSize = false;
        }
    }

    int getRows() {
        return this.rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRows(int rows) {
        if (rows <= 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.rows = rows;
            this.calcSize = false;
        }
    }

    boolean getWordwrap() {
        return this.wordwrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWordwrap(boolean b) {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.wordwrap = b;
            this.calcSize = false;
        }
    }

    Point getViewPosition() {
        return new Point(this.viewPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewPosition(int x, int y) {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.viewPosition.x = x;
            this.viewPosition.y = y;
        }
    }

    Dimension getTextSize() {
        return new Dimension(this.textSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTextSize(int width, int height) {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.textSize.width = width;
            this.textSize.height = height;
        }
    }

    Insets getFrameSize() {
        return (Insets)this.frameSize.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFrameSize(int top, int left, int bottom, int right) {
        TextComponent textComponent = this;
        synchronized (textComponent) {
            this.frameSize.top = top;
            this.frameSize.left = left;
            this.frameSize.bottom = bottom;
            this.frameSize.right = right;
        }
    }

    int getLineHeight() {
        return this.lineHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputBox(int x, int y, boolean mouse) {
        if (!this.isEnabled() || this.locked) {
            return;
        }
        Dimension size = this.getSize();
        if (mouse && (x < this.frameSize.left - 2 || y < this.frameSize.top - 2 || size.width - this.frameSize.right + 2 <= x || size.height - this.frameSize.bottom + 2 <= y)) {
            return;
        }
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        while (!(parent instanceof Frame)) {
            if ((parent = parent.getParent()) != null) continue;
            return;
        }
        TextComponent textComponent = this;
        synchronized (textComponent) {
            if (this.openWindow || this.lastClose + 200L > System.currentTimeMillis()) {
                return;
            }
            this.openWindow = true;
            this.lastClose = 0L;
        }
        Window window = this.showInputBox((Frame)parent, x, y);
        if (window == null) {
            this.openWindow = false;
            return;
        }
        window.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ((Window)e.getComponent()).removeWindowListener(this);
                TextComponent.this.lastClose = System.currentTimeMillis();
                TextComponent.this.openWindow = false;
            }
        });
    }

    abstract Window showInputBox(Frame var1, int var2, int var3);

    private class Blink
    extends Thread {
        private int interval;

        private Blink(int interval) {
            this.interval = interval;
            TextComponent.this.viewCursor = true;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(this.interval);
                    Graphics g = TextComponent.this.getGraphics();
                    if (g != null) {
                        try {
                            TextComponent.this.paintCursor(g);
                        }
                        finally {
                            g.dispose();
                        }
                    }
                    TextComponent.this.viewCursor = !TextComponent.this.viewCursor;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

