/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.InnerScrollbar;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

public class List
extends Component {
    private static final String BASE = "list";
    private static int nameCounter = 0;
    private static final int INSET_LIST_H = 2;
    private static final int INSET_LIST_V = 2;
    private static final int INSET_NONE_H = 1;
    private static final int INSET_NONE_V = 1;
    private static final int INSET_S = 1;
    private static final int SB_H = 16;
    private static final int MOVE_CLICK = 1;
    private static final int MOVE_DRAG = 2;
    private static final int MOVE_KEY = 3;
    private int INSET_H;
    private int INSET_V;
    private int rows;
    private boolean multipleMode;
    private boolean listMode;
    private Vector values = new Vector();
    private Vector texts = new Vector();
    private int selectedIndex = -1;
    private Vector selections = null;
    private int currentIndex = 0;
    private int currentIndex2 = 0;
    private int currentIndex3 = 0;
    private int viewStart = 0;
    private int viewEnd = 0;
    private int visibleIndex = -1;
    private int visibleReq = -1;
    private int rowWidth = -1;
    private Scrollbar scrollbar = null;
    private boolean lastMultipleSelected = true;
    private AutoScroll autoScroll;
    private boolean resetText = true;

    public List(Option option, ImageCreator ic) {
        this(option, ic, 0, false, true);
    }

    public List(Option option, ImageCreator ic, int rows) {
        this(option, ic, rows, false, true);
    }

    public List(Option option, ImageCreator ic, int rows, boolean multipleMode) {
        this(option, ic, rows, multipleMode, true);
    }

    List(Option option, ImageCreator ic, int rows, boolean multipleMode, boolean listMode) {
        super(option, ic);
        this.rows = rows;
        this.setMultipleMode(multipleMode);
        this.listMode = listMode;
        if (listMode) {
            this.INSET_H = 2;
            this.INSET_V = 2;
        } else {
            this.INSET_H = 1;
            this.INSET_V = 1;
        }
        this.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent e) {
                if (!List.this.isEnabled()) {
                    return;
                }
                boolean isShift = (e.getModifiers() & 1) != 0;
                boolean isCtrl = (e.getModifiers() & 2) != 0;
                switch (e.getKeyCode()) {
                    case 37: 
                    case 40: {
                        e.consume();
                        int index = List.this.currentIndex;
                        if (index + 1 >= List.this.values.size()) {
                            return;
                        }
                        List.this.moveCurrent(++index, 3, (e.getModifiers() & 1) != 0, (e.getModifiers() & 2) != 0);
                        break;
                    }
                    case 38: 
                    case 39: {
                        e.consume();
                        int index = List.this.currentIndex;
                        if (index <= 0) {
                            return;
                        }
                        List.this.moveCurrent(--index, 3, (e.getModifiers() & 1) != 0, (e.getModifiers() & 2) != 0);
                        break;
                    }
                    case 32: {
                        e.consume();
                        boolean selected = false;
                        List list = List.this;
                        synchronized (list) {
                            if (List.this.currentIndex == -1 || List.this.currentIndex >= List.this.values.size()) {
                                return;
                            }
                            if (List.this.multipleMode) {
                                selected = List.this.isIndexSelected(List.this.currentIndex);
                            }
                        }
                        if (selected) {
                            List.this.deselect(List.this.currentIndex);
                            break;
                        }
                        List.this.select(List.this.currentIndex);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!List.this.isEnabled()) {
                    return;
                }
                e.consume();
                if (List.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                    return;
                }
                List.this.moveCurrentFromPoint(e.getX(), e.getY(), 1, true, (e.getModifiers() & 1) != 0, (e.getModifiers() & 2) != 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseReleased(MouseEvent e) {
                if (!List.this.isEnabled()) {
                    return;
                }
                e.consume();
                if (List.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                    return;
                }
                List list = List.this;
                synchronized (list) {
                    if (List.this.autoScroll != null) {
                        List.this.autoScroll.interrupt();
                        List.this.autoScroll = null;
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                if (!List.this.isEnabled()) {
                    return;
                }
                e.consume();
                if (List.this.scrollbar.contains(e.getX(), e.getY(), true)) {
                    return;
                }
                List.this.moveCurrentFromPoint(e.getX(), e.getY(), 2, true, (e.getModifiers() & 1) != 0, (e.getModifiers() & 2) != 0);
            }

            public void mouseMoved(MouseEvent e) {
                if (!List.this.isEnabled()) {
                    return;
                }
                e.consume();
                if (List.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                    return;
                }
                if (!List.this.listMode) {
                    List.this.moveCurrentFromPoint(e.getX(), e.getY(), 2, false, false, false);
                }
            }
        });
        this.setForeground(SystemColor.textText);
        if (Environment.javaVersion < 102) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        List list = this;
        synchronized (list) {
            if (this.resetText) {
                this.resetText();
            }
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean b) {
        if (!b) {
            List list = this;
            synchronized (list) {
                if (this.autoScroll != null) {
                    this.autoScroll.interrupt();
                    this.autoScroll = null;
                }
            }
        }
        super.setEnabled(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            this.scrollbar = new Scrollbar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            if (this.scrollbar != null) {
                this.scrollbar.dispose();
                this.scrollbar = null;
            }
        }
    }

    protected String paramString() {
        String str = super.paramString();
        return str + ",selected=" + this.getSelectedItem();
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics g, Dimension size, int state, boolean focus) {
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        Vector texts = null;
        Vector selections = null;
        int selectedIndex = -1;
        int lineNum = 0;
        int viewNum = 0;
        List list = this;
        synchronized (list) {
            if (this.resetText) {
                this.resetText();
            }
            texts = (Vector)this.texts.clone();
            if (this.multipleMode) {
                selections = (Vector)this.selections.clone();
            }
            selectedIndex = this.selectedIndex;
            lineNum = texts.size();
            viewNum = size.width / this.rowWidth;
            if (lineNum == 0) {
                return;
            }
            if (lineNum <= viewNum) {
                this.viewStart = 0;
            } else if (this.visibleReq != -1 && this.visibleReq < this.viewStart) {
                this.viewStart = this.visibleReq;
            } else if (this.visibleReq != -1 && this.visibleReq > this.viewEnd) {
                this.viewStart = Math.max(0, this.visibleReq - viewNum + 1);
            } else if (this.viewStart + viewNum > lineNum) {
                this.viewStart = Math.max(0, lineNum - viewNum);
            }
            this.viewEnd = Math.min(this.viewStart + viewNum - 1, lineNum - 1);
            this.visibleReq = -1;
        }
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
        Color color = fg;
        if (state == 4) {
            color = new Color(new GrayFilter(bg).filterRGB(0, 0, color.getRGB()));
        }
        g.setFont(this.getFont());
        int x = size.width - this.INSET_H - 1;
        int y = this.INSET_V;
        int w = this.rowWidth;
        int h = size.height - this.INSET_V * 2;
        if (this.scrollbar.isVisible()) {
            h -= 16;
        }
        for (int i = this.viewStart; i <= this.viewEnd; ++i) {
            if (this.isIndexSelected(i)) {
                g.setColor(SystemColor.textHighlight);
                g.fillRect(x - w + 1, y, w, h);
                g.setColor(SystemColor.textHighlightText);
            } else {
                g.setColor(color);
            }
            ((Text)texts.elementAt(i)).draw(g, x + 1, y + 1, 0);
            if (focus && i == this.currentIndex) {
                GraphicsUtils.drawDashed(g, x - w + 1, y, w, 1, 1, 1, 1);
                GraphicsUtils.drawDashed(g, x - w + 1, y, 1, h, 1, 1, 2);
                GraphicsUtils.drawDashed(g, x - w + 1, y + h - 1, w, 1, 1, 1, 1);
                GraphicsUtils.drawDashed(g, x, y, 1, h, 1, 1, 2);
            }
            x -= this.rowWidth;
        }
        Border border = this.getBorder();
        if (border != null) {
            border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
        } else if (this.listMode) {
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, 0, size.width - 1, 0);
            g.drawLine(0, 0, 0, size.height - 1);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(1, 1, size.width - 2, 1);
            g.drawLine(1, 1, 1, size.height - 2);
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(size.width - 2, 2, size.width - 2, size.height - 2);
            g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(size.width - 1, 1, size.width - 1, size.height - 1);
            g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
        } else {
            g.setColor(SystemColor.controlDkShadow);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        }
        if (this.scrollbar.isVisible()) {
            this.scrollbar.setBounds(this.INSET_H, size.height - 16 - this.INSET_V, size.width - this.INSET_H * 2, 16);
            this.scrollbar.setReverseValues(this.viewStart, viewNum, 0, lineNum);
            this.scrollbar.setBlockIncrement(Math.max(1, viewNum - 1));
            this.scrollbar.paint(g, true);
        }
    }

    public synchronized void add(String item) {
        this.addItem(item);
    }

    public synchronized void addItem(String item) {
        int index;
        this.resetText = true;
        this.values.addElement(item);
        this.texts.addElement(null);
        if (this.multipleMode) {
            this.selections.addElement(Boolean.FALSE);
        }
        if (this.viewStart <= (index = this.values.size()) && index <= this.viewEnd) {
            this.repaintForce();
        }
    }

    public synchronized void add(String item, int index) {
        this.addItem(item, index);
    }

    public synchronized void addItem(String item, int index) {
        this.resetText = true;
        this.values.insertElementAt(item, index);
        this.texts.insertElementAt(null, index);
        if (this.multipleMode) {
            this.selections.insertElementAt(Boolean.FALSE, index);
        }
        if (this.viewStart <= index && index <= this.viewEnd) {
            this.repaintForce();
        }
    }

    public synchronized void replaceItem(String item, int index) {
        this.resetText = true;
        this.values.setElementAt(item, index);
        this.texts.setElementAt(null, index);
        if (this.viewStart <= index && index <= this.viewEnd) {
            this.repaintForce();
        }
    }

    public String getItem(int index) {
        return (String)this.values.elementAt(index);
    }

    public synchronized String[] getItems() {
        Object[] lists = new String[this.values.size()];
        this.values.copyInto(lists);
        return lists;
    }

    public synchronized void delItem(int index) {
        this.remove(index);
    }

    public synchronized void remove(int index) {
        this.values.removeElementAt(index);
        this.texts.removeElementAt(index);
        if (this.multipleMode) {
            this.selections.removeElementAt(index);
        }
        if (index == this.selectedIndex) {
            this.select(-1);
        }
        if (this.viewStart <= index && index <= this.viewEnd) {
            this.repaintForce();
        }
    }

    public synchronized void remove(String item) {
        int index = this.values.indexOf(item);
        if (index == -1) {
            return;
        }
        this.remove(index);
    }

    public synchronized void removeAll() {
        this.values.removeAllElements();
        this.texts.removeAllElements();
        if (this.multipleMode) {
            this.selections.removeAllElements();
        }
        this.selectedIndex = -1;
        this.currentIndex = 0;
        this.currentIndex2 = 0;
        this.currentIndex3 = 0;
        this.visibleReq = -1;
        this.repaintForce();
    }

    public int getItemCount() {
        return this.values.size();
    }

    public synchronized int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized int[] getSelectedIndexs() {
        if (!this.multipleMode) {
            if (this.selectedIndex == -1) {
                return new int[0];
            }
            return new int[]{this.selectedIndex};
        }
        int count = 0;
        for (int i = this.selections.size() - 1; i >= 0; --i) {
            if (!((Boolean)this.selections.elementAt(i)).booleanValue()) continue;
            ++count;
        }
        int[] ret = new int[count];
        if (count > 0) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                if (!((Boolean)this.selections.elementAt(i)).booleanValue()) continue;
                ret[--count] = i;
            }
        }
        return ret;
    }

    public synchronized String getSelectedItem() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.getItem(this.selectedIndex);
    }

    public synchronized String[] getSelectedItems() {
        if (!this.multipleMode) {
            if (this.selectedIndex == -1) {
                return new String[0];
            }
            return new String[]{(String)this.values.elementAt(this.selectedIndex)};
        }
        int count = 0;
        for (int i = this.selections.size() - 1; i >= 0; --i) {
            if (!((Boolean)this.selections.elementAt(i)).booleanValue()) continue;
            ++count;
        }
        String[] ret = new String[count];
        if (count > 0) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                if (!((Boolean)this.selections.elementAt(i)).booleanValue()) continue;
                ret[--count] = (String)this.values.elementAt(i);
            }
        }
        return ret;
    }

    public synchronized boolean isIndexSelected(int index) {
        if (this.multipleMode) {
            return (Boolean)this.selections.elementAt(index);
        }
        return this.selectedIndex == index;
    }

    public synchronized void select(int index) {
        if (this.selectedIndex == index) {
            return;
        }
        boolean moveCurrent = this.currentIndex == -1 || !this.multipleMode || this.multipleMode && this.currentIndex < this.selections.size() && !this.isIndexSelected(this.currentIndex);
        this.selectedIndex = index;
        if (moveCurrent) {
            this.currentIndex = index;
            this.currentIndex2 = index;
            this.currentIndex3 = index;
            this.visibleReq = index;
        }
        if (this.multipleMode) {
            this.selections.setElementAt(Boolean.TRUE, index);
        }
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    public synchronized void deselect(int index) {
        if (this.selectedIndex == index) {
            this.selectedIndex = -1;
        }
        if (this.multipleMode) {
            this.selections.setElementAt(Boolean.FALSE, index);
        }
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    public int getRows() {
        return this.rows;
    }

    public boolean getMultipleMode() {
        return this.multipleMode;
    }

    public synchronized void setMultipleMode(boolean b) {
        this.multipleMode = b;
        if (this.multipleMode) {
            this.selections = new Vector();
            for (int i = this.values.size() - 1; i >= 0; --i) {
                this.selections.addElement(Boolean.FALSE);
            }
            if (this.selectedIndex != -1) {
                this.selections.setElementAt(Boolean.TRUE, this.selectedIndex);
            }
        } else {
            this.selections = null;
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void makeVisible(int index) {
        this.visibleIndex = index;
        if ((this.visibleIndex < this.viewStart || this.viewEnd < this.visibleIndex) && this.isVisible()) {
            this.visibleReq = index;
            this.repaintForce();
        }
    }

    public boolean containsScrollbar(int x, int y) {
        Scrollbar scrollbar = this.scrollbar;
        return scrollbar != null && scrollbar.contains(x, y, false);
    }

    private void resetText() {
        Dimension size;
        Scrollbar scrollbar = this.scrollbar;
        if (scrollbar == null) {
            return;
        }
        this.resetText = false;
        int w = 0;
        int h = 0;
        for (int i = this.values.size() - 1; i >= 0; --i) {
            String value = (String)this.values.elementAt(i);
            Text text = (Text)this.texts.elementAt(i);
            if (value != null && text == null) {
                try {
                    text = super.getText(value);
                    this.texts.setElementAt(text, i);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
            if (text == null) continue;
            size = text.getSize(0);
            w = Math.max(w, size.width);
            h = Math.max(h, size.height);
        }
        try {
            size = super.getText("y").getSize(0);
            w = Math.max(w, size.width);
            h = Math.max(h, size.height);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        int row = 0;
        row = this.listMode ? (this.rows > 0 ? this.rows : this.values.size()) : Math.min(this.rows, this.values.size());
        this.setPreferredSize((w + 2) * row + this.INSET_H * 2, h + 2 + this.INSET_V * 2 + 16);
        this.rowWidth = w + 2;
        scrollbar.setVisible(row < this.values.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCurrentFromPoint(int x, int y, int source, boolean auto, boolean isShift, boolean isCtrl) {
        int index = 0;
        List list = this;
        synchronized (list) {
            Dimension size = this.getSize();
            if (source != 2) {
                if (x <= this.INSET_H || size.width - this.INSET_H <= x || y <= this.INSET_V || size.height - this.INSET_V <= y) {
                    return;
                }
            } else {
                if (x <= this.INSET_H) {
                    if (auto && this.viewEnd + 1 < this.values.size()) {
                        int d = -1 * (x - this.INSET_H);
                        if (this.autoScroll == null) {
                            this.autoScroll = new AutoScroll(true, d, isShift, isCtrl);
                            this.autoScroll.start();
                        } else {
                            this.autoScroll.setDistance(true, d, isShift, isCtrl);
                        }
                    }
                    return;
                }
                if (size.width - this.INSET_H <= x) {
                    if (auto && this.viewStart > 0) {
                        int d = x - (size.width - this.INSET_H);
                        if (this.autoScroll == null) {
                            this.autoScroll = new AutoScroll(false, d, isShift, isCtrl);
                            this.autoScroll.start();
                        } else {
                            this.autoScroll.setDistance(false, d, isShift, isCtrl);
                        }
                    }
                    return;
                }
                if (this.autoScroll != null) {
                    this.autoScroll.interrupt();
                    this.autoScroll = null;
                }
            }
            int w = size.width - this.INSET_H * 2;
            int d = w % this.rowWidth;
            int last = this.viewStart + w / this.rowWidth - 1;
            index = (x -= this.INSET_H) <= d ? last : last - (x - d) / this.rowWidth;
        }
        this.moveCurrent(index, source, isShift, isCtrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCurrent(int index, int source, boolean isShift, boolean isCtrl) {
        block24: {
            List list = this;
            synchronized (list) {
                block22: {
                    int size;
                    block25: {
                        block23: {
                            int i;
                            size = this.values.size();
                            if (index >= size || index == this.currentIndex && index == this.selectedIndex && !this.multipleMode) {
                                return;
                            }
                            this.currentIndex = index;
                            if (!isShift) {
                                this.currentIndex2 = index;
                            }
                            if (source == 1) {
                                this.currentIndex3 = index;
                            }
                            this.visibleReq = index;
                            if (!this.multipleMode) break block22;
                            if (!isShift) break block23;
                            int start = Math.min(this.currentIndex, this.currentIndex2);
                            int end = Math.max(this.currentIndex, this.currentIndex2);
                            for (i = 0; i < start; ++i) {
                                this.selections.setElementAt(Boolean.FALSE, i);
                            }
                            for (i = start; i <= end; ++i) {
                                this.selections.setElementAt(Boolean.TRUE, i);
                            }
                            for (i = end + 1; i < size; ++i) {
                                this.selections.setElementAt(Boolean.FALSE, i);
                            }
                            break block24;
                        }
                        if (!isCtrl) break block25;
                        switch (source) {
                            case 1: {
                                this.lastMultipleSelected = this.isIndexSelected(index);
                                if (this.lastMultipleSelected) {
                                    this.selections.setElementAt(Boolean.FALSE, index);
                                    break;
                                }
                                this.selections.setElementAt(Boolean.TRUE, index);
                                break;
                            }
                            case 2: {
                                if (this.lastMultipleSelected) {
                                    this.selections.setElementAt(Boolean.FALSE, index);
                                    break;
                                }
                                this.selections.setElementAt(Boolean.TRUE, index);
                                break;
                            }
                        }
                        break block24;
                    }
                    switch (source) {
                        case 2: {
                            int i;
                            int start = Math.min(this.currentIndex, this.currentIndex3);
                            int end = Math.max(this.currentIndex, this.currentIndex3);
                            for (i = 0; i < start; ++i) {
                                this.selections.setElementAt(Boolean.FALSE, i);
                            }
                            for (i = start; i <= end; ++i) {
                                this.selections.setElementAt(Boolean.TRUE, i);
                            }
                            for (i = end + 1; i < size; ++i) {
                                this.selections.setElementAt(Boolean.FALSE, i);
                            }
                            break block24;
                        }
                        default: {
                            for (int i = 0; i < size; ++i) {
                                this.selections.setElementAt(Boolean.FALSE, i);
                            }
                            this.selections.setElementAt(Boolean.TRUE, index);
                            break;
                        }
                    }
                    break block24;
                }
                this.selectedIndex = index;
            }
        }
        this.repaintForce();
    }

    private class AutoScroll
    extends Thread {
        private boolean forward;
        private int interval;
        private boolean isShift;
        private boolean isCtrl;

        private AutoScroll(boolean forward, int distance, boolean isShift, boolean isCtrl) {
            this.setDistance(forward, distance, isShift, isCtrl);
        }

        private void setDistance(boolean forward, int n, boolean isShift, boolean isCtrl) {
            this.forward = forward;
            this.isShift = isShift;
            this.isCtrl = isCtrl;
            this.interval = n < 4 ? 200 : (n < 8 ? 80 : 20);
        }

        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(this.interval);
                    int index = 0;
                    if (!(this.forward ? (index = List.this.viewEnd + 1) >= List.this.values.size() : (index = List.this.viewStart - 1) < 0)) {
                        List.this.moveCurrent(index, 2, this.isShift, this.isCtrl);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class Scrollbar
    extends InnerScrollbar {
        private Scrollbar() {
            super(0, List.this);
        }

        public void repaint() {
            List.this.repaintForce();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changedValue() {
            List list = List.this;
            synchronized (list) {
                int v = this.getReverseValue();
                if (v == List.this.viewStart) {
                    return;
                }
                List.this.viewStart = v;
            }
            List.this.repaintForce();
        }
    }
}

