/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.awt.tate.List;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

public class Choice
extends Component {
    private static final String BASE = "choice";
    private static int nameCounter = 0;
    private static final int INSET_H = 2;
    private static final int INSET_V = 2;
    private static final int INSET_A = 2;
    private static final int INSET_S = 3;
    private static final int ARROW_WIDTH = 11;
    private static final int ARROW_HEIGHT = 12;
    private static final int[] ARROW_ALLOW = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int index = -1;
    private Vector values = new Vector();
    private Vector texts = new Vector();
    private List list;
    private boolean openWindow;
    private long lastClose;
    private boolean resetText = true;

    public Choice(Option option, ImageCreator ic) {
        super(option, ic);
        this.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent e) {
                if (!Choice.this.isEnabled()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 37: 
                    case 40: {
                        e.consume();
                        if ((e.getModifiers() & 8) != 0) {
                            Choice.this.showItemList();
                            return;
                        }
                        Choice choice = Choice.this;
                        synchronized (choice) {
                            if (Choice.this.index + 1 >= Choice.this.values.size()) {
                                return;
                            }
                            Choice.this.index++;
                        }
                        Choice.this.repaintForce();
                        break;
                    }
                    case 38: 
                    case 39: {
                        e.consume();
                        if ((e.getModifiers() & 8) != 0) {
                            Choice.this.showItemList();
                            return;
                        }
                        Choice choice = Choice.this;
                        synchronized (choice) {
                            if (Choice.this.index <= 0) {
                                return;
                            }
                            Choice.this.index--;
                        }
                        Choice.this.repaintForce();
                        break;
                    }
                    case 32: {
                        e.consume();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!Choice.this.isEnabled()) {
                    return;
                }
                e.consume();
                if ((e.getModifiers() & 0x10) != 0) {
                    Choice.this.showItemList();
                }
            }
        });
        this.setForeground(SystemColor.textText);
        if (Environment.javaVersion < 102) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Choice choice = this;
        synchronized (choice) {
            if (this.resetText) {
                this.resetText();
            }
        }
        return super.getPreferredSize();
    }

    protected String paramString() {
        String str = super.paramString();
        return str + ",current=" + this.getSelectedItem();
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics g, Dimension size, int state, boolean focus) {
        Border border;
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        Text text = null;
        Choice choice = this;
        synchronized (choice) {
            if (this.resetText) {
                this.resetText();
            }
            if (this.index != -1 && this.index < this.texts.size()) {
                text = (Text)this.texts.elementAt(this.index);
            }
        }
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
        int x = 3;
        int y = 3;
        int w = size.width - 4 - 2;
        int h = size.height - 4 - 4 - 12 - 2;
        Color color = fg;
        if (focus) {
            g.setColor(SystemColor.textHighlight);
            g.fillRect(x, y, w, h);
            g.setColor(SystemColor.textHighlightText);
        } else {
            if (state == 4) {
                color = new Color(new GrayFilter(bg).filterRGB(0, 0, color.getRGB()));
            }
            g.setColor(color);
        }
        if (text != null) {
            g.setFont(this.getFont());
            text.draw(g, size.width - 2 - 3, 5, 0);
        }
        if (focus) {
            GraphicsUtils.drawDashed(g, x, y, w, 1, 1, 1, 1);
            GraphicsUtils.drawDashed(g, x, y, 1, h, 1, 1, 2);
            GraphicsUtils.drawDashed(g, x, y + h - 1, w, 1, 1, 1, 1);
            GraphicsUtils.drawDashed(g, x + w - 1, y, 1, h, 1, 1, 2);
        }
        if ((border = this.getBorder()) != null) {
            border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
        } else {
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, 0, size.width - 1, 0);
            g.drawLine(0, 0, 0, size.height - 1);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(1, 1, size.width - 2, 1);
            g.drawLine(1, 1, 1, size.height - 2);
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(size.width - 2, 2, size.width - 2, size.height - 2);
            g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(size.width - 1, 1, size.width - 1, size.height - 1);
            g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
        }
        int x1 = 2;
        int y1 = size.height - 2 - 12 - 4;
        int x2 = size.width - 2 - 1;
        int y2 = y1 + 12 + 4 - 1;
        g.setColor(SystemColor.control);
        g.fillRect(x1 + 2, y1 + 2, x2 - x1 + 1 - 4, y2 - y1 + 1 - 4);
        g.setColor(SystemColor.controlHighlight);
        g.drawLine(x1, y1, x2, y1);
        g.drawLine(x1, y1, x1, y2);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
        g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
        g.setColor(SystemColor.controlShadow);
        g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
        g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
        g.setColor(SystemColor.controlDkShadow);
        g.drawLine(x2, y1, x2, y2);
        g.drawLine(x1, y2, x2, y2);
        this.drawArray(g, ARROW_ALLOW, (size.width - 11) / 2, y1 + 2, 11, 12, color);
    }

    public synchronized void add(String item) {
        this.addItem(item);
    }

    public synchronized void addItem(String item) {
        this.resetText = true;
        this.values.addElement(item);
        this.texts.addElement(null);
        if (this.list != null) {
            this.list.addItem(item);
        }
    }

    public synchronized void insert(String item, int index) {
        this.resetText = true;
        this.values.insertElementAt(item, index);
        this.texts.insertElementAt(null, index);
        if (this.list != null) {
            this.list.addItem(item, index);
        }
    }

    public String getItem(int index) {
        return (String)this.values.elementAt(index);
    }

    public synchronized void remove(int index) {
        this.values.removeElementAt(index);
        this.texts.removeElementAt(index);
        if (index == this.index) {
            this.select(-1);
        }
        if (this.list != null) {
            this.list.remove(index);
        }
    }

    public synchronized void remove(String item) {
        int index = this.values.indexOf(item);
        if (index == -1) {
            return;
        }
        this.remove(index);
    }

    public synchronized void removeAll() {
        this.values.removeAllElements();
        this.texts.removeAllElements();
        this.index = -1;
        this.repaintForce();
        if (this.list != null) {
            this.list.removeAll();
        }
    }

    public int getItemCount() {
        return this.values.size();
    }

    public synchronized int getSelectedIndex() {
        return this.index;
    }

    public synchronized String getSelectedItem() {
        if (this.index == -1) {
            return null;
        }
        return this.getItem(this.index);
    }

    public synchronized void select(int index) {
        if (this.index == index) {
            return;
        }
        this.index = index;
        if (this.isVisible() && this.values.size() > 0) {
            this.repaintForce();
        }
    }

    public synchronized void select(String item) {
        int index = this.values.indexOf(item);
        if (index == -1) {
            return;
        }
        this.select(index);
    }

    private void resetText() {
        Dimension size;
        this.resetText = false;
        int w = 11;
        int h = 0;
        for (int i = this.values.size() - 1; i >= 0; --i) {
            String value = (String)this.values.elementAt(i);
            Text text = (Text)this.texts.elementAt(i);
            if (value != null && text == null) {
                try {
                    text = super.getText(value);
                    this.texts.setElementAt(text, i);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
            if (text == null) continue;
            size = text.getSize(0);
            w = Math.max(w, size.width);
            h = Math.max(h, size.height);
        }
        try {
            size = super.getText("y").getSize(0);
            w = Math.max(w, size.width);
            h = Math.max(h, size.height);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.setPreferredSize(w + 4 + 6, h + 4 + 6 + 4 + 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArray(Graphics g, int[] base, int x, int y, int width, int height, Color color) {
        SyncObserver so;
        int fg = color.getRGB() | 0xFF000000;
        int bg = 0;
        int[] buffer = new int[base.length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = base[i] == 1 ? fg : bg;
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, buffer, 0, width);
        mis.setAnimated(false);
        Image image = this.getToolkit().createImage(mis);
        SyncObserver syncObserver = so = new SyncObserver();
        synchronized (syncObserver) {
            so.init(g, x, y, width, height);
            if (!g.drawImage(image, x, y, width, height, so)) {
                try {
                    so.wait(10000L);
                }
                catch (InterruptedException e) {
                    System.out.println("wait to draw a icon");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showItemList() {
        Choice choice = this;
        synchronized (choice) {
            if (this.openWindow || this.lastClose + 200L > System.currentTimeMillis()) {
                return;
            }
            this.openWindow = true;
            this.lastClose = 0L;
        }
        Container parent = this.getParent();
        while (!(parent instanceof Frame)) {
            if ((parent = parent.getParent()) != null) continue;
            this.openWindow = false;
            return;
        }
        ListWindow listWindow = new ListWindow((Frame)parent);
        Point point = this.getLocationOnScreen();
        Dimension size = listWindow.getSize();
        ((java.awt.Component)listWindow).setLocation(point.x - size.width, point.y + 3);
        listWindow.show();
        this.list.requestFocus();
        listWindow.toFront();
    }

    private class ListWindow
    extends Window {
        private Frame parent;
        private MouseListener mouseListener;
        private ComponentListener componentListener;
        private boolean isClosed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListWindow(Frame parent) {
            super(parent);
            this.parent = parent;
            Choice choice = Choice.this;
            synchronized (choice) {
                Choice.this.list = new List(Choice.this.option, Choice.this.ic, 10, false, false);
                int size = Choice.this.values.size();
                for (int i = 0; i < size; ++i) {
                    Choice.this.list.addItem((String)Choice.this.values.elementAt(i));
                }
                Choice.this.list.select(Choice.this.index);
            }
            this.add(Choice.this.list);
            this.pack();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowDeactivated(WindowEvent e) {
                    this.this$1.removeWindowListener(this);
                    ListWindow.access$500(this.this$1, false);
                }
            });
            Choice.this.list.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = this$1;
                }

                public void focusLost(FocusEvent e) {
                    ListWindow.access$500(this.this$1, false);
                }
            });
            Choice.this.list.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 27: {
                            e.consume();
                            ListWindow.access$500(this.this$1, false);
                            break;
                        }
                        case 10: {
                            e.consume();
                            ListWindow.access$500(this.this$1, true);
                        }
                    }
                }
            });
            Choice.this.list.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    e.consume();
                    if (Choice.access$400(ListWindow.access$600(this.this$1)).containsScrollbar(e.getX(), e.getY())) {
                        return;
                    }
                    ListWindow.access$500(this.this$1, true);
                }
            });
            this.mouseListener = new MouseAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent e) {
                    ListWindow.access$500(this.this$1, false);
                }
            };
            parent.addMouseListener(this.mouseListener);
            this.componentListener = new ComponentAdapter(this){
                private final /* synthetic */ ListWindow this$1;
                {
                    this.this$1 = this$1;
                }

                public void componentResized(ComponentEvent e) {
                    ListWindow.access$500(this.this$1, false);
                }

                public void componentMoved(ComponentEvent e) {
                    ListWindow.access$500(this.this$1, false);
                }
            };
            parent.addComponentListener(this.componentListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean commit) {
            ListWindow listWindow = this;
            synchronized (listWindow) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            if (commit) {
                Choice.this.select(Choice.this.list.getSelectedIndex());
            }
            Choice.this.lastClose = System.currentTimeMillis();
            Choice.this.openWindow = false;
            this.dispose();
        }

        public void update(Graphics g) {
            ((Container)this).paint(g);
        }

        public void dispose() {
            super.dispose();
            this.parent.removeMouseListener(this.mouseListener);
            this.parent.removeComponentListener(this.componentListener);
        }

        public void add(Component c) {
            super.add(c);
        }

        static /* synthetic */ void access$500(ListWindow x0, boolean x1) {
            x0.close(x1);
        }

        static /* synthetic */ Choice access$600(ListWindow x0) {
            return x0.Choice.this;
        }
    }
}

