/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.awt.tate.CheckboxGroup;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

public class Checkbox
extends Component {
    private static final String BASE = "checkbox";
    private static int nameCounter = 0;
    private static final int INSET_H = 3;
    private static final int INSET_V = 3;
    private static final int INSET_S = 5;
    private static final int CHECK_WIDTH = 14;
    private static final int CHECK_HEIGHT = 14;
    private static final int[] CHECK_CHECK = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int RADIO_WIDTH = 12;
    private static final int RADIO_HEIGHT = 12;
    private static final int[] RADIO_FRAME1 = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RADIO_FRAME2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RADIO_FRAME3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RADIO_FRAME4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
    private static final int[] RADIO_BACK = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RADIO_CHECK = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Color iconColor;
    private Image backImage;
    private String label;
    private Text text;
    private boolean state;
    CheckboxGroup group;
    private boolean resetText = true;

    public Checkbox(Option option, ImageCreator ic) {
        this(option, ic, null, false, null);
    }

    public Checkbox(Option option, ImageCreator ic, String label) {
        this(option, ic, label, false, null);
    }

    public Checkbox(Option option, ImageCreator ic, String label, boolean state) {
        this(option, ic, label, state, null);
    }

    public Checkbox(Option option, ImageCreator ic, String label, boolean state, CheckboxGroup group) {
        super(option, ic);
        this.setLabel(label);
        this.setState(state);
        this.setCheckboxGroup(group);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!Checkbox.this.isEnabled()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 32: {
                        e.consume();
                        Checkbox.this.setViewState(3);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent e) {
                if (!Checkbox.this.isEnabled()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 32: {
                        e.consume();
                        if (Checkbox.this.getViewState() != 3) break;
                        Checkbox.this.setViewState(0);
                        if (!Checkbox.this.isEnabled()) break;
                        Checkbox checkbox = Checkbox.this;
                        synchronized (checkbox) {
                            Checkbox.this.setState(Checkbox.this.group == null ? !Checkbox.this.state : true);
                            break;
                        }
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent e) {
                if (!Checkbox.this.isEnabled()) {
                    return;
                }
                e.consume();
                if ((e.getModifiers() & 0x10) != 0) {
                    Checkbox checkbox = Checkbox.this;
                    synchronized (checkbox) {
                        Checkbox.this.setState(Checkbox.this.group == null ? !Checkbox.this.state : true);
                    }
                }
            }
        });
        if (Environment.javaVersion < 102) {
            this.setIconcolor(SystemColor.window);
        } else {
            this.setIconcolor(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Checkbox checkbox = this;
        synchronized (checkbox) {
            if (this.resetText) {
                this.resetText();
            }
        }
        return super.getPreferredSize();
    }

    protected String paramString() {
        String str = super.paramString();
        String label = this.label;
        if (label != null) {
            str = str + ",label=" + label;
        }
        return str + ",state=" + this.state;
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics g, Dimension size, int state, boolean focus) {
        Border border;
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        Text text = null;
        boolean checkBox = true;
        boolean checked = false;
        Checkbox checkbox = this;
        synchronized (checkbox) {
            if (this.resetText) {
                this.resetText();
            }
            text = this.text;
            checkBox = this.group == null;
            checked = this.state;
        }
        if (this.backImage != null) {
            SyncObserver so;
            SyncObserver syncObserver = so = new SyncObserver();
            synchronized (syncObserver) {
                so.init(g, 0, 0, size.width, size.height);
                if (!g.drawImage(this.backImage, 0, 0, size.width, size.height, so)) {
                    try {
                        so.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("wait to draw a backimage");
                    }
                }
            }
        }
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
        if (checkBox) {
            int x = (size.width - 14) / 2;
            int y = text != null ? 3 : 1;
            g.setColor(SystemColor.controlShadow);
            g.drawLine(x, y, x + 14 - 2, y);
            g.drawLine(x, y, x, y + 14 - 2);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(x + 1, y + 1, x + 14 - 3, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + 14 - 3);
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(x + 14 - 2, y + 1, x + 14 - 2, y + 14 - 2);
            g.drawLine(x + 1, y + 14 - 2, x + 14 - 2, y + 14 - 2);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(x + 14 - 1, y, x + 14 - 1, y + 14 - 1);
            g.drawLine(x, y + 14 - 1, x + 14 - 1, y + 14 - 1);
            g.setColor(state == 2 || state == 3 || state == 4 ? SystemColor.controlHighlight : this.iconColor);
            g.fillRect(x + 2, y + 2, 10, 10);
            if (checked) {
                this.drawArray(g, CHECK_CHECK, new int[196], x, y, 14, 14, fg);
            }
        } else {
            int[] buffer = new int[144];
            int x = (size.width - 12) / 2;
            int y = text != null ? 3 : 1;
            Object c = null;
            this.drawArray(g, RADIO_FRAME1, buffer, x, y, 12, 12, SystemColor.controlShadow);
            this.drawArray(g, RADIO_FRAME2, buffer, x, y, 12, 12, SystemColor.controlDkShadow);
            this.drawArray(g, RADIO_FRAME3, buffer, x, y, 12, 12, SystemColor.controlHighlight);
            this.drawArray(g, RADIO_FRAME4, buffer, x, y, 12, 12, SystemColor.controlLtHighlight);
            this.drawArray(g, RADIO_BACK, buffer, x, y, 12, 12, state == 2 || state == 3 || state == 4 ? SystemColor.controlHighlight : this.iconColor);
            if (checked) {
                this.drawArray(g, RADIO_CHECK, buffer, x, y, 12, 12, fg);
            }
        }
        if (text != null) {
            Color color = fg;
            if (state == 4) {
                color = new Color(new GrayFilter(bg).filterRGB(0, 0, color.getRGB()));
            }
            g.setColor(color);
            g.setFont(this.getFont());
            text.draw(g, size.width - 3, 8 + (checkBox ? 14 : 12), 0);
        }
        if ((border = this.getBorder()) != null) {
            border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
        }
        if (focus) {
            g.setColor(fg);
            int w = 0;
            int h = 0;
            if (checkBox) {
                w = 16;
                h = 16;
            } else {
                w = 14;
                h = 14;
            }
            int x = (size.width - w) / 2;
            int y = text != null ? 2 : 0;
            GraphicsUtils.drawDashed(g, x, y, w, 1, 1, 1, 1);
            GraphicsUtils.drawDashed(g, x, y, 1, h, 1, 1, 2);
            GraphicsUtils.drawDashed(g, x, y + h - 1, w, 1, 1, 1, 1);
            GraphicsUtils.drawDashed(g, x + w - 1, y, 1, h, 1, 1, 2);
            if (text != null) {
                x = 1;
                y = h - 2 + 3 + 5 - 2;
                w = size.width - 2;
                h = size.height - y - 1;
                GraphicsUtils.drawDashed(g, x, y, w, 1, 1, 1, 1);
                GraphicsUtils.drawDashed(g, x, y, 1, h, 1, 1, 2);
                GraphicsUtils.drawDashed(g, x, y + h - 1, w, 1, 1, 1, 1);
                GraphicsUtils.drawDashed(g, x + w - 1, y, 1, h, 1, 1, 2);
            }
        }
    }

    public Color getIconcolor() {
        return this.iconColor;
    }

    public synchronized void setIconcolor(Color c) {
        this.iconColor = c;
    }

    public synchronized void setBackground(Image image) {
        this.backImage = image;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        if (this.label == label || this.label != null && label != null && this.label.compareTo(label) == 0) {
            return;
        }
        this.label = label;
        this.text = null;
        this.resetText = true;
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean state) {
        if (this.state == state) {
            return;
        }
        CheckboxGroup group = this.group;
        if (group != null) {
            if (state) {
                group.setSelectedCheckbox(this);
            } else if (group.getSelectedCheckbox() == this) {
                group.selectedCheckbox = null;
            }
        }
        this.setStateInternal(state);
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckboxGroup(CheckboxGroup g) {
        CheckboxGroup group = null;
        boolean state = false;
        Checkbox checkbox = this;
        synchronized (checkbox) {
            group = this.group;
            state = this.state;
        }
        if (group != null && state) {
            group.setSelectedCheckbox(null);
        }
        checkbox = this;
        synchronized (checkbox) {
            this.group = g;
            if (this.state && g != null) {
                g.setSelectedCheckbox(this);
            }
        }
    }

    private void resetText() {
        this.resetText = false;
        this.text = null;
        int w = 0;
        int h = 0;
        if (this.group == null) {
            w = 14;
            h = 14;
        } else {
            w = 12;
            h = 12;
        }
        if (this.label != null) {
            try {
                this.text = this.getText(this.label);
                Dimension size = this.text.getSize(0);
                this.setPreferredSize(Math.max(w + 2, size.width + 6), h + size.height + 6 + 5);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.setPreferredSize(w + 2, h + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArray(Graphics g, int[] base, int[] buffer, int x, int y, int width, int height, Color color) {
        SyncObserver so;
        int fg = color.getRGB() | 0xFF000000;
        int bg = 0;
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = base[i] == 1 ? fg : bg;
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, buffer, 0, width);
        mis.setAnimated(false);
        Image image = this.getToolkit().createImage(mis);
        SyncObserver syncObserver = so = new SyncObserver();
        synchronized (syncObserver) {
            so.init(g, x, y, width, height);
            if (!g.drawImage(image, x, y, width, height, so)) {
                try {
                    so.wait(10000L);
                }
                catch (InterruptedException e) {
                    System.out.println("wait to draw a icon");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateInternal(boolean state) {
        Checkbox checkbox = this;
        synchronized (checkbox) {
            if (this.state == state) {
                return;
            }
            this.state = state;
        }
        this.repaintForce();
    }
}

