/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.event.ActionEvent;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.rendering.Option;

public class Button
extends Component {
    private static final String BASE = "button";
    private static int nameCounter = 0;
    private static final int INSET_H = 5;
    private static final int INSET_V = 8;
    private String label;
    private String command;
    private Text text;
    private transient ActionListener actionListener;

    public Button(Option option, ImageCreator ic) {
        this(option, ic, null);
    }

    public Button(Option option, ImageCreator ic, String label) {
        super(option, ic);
        this.setLabel(label);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!Button.this.isEnabled()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        e.consume();
                        if (!Button.this.isEnabled()) break;
                        Button.this.postActionEvent(e.getModifiers());
                        break;
                    }
                    case 32: {
                        e.consume();
                        Button.this.setViewState(3);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                if (!Button.this.isEnabled()) {
                    return;
                }
                e.consume();
                switch (e.getKeyCode()) {
                    case 32: {
                        e.consume();
                        if (Button.this.getViewState() != 3) break;
                        Button.this.setViewState(0);
                        if (!Button.this.isEnabled()) break;
                        Button.this.postActionEvent(e.getModifiers());
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!Button.this.isEnabled()) {
                    return;
                }
                e.consume();
                if ((e.getModifiers() & 0x10) != 0) {
                    Button.this.postActionEvent(e.getModifiers());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Button button = this;
        synchronized (button) {
            if (this.text == null && this.label != null) {
                this.resetText();
            }
        }
        return super.getPreferredSize();
    }

    protected String paramString() {
        String str = super.paramString();
        return str + ",label=" + this.label;
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics g, Dimension size, int state, boolean focus) {
        Border border;
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        Text text = null;
        Button button = this;
        synchronized (button) {
            if (this.text == null && this.label != null) {
                this.resetText();
            }
            text = this.text;
        }
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
        if (text != null) {
            g.setFont(this.getFont());
            int fix = state == 2 || state == 3 ? 1 : 0;
            Color color = fg;
            if (state == 4) {
                g.setColor(SystemColor.controlLtHighlight);
                text.draw(g, size.width - 5 + fix + 1, 8 + fix + 1, 0);
                color = new Color(new GrayFilter(bg).filterRGB(0, 0, color.getRGB()));
            }
            g.setColor(color);
            text.draw(g, size.width - 5 + fix, 8 + fix, 0);
        }
        if ((border = this.getBorder()) != null) {
            border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
        } else {
            int fix;
            int n = fix = focus ? 1 : 0;
            if (state == 2 || state == 3) {
                g.setColor(SystemColor.controlShadow);
                g.drawLine(fix, fix, size.width - 1 - fix, fix);
                g.drawLine(fix, fix, fix, size.height - 1 - fix);
                g.setColor(SystemColor.controlDkShadow);
                g.drawLine(1 + fix, 1 + fix, size.width - 2 - fix, 1 + fix);
                g.drawLine(1 + fix, 1 + fix, 1 + fix, size.height - 2 - fix);
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(size.width - 1 - fix, 1 + fix, size.width - 1 - fix, size.height - 1 - fix);
                g.drawLine(1 + fix, size.height - 1 - fix, size.width - 1 - fix, size.height - 1 - fix);
            } else {
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(fix, fix, size.width - 1 - fix, fix);
                g.drawLine(fix, fix, fix, size.height - 1 - fix);
                g.setColor(SystemColor.controlShadow);
                g.drawLine(size.width - 2 - fix, 2 + fix, size.width - 2 - fix, size.height - 2 - fix);
                g.drawLine(2 + fix, size.height - 2 - fix, size.width - 2 - fix, size.height - 2 - fix);
                g.setColor(SystemColor.controlDkShadow);
                g.drawLine(size.width - 1 - fix, 1 + fix, size.width - 1 - fix, size.height - 1 - fix);
                g.drawLine(1 + fix, size.height - 1 - fix, size.width - 1 - fix, size.height - 1 - fix);
            }
        }
        if (focus) {
            g.setColor(fg);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            GraphicsUtils.drawDashed(g, 3, 3, size.width - 7, 1, 1, 1, 1);
            GraphicsUtils.drawDashed(g, 3, 3, 1, size.height - 7, 1, 1, 2);
            GraphicsUtils.drawDashed(g, 3, size.height - 4, size.width - 7, 1, 1, 1, 1);
            GraphicsUtils.drawDashed(g, size.width - 4, 3, 1, size.height - 7, 1, 1, 2);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        if (this.label == label || this.label != null && label != null && this.label.compareTo(label) == 0) {
            return;
        }
        this.label = label;
        this.text = null;
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    public String getActionCommand() {
        return this.command != null ? this.command : this.label;
    }

    public void setActionCommand(String command) {
        this.command = command;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.enableEvents(128L);
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    private void postActionEvent(int modifiers) {
        ActionEvent e = new ActionEvent(this, 3020, this.getActionCommand(), modifiers);
        try {
            this.getToolkit().getSystemEventQueue().postEvent(e);
        }
        catch (SecurityException ex) {
            this.processActionEvent(e);
        }
    }

    private void resetText() {
        this.text = null;
        if (this.label != null) {
            try {
                this.text = this.getText(this.label);
                Dimension size = this.text.getSize(0);
                this.setPreferredSize(size.width + 10, size.height + 16);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.setPreferredSize(0, 0);
        }
    }
}

