/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.event;

import java.awt.TextComponent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Hashtable;

public class KeyFilter {
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    private static final int INT_LEN = 9;
    private static final int LONG_LEN = 18;
    private static final int FLOAT_LEN = 7;
    private static final int DOUBLE_LEN = 14;
    private int type;
    private Listener listener = new Listener();
    private Hashtable oldValueTable = new Hashtable();

    public KeyFilter() {
        this.type = 4;
    }

    public KeyFilter(int type) {
        this.type = type;
    }

    public void attach(TextComponent c) {
        this.oldValueTable.put(c, c.getText());
        c.addKeyListener(this.listener);
        c.addTextListener(this.listener);
    }

    public void detach(TextComponent c) {
        this.oldValueTable.remove(c);
        c.removeKeyListener(this.listener);
        c.removeTextListener(this.listener);
    }

    private class Listener
    extends KeyAdapter
    implements TextListener {
        private Listener() {
        }

        public void keyPressed(KeyEvent e) {
            if (!KeyFilter.this.oldValueTable.containsKey(e.getSource())) {
                return;
            }
            if (e.getModifiers() != 0) {
                return;
            }
            int code = e.getKeyCode();
            if (code < 32 || 33 <= code && code <= 40 || 112 <= code && code <= 127 || code == 144 || code == 145 || 154 <= code && code <= 157) {
                return;
            }
            TextComponent text = (TextComponent)e.getSource();
            int select = Math.abs(text.getSelectionStart() - text.getSelectionEnd());
            String value = text.getText();
            switch (KeyFilter.this.type) {
                case 4: {
                    if (!this.isNumber(code) || value.length() > 9 + select) break;
                    return;
                }
                case 5: {
                    if (!this.isNumber(code) || value.length() > 18 + select) break;
                    return;
                }
                case 6: {
                    if (!this.isNumber(code) && !this.isPeriod(code, value) || value.length() > 7 + select) break;
                    return;
                }
                case 7: {
                    if (!this.isNumber(code) && !this.isPeriod(code, value) || value.length() > 14 + select) break;
                    return;
                }
                default: {
                    return;
                }
            }
            e.consume();
        }

        public void textValueChanged(TextEvent e) {
            int times;
            Object source = e.getSource();
            String oldValue = (String)KeyFilter.this.oldValueTable.get(source);
            if (oldValue == null) {
                return;
            }
            TextComponent text = (TextComponent)source;
            String newValue = text.getText();
            if (oldValue.compareTo(newValue) == 0) {
                return;
            }
            for (times = 0; times < 2; ++times) {
                try {
                    if (newValue.length() <= 0) continue;
                    switch (KeyFilter.this.type) {
                        case 4: {
                            String.valueOf(Integer.parseInt(newValue));
                            if (newValue.length() <= 9) break;
                            throw new NumberFormatException();
                        }
                        case 5: {
                            String.valueOf(Long.parseLong(newValue));
                            if (newValue.length() <= 18) break;
                            throw new NumberFormatException();
                        }
                        case 6: {
                            Float.valueOf("0" + newValue).toString();
                            if (newValue.length() <= 7) break;
                            throw new NumberFormatException();
                        }
                        case 7: {
                            Double.valueOf("0" + newValue).toString();
                            if (newValue.length() <= 14) break;
                            throw new NumberFormatException();
                        }
                    }
                    continue;
                }
                catch (NumberFormatException ex) {
                    newValue = times == 0 ? oldValue : "";
                }
            }
            if (times > 0) {
                int pos = text.getCaretPosition();
                int len = newValue.length();
                text.setText(newValue);
                text.setCaretPosition(Math.min(pos, newValue.length()));
            }
            KeyFilter.this.oldValueTable.put(source, newValue);
        }

        private boolean isNumber(int code) {
            return 48 <= code && code <= 57 || 96 <= code && code <= 105;
        }

        private boolean isPeriod(int code, String value) {
            return value.indexOf(46) == -1 && (code == 110 || code == 46);
        }
    }
}

