/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.util.Vector;
import net.hizlab.kagetaka.awt.ColorConverter;
import net.hizlab.kagetaka.awt.ImageUtils;

public class Toolbar
extends Container {
    public static final String NORMAL = "normal";
    public static final String MAXIMUM = "maximum";
    private Image backImage;
    private Dimension backImageSize;

    public Toolbar() {
        this.setLayout(new Layout(1, 1, 1, 1, 0));
        this.setBackground(SystemColor.control);
    }

    protected void paintFrame(Graphics g) {
        Color bg = this.getBackground();
        Dimension size = this.getSize();
        g.setColor(ColorConverter.getBrighter(bg));
        g.drawLine(0, 0, size.width - 1, 0);
        g.drawLine(0, 0, 0, size.height - 1);
        g.setColor(ColorConverter.getDarker(bg));
        g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
        g.drawLine(size.width - 1, 1, size.width - 1, size.height - 1);
    }

    public void setBackImage(Image image) {
        this.backImage = image;
        if (image != null && !ImageUtils.load(image, this)) {
            image = null;
        }
        if (image != null) {
            this.backImageSize = new Dimension(image.getWidth(this), image.getHeight(this));
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        if (this.backImage != null) {
            int x = 0;
            int y = 0;
            for (x = 0; x < size.width; x += this.backImageSize.width) {
                for (y = 0; y < size.height; y += this.backImageSize.height) {
                    g.drawImage(this.backImage, x, y, this);
                }
            }
        }
        this.paintFrame(g);
        super.paint(g);
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.backImageSize != null) {
            return new Dimension(Math.max(this.backImageSize.width, size.width), Math.max(this.backImageSize.height, size.height));
        }
        return size;
    }

    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        if (this.backImageSize != null) {
            return new Dimension(Math.max(this.backImageSize.width, size.width), Math.max(this.backImageSize.height, size.height));
        }
        return size;
    }

    private class Layout
    implements LayoutManager {
        private int top;
        private int left;
        private int bottom;
        private int right;
        private int gap;
        private Vector maximum = new Vector();

        private Layout(int top, int left, int bottom, int right, int gap) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
            this.gap = gap;
        }

        public void addLayoutComponent(String name, Component comp) {
            if (name != null && name.compareTo(Toolbar.MAXIMUM) == 0) {
                this.maximum.addElement(comp);
            }
        }

        public void removeLayoutComponent(Component comp) {
            this.maximum.removeElement(comp);
        }

        public Dimension preferredLayoutSize(Container target) {
            return this.getLayoutSize(target, true);
        }

        public Dimension minimumLayoutSize(Container target) {
            return this.getLayoutSize(target, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container target, boolean preferred) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Dimension size = new Dimension(0, 0);
                int nmembers = target.getComponentCount();
                for (int i = 0; i < nmembers; ++i) {
                    Component c = target.getComponent(i);
                    if (!c.isVisible()) continue;
                    Dimension d = preferred ? c.getPreferredSize() : c.getMinimumSize();
                    size.height = Math.max(size.height, d.height);
                    if (i > 0) {
                        size.width += this.gap;
                    }
                    size.width += d.width;
                }
                Insets insets = target.getInsets();
                size.width += insets.left + insets.right + this.left + this.right;
                size.height += insets.top + insets.bottom + this.top + this.bottom;
                return size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets = target.getInsets();
                Dimension size = target.getSize();
                int oddwidth = 0;
                int oddnum = 0;
                int maxheight = size.height - (insets.top + insets.bottom + this.top + this.bottom);
                int nmembers = target.getComponentCount();
                int x = insets.left + this.left;
                int y = insets.top + this.top;
                if (this.maximum.size() > 0) {
                    Dimension allSize = this.getLayoutSize(target, true);
                    oddwidth = Math.max(size.width - allSize.width, 0);
                    for (int i = 0; i < this.maximum.size(); ++i) {
                        if (!((Component)this.maximum.elementAt(i)).isVisible()) continue;
                        ++oddnum;
                    }
                }
                for (int i = 0; i < nmembers; ++i) {
                    Component c = target.getComponent(i);
                    if (!c.isVisible()) continue;
                    Dimension d = c.getPreferredSize();
                    if (oddnum > 0 && this.maximum.indexOf(c) >= 0) {
                        int odd = oddwidth / oddnum;
                        d.width += odd;
                        oddwidth -= odd;
                        --oddnum;
                    }
                    c.setBounds(x, y, d.width, maxheight);
                    x += d.width;
                    x += this.gap;
                }
            }
        }
    }
}

