/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.HiddenFrame;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.util.Environment;

public class ToolTip {
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private static final int MARGIN = 3;
    private static final int SPACE = 15;
    private volatile long delay;
    private volatile long term;
    private Font font;
    private Color colorFore;
    private Color colorBack;
    private Color colorEdge;
    private Hashtable attached = new Hashtable();
    private ToolTipWindow window;
    private ToolTipThread timer;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;

    public ToolTip(long delay, long term) {
        this.delay = delay;
        this.term = term;
        this.timer = new ToolTipThread("Kankana-ToolTip");
        this.timer.start();
        this.mouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                ToolTip.this.timer.start(e);
            }

            public void mouseExited(MouseEvent e) {
                ToolTip.this.timer.cancel();
            }

            public void mousePressed(MouseEvent e) {
                ToolTip.this.timer.reset(e);
            }

            public void mouseReleased(MouseEvent e) {
                ToolTip.this.timer.reset(e);
            }
        };
        this.mouseMotionListener = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                ToolTip.this.timer.reset(e);
            }
        };
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ToolTip.this.timer.cancel();
            }
        };
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ToolTip.this.timer.cancel();
            }
        };
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.infoText);
        this.setBackground(SystemColor.info);
        this.setEdgeColor(SystemColor.windowBorder);
    }

    public Font getFont() {
        return this.font;
    }

    public synchronized void setFont(Font font) {
        this.font = font;
        ToolTipWindow w = this.window;
        if (w != null) {
            w.changeText = true;
        }
    }

    public Color getForeground() {
        return this.colorFore;
    }

    public synchronized void setForeground(Color c) {
        this.colorFore = c;
        ToolTipWindow w = this.window;
        if (w != null) {
            w.changeText = true;
        }
    }

    public Color getBackground() {
        return this.colorBack;
    }

    public synchronized void setBackground(Color c) {
        this.colorBack = c;
        ToolTipWindow w = this.window;
        if (w != null) {
            w.changeText = true;
        }
    }

    public Color getEdgeColor() {
        return this.colorEdge;
    }

    public synchronized void setEdgeColor(Color c) {
        this.colorEdge = c;
        ToolTipWindow w = this.window;
        if (w != null) {
            w.changeText = true;
        }
    }

    public void cancel() {
        this.timer.cancel();
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getTerm() {
        return this.term;
    }

    public void setTerm(long term) {
        this.term = term;
    }

    public synchronized void attachComponent(Component c, String tip) {
        if (this.attached.containsKey(c)) {
            return;
        }
        this.attached.put(c, tip);
        c.addKeyListener(this.keyListener);
        c.addMouseListener(this.mouseListener);
        c.addMouseMotionListener(this.mouseMotionListener);
        if (Environment.javaVersion >= 104) {
            c.addFocusListener(this.focusListener);
        }
        if (c instanceof Container) {
            Component[] cs = ((Container)c).getComponents();
            for (int i = 0; i < cs.length; ++i) {
                this.attachComponent(cs[i], tip);
            }
        }
    }

    public synchronized void detachComponent(Component c) {
        if (!this.attached.containsKey(c)) {
            return;
        }
        this.attached.remove(c);
        c.removeKeyListener(this.keyListener);
        c.removeMouseListener(this.mouseListener);
        c.removeMouseMotionListener(this.mouseMotionListener);
        if (Environment.javaVersion >= 104) {
            c.removeFocusListener(this.focusListener);
        }
        if (c instanceof Container) {
            Component[] cs = ((Container)c).getComponents();
            for (int i = 0; i < cs.length; ++i) {
                this.detachComponent(cs[i]);
            }
        }
    }

    public void dispose() {
        this.timer.interrupt();
        ToolTipWindow w = this.window;
        if (w != null) {
            w.dispose();
        }
    }

    private class ToolTipThread
    extends Thread {
        private Component component;
        private boolean reset;
        private int x;
        private int y;

        private ToolTipThread(String name) {
            super(name);
        }

        public void run() {
            try {
                ToolTipThread toolTipThread = this;
                synchronized (toolTipThread) {
                    block5: while (true) {
                        this.wait();
                        while (true) {
                            if (this.component == null || !this.reset) continue block5;
                            this.reset = false;
                            this.wait(ToolTip.this.delay);
                            if (this.reset || this.component == null) continue;
                            this.show((String)ToolTip.this.attached.get(this.component));
                            this.wait(ToolTip.this.term);
                            this.hide();
                        }
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private synchronized void start(MouseEvent e) {
            this.component = e.getComponent();
            this.reset = true;
            this.calculate(e);
            this.notify();
        }

        private synchronized void cancel() {
            this.component = null;
            this.reset = true;
            this.hide();
            this.notify();
        }

        private synchronized void reset(MouseEvent e) {
            this.component = e.getComponent();
            this.reset = true;
            this.hide();
            this.calculate(e);
            this.notify();
        }

        private void calculate(MouseEvent e) {
            Point p = e.getComponent().getLocationOnScreen();
            this.x = p.x + e.getX();
            this.y = p.y + e.getY();
        }

        private synchronized void show(String tip) {
            if (tip == null) {
                return;
            }
            if (ToolTip.this.window == null) {
                ToolTip.this.window = new ToolTipWindow();
            }
            ToolTip.this.window.setText(tip);
            int x = this.x + 15;
            int y = this.y + 15;
            Dimension screenSize = ToolTip.this.window.getToolkit().getScreenSize();
            Dimension windowSize = ToolTip.this.window.getSize();
            screenSize.width -= 45;
            screenSize.height -= 45;
            if (x + windowSize.width > screenSize.width) {
                x = screenSize.width - windowSize.width;
            }
            if (y + windowSize.height > screenSize.height) {
                y = this.y - 15 - windowSize.height;
            }
            ((Component)ToolTip.this.window).setLocation(x, y);
            ToolTip.this.window.show();
        }

        private synchronized void hide() {
            if (ToolTip.this.window == null || !ToolTip.this.window.isVisible()) {
                return;
            }
            ((Component)ToolTip.this.window).setVisible(false);
        }
    }

    private class ToolTipWindow
    extends Window
    implements ImageCreator {
        private String text;
        private boolean changeText = true;
        private Object lock = new Object();
        private int width;
        private int height;
        private FontMetrics fm = null;
        private int baseFull = 0;
        private int baseHalf = 0;
        private Image offscreen;
        private Graphics offscreenGraphics;

        private ToolTipWindow() {
            super(HiddenFrame.getInstance());
            this.pack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setText(String text) {
            Object object = this.lock;
            synchronized (object) {
                if (this.text != null && this.text.compareTo(text) == 0) {
                    return;
                }
                this.text = text;
                this.changeText = true;
                this.calculate();
            }
        }

        private void calculate() {
            FontData fontData = FontData.getInstance(this, ToolTip.this.font);
            this.fm = fontData.getFontMetrics();
            this.baseFull = fontData.getFullBase();
            this.baseHalf = fontData.getHalfBase();
            int width = this.fm.stringWidth(this.text) + 6 + 2;
            int height = Math.max(fontData.getFullSize().height, fontData.getHalfHeight()) + 6 + 2;
            if (this.width != width || this.height != height) {
                if (this.offscreen != null) {
                    this.offscreenGraphics.dispose();
                    this.offscreen.flush();
                }
                this.offscreen = this.createImage(width, height);
                this.offscreenGraphics = this.offscreen.getGraphics();
            }
            ((Component)this).setSize(width, height);
            this.width = width;
            this.height = height;
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            int height;
            int width;
            Image image;
            Object object = this.lock;
            synchronized (object) {
                image = this.offscreen;
                width = this.width;
                height = this.height;
                if (this.changeText) {
                    this.offscreenGraphics.setColor(ToolTip.this.colorBack);
                    this.offscreenGraphics.fillRect(1, 1, width - 3, height - 3);
                    this.offscreenGraphics.setColor(ToolTip.this.colorEdge);
                    this.offscreenGraphics.drawRect(0, 0, width - 1, height - 1);
                    this.offscreenGraphics.setColor(ToolTip.this.colorFore);
                    int x = 4;
                    int y = 4;
                    char[] chars = this.text.toCharArray();
                    int length = chars.length;
                    for (int i = 0; i < length; ++i) {
                        char c = chars[i];
                        this.offscreenGraphics.drawChars(chars, i, 1, x, y + (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? this.baseHalf : this.baseFull));
                        x += this.fm.charWidth(chars[i]);
                    }
                    this.changeText = false;
                }
            }
            g.drawImage(image, 0, 0, width, height, this);
        }

        public void dispose() {
            if (this.offscreen != null) {
                this.offscreenGraphics.dispose();
                this.offscreen.flush();
                this.offscreenGraphics = null;
                this.offscreen = null;
            }
            super.dispose();
        }

        public void show() {
            this.toFront();
            super.show();
        }
    }
}

