/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.awt.AWTEventMulticaster;
import net.hizlab.kagetaka.awt.AlignLayout;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageButton;
import net.hizlab.kagetaka.awt.ImageCreatorComponent;
import net.hizlab.kagetaka.awt.ImageUtils;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.event.TabEvent;
import net.hizlab.kagetaka.awt.event.TabListener;
import net.hizlab.kagetaka.awt.image.OffscreenObserver;

public class TabbedContainer
extends Container {
    private static final int TABBAR_LEFT_FIX = 4;
    private static final int TABBAR_RIGHT_FIX = 5;
    private static final int TABBAR_IMAGE_FIX = 2;
    private static final int TABBAR_HEIGHT_FIX = 4;
    private static final int NOACTIVE = 0;
    private static final int ACTIVE = 1;
    private static final int BEFORE = 2;
    private static final int[] LEFT_IMAGE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RIGHT_IMAGE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int tabbarHeight = 0;
    private int minWidth = 50;
    private int maxWidth = 300;
    private Color focusFrameColor;
    private Font activeTitleFont;
    private Color activeTitleForeground;
    private Color activeTitleBackground;
    private Font unactiveTitleFont;
    private Color unactiveTitleForeground;
    private Color unactiveTitleBackground;
    private Tabbar tabbar;
    private AlignLayout tabbarLayout;
    private TabScrollbar tabScrollbar;
    private Container main;
    private CardLayout mainLayout;
    private TabPanel activeTabPanel;
    private int activeTabPanelIndex;
    private boolean activeVisible;
    private Vector panels = new Vector();
    private Hashtable hash = new Hashtable();
    private Vector images = new Vector();
    private transient TabListener tabListener;
    private transient ComponentListener tabComponentListener;
    private transient FocusListener tabFocusListener;
    private transient KeyListener tabKeyListener;
    private transient MouseListener tabMouseListener;
    private transient MouseMotionListener tabMouseMotionListener;

    public TabbedContainer() {
        this.tabbar = new Tabbar();
        this.tabbarLayout = new AlignLayout(1);
        this.tabbar.setLayout(this.tabbarLayout);
        this.tabScrollbar = new TabScrollbar();
        this.tabScrollbar.setVisible(false);
        this.main = new Container(){};
        this.mainLayout = new CardLayout();
        this.main.setLayout(this.mainLayout);
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(0, 0, 0, 0);
        this.setLayout(gbl);
        insets.left = 2;
        LayoutUtils.addGridBag(this, this.tabbar, gbl, 0, 0, 1, 1, 1.0, 0.0, 0, 17, insets);
        insets.left = 0;
        insets.bottom = 2;
        LayoutUtils.addGridBag(this, this.tabScrollbar, gbl, 1, 0, 1, 1, 0.0, 0.0, 0, 14, insets);
        insets.bottom = 0;
        LayoutUtils.addGridBag(this, this.main, gbl, 0, 1, 2, 1, 1.0, 1.0, 1, 10, insets);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                TabbedContainer.this.relayoutTabs();
            }
        });
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.setFocusFrameColor(SystemColor.windowBorder);
        this.setActiveTitleFont(Font.decode("Dialog"));
        this.setActiveTitleForeground(SystemColor.controlText);
        this.setActiveTitleBackground(SystemColor.control);
        this.setUnActiveTitleFont(Font.decode("Dialog"));
        this.setUnActiveTitleForeground(SystemColor.controlText);
        this.setUnActiveTitleBackground(SystemColor.control);
    }

    public void addPanel(String key, String title, Image image, Component comp, boolean focus) {
        this.addPanel(key, title, image, comp, focus, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPanel(String key, String title, Image image, Component comp, boolean focus, int index) {
        Vector vector = this.panels;
        synchronized (vector) {
            if (this.hash.containsKey(key)) {
                throw new IllegalArgumentException("Already exists key `" + key + "'");
            }
            TabPanel panel = new TabPanel(key, title, image, comp);
            if (index == -1) {
                this.panels.addElement(panel);
                index = this.panels.size() - 1;
            } else {
                this.panels.insertElementAt(panel, index);
            }
            this.hash.put(panel.key, panel);
            panel.attach(index);
            if (this.tabComponentListener != null) {
                panel.tab.addComponentListener(this.tabComponentListener);
            }
            if (this.tabFocusListener != null) {
                panel.tab.addFocusListener(this.tabFocusListener);
            }
            if (this.tabKeyListener != null) {
                panel.tab.addKeyListener(this.tabKeyListener);
            }
            if (this.tabMouseListener != null) {
                panel.tab.addMouseListener(this.tabMouseListener);
            }
            if (this.tabMouseMotionListener != null) {
                panel.tab.addMouseMotionListener(this.tabMouseMotionListener);
            }
            if (this.panels.size() == 1 || focus) {
                panel.setActived(false);
            }
        }
        this.relayoutTabs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePanel(String key) {
        Vector vector = this.panels;
        synchronized (vector) {
            TabPanel panel = (TabPanel)this.hash.get(key);
            if (panel == null) {
                throw new IllegalArgumentException("Invalid key `" + key + "'");
            }
            int index = this.panels.indexOf(panel);
            this.hash.remove(key);
            this.panels.removeElementAt(index);
            panel.detach(index);
            if (this.panels.size() > 0) {
                if (panel == this.activeTabPanel) {
                    if (index > 0) {
                        --index;
                    }
                    TabPanel newFocusPanel = (TabPanel)this.panels.elementAt(index);
                    newFocusPanel.setActived(false);
                    if (panel.tab.focus) {
                        newFocusPanel.tab.requestFocus();
                    }
                } else if (index < this.activeTabPanelIndex) {
                    --this.activeTabPanelIndex;
                }
            } else {
                this.activeTabPanel = null;
                this.activeTabPanelIndex = 0;
            }
        }
        this.relayoutTabs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String key, String title) {
        TabPanel panel;
        boolean relayout = false;
        Vector vector = this.panels;
        synchronized (vector) {
            panel = (TabPanel)this.hash.get(key);
            if (panel == null) {
                throw new IllegalArgumentException("Invalid key `" + key + "'");
            }
            relayout = panel.tab.setTitle(title, panel.tab.image);
        }
        if (relayout) {
            this.relayoutTabs();
        }
        panel.tab.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(String key, Image image) {
        TabPanel panel;
        boolean relayout = false;
        Vector vector = this.panels;
        synchronized (vector) {
            panel = (TabPanel)this.hash.get(key);
            if (panel == null) {
                throw new IllegalArgumentException("Invalid key `" + key + "'");
            }
            relayout = panel.tab.setTitle(panel.tab.title, image);
        }
        if (relayout) {
            this.relayoutTabs();
        }
        panel.tab.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setActivePanel(String key) {
        Vector vector = this.panels;
        synchronized (vector) {
            TabPanel panel = (TabPanel)this.hash.get(key);
            if (panel == null) {
                throw new IllegalArgumentException("Invalid key `" + key + "'");
            }
            if (panel == this.activeTabPanel) {
                return false;
            }
            return panel.setActived(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActivePanelKey() {
        Vector vector = this.panels;
        synchronized (vector) {
            if (this.activeTabPanel == null) {
                return null;
            }
            return this.activeTabPanel.key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivePanelIndex() {
        Vector vector = this.panels;
        synchronized (vector) {
            if (this.activeTabPanel == null) {
                return -1;
            }
            return this.activeTabPanelIndex;
        }
    }

    public synchronized int getTabMinWidth() {
        return this.minWidth;
    }

    public synchronized void setTabMinWidth(int width) {
        this.minWidth = width;
        this.relayoutTabs();
    }

    public synchronized int getTabMaxWidth() {
        return this.maxWidth;
    }

    public synchronized void setTabMaxWidth(int width) {
        this.maxWidth = width;
        this.relayoutTabs();
    }

    public synchronized void setForeground(Color color) {
        super.setForeground(color);
        this.tabScrollbar.setForeground(color);
    }

    public synchronized void setBackground(Color color) {
        super.setBackground(color);
        this.tabScrollbar.setBackground(color);
    }

    public synchronized Color getFocusFrameColor() {
        return this.focusFrameColor;
    }

    public synchronized void setFocusFrameColor(Color color) {
        this.focusFrameColor = color;
    }

    public synchronized Font getActiveTitleFont() {
        return this.activeTitleFont;
    }

    public synchronized void setActiveTitleFont(Font font) {
        this.activeTitleFont = font;
        this.calculateTabbarSize();
    }

    public synchronized Color getActiveTitleForeground() {
        return this.activeTitleForeground;
    }

    public synchronized void setActiveTitleForeground(Color color) {
        this.activeTitleForeground = color;
    }

    public synchronized Color getActiveTitleBackground() {
        return this.activeTitleBackground;
    }

    public synchronized void setActiveTitleBackground(Color color) {
        this.activeTitleBackground = color;
    }

    public synchronized Font getUnActiveTitleFont() {
        return this.unactiveTitleFont;
    }

    public synchronized void setUnActiveTitleFont(Font font) {
        this.unactiveTitleFont = font;
        this.calculateTabbarSize();
    }

    public synchronized Color getUnActiveTitleForeground() {
        return this.unactiveTitleForeground;
    }

    public synchronized void setUnActiveTitleForeground(Color color) {
        this.unactiveTitleForeground = color;
    }

    public synchronized Color getUnActiveTitleBackground() {
        return this.unactiveTitleBackground;
    }

    public synchronized void setUnActiveTitleBackground(Color color) {
        this.unactiveTitleBackground = color;
    }

    public synchronized void setTabScrollButton(ImageButton left, ImageButton right) {
        this.tabScrollbar.setButton(left, right);
    }

    public synchronized void resetTabScrollButton() {
        this.tabScrollbar.createDefaultButton();
    }

    public synchronized void addTabListener(TabListener l) {
        this.enableEvents(0L);
        this.tabListener = AWTEventMulticaster.add(this.tabListener, l);
    }

    public synchronized void removeTabListener(TabListener l) {
        this.tabListener = AWTEventMulticaster.remove(this.tabListener, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKey(Component c) {
        if (c == null || !(c instanceof Tab)) {
            return null;
        }
        Tab tab = (Tab)c;
        Vector vector = this.panels;
        synchronized (vector) {
            for (int i = 0; i < this.panels.size(); ++i) {
                TabPanel panel = (TabPanel)this.panels.elementAt(i);
                if (tab != panel.tab) continue;
                return panel.key;
            }
        }
        return null;
    }

    public synchronized void addTabComponentListener(ComponentListener l) {
        this.tabComponentListener = java.awt.AWTEventMulticaster.add(this.tabComponentListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.addComponentListener(l);
        }
    }

    public synchronized void removeTabComponentListener(ComponentListener l) {
        this.tabComponentListener = java.awt.AWTEventMulticaster.remove(this.tabComponentListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.removeComponentListener(l);
        }
    }

    public synchronized void addTabFocusListener(FocusListener l) {
        this.tabFocusListener = java.awt.AWTEventMulticaster.add(this.tabFocusListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.addFocusListener(l);
        }
    }

    public synchronized void removeTabFocusListener(FocusListener l) {
        this.tabFocusListener = java.awt.AWTEventMulticaster.remove(this.tabFocusListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.removeFocusListener(l);
        }
    }

    public synchronized void addTabKeyListener(KeyListener l) {
        this.tabKeyListener = java.awt.AWTEventMulticaster.add(this.tabKeyListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.addKeyListener(l);
        }
    }

    public synchronized void removeTabKeyListener(KeyListener l) {
        this.tabKeyListener = java.awt.AWTEventMulticaster.remove(this.tabKeyListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.removeKeyListener(l);
        }
    }

    public synchronized void addTabMouseListener(MouseListener l) {
        this.tabMouseListener = java.awt.AWTEventMulticaster.add(this.tabMouseListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.addMouseListener(l);
        }
    }

    public synchronized void removeTabMouseListener(MouseListener l) {
        this.tabMouseListener = java.awt.AWTEventMulticaster.remove(this.tabMouseListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.removeMouseListener(l);
        }
    }

    public synchronized void addTabMouseMotionListener(MouseMotionListener l) {
        this.tabMouseMotionListener = java.awt.AWTEventMulticaster.add(this.tabMouseMotionListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.addMouseMotionListener(l);
        }
    }

    public synchronized void removeTabMouseMotionListener(MouseMotionListener l) {
        this.tabMouseMotionListener = java.awt.AWTEventMulticaster.remove(this.tabMouseMotionListener, l);
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.removeMouseMotionListener(l);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, this.tabbarHeight);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        size.height = this.tabbar.getSize().height;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        this.paintUnderLine(g, size);
        if (this.tabbarLayout.getStatus().top == this.activeTabPanelIndex) {
            g.setColor(this.activeTitleBackground.brighter());
            g.drawLine(1, 1, 1, 1);
            g.drawLine(0, 2, 0, size.height - 2);
            g.setColor(this.activeTitleBackground);
            g.drawLine(1, 2, 1, size.height - 2);
        }
        this.paintComponents(g);
    }

    protected String paramString() {
        String str = super.paramString();
        return str;
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof TabEvent) {
            this.processTabEvent((TabEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processTabEvent(TabEvent e) {
        if (this.tabListener == null) {
            return;
        }
        switch (e.getID()) {
            case 3000: {
                this.tabListener.activeChanged(e);
                break;
            }
            case 3001: {
                this.tabListener.tabAdded(e);
                break;
            }
            case 3002: {
                this.tabListener.tabRemoved(e);
                break;
            }
            case 3003: {
                this.tabListener.tabChanged(e);
            }
        }
    }

    private void calculateTabbarSize() {
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.calculateWidth();
        }
        this.calculateTabbarHeight();
        this.relayoutTabs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateTabbarHeight() {
        Vector vector = this.panels;
        synchronized (vector) {
            this.tabbarHeight = Math.max(this.activeTitleFont != null ? this.getFontMetrics(this.activeTitleFont).getHeight() : 0, this.unactiveTitleFont != null ? this.getFontMetrics(this.unactiveTitleFont).getHeight() : 0);
            for (int i = 0; i < this.images.size(); ++i) {
                this.tabbarHeight = Math.max(this.tabbarHeight, ((Dimension)this.images.elementAt((int)i)).height);
            }
            this.tabbarHeight += 8;
        }
    }

    private void invalidateAllTabs() {
        for (int i = 0; i < this.panels.size(); ++i) {
            ((TabPanel)this.panels.elementAt(i)).tab.invalidate();
        }
    }

    private void postEvent(String key, int id) {
        this.getToolkit().getSystemEventQueue().postEvent(new TabEvent(this, key, id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relayoutTabs() {
        if (this.tabbar != null && this.isVisible()) {
            boolean visible;
            boolean bl = visible = this.panels.size() > 1 && this.getSize().width < this.tabbar.getPreferredSize().width;
            if (this.tabScrollbar.isVisible() != visible) {
                this.tabScrollbar.setVisible(visible);
            }
        }
        this.validate();
        Vector vector = this.panels;
        synchronized (vector) {
            if (this.panels.size() <= 1) {
                return;
            }
            if (this.activeTabPanel != null) {
                this.tabbarLayout.show(this.tabbar, this.activeTabPanelIndex);
            }
        }
        this.repaintTabScroll();
    }

    private void repaintTabScroll() {
        boolean b;
        AlignLayout.Status status = this.tabbarLayout.getStatus();
        boolean bl = b = status.top <= this.activeTabPanelIndex && this.activeTabPanelIndex <= status.last;
        if (b != this.activeVisible) {
            this.activeVisible = b;
            if (status.last == this.activeTabPanelIndex && status.last > 0) {
                ((TabPanel)this.panels.elementAt(status.last - 1)).tab.refresh();
            } else if (status.last >= 0 && status.last + 1 == this.activeTabPanelIndex) {
                ((TabPanel)this.panels.elementAt(status.last)).tab.refresh();
            }
        }
        this.repaint(0, 0, 2, this.tabbar.getSize().height);
        this.tabScrollbar.setValues(status.top, status.last, status.total);
    }

    private void paintUnderLine(Graphics g, Dimension size) {
        g.setColor(this.activeTitleBackground);
        g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
        g.setColor(this.unactiveTitleBackground.brighter());
        g.drawLine(0, size.height - 2, size.width - 1, size.height - 2);
    }

    private class TabScrollbar
    extends Container {
        private ImageButton defaultLeft;
        private ImageButton defaultRight;
        private ImageButton left;
        private ImageButton right;

        private TabScrollbar() {
            this.setLayout(new FlowLayout(1, 0, 0));
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        private synchronized void setButton(ImageButton left, ImageButton right) {
            if (this.left != null && left != null) {
                left.setEnabled(this.left.isEnabled());
            }
            if (this.right != null && right != null) {
                right.setEnabled(this.right.isEnabled());
            }
            this.left = left;
            this.right = right;
            Color bg = this.getBackground();
            left.setBackground(bg);
            right.setBackground(bg);
            left.addMouseListener(new MouseAdapter(this){
                private boolean pressed;
                private final /* synthetic */ TabScrollbar this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent e) {
                    if (TabScrollbar.access$5000(this.this$1, e)) {
                        this.pressed = true;
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (TabScrollbar.access$5000(this.this$1, e)) {
                        TabbedContainer.access$2800(TabScrollbar.access$5100(this.this$1)).previous(TabbedContainer.access$2300(TabScrollbar.access$5100(this.this$1)));
                        TabbedContainer.access$3100(TabScrollbar.access$5100(this.this$1));
                    }
                    this.pressed = false;
                }
            });
            right.addMouseListener(new MouseAdapter(this){
                private boolean pressed;
                private final /* synthetic */ TabScrollbar this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent e) {
                    if (TabScrollbar.access$5000(this.this$1, e)) {
                        this.pressed = true;
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (TabScrollbar.access$5000(this.this$1, e)) {
                        TabbedContainer.access$2800(TabScrollbar.access$5100(this.this$1)).next(TabbedContainer.access$2300(TabScrollbar.access$5100(this.this$1)));
                        TabbedContainer.access$3100(TabScrollbar.access$5100(this.this$1));
                    }
                    this.pressed = false;
                }
            });
            this.removeAll();
            this.add(left);
            this.add(right);
        }

        private synchronized void setValues(int top, int last, int total) {
            if (this.left != null) {
                this.left.setEnabled(top > 0);
            }
            if (this.right != null) {
                this.right.setEnabled(last + 1 < total);
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension leftSize = null;
            Dimension rightSize = null;
            if (this.left != null) {
                leftSize = this.left.getPreferredSize();
            }
            if (this.right != null) {
                rightSize = this.right.getPreferredSize();
            }
            return new Dimension((leftSize != null ? leftSize.width : 0) + (rightSize != null ? rightSize.width : 0), Math.max(leftSize != null ? leftSize.height : 0, rightSize != null ? rightSize.height : 0));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            if (this.left != null) {
                this.left.setBackground(c);
            }
            if (this.right != null) {
                this.right.setBackground(c);
            }
        }

        public void setVisible(boolean v) {
            super.setVisible(v);
            if (v) {
                this.left.repaint();
                this.right.repaint();
            } else {
                TabbedContainer.this.activeVisible = true;
            }
        }

        public void addNotify() {
            super.addNotify();
            if (this.left == null || this.right == null) {
                this.createDefaultButton();
            }
        }

        private void createDefaultButton() {
            if (this.defaultLeft == null) {
                int i;
                ImageButton left = this.defaultLeft = new ImageButton(null);
                ImageButton right = this.defaultRight = new ImageButton(null);
                int fg = this.getForeground().getRGB() | 0xFF000000;
                int bg = 0;
                int w = 13;
                int h = 13;
                int[] bitmap = new int[w * h];
                for (i = 0; i < bitmap.length; ++i) {
                    bitmap[i] = LEFT_IMAGE[i] == 1 ? fg : bg;
                }
                MemoryImageSource mis = new MemoryImageSource(w, h, bitmap, 0, w);
                mis.setAnimated(false);
                left.setImage(left.createImage(mis));
                bitmap = new int[w * h];
                for (i = 0; i < bitmap.length; ++i) {
                    bitmap[i] = RIGHT_IMAGE[i] == 1 ? fg : bg;
                }
                mis = new MemoryImageSource(w, h, bitmap, 0, w);
                mis.setAnimated(false);
                right.setImage(right.createImage(mis));
            }
            this.setButton(this.defaultLeft, this.defaultRight);
        }

        private boolean check(MouseEvent e) {
            Component c = e.getComponent();
            if (!c.isEnabled()) {
                return false;
            }
            if ((e.getModifiers() & 0x10) == 0) {
                return false;
            }
            int x = e.getX();
            int y = e.getY();
            Dimension size = c.getSize();
            return 0 <= x && x < size.width && 0 <= y && y <= size.height;
        }

        static /* synthetic */ boolean access$5000(TabScrollbar x0, MouseEvent x1) {
            return x0.check(x1);
        }

        static /* synthetic */ TabbedContainer access$5100(TabScrollbar x0) {
            return x0.TabbedContainer.this;
        }
    }

    private class Tab
    extends Component {
        private ImageCreatorComponent icc = new ImageCreatorComponent(this);
        private Object lock = new Object();
        private String title;
        private Image image;
        private Dimension imageSize;
        private int width;
        private int active;
        private boolean focus;
        private boolean focusTraversable;
        private Image offScreen;
        private Graphics og;
        private OffscreenObserver oo;

        private Tab(String title, Image image) {
            this.setTitle(title, image);
            this.addFocusListener(new FocusListener(this){
                private final /* synthetic */ Tab this$1;
                {
                    this.this$1 = this$1;
                }

                public void focusGained(FocusEvent e) {
                    if (!Tab.access$900(this.this$1)) {
                        Tab.access$902(this.this$1, true);
                        Tab.access$1200(this.this$1);
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (Tab.access$900(this.this$1)) {
                        Tab.access$902(this.this$1, false);
                        Tab.access$1200(this.this$1);
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ Tab this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void componentResized(ComponentEvent e) {
                    Object object = Tab.access$3300(this.this$1);
                    synchronized (object) {
                        if (Tab.access$3400(this.this$1) != null) {
                            if (Tab.access$3500(this.this$1) != null) {
                                Tab.access$3500((Tab)this.this$1).original.flush();
                                Tab.access$3500(this.this$1).dispose();
                                Tab.access$3502(this.this$1, null);
                            }
                            Tab.access$3600(this.this$1).dispose();
                            Tab.access$3400(this.this$1).flush();
                        }
                        Dimension size = this.this$1.getSize();
                        if (size.width == 0 || size.height == 0) {
                            Tab.access$3402(this.this$1, null);
                            Tab.access$3602(this.this$1, null);
                        } else {
                            Tab.access$3402(this.this$1, this.this$1.createImage(size.width, size.height));
                            Tab.access$3602(this.this$1, Tab.access$3400(this.this$1).getGraphics());
                            Tab.access$1200(this.this$1);
                        }
                    }
                }
            });
        }

        private boolean setTitle(String title, Image image) {
            boolean change = false;
            boolean recalc = false;
            if (this.title != title) {
                change = true;
                recalc = true;
                this.title = title;
            }
            if (this.image != image) {
                change = true;
                boolean bl = recalc || this.image == null != (image == null) ? true : (recalc = false);
                if (this.imageSize != null) {
                    TabbedContainer.this.images.removeElement(this.imageSize);
                }
                if (image != null) {
                    if (ImageUtils.load(image, TabbedContainer.this)) {
                        boolean heightChanged;
                        Dimension newSize = new Dimension(image.getWidth(TabbedContainer.this), image.getHeight(TabbedContainer.this));
                        boolean bl2 = heightChanged = this.imageSize != null && this.imageSize.height != newSize.height;
                        if (!recalc) {
                            recalc = this.imageSize != null && this.imageSize.width != newSize.width;
                        }
                        this.imageSize = newSize;
                        TabbedContainer.this.images.addElement(this.imageSize);
                        if (heightChanged) {
                            TabbedContainer.this.calculateTabbarHeight();
                        }
                    } else {
                        image = null;
                    }
                }
                this.image = image;
                if (image == null) {
                    this.imageSize = null;
                }
            }
            if (!change) {
                return false;
            }
            if (!recalc || !this.calculateWidth()) {
                this.refresh();
                return false;
            }
            return true;
        }

        private boolean calculateWidth() {
            int w = 0;
            if (this.image != null) {
                w += this.imageSize.width;
                w += 2;
            }
            if (this.title != null) {
                w += Math.max(this.getFontMetrics(TabbedContainer.this.activeTitleFont).stringWidth(this.title), this.getFontMetrics(TabbedContainer.this.unactiveTitleFont).stringWidth(this.title));
            }
            if ((w += 9) == this.width) {
                return false;
            }
            this.width = w;
            this.invalidate();
            return true;
        }

        public boolean isFocusTraversable() {
            return this.focusTraversable;
        }

        public Dimension getMinimumSize() {
            return new Dimension(TabbedContainer.this.minWidth, TabbedContainer.this.tabbarHeight);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(Math.max(Math.min(this.width, TabbedContainer.this.maxWidth), TabbedContainer.this.minWidth), TabbedContainer.this.tabbarHeight);
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (this.offScreen != null) {
                g.drawImage(this.offScreen, 0, 0, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refresh() {
            Object object = this.lock;
            synchronized (object) {
                if (this.offScreen == null) {
                    return;
                }
                if (this.oo != null) {
                    this.oo.original.flush();
                    this.oo.dispose();
                    this.oo = null;
                }
                Dimension size = this.getSize();
                Color bg = null;
                this.og.setColor(TabbedContainer.this.getBackground());
                this.og.fillRect(0, 0, size.width, size.height);
                if (this.active == 1) {
                    bg = TabbedContainer.this.activeTitleBackground;
                    this.og.setColor(bg);
                    this.og.fillRect(0, 1, size.width - 2, size.height - 2);
                } else {
                    bg = TabbedContainer.this.unactiveTitleBackground;
                    this.og.setColor(bg);
                    this.og.fillRect(1, 3, size.width - 3, size.height - 5);
                }
                int fix = this.active == 1 ? 0 : 1;
                int x = 4 + fix;
                if (this.image != null) {
                    int y = (int)((double)(TabbedContainer.this.tabbarHeight - this.imageSize.height) / 2.0 + 0.5);
                    Image original = this.createImage(this.imageSize.width, this.imageSize.height);
                    if (original != null) {
                        Graphics g = original.getGraphics();
                        g.setColor(bg);
                        g.fillRect(0, 0, this.imageSize.width, this.imageSize.height);
                        g.dispose();
                        this.oo = new OffscreenObserver(this, this.og, x, y + fix, original);
                        this.og.drawImage(this.image, x, y + fix, this.oo);
                        x += this.imageSize.width;
                        x += 2;
                    }
                }
                if (this.title != null) {
                    Font font = null;
                    if (this.active == 1) {
                        font = TabbedContainer.this.activeTitleFont;
                        this.og.setFont(font);
                        this.og.setColor(TabbedContainer.this.activeTitleForeground);
                    } else {
                        font = TabbedContainer.this.unactiveTitleFont;
                        this.og.setFont(font);
                        this.og.setColor(TabbedContainer.this.unactiveTitleForeground);
                    }
                    FontData fd = FontData.getInstance(this.icc, font);
                    FontMetrics fm = fd.getFontMetrics();
                    int offset = (int)((double)(TabbedContainer.this.tabbarHeight - fd.getFullSize().height) / 2.0 + 0.5);
                    int y1 = fd.getHalfBase() + offset + fix;
                    int y2 = fd.getFullBase() + offset + fix;
                    int end = size.width - 5 + fix;
                    boolean cut = false;
                    if (fm.stringWidth(this.title) + x > end) {
                        end -= fm.stringWidth("...");
                        cut = true;
                    }
                    char[] cs = new char[1];
                    for (int i = 0; i < this.title.length(); ++i) {
                        char c;
                        cs[0] = c = this.title.charAt(i);
                        int w = fm.charWidth(c);
                        if (x + w > end) break;
                        this.og.drawChars(cs, 0, 1, x, c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? y1 : y2);
                        x += w;
                    }
                    if (cut) {
                        this.og.drawString("...", x, y1);
                    }
                }
                if (this.active == 1) {
                    this.og.setColor(bg.brighter());
                    this.og.drawLine(0, 0, size.width - 3, 0);
                    this.og.setColor(bg.darker());
                    this.og.drawLine(size.width - 2, 2, size.width - 2, size.height - 2);
                    this.og.setColor(bg.darker().darker());
                    this.og.drawLine(size.width - 2, 1, size.width - 2, 1);
                    this.og.drawLine(size.width - 1, 2, size.width - 1, size.height - 2);
                } else {
                    this.og.setColor(bg.brighter());
                    this.og.drawLine(1, 3, 1, 3);
                    this.og.drawLine(2, 2, size.width - 3, 2);
                    this.og.drawLine(0, 4, 0, size.height - 1);
                    this.og.drawLine(0, size.height - 2, size.width - 1, size.height - 2);
                    if (this.active == 2 && TabbedContainer.this.activeVisible) {
                        this.og.setColor(TabbedContainer.this.activeTitleBackground.brighter());
                        this.og.drawLine(size.width - 1, 1, size.width - 1, 1);
                        this.og.drawLine(size.width - 2, 2, size.width - 2, size.height - 2);
                        this.og.setColor(TabbedContainer.this.activeTitleBackground);
                        this.og.drawLine(size.width - 1, 2, size.width - 1, size.height - 2);
                    } else {
                        this.og.setColor(bg.darker());
                        this.og.drawLine(size.width - 2, 4, size.width - 2, size.height - 3);
                        this.og.setColor(bg.darker().darker());
                        this.og.drawLine(size.width - 2, 3, size.width - 2, 3);
                        this.og.drawLine(size.width - 1, 4, size.width - 1, size.height - 3);
                    }
                }
                this.og.setColor(TabbedContainer.this.activeTitleBackground);
                this.og.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
                if (this.focus) {
                    this.og.setColor(TabbedContainer.this.focusFrameColor);
                    GraphicsUtils.drawDashed(this.og, 1, 3, size.width - 6, 1, 1, 1, 1);
                    GraphicsUtils.drawDashed(this.og, 1, 3, 1, size.height - 5, 1, 1, 2);
                    GraphicsUtils.drawDashed(this.og, 1, size.height - 3, size.width - 6, 1, 1, 1, 1);
                    GraphicsUtils.drawDashed(this.og, size.width - 5, 3, 1, size.height - 5, 1, 1, 2);
                }
                this.repaint();
            }
        }

        private String cutWidth(FontMetrics fm, String value, int width) {
            int w;
            int i;
            if (fm.stringWidth(value) < width) {
                return value;
            }
            width -= fm.stringWidth("...");
            int length = value.length();
            for (i = 0; i < length && width - (w = fm.charWidth(value.charAt(i))) >= 0; ++i) {
                width -= w;
            }
            return value.substring(0, i) + "...";
        }

        static /* synthetic */ boolean access$902(Tab x0, boolean x1) {
            x0.focus = x1;
            return x0.focus;
        }

        static /* synthetic */ Object access$3300(Tab x0) {
            return x0.lock;
        }

        static /* synthetic */ Image access$3400(Tab x0) {
            return x0.offScreen;
        }

        static /* synthetic */ OffscreenObserver access$3500(Tab x0) {
            return x0.oo;
        }

        static /* synthetic */ OffscreenObserver access$3502(Tab x0, OffscreenObserver x1) {
            x0.oo = x1;
            return x0.oo;
        }

        static /* synthetic */ Graphics access$3600(Tab x0) {
            return x0.og;
        }

        static /* synthetic */ Image access$3402(Tab x0, Image x1) {
            x0.offScreen = x1;
            return x0.offScreen;
        }

        static /* synthetic */ Graphics access$3602(Tab x0, Graphics x1) {
            x0.og = x1;
            return x0.og;
        }
    }

    private class Tabbar
    extends Container {
        private Tabbar() {
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            super.paint(g);
            AlignLayout.Status status = TabbedContainer.this.tabbarLayout.getStatus();
            Rectangle rect = ((TabPanel)TabbedContainer.this.panels.elementAt(status.last)).tab.getBounds();
            Dimension size = this.getSize();
            int x = rect.x + rect.width;
            int w = size.width - x;
            if (w > 0) {
                g.setColor(TabbedContainer.this.getBackground());
                g.fillRect(x, 0, w, size.height);
            }
            TabbedContainer.this.paintUnderLine(g, this.getSize());
        }
    }

    private class TabPanel {
        private String key;
        private Tab tab;
        private Component comp;
        private int index;
        private int active;

        private TabPanel(String key, String title, Image image, Component comp) {
            this.key = key;
            this.tab = new Tab(title, image);
            this.comp = comp;
            this.tab.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ TabPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    if ((e.getModifiers() & 0x10) == 16 && e.getClickCount() == 1) {
                        if (TabPanel.access$1900(this.this$1) != 1) {
                            TabPanel.access$700(this.this$1, true);
                        }
                        TabPanel.access$600(this.this$1).requestFocus();
                    }
                }
            });
            this.tab.addKeyListener(new KeyAdapter(this, TabbedContainer.this){
                private final /* synthetic */ TabbedContainer val$this$0;
                private final /* synthetic */ TabPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 33: 
                        case 37: {
                            Vector vector = TabbedContainer.access$2100(TabPanel.access$2000(this.this$1));
                            synchronized (vector) {
                                int index = TabbedContainer.access$2100(TabPanel.access$2000(this.this$1)).indexOf(this.this$1);
                                if (index <= 0) {
                                    return;
                                }
                                TabPanel panel = (TabPanel)TabbedContainer.access$2100(TabPanel.access$2000(this.this$1)).elementAt(index - 1);
                                TabPanel.access$700(panel, true);
                                TabPanel.access$600(panel).requestFocus();
                                break;
                            }
                        }
                        case 34: 
                        case 39: {
                            Vector vector = TabbedContainer.access$2100(TabPanel.access$2000(this.this$1));
                            synchronized (vector) {
                                int index = TabbedContainer.access$2100(TabPanel.access$2000(this.this$1)).indexOf(this.this$1);
                                if (index + 1 >= TabbedContainer.access$2100(TabPanel.access$2000(this.this$1)).size()) {
                                    return;
                                }
                                TabPanel panel = (TabPanel)TabbedContainer.access$2100(TabPanel.access$2000(this.this$1)).elementAt(index + 1);
                                TabPanel.access$700(panel, true);
                                TabPanel.access$600(panel).requestFocus();
                                break;
                            }
                        }
                        case 36: {
                            Vector vector = TabbedContainer.access$2100(TabPanel.access$2000(this.this$1));
                            synchronized (vector) {
                                TabPanel panel = (TabPanel)TabbedContainer.access$2100(TabPanel.access$2000(this.this$1)).elementAt(0);
                                TabPanel.access$700(panel, true);
                                TabPanel.access$600(panel).requestFocus();
                                break;
                            }
                        }
                        case 35: {
                            Vector vector = TabbedContainer.access$2100(TabPanel.access$2000(this.this$1));
                            synchronized (vector) {
                                TabPanel panel = (TabPanel)TabbedContainer.access$2100(TabPanel.access$2000(this.this$1)).elementAt(TabbedContainer.access$2100(TabPanel.access$2000(this.this$1)).size() - 1);
                                TabPanel.access$700(panel, true);
                                TabPanel.access$600(panel).requestFocus();
                                break;
                            }
                        }
                    }
                }
            });
        }

        private void attach(int index) {
            this.index = index;
            this.comp.setSize(TabbedContainer.this.main.getSize());
            TabbedContainer.this.tabbar.add((Component)this.tab, new Integer(index));
            TabbedContainer.this.main.add(this.comp, this.key);
            if (index > 0) {
                TabPanel panel = (TabPanel)TabbedContainer.this.panels.elementAt(index - 1);
                if (panel.active == 2) {
                    panel.changeActived(0);
                    this.changeActived(2);
                }
            }
        }

        private void detach(int index) {
            TabbedContainer.this.tabbar.remove(this.tab);
            TabbedContainer.this.main.remove(this.comp);
            if (index > 0 && this.active == 2) {
                ((TabPanel)TabbedContainer.this.panels.elementAt(index - 1)).changeActived(2);
            }
        }

        private boolean setActived(boolean postEvent) {
            if (!this.changeActived(1)) {
                return false;
            }
            if (postEvent) {
                TabbedContainer.this.postEvent(this.key, 3000);
            }
            return true;
        }

        private boolean changeActived(int active) {
            if (active == this.active) {
                return false;
            }
            boolean focus = false;
            if (this.active == 1) {
                this.changeBeforeActive(0);
            }
            if (active == 1 && TabbedContainer.this.activeTabPanel != null && TabbedContainer.this.activeTabPanel != this) {
                focus = ((TabbedContainer)TabbedContainer.this).activeTabPanel.tab.focus;
                TabbedContainer.this.activeTabPanel.changeActived(0);
            }
            this.active = active;
            this.tab.active = active;
            this.tab.focusTraversable = active == 1;
            if (focus) {
                this.tab.requestFocus();
            }
            if (active == 1) {
                int index = TabbedContainer.this.panels.indexOf(this);
                TabbedContainer.this.tabbarLayout.show(TabbedContainer.this.tabbar, index);
                TabbedContainer.this.mainLayout.show(TabbedContainer.this.main, this.key);
                TabbedContainer.this.activeTabPanel = this;
                TabbedContainer.this.activeTabPanelIndex = index;
                this.changeBeforeActive(2);
                TabbedContainer.this.repaintTabScroll();
            }
            this.tab.refresh();
            return true;
        }

        private void changeBeforeActive(int active) {
            int index = TabbedContainer.this.panels.indexOf(this);
            if (index > 0) {
                ((TabPanel)TabbedContainer.this.panels.elementAt(index - 1)).changeActived(active);
            }
        }

        static /* synthetic */ int access$1900(TabPanel x0) {
            return x0.active;
        }

        static /* synthetic */ TabbedContainer access$2000(TabPanel x0) {
            return x0.TabbedContainer.this;
        }
    }
}

