/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreatorComponent;
import net.hizlab.kagetaka.util.Environment;

public class StatusBar
extends Component {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resource";
    private static final int MENU_COPY = 0;
    private Dimension statusSize = new Dimension(0, 0);
    private String statusText = null;
    private char[] statusChars = null;
    private PopupMenu popupMenu = null;
    private ImageCreatorComponent icc = new ImageCreatorComponent(this);

    public StatusBar() {
        this.setFont(Font.decode("Dialog"));
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.setVisible(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || (e.getModifiers() & 4) == 4) {
                    StatusBar.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.popupMenu = new PopupMenu(Resource.getMessage(RESOURCE, "statusbar.menu", null));
        MenuItem mi = new MenuItem(Resource.getMessage(RESOURCE, "statusbar.menu.copy", null));
        mi.addActionListener(new MenuActionListener(0));
        this.popupMenu.add(mi);
        this.add(this.popupMenu);
    }

    public synchronized void setText(String value) {
        if (this.statusText == value) {
            return;
        }
        if (this.statusText == null || value == null || this.statusText.compareTo(value) != 0) {
            this.statusText = value;
            this.statusChars = (char[])(this.statusText != null ? this.statusText.toCharArray() : null);
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.statusSize.height = this.getFontMetrics(font).getHeight() + 5;
        this.setSize(this.statusSize);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.statusSize);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.statusSize);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.statusSize);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        Color bg = this.getBackground();
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(this.getForeground());
        StatusBar statusBar = this;
        synchronized (statusBar) {
            if (this.statusChars != null) {
                FontData fontData = FontData.getInstance(this.icc, this.getFont());
                FontMetrics fm = fontData.getFontMetrics();
                int x = 4;
                int fix = (size.height - fontData.getMaxHeight()) / 2 + 1;
                int y1 = fontData.getHalfBase() + fix;
                int y2 = fontData.getFullBase() + fix;
                for (int i = 0; i < this.statusChars.length; ++i) {
                    char c = this.statusChars[i];
                    g.drawChars(this.statusChars, i, 1, x, c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? y1 : y2);
                    x += fm.charWidth(this.statusChars[i]);
                }
            }
        }
        g.setColor(SystemColor.controlShadow);
        g.drawLine(1, 2, size.width, 2);
        g.drawLine(1, 2, 1, size.height);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(size.width - 1, 2, size.width - 1, size.height - 1);
        g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
        if (Environment.isWindows) {
            g.setColor(bg);
            g.drawLine(size.width - 13, size.height - 1, size.width - 1, size.height - 1);
            g.drawLine(size.width - 1, size.height - 13, size.width - 1, size.height - 1);
            g.drawLine(size.width - 2, size.height - 2, size.width - 2, size.height - 2);
            g.drawLine(size.width - 6, size.height - 2, size.width - 2, size.height - 6);
            g.drawLine(size.width - 10, size.height - 2, size.width - 2, size.height - 10);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(size.width - 5, size.height - 2, size.width - 2, size.height - 5);
            g.drawLine(size.width - 9, size.height - 2, size.width - 2, size.height - 9);
            g.drawLine(size.width - 13, size.height - 2, size.width - 2, size.height - 13);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(size.width - 3, size.height - 2, size.width - 2, size.height - 3);
            g.drawLine(size.width - 4, size.height - 2, size.width - 2, size.height - 4);
            g.drawLine(size.width - 7, size.height - 2, size.width - 2, size.height - 7);
            g.drawLine(size.width - 8, size.height - 2, size.width - 2, size.height - 8);
            g.drawLine(size.width - 11, size.height - 2, size.width - 2, size.height - 11);
            g.drawLine(size.width - 12, size.height - 2, size.width - 2, size.height - 12);
        }
    }

    protected String paramString() {
        String str = super.paramString();
        return str;
    }

    private void copyClipboard(String value) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(value);
        clipboard.setContents(data, data);
    }

    private class MenuActionListener
    implements ActionListener {
        private int index = 0;

        private MenuActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this.index) {
                case 0: {
                    StatusBar.this.copyClipboard(StatusBar.this.statusText);
                }
            }
        }
    }
}

