/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;

public class ProgressBar
extends Component {
    private int min;
    private int max;
    private int now;

    public ProgressBar() {
        this(0, 100, 0);
    }

    public ProgressBar(int min, int max) {
        this(min, max, min);
    }

    public ProgressBar(int min, int max, int now) {
        this.min = min;
        this.max = max;
        this.now = now;
        this.setForeground(SystemColor.controlShadow);
        this.setBackground(SystemColor.control);
    }

    public int getValue() {
        return this.now;
    }

    public void setValue(int now) {
        if (this.now != now) {
            this.now = now;
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, 16);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        Color bg = this.getBackground();
        Color bgDarker = bg.darker();
        Color bgBrighter = bg.brighter();
        g.setColor(bg);
        g.drawRect(1, 1, size.width - 2, size.height - 2);
        g.setColor(bgDarker);
        g.drawLine(0, 0, size.width, 0);
        g.drawLine(0, 0, 0, size.height);
        g.setColor(bgBrighter);
        g.drawLine(size.width - 1, 0, size.width - 1, size.height - 1);
        g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
        double per = (double)this.now / (double)(this.max - this.min);
        if (per < 0.0) {
            per = 0.0;
        } else if (per > 100.0) {
            per = 100.0;
        }
        int len = (int)((double)(size.width - 4) * per);
        if (len > 0) {
            g.setColor(this.getForeground());
            g.fillRect(2, 2, len, size.height - 4);
        }
        if (len + 4 < size.width) {
            g.setColor(bg);
            g.fillRect(len + 2, 2, size.width - len - 4, size.height - 4);
        }
    }

    protected String paramString() {
        String str = super.paramString();
        return str + ",min=" + this.min + ",max=" + this.max + ",now=" + this.now;
    }
}

