/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreator;

public abstract class InnerToolTip {
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private static final int INNER_MARGIN = 3;
    private static final int OUTER_MARGIN = 3;
    private static int threadCount = 0;
    private ImageCreator creator = null;
    private volatile long delay = 0L;
    private volatile long term = 0L;
    private Insets fix = null;
    private Font font = null;
    private Color colorFore = null;
    private Color colorBack = null;
    private Color colorEdge = null;
    private Tip tip;
    private ToolTipThread timer;

    public InnerToolTip(ImageCreator creator, long delay, long term, Insets fix) {
        if (fix == null) {
            fix = new Insets(0, 0, 0, 0);
        }
        this.creator = creator;
        this.delay = delay;
        this.term = term;
        this.fix = fix;
        this.timer = new ToolTipThread("Kankana-InnerToolTip-" + ++threadCount);
        this.timer.start();
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.infoText);
        this.setBackground(SystemColor.info);
        this.setEdgeColor(SystemColor.windowBorder);
    }

    public synchronized void showTip(String value, int x, int y, int width, int height) {
        this.timer.reset(new Tip(value, x, y, width, height));
    }

    public void cancel() {
        this.timer.cancel();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getForeground() {
        return this.colorFore;
    }

    public void setForeground(Color c) {
        this.colorFore = c;
    }

    public Color getBackground() {
        return this.colorBack;
    }

    public void setBackground(Color c) {
        this.colorBack = c;
    }

    public Color getEdgeColor() {
        return this.colorEdge;
    }

    public void setEdgeColor(Color c) {
        this.colorEdge = c;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getTerm() {
        return this.term;
    }

    public void setTerm(long term) {
        this.term = term;
    }

    public void paint(Graphics g) {
        Tip tip = this.tip;
        if (tip != null) {
            tip.paint(g);
        }
    }

    public void dispose() {
        this.timer.interrupt();
    }

    public abstract void repaint(int var1, int var2, int var3, int var4);

    private class Tip
    implements Cloneable {
        private String value;
        private int baseX;
        private int baseY;
        private int baseWidth;
        private int baseHeight;
        private char[] chars;
        private Font font;
        private FontMetrics fm;
        private int baseFull;
        private int baseHalf;
        private int x;
        private int y;
        private int width;
        private int height;

        private Tip(String value, int x, int y, int width, int height) {
            this.value = value;
            this.baseX = x;
            this.baseY = y;
            this.baseWidth = width;
            this.baseHeight = height;
        }

        private void initialize() {
            Font font = InnerToolTip.this.font;
            if (font == this.font) {
                return;
            }
            FontData fontData = FontData.getInstance(InnerToolTip.this.creator, font);
            this.chars = this.value.toCharArray();
            this.font = font;
            this.fm = fontData.getFontMetrics();
            this.baseFull = fontData.getFullBase();
            this.baseHalf = fontData.getHalfBase();
            int x = this.baseX;
            int y = this.baseY;
            int width = this.fm.stringWidth(this.value) + 6 + 2;
            int height = Math.max(fontData.getFullSize().height, fontData.getHalfHeight()) + 6 + 2;
            if (this.baseWidth < x + width + 3) {
                x = this.baseWidth - width - 3;
            }
            if (x < 3) {
                x = 3;
            }
            if (this.baseHeight < y + height + 3) {
                y = this.baseHeight - height - 3;
            }
            if (y < 3) {
                y = 3;
            }
            this.x = x;
            this.y = y;
            this.width = width - 1;
            this.height = height - 1;
        }

        private void paint(Graphics g) {
            g.setColor(InnerToolTip.this.colorBack);
            g.fillRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2);
            g.setColor(InnerToolTip.this.colorEdge);
            g.drawRect(this.x, this.y, this.width - 1, this.height - 1);
            g.setColor(InnerToolTip.this.colorFore);
            int x = this.x + 3 + 1;
            int y = this.y + 3 + 1;
            g.setFont(this.font);
            for (int i = 0; i < this.chars.length; ++i) {
                char c = this.chars[i];
                g.drawChars(this.chars, i, 1, x, y + (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? this.baseHalf : this.baseFull));
                x += this.fm.charWidth(this.chars[i]);
            }
        }
    }

    private class ToolTipThread
    extends Thread {
        private Tip tip;
        private boolean reset;

        private ToolTipThread(String name) {
            super(name);
        }

        public void run() {
            try {
                ToolTipThread toolTipThread = this;
                synchronized (toolTipThread) {
                    block5: while (true) {
                        this.wait();
                        while (true) {
                            if (this.tip == null || !this.reset) continue block5;
                            this.reset = false;
                            this.wait(InnerToolTip.this.delay);
                            if (this.reset || this.tip == null) continue;
                            this.tip.initialize();
                            Tip paintTip = this.tip;
                            InnerToolTip.this.tip = paintTip;
                            InnerToolTip.this.repaint(paintTip.x, paintTip.y, paintTip.width, paintTip.height);
                            this.wait(InnerToolTip.this.term);
                            InnerToolTip.this.tip = null;
                            InnerToolTip.this.repaint(paintTip.x, paintTip.y, paintTip.width, paintTip.height);
                        }
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private synchronized void cancel() {
            this.reset = true;
            this.tip = null;
            InnerToolTip.this.tip = null;
            this.notify();
        }

        private synchronized void reset(Tip tip) {
            this.reset = true;
            this.tip = tip;
            this.notify();
        }
    }
}

