/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.EventListener;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;

public abstract class InnerScrollbar {
    private static final int NONE = -1;
    private static final int NORMAL = 0;
    private static final int DOWN1 = 1;
    private static final int DOWN2 = 2;
    private static final int DISABLE = 3;
    private static final int ARROW1 = 1;
    private static final int ARROW2 = 2;
    private static final int SPACE1 = 3;
    private static final int SPACE2 = 4;
    private static final int HANDLE = 5;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int ARROW_SIZE = 15;
    private static final int[] ARROW_LEFT = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] ARROW_RIGHT = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] ARROW_TOP = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] ARROW_BOTTOM = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Listener listener;
    private int orientation;
    private Component component;
    private boolean isHorizontal;
    private boolean isEnabled = true;
    private boolean isVisible = true;
    private Color sliderColor;
    private int value = 0;
    private int visible = 1;
    private int minimum = 0;
    private int maximum = 1;
    private int unitIncrement = 1;
    private int blockIncrement = 1;
    private int pressedArea = -1;
    private Point pressedHandle = new Point(0, 0);
    private AutoScroll autoScroll;
    private boolean rectChanged;
    private Rectangle rectangle = new Rectangle(0, 0, 0, 0);
    private Rectangle rectArrow1 = new Rectangle(0, 0, 0, 0);
    private Rectangle rectArrow2 = new Rectangle(0, 0, 0, 0);
    private Rectangle rectSlider = new Rectangle(0, 0, 0, 0);
    private Rectangle rectHandle = new Rectangle(0, 0, 0, 0);

    public InnerScrollbar(int orientation, Component component) {
        this.orientation = orientation;
        this.component = component;
        this.isHorizontal = orientation == 0;
        this.calculateColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int width, int height) {
        InnerScrollbar innerScrollbar = this;
        synchronized (innerScrollbar) {
            this.rectangle.setBounds(x, y, width, height);
            if (this.isHorizontal) {
                this.rectArrow1.setBounds(x, y, 15, height);
                this.rectArrow2.setBounds(x + width - 15, y, 15, height);
                this.rectSlider.setBounds(x + 15, y, width - 30, height);
            } else {
                this.rectArrow1.setBounds(x, y, width, 15);
                this.rectArrow2.setBounds(x, y + height - 15, width, 15);
                this.rectSlider.setBounds(x, y + 15, width, height - 30);
            }
            this.rectChanged = true;
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.rectangle);
    }

    public int getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int value) {
        InnerScrollbar innerScrollbar = this;
        synchronized (innerScrollbar) {
            if (this.value == value) {
                return;
            }
            this.value = value;
            this.rectChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReverseValue() {
        InnerScrollbar innerScrollbar = this;
        synchronized (innerScrollbar) {
            return this.maximum - this.visible - this.value + this.minimum;
        }
    }

    public int getVisibleAmount() {
        return this.visible;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValues(int value, int visible, int minimum, int maximum) {
        if (maximum <= minimum) {
            maximum = minimum + 1;
        }
        if (visible > maximum - minimum) {
            visible = maximum - minimum;
        }
        if (visible < 1) {
            visible = 1;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (value > maximum - visible) {
            value = maximum - visible;
        }
        InnerScrollbar innerScrollbar = this;
        synchronized (innerScrollbar) {
            if (this.value == value && this.visible == visible && this.minimum == minimum && this.maximum == maximum) {
                return false;
            }
            this.value = value;
            this.visible = visible;
            this.minimum = minimum;
            this.maximum = maximum;
            this.rectChanged = true;
        }
        return true;
    }

    public void setReverseValues(int value, int visible, int minimum, int maximum) {
        this.setValues(maximum - visible - value + minimum, visible, minimum, maximum);
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int unit) {
        this.unitIncrement = unit;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int block) {
        this.blockIncrement = block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        InnerScrollbar innerScrollbar = this;
        synchronized (innerScrollbar) {
            if (this.listener != null) {
                this.component.removeMouseListener(this.listener);
                this.component.removeMouseMotionListener(this.listener);
                this.listener = null;
            }
            if (this.autoScroll != null) {
                this.autoScroll.interrupt();
                this.autoScroll = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean b) {
        this.isEnabled = b;
        if (!b) {
            this.pressedArea = -1;
            InnerScrollbar innerScrollbar = this;
            synchronized (innerScrollbar) {
                if (this.autoScroll != null) {
                    this.autoScroll.pause();
                }
            }
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean b) {
        this.isVisible = b;
        if (!b) {
            this.pressedArea = -1;
            InnerScrollbar innerScrollbar = this;
            synchronized (innerScrollbar) {
                if (this.autoScroll != null) {
                    this.autoScroll.pause();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canScroll() {
        InnerScrollbar innerScrollbar = this;
        synchronized (innerScrollbar) {
            return this.maximum - this.minimum > this.visible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, boolean arrow) {
        if (!this.isVisible) {
            return;
        }
        InnerScrollbar innerScrollbar = this;
        synchronized (innerScrollbar) {
            if (this.listener == null) {
                this.listener = new Listener();
                this.component.addMouseListener(this.listener);
                this.component.addMouseMotionListener(this.listener);
            }
            if (this.rectChanged) {
                int total = this.maximum - this.minimum;
                int denominator = this.maximum - this.visible - this.minimum;
                if (this.isHorizontal) {
                    int w = this.rectSlider.width;
                    if (this.visible < total && total > 0) {
                        w = (int)Math.round((double)w * (double)this.visible / (double)total + 0.5);
                    }
                    int x = this.rectSlider.width - w;
                    if (denominator > 0) {
                        x = x * (this.value - this.minimum) / denominator;
                    }
                    this.rectHandle.setBounds(this.rectSlider.x + x, this.rectSlider.y, w, this.rectSlider.height);
                } else {
                    int h = this.rectSlider.height;
                    if (this.visible < total && total > 0) {
                        h = (int)Math.round((double)h * (double)this.visible / (double)total + 0.5);
                    }
                    int y = this.rectSlider.height - h;
                    if (denominator > 0) {
                        y = y * (this.value - this.minimum) / denominator;
                    }
                    this.rectHandle.setBounds(this.rectSlider.x, this.rectSlider.y + y, this.rectSlider.width, h);
                }
            }
            Rectangle r = this.rectSlider;
            g.setColor(this.sliderColor);
            g.fillRect(r.x, r.y, r.width, r.height);
            if (arrow) {
                int[] types = new int[]{1, 2};
                Rectangle[] rects = new Rectangle[]{this.rectArrow1, this.rectArrow2};
                int[][] images = this.isHorizontal ? new int[][]{ARROW_LEFT, ARROW_RIGHT} : new int[][]{ARROW_TOP, ARROW_BOTTOM};
                Color color = SystemColor.controlText;
                if (!this.isEnabled) {
                    color = new Color(new GrayFilter(SystemColor.control).filterRGB(0, 0, color.getRGB()));
                }
                for (int i = 0; i < 2; ++i) {
                    int fix;
                    r = rects[i];
                    g.setColor(SystemColor.control);
                    g.fillRect(r.x, r.y, r.width, r.height);
                    int n = fix = this.pressedArea == types[i] ? 3 : 2;
                    if (!this.isEnabled) {
                        this.drawArray(g, images[i], (this.isHorizontal ? r.x : r.x + (r.width - 15) / 2) + fix + 1, (this.isHorizontal ? r.y + (r.height - 15) / 2 : r.y) + fix + 1, 11, 11, SystemColor.controlLtHighlight);
                    }
                    this.drawArray(g, images[i], (this.isHorizontal ? r.x : r.x + (r.width - 15) / 2) + fix, (this.isHorizontal ? r.y + (r.height - 15) / 2 : r.y) + fix, 11, 11, color);
                    if (this.pressedArea == types[i]) {
                        g.setColor(SystemColor.controlShadow);
                        g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
                        continue;
                    }
                    g.setColor(SystemColor.controlHighlight);
                    g.drawLine(r.x, r.y, r.x + r.width - 1, r.y);
                    g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
                    g.setColor(SystemColor.controlLtHighlight);
                    g.drawLine(r.x + 1, r.y + 1, r.x + r.width - 2, r.y + 1);
                    g.drawLine(r.x + 1, r.y + 1, r.x + 1, r.y + r.height - 2);
                    g.setColor(SystemColor.controlShadow);
                    g.drawLine(r.x + r.width - 2, r.y + 2, r.x + r.width - 2, r.y + r.height - 2);
                    g.drawLine(r.x + 2, r.y + r.height - 2, r.x + r.width - 2, r.y + r.height - 2);
                    g.setColor(SystemColor.controlDkShadow);
                    g.drawLine(r.x + r.width - 1, r.y + 1, r.x + r.width - 1, r.y + r.height - 1);
                    g.drawLine(r.x + 1, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
                }
            }
            if (this.isEnabled && this.rectHandle.width > 0 && this.rectHandle.height > 0) {
                r = this.rectHandle;
                g.setColor(SystemColor.control);
                g.fillRect(r.x, r.y, r.width, r.height);
                g.setColor(SystemColor.controlHighlight);
                g.drawLine(r.x, r.y, r.x + r.width - 1, r.y);
                g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(r.x + 1, r.y + 1, r.x + r.width - 2, r.y + 1);
                g.drawLine(r.x + 1, r.y + 1, r.x + 1, r.y + r.height - 2);
                g.setColor(SystemColor.controlShadow);
                g.drawLine(r.x + r.width - 2, r.y + 2, r.x + r.width - 2, r.y + r.height - 2);
                g.drawLine(r.x + 2, r.y + r.height - 2, r.x + r.width - 2, r.y + r.height - 2);
                g.setColor(SystemColor.controlDkShadow);
                g.drawLine(r.x + r.width - 1, r.y + 1, r.x + r.width - 1, r.y + r.height - 1);
                g.drawLine(r.x + 1, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
            }
            switch (this.pressedArea) {
                case 3: 
                case 4: {
                    g.setColor(SystemColor.controlShadow);
                    r = this.rectSlider;
                    if (this.pressedArea == 3) {
                        if (this.isHorizontal) {
                            g.fillRect(r.x, r.y, this.rectHandle.x - r.x, r.height);
                            break;
                        }
                        g.fillRect(r.x, r.y, r.width, this.rectHandle.y - r.y);
                        break;
                    }
                    if (this.isHorizontal) {
                        g.fillRect(r.x + (this.rectHandle.x - r.x) + this.rectHandle.width, r.y, r.width - (this.rectHandle.x - r.x) - this.rectHandle.width, r.height);
                        break;
                    }
                    g.fillRect(r.x, r.y + (this.rectHandle.y - r.y) + this.rectHandle.height, r.width, r.height - (this.rectHandle.y - r.y) - this.rectHandle.height);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArray(Graphics g, int[] base, int x, int y, int width, int height, Color color) {
        SyncObserver so;
        int fg = color.getRGB() | 0xFF000000;
        int bg = 0;
        int[] buffer = new int[base.length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = base[i] == 1 ? fg : bg;
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, buffer, 0, width);
        mis.setAnimated(false);
        Image image = this.component.getToolkit().createImage(mis);
        SyncObserver syncObserver = so = new SyncObserver();
        synchronized (syncObserver) {
            so.init(g, x, y, width, height);
            if (!g.drawImage(image, x, y, width, height, so)) {
                try {
                    so.wait(10000L);
                }
                catch (InterruptedException e) {
                    System.out.println("wait to draw a icon");
                }
            }
        }
    }

    public boolean contains(int x, int y, boolean drag) {
        if (!this.isVisible) {
            return false;
        }
        if (this.pressedArea != -1) {
            return true;
        }
        if (drag) {
            return false;
        }
        return this.rectangle.contains(x, y);
    }

    public boolean isOwnListener(EventListener l) {
        return l == this.listener;
    }

    public abstract void repaint();

    public void changedValue() {
    }

    private void calculateColor() {
        int rgb1 = SystemColor.controlHighlight.getRGB();
        int rgb2 = SystemColor.controlLtHighlight.getRGB();
        int r1 = (rgb1 & 0xFF0000) >> 16;
        int g1 = (rgb1 & 0xFF00) >> 8;
        int b1 = rgb1 & 0xFF;
        int r2 = (rgb2 & 0xFF0000) >> 16;
        int g2 = (rgb2 & 0xFF00) >> 8;
        int b2 = rgb2 & 0xFF;
        this.sliderColor = new Color((r1 + r2) / 2, (g1 + g2) / 2, (b1 + b2) / 2);
    }

    private class AutoScroll
    extends Thread {
        private static final int INIT_INTERVAL = 300;
        private static final int INIT_TIMER = 300;
        private static final int NEXT_INTERVAL = 35;
        private int interval = 300;
        private boolean pause;
        private long startTime;
        private MouseEvent event;

        private AutoScroll(MouseEvent e) {
            this.setName("AutoScroll-" + InnerScrollbar.this.component.getName() + "-" + InnerScrollbar.this.orientation);
            this.setDaemon(true);
            this.pause = false;
            this.startTime = System.currentTimeMillis();
            this.event = e;
            try {
                this.setPriority(10);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPoint(int x, int y) {
            boolean inner = false;
            Object object = InnerScrollbar.this;
            synchronized (object) {
                switch (InnerScrollbar.this.pressedArea) {
                    case 1: {
                        inner = InnerScrollbar.this.rectArrow1.contains(x, y);
                        break;
                    }
                    case 2: {
                        inner = InnerScrollbar.this.rectArrow2.contains(x, y);
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (!InnerScrollbar.this.rectSlider.contains(x, y) || InnerScrollbar.this.rectHandle.contains(x, y)) break;
                        if (InnerScrollbar.this.isHorizontal) {
                            if (x < ((InnerScrollbar)InnerScrollbar.this).rectHandle.x) {
                                inner = InnerScrollbar.this.pressedArea == 3;
                                break;
                            }
                            inner = InnerScrollbar.this.pressedArea == 4;
                            break;
                        }
                        if (y < ((InnerScrollbar)InnerScrollbar.this).rectHandle.y) {
                            inner = InnerScrollbar.this.pressedArea == 3;
                            break;
                        }
                        boolean bl = inner = InnerScrollbar.this.pressedArea == 4;
                    }
                }
                if (inner) {
                    this.event = new MouseEvent(this.event.getComponent(), this.event.getID(), this.event.getWhen(), this.event.getModifiers(), x, y, this.event.getClickCount(), this.event.isPopupTrigger());
                }
            }
            object = this;
            synchronized (object) {
                boolean bl = this.pause = !inner;
                if (inner) {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(this.interval);
                    AutoScroll autoScroll = this;
                    synchronized (autoScroll) {
                        if (this.pause) {
                            this.wait();
                            continue;
                        }
                    }
                    if (this.interval == 300 && this.startTime + 300L < System.currentTimeMillis()) {
                        this.interval = 35;
                    }
                    InnerScrollbar.this.listener.mousePressed(this.event, false);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void pause() {
            this.pause = true;
        }

        public synchronized void resume(MouseEvent e) {
            if (!this.pause) {
                return;
            }
            this.event = e;
            this.interval = 300;
            this.pause = false;
            this.notify();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.mousePressed(e, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mousePressed(MouseEvent e, boolean mouse) {
            int x = e.getX();
            int y = e.getY();
            if (!(InnerScrollbar.this.isVisible && InnerScrollbar.this.isEnabled && e.getComponent().isEnabled() && InnerScrollbar.this.rectangle.contains(x, y))) {
                return;
            }
            e.consume();
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            boolean repaint = false;
            boolean change = false;
            InnerScrollbar innerScrollbar = InnerScrollbar.this;
            synchronized (innerScrollbar) {
                int pa = InnerScrollbar.this.pressedArea;
                if (InnerScrollbar.this.rectArrow1.contains(x, y)) {
                    InnerScrollbar.this.pressedArea = 1;
                } else if (InnerScrollbar.this.rectArrow2.contains(x, y)) {
                    InnerScrollbar.this.pressedArea = 2;
                } else if (InnerScrollbar.this.rectHandle.contains(x, y)) {
                    InnerScrollbar.this.pressedArea = 5;
                    ((InnerScrollbar)InnerScrollbar.this).pressedHandle.x = x - ((InnerScrollbar)InnerScrollbar.this).rectHandle.x;
                    ((InnerScrollbar)InnerScrollbar.this).pressedHandle.y = y - ((InnerScrollbar)InnerScrollbar.this).rectHandle.y;
                } else if (InnerScrollbar.this.rectSlider.contains(x, y)) {
                    if (InnerScrollbar.this.isHorizontal) {
                        if (x < ((InnerScrollbar)InnerScrollbar.this).rectHandle.x) {
                            InnerScrollbar.this.pressedArea = 3;
                        } else {
                            InnerScrollbar.this.pressedArea = 4;
                        }
                    } else if (y < ((InnerScrollbar)InnerScrollbar.this).rectHandle.y) {
                        InnerScrollbar.this.pressedArea = 3;
                    } else {
                        InnerScrollbar.this.pressedArea = 4;
                    }
                } else {
                    InnerScrollbar.this.pressedArea = -1;
                }
                if (pa != InnerScrollbar.this.pressedArea && (InnerScrollbar.this.pressedArea == 1 || InnerScrollbar.this.pressedArea == 2 || InnerScrollbar.this.pressedArea == 3 || InnerScrollbar.this.pressedArea == 4)) {
                    repaint = true;
                }
                int v = InnerScrollbar.this.value;
                switch (InnerScrollbar.this.pressedArea) {
                    case 1: {
                        v = Math.max(InnerScrollbar.this.minimum, v - InnerScrollbar.this.unitIncrement);
                        break;
                    }
                    case 2: {
                        v = Math.min(InnerScrollbar.this.maximum, v + InnerScrollbar.this.unitIncrement);
                        break;
                    }
                    case 3: {
                        v = Math.max(InnerScrollbar.this.minimum, v - InnerScrollbar.this.blockIncrement);
                        break;
                    }
                    case 4: {
                        v = Math.min(InnerScrollbar.this.maximum, v + InnerScrollbar.this.blockIncrement);
                    }
                }
                v = Math.max(InnerScrollbar.this.minimum, Math.min(v, InnerScrollbar.this.maximum - InnerScrollbar.this.visible));
                if (v != InnerScrollbar.this.value) {
                    InnerScrollbar.this.value = v;
                    InnerScrollbar.this.rectChanged = true;
                    repaint = true;
                    change = true;
                }
                if (!mouse) {
                    InnerScrollbar.this.pressedArea = pa;
                }
                if (mouse && InnerScrollbar.this.pressedArea != 5) {
                    if (InnerScrollbar.this.autoScroll == null) {
                        (InnerScrollbar.this.autoScroll = new AutoScroll(e)).start();
                    } else {
                        InnerScrollbar.this.autoScroll.resume(e);
                    }
                }
            }
            if (change) {
                InnerScrollbar.this.changedValue();
            }
            if (repaint) {
                InnerScrollbar.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent e) {
            InnerScrollbar innerScrollbar = InnerScrollbar.this;
            synchronized (innerScrollbar) {
                if (InnerScrollbar.this.autoScroll != null) {
                    InnerScrollbar.this.autoScroll.pause();
                }
            }
            if (!(InnerScrollbar.this.isVisible && InnerScrollbar.this.isEnabled && e.getComponent().isEnabled() && InnerScrollbar.this.pressedArea != -1)) {
                return;
            }
            e.consume();
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            int pa = InnerScrollbar.this.pressedArea;
            InnerScrollbar innerScrollbar2 = InnerScrollbar.this;
            synchronized (innerScrollbar2) {
                InnerScrollbar.this.pressedArea = -1;
            }
            switch (pa) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    InnerScrollbar.this.repaint();
                    break;
                }
                case 5: {
                    InnerScrollbar.this.rectChanged = true;
                    InnerScrollbar.this.repaint();
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent e) {
            if (!(InnerScrollbar.this.isVisible && InnerScrollbar.this.isEnabled && e.getComponent().isEnabled() && InnerScrollbar.this.pressedArea != -1)) {
                return;
            }
            e.consume();
            boolean repaint = false;
            boolean change = false;
            Listener listener = this;
            synchronized (listener) {
                int x = e.getX();
                int y = e.getY();
                if (InnerScrollbar.this.pressedArea != 5) {
                    if (InnerScrollbar.this.autoScroll != null) {
                        InnerScrollbar.this.autoScroll.setPoint(x, y);
                    }
                    return;
                }
                int oldValue = InnerScrollbar.this.value;
                if (InnerScrollbar.this.isHorizontal) {
                    x -= ((InnerScrollbar)InnerScrollbar.this).pressedHandle.x;
                    x = Math.max(x, ((InnerScrollbar)InnerScrollbar.this).rectSlider.x);
                    if (((InnerScrollbar)InnerScrollbar.this).rectHandle.x != (x = Math.min(x, ((InnerScrollbar)InnerScrollbar.this).rectSlider.x + ((InnerScrollbar)InnerScrollbar.this).rectSlider.width - ((InnerScrollbar)InnerScrollbar.this).rectHandle.width))) {
                        InnerScrollbar.this.value = (InnerScrollbar.this.maximum - InnerScrollbar.this.visible - InnerScrollbar.this.minimum) * (x - ((InnerScrollbar)InnerScrollbar.this).rectSlider.x) / (((InnerScrollbar)InnerScrollbar.this).rectSlider.width - ((InnerScrollbar)InnerScrollbar.this).rectHandle.width) + InnerScrollbar.this.minimum;
                        ((InnerScrollbar)InnerScrollbar.this).rectHandle.x = x;
                        repaint = true;
                    }
                } else {
                    y -= ((InnerScrollbar)InnerScrollbar.this).pressedHandle.y;
                    y = Math.max(y, ((InnerScrollbar)InnerScrollbar.this).rectSlider.y);
                    if (((InnerScrollbar)InnerScrollbar.this).rectHandle.y != (y = Math.min(y, ((InnerScrollbar)InnerScrollbar.this).rectSlider.y + ((InnerScrollbar)InnerScrollbar.this).rectSlider.height - ((InnerScrollbar)InnerScrollbar.this).rectHandle.height))) {
                        InnerScrollbar.this.value = (InnerScrollbar.this.maximum - InnerScrollbar.this.visible - InnerScrollbar.this.minimum) * (y - ((InnerScrollbar)InnerScrollbar.this).rectSlider.y) / (((InnerScrollbar)InnerScrollbar.this).rectSlider.height - ((InnerScrollbar)InnerScrollbar.this).rectHandle.height) + InnerScrollbar.this.minimum;
                        ((InnerScrollbar)InnerScrollbar.this).rectHandle.y = y;
                        repaint = true;
                    }
                }
                change = oldValue != InnerScrollbar.this.value;
            }
            if (change) {
                InnerScrollbar.this.changedValue();
            }
            if (repaint) {
                InnerScrollbar.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

