/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import net.hizlab.kagetaka.awt.ImageCreatorComponent;
import net.hizlab.kagetaka.awt.ImageUtils;
import net.hizlab.kagetaka.awt.image.OffscreenObserver;

public class ImageLabel
extends Component {
    private static final int SPACE = 2;
    private ImageCreatorComponent icc = new ImageCreatorComponent(this);
    private Image image;
    private Dimension size = new Dimension(2, 2);
    private boolean refresh;
    private Image offScreen;
    private Graphics og;
    private Object ogLock = new Object();
    private OffscreenObserver oo;

    public ImageLabel() {
        this(null);
    }

    public ImageLabel(Image image) {
        this.setImage(image);
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent e) {
                Object object = ImageLabel.this.ogLock;
                synchronized (object) {
                    if (ImageLabel.this.offScreen != null) {
                        if (ImageLabel.this.oo != null) {
                            ImageLabel.this.oo.dispose();
                            ImageLabel.this.oo = null;
                        }
                        ImageLabel.this.og.dispose();
                        ImageLabel.this.offScreen.flush();
                    }
                    Dimension nowSize = ImageLabel.this.getSize();
                    if (nowSize.width == 0 || nowSize.height == 0) {
                        ImageLabel.this.offScreen = null;
                        ImageLabel.this.og = null;
                    } else {
                        ImageLabel.this.offScreen = ImageLabel.this.createImage(nowSize.width, nowSize.height);
                        ImageLabel.this.og = ImageLabel.this.offScreen.getGraphics();
                        ImageLabel.this.refresh = true;
                        ImageLabel.this.repaint();
                    }
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.size);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Image getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image image) {
        Dimension dimension = this.size;
        synchronized (dimension) {
            Dimension old = new Dimension(this.size);
            if (image != null && ImageUtils.load(image, this)) {
                this.size.width = image.getWidth(this) + 4;
                this.size.height = image.getHeight(this) + 4;
            } else {
                image = null;
                this.size.height = 4;
                this.size.width = 4;
            }
            this.image = image;
            this.refresh = true;
            if (!old.equals(this.size)) {
                this.invalidate();
            }
            this.repaint();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Object object = this.ogLock;
        synchronized (object) {
            Dimension dimension = this.size;
            synchronized (dimension) {
                if (this.refresh) {
                    this.refresh();
                }
            }
            if (this.offScreen != null) {
                g.drawImage(this.offScreen, 0, 0, this);
            }
        }
    }

    private void refresh() {
        if (this.offScreen == null) {
            return;
        }
        if (this.oo != null) {
            this.oo.dispose();
            this.oo = null;
        }
        Dimension size = this.getSize();
        this.og.setColor(this.getBackground());
        this.og.fillRect(0, 0, size.width, size.height);
        this.og.setColor(SystemColor.controlShadow);
        this.og.drawLine(0, 0, size.width - 1, 0);
        this.og.drawLine(0, 0, 0, size.height - 1);
        this.og.setColor(SystemColor.controlDkShadow);
        this.og.drawLine(1, 1, size.width - 2, 1);
        this.og.drawLine(1, 1, 1, size.height - 2);
        this.og.setColor(SystemColor.controlHighlight);
        this.og.drawLine(size.width - 2, 2, size.width - 2, size.height - 2);
        this.og.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
        this.og.setColor(SystemColor.controlLtHighlight);
        this.og.drawLine(size.width - 1, 1, size.width - 1, size.height - 1);
        this.og.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
        if (this.image != null) {
            int x = (size.width - this.size.width) / 2 + 2;
            int y = (size.height - this.size.height) / 2 + 2;
            this.oo = new OffscreenObserver(this, this.og, x, y, null);
            this.og.drawImage(this.image, x, y, this.oo);
        }
        this.refresh = false;
    }
}

