/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.FilteredImageSource;
import net.hizlab.kagetaka.awt.AWTEventMulticaster;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreatorComponent;
import net.hizlab.kagetaka.awt.ImageUtils;
import net.hizlab.kagetaka.awt.SizedComponent;
import net.hizlab.kagetaka.awt.event.StateEvent;
import net.hizlab.kagetaka.awt.event.StateListener;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.OffscreenObserver;

public class ImageButton
extends SizedComponent {
    private static final Font DEFAULT_FONT = Font.decode("Dialog-plain-12");
    private static final int LABEL_RIGHT = 3;
    public static final int NORMAL = 0;
    public static final int OVER = 1;
    public static final int DOWN = 2;
    public static final int DISABLE = 3;
    public static final int HOTSPOT_OVER = 4;
    public static final int HOTSPOT_DOWN = 5;
    private Image backImage;
    private Dimension backImageSize;
    private ImageCreatorComponent icc = new ImageCreatorComponent(this);
    private int state;
    private int stateEnable;
    private int stateDown;
    private int statePaint = -1;
    private Object stateLock = new Object();
    private int pressX = -1;
    private int pressY = -1;
    private Polygon hotspot;
    private boolean isSeparate;
    private Image base;
    private Image over;
    private Image down;
    private Image disable;
    private Polygon sarea;
    private Image sover;
    private Image sdown;
    private Image sdisable;
    private String label;
    private Dimension labelSize;
    private Dimension baseSize;
    private Dimension spotSize;
    private Image offScreen;
    private Graphics og;
    private Object ogLock = new Object();
    private OffscreenObserver oob;
    private OffscreenObserver oos;
    private transient StateListener stateListener;

    public ImageButton(Image base) {
        this(null, true, base, null, null, null, null, null, null, null);
    }

    public ImageButton(String label, Image base) {
        this(label, true, base, null, null, null, null, null, null, null);
    }

    public ImageButton(Image base, Image spot) {
        this(null, true, base, null, null, null, spot, null, null, null);
    }

    public ImageButton(String label, Image base, Image spot) {
        this(label, true, base, null, null, null, spot, null, null, null);
    }

    public ImageButton(boolean separate, Image base, Image over, Image down, Image disable, Image sover, Image sdown, Image sdisable, Polygon sarea) {
        this(null, separate, base, down, over, disable, sover, sdown, sdisable, sarea);
    }

    public ImageButton(String label, boolean separate, Image base, Image over, Image down, Image disable, Image sover, Image sdown, Image sdisable, Polygon sarea) {
        this.setImageImpl(separate, base, down, over, disable, sover, sdown, sdisable, sarea);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 0x10) == 0) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                if (x < 0 || y < 0 || x >= ImageButton.this.size.width || y > ImageButton.this.size.height) {
                    return;
                }
                if (ImageButton.this.hotspot != null && ImageButton.this.hotspot.contains(x, y)) {
                    ImageButton.this.changeState(5);
                } else {
                    ImageButton.this.changeState(2);
                }
                ImageButton.this.pressX = e.getX();
                ImageButton.this.pressY = e.getY();
            }

            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 0x10) == 0) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                if (x < 0 || y < 0 || x >= ImageButton.this.size.width || y > ImageButton.this.size.height) {
                    ImageButton.this.changeState(0);
                } else if (ImageButton.this.hotspot != null && ImageButton.this.hotspot.contains(e.getX(), e.getY())) {
                    ImageButton.this.changeState(4);
                } else {
                    ImageButton.this.changeState(1);
                }
                if (e.getClickCount() > 0 && x >= 0 && y >= 0 && x < ImageButton.this.size.width && y < ImageButton.this.size.height && (x != ImageButton.this.pressX || y != ImageButton.this.pressY)) {
                    ImageButton.this.getToolkit().getSystemEventQueue().postEvent(new MouseEvent(e.getComponent(), 500, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger()));
                }
            }

            public void mouseEntered(MouseEvent e) {
                if (ImageButton.this.hotspot != null && ImageButton.this.hotspot.contains(e.getX(), e.getY())) {
                    ImageButton.this.changeState(4);
                } else {
                    ImageButton.this.changeState(1);
                }
            }

            public void mouseExited(MouseEvent e) {
                ImageButton.this.changeState(0);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (ImageButton.this.state == 0) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                if (x < 0 || y < 0 || x >= ImageButton.this.size.width || y > ImageButton.this.size.height) {
                    return;
                }
                ImageButton.this.changeState(ImageButton.this.stateDown);
            }

            public void mouseMoved(MouseEvent e) {
                if (ImageButton.this.hotspot == null) {
                    return;
                }
                if (ImageButton.this.hotspot.contains(e.getX(), e.getY())) {
                    ImageButton.this.changeState(4);
                } else {
                    ImageButton.this.changeState(1);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent e) {
                Object object = ImageButton.this.ogLock;
                synchronized (object) {
                    if (ImageButton.this.offScreen != null) {
                        if (ImageButton.this.oob != null) {
                            ImageButton.this.oob.dispose();
                            ImageButton.this.oob = null;
                        }
                        if (ImageButton.this.oos != null) {
                            ImageButton.this.oos.dispose();
                            ImageButton.this.oos = null;
                        }
                        ImageButton.this.og.dispose();
                        ImageButton.this.offScreen.flush();
                    }
                    Dimension nowSize = ImageButton.this.getSize();
                    if (nowSize.width == 0 || nowSize.height == 0) {
                        ImageButton.this.offScreen = null;
                        ImageButton.this.og = null;
                    } else {
                        ImageButton.this.offScreen = ImageButton.this.createImage(nowSize.width, nowSize.height);
                        ImageButton.this.og = ImageButton.this.offScreen.getGraphics();
                        ImageButton.this.repaint();
                    }
                    if (ImageButton.this.hotspot != null && (nowSize.width > ImageButton.this.size.width || nowSize.height > ImageButton.this.size.height)) {
                        ImageButton.this.calculateHotspot();
                    }
                }
            }
        });
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.setLabel(label);
    }

    public boolean isSeparate() {
        return this.isSeparate;
    }

    public boolean hasHotspot() {
        return this.hotspot != null;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isSeparate) {
                return;
            }
            if (this.label == label || this.label != null && label != null && this.label.compareTo(label) == 0) {
                return;
            }
            this.label = label;
            this.labelSize = null;
            if (label != null) {
                FontMetrics fm = this.getFontMetrics(this.getFont());
                this.labelSize = new Dimension(fm.stringWidth(label) + 3, fm.getHeight());
            }
            this.calculateSize();
        }
    }

    public void setImage(Image base) {
        this.setImageImpl(true, base, null, null, null, null, null, null, null);
    }

    public void setImage(Image base, Image spot) {
        this.setImageImpl(true, base, null, null, null, spot, null, null, null);
    }

    public void setImage(boolean separate, Image base, Image over, Image down, Image disable, Image sover, Image sdown, Image sdisable, Polygon sarea) {
        this.setImageImpl(separate, base, over, down, disable, sover, sdown, sdisable, sarea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImageImpl(boolean separate, Image base, Image over, Image down, Image disable, Image sover, Image sdown, Image sdisable, Polygon sarea) {
        Object object = this.stateLock;
        synchronized (object) {
            if (base != null && !ImageUtils.load(base, this)) {
                base = null;
            }
            if (down != null && !ImageUtils.load(down, this)) {
                down = null;
            }
            if (over != null && !ImageUtils.load(over, this)) {
                over = null;
            }
            if (disable != null && !ImageUtils.load(disable, this)) {
                disable = null;
            }
            if (sover != null && !ImageUtils.load(sover, this)) {
                sover = null;
            }
            if (sdown != null && !ImageUtils.load(sdown, this)) {
                sdown = null;
            }
            if (sdisable != null && !ImageUtils.load(sdisable, this)) {
                sdisable = null;
            }
            this.isSeparate = separate;
            this.base = base;
            this.over = over;
            this.down = down;
            this.disable = disable;
            this.sover = sover;
            this.sdown = sdown;
            this.sdisable = sdisable;
            this.sarea = sarea;
            this.baseSize = new Dimension(0, 0);
            this.spotSize = null;
            if (base != null) {
                this.baseSize.width = base.getWidth(this);
                this.baseSize.height = base.getHeight(this);
                if (this.isSeparate) {
                    this.baseSize.width += 3;
                    this.baseSize.height += 3;
                }
            }
            if (this.isSeparate && sover != null) {
                this.spotSize = new Dimension(sover.getWidth(this) + 3, sover.getHeight(this) + 3);
            }
            if (!this.isSeparate) {
                this.label = null;
                this.labelSize = null;
            }
            this.calculateSize();
            this.repaint();
        }
    }

    private void calculateSize() {
        Dimension newSize = new Dimension(this.baseSize.width, this.baseSize.height);
        if (this.spotSize != null) {
            newSize.width += this.spotSize.width;
            newSize.height = Math.max(newSize.height, this.spotSize.height);
        }
        if (this.labelSize != null) {
            newSize.width += this.labelSize.width;
            newSize.height = Math.max(newSize.height, this.labelSize.height);
        }
        this.calculateHotspot();
        if (!this.size.equals(newSize)) {
            this.size = newSize;
            this.invalidate();
        }
    }

    private void calculateHotspot() {
        if (this.sover == null) {
            return;
        }
        Dimension nowSize = this.getSize();
        if (this.sarea != null) {
            int h;
            int w = (nowSize.width - this.size.width) / 2;
            if (this.isSeparate) {
                h = (nowSize.height - this.spotSize.height) / 2;
                w += this.baseSize.width;
                if (this.labelSize != null) {
                    w += this.labelSize.width;
                }
            } else {
                h = (nowSize.height - this.size.height) / 2;
            }
            if (w == 0 && h == 0) {
                this.hotspot = this.sarea;
            } else {
                int npoints = this.sarea.npoints;
                int[] xpoints = new int[npoints];
                int[] ypoints = new int[npoints];
                System.arraycopy(this.sarea.xpoints, 0, xpoints, 0, npoints);
                System.arraycopy(this.sarea.ypoints, 0, ypoints, 0, npoints);
                int i = 0;
                while (i < npoints) {
                    int n = i;
                    xpoints[n] = xpoints[n] + w;
                    int n2 = i++;
                    ypoints[n2] = ypoints[n2] + h;
                }
                this.hotspot = new Polygon(xpoints, ypoints, npoints);
            }
        } else {
            int w = this.baseSize.width + (nowSize.width - this.size.width) / 2;
            if (this.labelSize != null) {
                w += this.labelSize.width;
            }
            this.hotspot = new Polygon(new int[]{w, w + this.spotSize.width, w + this.spotSize.width, w}, new int[]{0, 0, nowSize.height, nowSize.height}, 4);
        }
    }

    public Polygon getHotspotArea() {
        return this.hotspot;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Object object = this.ogLock;
        synchronized (object) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (this.state != this.statePaint) {
                    this.refresh();
                }
            }
            if (this.offScreen != null) {
                g.drawImage(this.offScreen, 0, 0, this);
            }
        }
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.changeState(b ? this.stateEnable : 3);
    }

    protected String paramString() {
        String str = super.paramString();
        return str + ",state=" + this.state;
    }

    public synchronized void addStateListener(StateListener l) {
        this.enableEvents(0L);
        this.stateListener = AWTEventMulticaster.add(this.stateListener, l);
    }

    public synchronized void removeStateListener(StateListener l) {
        this.stateListener = AWTEventMulticaster.remove(this.stateListener, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof StateEvent) {
            this.processStateEvent((StateEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processStateEvent(StateEvent e) {
        if (this.stateListener == null) {
            return;
        }
        switch (e.getID()) {
            case 3010: {
                this.stateListener.stateChanged(e);
            }
        }
    }

    private void postStateEvent(int state) {
        StateEvent e = new StateEvent(this, 3010, state);
        try {
            this.getToolkit().getSystemEventQueue().postEvent(e);
        }
        catch (SecurityException ex) {
            this.processStateEvent(e);
        }
    }

    public void setBackImage(Image image) {
        this.backImage = image;
        if (image != null && !ImageUtils.load(image, this)) {
            image = null;
        }
        if (image != null) {
            this.backImageSize = new Dimension(image.getWidth(this), image.getHeight(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        Object object = this.ogLock;
        synchronized (object) {
            int offset;
            if (this.offScreen == null) {
                return;
            }
            if (this.oob != null) {
                this.oob.dispose();
                this.oob = null;
            }
            if (this.oos != null) {
                this.oos.dispose();
                this.oos = null;
            }
            Dimension nowSize = this.getSize();
            Point p = new Point((nowSize.width - this.size.width) / 2, 0);
            Color bg = this.getBackground();
            this.og.setColor(bg);
            this.og.fillRect(0, 0, nowSize.width, nowSize.height);
            if (this.backImage != null) {
                int x = 0;
                int y = 0;
                for (x = 0; x < nowSize.width; x += this.backImageSize.width) {
                    for (y = 0; y < nowSize.height; y += this.backImageSize.height) {
                        this.og.drawImage(this.backImage, x, y, this);
                    }
                }
            }
            Image image = null;
            Image simage = null;
            if (this.isSeparate) {
                int sw = this.baseSize.width + (this.labelSize != null ? this.labelSize.width : 0);
                switch (this.state) {
                    case 0: {
                        ++p.x;
                        ++p.y;
                        image = this.base;
                        simage = this.sover;
                        break;
                    }
                    case 1: 
                    case 4: {
                        this.og.setColor(bg.brighter());
                        this.og.drawLine(p.x, p.y, p.x + nowSize.width - 2, p.y);
                        this.og.drawLine(p.x, p.y, p.x, p.y + nowSize.height - 2);
                        if (this.hotspot != null) {
                            this.og.drawLine(p.x + sw, p.y, p.x + sw, p.y + nowSize.height - 2);
                        }
                        this.og.setColor(bg.darker());
                        this.og.drawLine(p.x, p.y + nowSize.height - 1, p.x + nowSize.width - 1, p.y + nowSize.height - 1);
                        this.og.drawLine(p.x + nowSize.width - 1, p.y, p.x + nowSize.width - 1, p.y + nowSize.height - 1);
                        if (this.hotspot != null) {
                            this.og.drawLine(p.x + sw - 1, p.y, p.x + sw - 1, p.y + nowSize.height - 1);
                        }
                        ++p.x;
                        ++p.y;
                        image = this.over != null ? this.over : this.base;
                        simage = this.sover;
                        break;
                    }
                    case 2: {
                        this.og.setColor(bg.darker());
                        this.og.drawLine(p.x, p.y, p.x + nowSize.width - 1, p.y);
                        this.og.drawLine(p.x, p.y, p.x, p.y + nowSize.height - 1);
                        if (this.hotspot != null) {
                            this.og.drawLine(p.x + sw, p.y, p.x + sw, p.y + nowSize.height - 2);
                        }
                        this.og.setColor(bg.brighter());
                        this.og.drawLine(p.x + 1, p.y + nowSize.height - 1, p.x + nowSize.width - 1, p.y + nowSize.height - 1);
                        this.og.drawLine(p.x + nowSize.width - 1, p.y + 1, p.x + nowSize.width - 1, p.y + nowSize.height - 1);
                        if (this.hotspot != null) {
                            this.og.drawLine(p.x + sw - 1, p.y, p.x + sw - 1, p.y + nowSize.height - 1);
                        }
                        p.x += 2;
                        p.y += 2;
                        image = this.down != null ? this.down : this.base;
                        simage = this.sdown != null ? this.sdown : this.sover;
                        break;
                    }
                    case 3: {
                        if (this.disable == null) {
                            this.disable = this.getDisableImage(this.base);
                        }
                        if (this.hotspot != null && this.sdisable == null) {
                            this.sdisable = this.getDisableImage(this.sover);
                        }
                        ++p.x;
                        ++p.y;
                        image = this.disable;
                        simage = this.sdisable;
                        break;
                    }
                    case 5: {
                        this.og.setColor(bg.brighter());
                        this.og.drawLine(p.x, p.y, p.x + sw - 2, p.y);
                        this.og.drawLine(p.x, p.y, p.x, p.y + nowSize.height - 2);
                        this.og.drawLine(p.x + nowSize.width - 1, p.y, p.x + nowSize.width - 1, p.y + nowSize.height - 1);
                        this.og.drawLine(p.x + sw, p.y + nowSize.height - 1, p.x + nowSize.width - 2, p.y + nowSize.height - 1);
                        this.og.setColor(bg.darker());
                        this.og.drawLine(p.x, p.y + nowSize.height - 1, p.x + sw - 1, p.y + nowSize.height - 1);
                        this.og.drawLine(p.x + sw - 1, p.y, p.x + sw - 1, p.y + nowSize.height - 2);
                        this.og.drawLine(p.x + sw, p.y, p.x + nowSize.width - 2, p.y);
                        this.og.drawLine(p.x + sw, p.y, p.x + sw, p.y + nowSize.height - 2);
                        ++p.x;
                        ++p.y;
                        image = this.base;
                        simage = this.sdown != null ? this.sdown : this.sover;
                    }
                }
            } else {
                switch (this.state) {
                    case 0: {
                        image = this.base;
                        break;
                    }
                    case 1: {
                        image = this.over;
                        break;
                    }
                    case 2: {
                        image = this.down;
                        break;
                    }
                    case 3: {
                        if (this.disable == null) {
                            this.disable = this.getDisableImage(this.base);
                        }
                        image = this.disable;
                        break;
                    }
                    case 4: {
                        image = this.sover;
                        break;
                    }
                    case 5: {
                        image = this.sdown;
                    }
                }
            }
            if (image != null) {
                offset = (nowSize.height - this.baseSize.height) / 2;
                this.oob = new OffscreenObserver(this, this.og, p.x, p.y + offset, null);
                this.og.drawImage(image, p.x, p.y + offset, this.oob);
                p.x += this.baseSize.width;
            }
            if (this.label != null) {
                Font font = this.getFont();
                this.og.setFont(font);
                Color color = this.getForeground();
                if (this.state == 3) {
                    color = new Color(new GrayFilter(this.getBackground()).filterRGB(0, 0, color.getRGB()));
                }
                this.og.setColor(color);
                FontData fd = FontData.getInstance(this.icc, font);
                FontMetrics fm = fd.getFontMetrics();
                offset = (int)((double)(nowSize.height - fd.getFullSize().height - 3) / 2.0 + 0.5);
                int y1 = fd.getHalfBase() + offset + p.y;
                int y2 = fd.getFullBase() + offset + p.y;
                char[] cs = new char[1];
                for (int i = 0; i < this.label.length(); ++i) {
                    char c;
                    cs[0] = c = this.label.charAt(i);
                    int w = fm.charWidth(c);
                    this.og.drawChars(cs, 0, 1, p.x, c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? y1 : y2);
                    p.x += w;
                }
                p.x += 3;
            }
            if (simage != null) {
                if (this.state == 5) {
                    ++p.x;
                    ++p.y;
                }
                offset = (nowSize.height - this.spotSize.height) / 2;
                this.oos = new OffscreenObserver(this, this.og, p.x, p.y + offset, null);
                this.og.drawImage(simage, p.x, p.y + offset, this.oos);
            }
            this.statePaint = this.state;
        }
    }

    private Image getDisableImage(Image image) {
        return this.createImage(new FilteredImageSource(image.getSource(), new GrayFilter(this.getBackground())));
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(int s) {
        Object object = this.stateLock;
        synchronized (object) {
            if (s != 3) {
                this.stateEnable = s;
            }
            if (!this.isEnabled()) {
                s = 3;
            }
            if (this.state != s) {
                this.state = s;
                switch (this.state) {
                    case 2: 
                    case 5: {
                        this.stateDown = this.state;
                    }
                }
                if (this.isVisible()) {
                    Graphics g = this.getGraphics();
                    if (g != null) {
                        try {
                            this.update(g);
                        }
                        finally {
                            g.dispose();
                        }
                    } else {
                        this.repaint();
                    }
                }
                this.postStateEvent(s);
            }
        }
    }
}

