/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import net.hizlab.kagetaka.awt.ImageCreator;

public class FontData {
    private static final char[] SAMPLE_JP = new char[]{'\u8a9e', '\u99c5', '\u253c', '\u254b'};
    private static final char[] SAMPLE_EN = new char[]{'A', 'B', 'C', 'D', 'j', 'y', 'p', '_'};
    private static final char[] SAMPLE_X = new char[]{'x'};
    private static final Color backColor = Color.white;
    private static final Color foreColor = Color.black;
    private static Hashtable cache = new Hashtable();
    private Font font = null;
    private FontMetrics fm = null;
    private int baseFull = 0;
    private int baseHalf = 0;
    private Dimension sizeFull = null;
    private int heightMax = 0;
    private int heightHalf = 0;
    private int heightX = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontData getInstance(ImageCreator creator, Font font) {
        String fontName = font.toString();
        Hashtable hashtable = cache;
        synchronized (hashtable) {
            if (cache.containsKey(fontName)) {
                return (FontData)cache.get(fontName);
            }
            FontData fd = new FontData(creator, font);
            cache.put(fontName, fd);
            return fd;
        }
    }

    private FontData(ImageCreator creator, Font font) {
        this.font = font;
        this.fm = creator.getToolkit().getFontMetrics(font);
        Dimension size = new Dimension(0, 0);
        this.sizeFull = new Dimension(0, 0);
        this.baseFull = this.calculate(creator, SAMPLE_JP, true, this.sizeFull);
        this.baseHalf = this.calculate(creator, SAMPLE_EN, false, size);
        this.heightHalf = size.height;
        this.calculate(creator, SAMPLE_X, false, size);
        this.heightX = size.height;
        if (this.sizeFull.height > this.heightHalf) {
            this.baseHalf += this.sizeFull.height - this.heightHalf;
            this.heightHalf = this.sizeFull.height;
            this.heightMax = this.sizeFull.height;
        } else {
            this.heightMax = this.heightHalf;
        }
    }

    private int calculate(ImageCreator creator, char[] sample, boolean calcWidth, Dimension size) {
        int i;
        int rect = this.fm.getHeight();
        Image image = creator.createImage(rect, rect);
        if (image == null) {
            throw new IllegalStateException("doesn't prepare for AWT");
        }
        Graphics g = image.getGraphics();
        g.setColor(backColor);
        g.fillRect(0, 0, rect, rect);
        g.setColor(foreColor);
        g.setFont(this.font);
        int desc = this.fm.getDescent();
        int base = rect - desc;
        for (int i2 = 0; i2 < sample.length; ++i2) {
            g.drawChars(sample, i2, 1, 0, base);
        }
        g.dispose();
        int[] bitmap = new int[rect * rect];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, rect, rect, bitmap, 0, rect);
        try {
            pg.grabPixels(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int fcc = foreColor.getRGB();
        int magic1 = 0;
        int magic2 = 0;
        for (i = 0; i < bitmap.length; ++i) {
            if (bitmap[i] != fcc) continue;
            magic1 = i / rect;
            break;
        }
        for (i = bitmap.length - 1; i >= 0; --i) {
            if (bitmap[i] != fcc) continue;
            magic2 = rect - i / rect - 1;
            break;
        }
        size.height = rect - magic1 - magic2;
        if (calcWidth) {
            int magic3 = rect;
            block5: for (int i3 = rect - 1; i3 >= 0; --i3) {
                for (int j = 0; j < rect; ++j) {
                    if (bitmap[j * rect + i3] != fcc) continue;
                    magic3 = i3 + 1;
                    break block5;
                }
            }
            size.width = magic3;
        }
        return rect - desc - magic1;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public Dimension getFullSize() {
        return new Dimension(this.sizeFull);
    }

    public int getMaxHeight() {
        return this.heightMax;
    }

    public int getHalfHeight() {
        return this.heightHalf;
    }

    public int getXHeight() {
        return this.heightX;
    }

    public int getFullBase() {
        return this.baseFull;
    }

    public int getHalfBase() {
        return this.baseHalf;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append('[');
        sb.append("font=");
        int code = this.font.getStyle();
        sb.append(this.font.getName());
        if ((code & 1) != 0 && (code & 2) != 0) {
            sb.append("-bolditalic-");
        } else if ((code & 1) != 0) {
            sb.append("-bold-");
        } else if ((code & 2) != 0) {
            sb.append("-italic-");
        } else {
            sb.append("-plain-");
        }
        sb.append(this.font.getSize());
        sb.append(",fullheight=");
        sb.append(this.sizeFull.height);
        sb.append(",fullwidth=");
        sb.append(this.sizeFull.width);
        sb.append(",maxheight=");
        sb.append(this.heightMax);
        sb.append(",halfheight=");
        sb.append(this.heightHalf);
        sb.append(",xheight=");
        sb.append(this.heightX);
        sb.append(",basefull=");
        sb.append(this.baseFull);
        sb.append(",basehalf=");
        sb.append(this.baseHalf);
        sb.append(']');
        return sb.toString();
    }
}

