/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.QuietPanel;
import net.hizlab.kagetaka.awt.SizedButton;

public abstract class DialogBox
extends Dialog {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resource";
    private static final int MARGIN = 10;
    private static final int BUTTON_LENGTH = 8;
    private static final int BUTTON_HEIGHT = 8;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_OKCANCEL = 1;
    protected static final int BUTTON_OKCANCELAPPLY = 2;
    protected static final int BUTTON_YESNO = 3;
    protected static final int BUTTON_YESNOCANCEL = 4;
    protected static final int BUTTON_CANCEL = 5;
    protected static final int DEFAULT_BUTTON1 = 0;
    protected static final int DEFAULT_BUTTON2 = 16;
    protected static final int DEFAULT_BUTTON3 = 32;
    protected static final int DEFAULT_BUTTON4 = 48;
    protected static final int ALIGN_CENTER = 0;
    protected static final int ALIGN_RIGHT = 256;
    protected static final int ALIGN_LEFT = 512;
    protected static final int OPTION_HELPBUTTON = 4096;
    protected static final int MASK_BUTTON = 15;
    protected static final int MASK_DEFAULT = 240;
    protected static final int MASK_ALIGN = 3840;
    public static final int RESULT_NONE = -1;
    public static final int RESULT_OK = 0;
    public static final int RESULT_CANCEL = 1;
    public static final int RESULT_YES = 2;
    public static final int RESULT_NO = 3;
    public static final String COMMAND_OK = "ok";
    public static final String COMMAND_YES = "yes";
    public static final String COMMAND_NO = "no";
    public static final String COMMAND_CANCEL = "cancel";
    public static final String COMMAND_APPLY = "apply";
    public static final String COMMAND_HELP = "help";
    private static Insets dialogInsets;
    protected Container mainPanel;
    private int result = -1;
    private int mode = 0;
    private Frame owner;
    private GridBagLayout dialogGbl;
    private Container buttonPanel;
    private GridBagLayout buttonGbl;
    private KeyListener defaultKeyListener;
    private Button[] buttons = new Button[4];
    private Button defaultButton;
    private boolean fixedSize;
    private transient ComponentListener buttonComponentListener;
    private transient FocusListener buttonFocusListener;
    private transient KeyListener buttonKeyListener;
    private transient MouseListener buttonMouseListener;
    private transient MouseMotionListener buttonMouseMotionListener;
    private transient ActionListener buttonActionListener;

    protected DialogBox(Frame owner, int mode) {
        super(owner);
        this.owner = owner;
        this.dialogGbl = new GridBagLayout();
        super.setLayout(this.dialogGbl);
        this.mainPanel = new QuietPanel();
        this.buttonGbl = new GridBagLayout();
        this.buttonPanel = new QuietPanel(this.buttonGbl);
        this.initializeMainPanel();
        this.addButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                int r = 0;
                if (command.compareTo(DialogBox.COMMAND_OK) == 0) {
                    r = 0;
                } else if (command.compareTo(DialogBox.COMMAND_YES) == 0) {
                    r = 2;
                } else if (command.compareTo(DialogBox.COMMAND_NO) == 0) {
                    r = 3;
                } else if (command.compareTo(DialogBox.COMMAND_CANCEL) == 0) {
                    r = 1;
                } else {
                    return;
                }
                if (DialogBox.this.dialogClosing(r)) {
                    DialogBox.this.result = r;
                    DialogBox.this.dispose();
                }
            }
        });
        this.defaultKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DialogBox.this.dispose();
                    e.consume();
                }
                if (e.getKeyCode() == 10) {
                    Button target = DialogBox.this.defaultButton;
                    if (e.getSource() instanceof Button) {
                        target = (Button)e.getSource();
                    }
                    target.dispatchEvent(new ActionEvent(target, 1001, target.getActionCommand(), e.getModifiers()));
                    e.consume();
                }
            }
        };
        this.addButtonKeyListener(this.defaultKeyListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DialogBox.this.dispose();
            }
        });
        this.addKeyListener(this.defaultKeyListener);
        this.setMode(mode);
    }

    private void initializeMainPanel() {
        LayoutUtils.addGridBag(this, this.mainPanel, this.dialogGbl, 0, 0, 1, 1, 1.0, 1.0, 1, 10, new Insets(10, 10, 5, 10));
        this.mainPanel.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                this.initComponent(e.getChild());
            }

            private void initComponent(Component component) {
                if (component instanceof Container) {
                    this.initContainer((Container)component);
                }
                this.addListener(component);
            }

            private void initContainer(Container container) {
                container.addContainerListener(this);
                Component[] components = container.getComponents();
                if (components != null) {
                    for (int i = 0; i < components.length; ++i) {
                        this.initComponent(components[i]);
                    }
                }
            }

            private void addListener(Component component) {
                component.addKeyListener(DialogBox.this.defaultKeyListener);
            }
        });
    }

    private void initializeButtonPanel() {
        if (super.getComponentCount() > 1) {
            super.remove(1);
        }
        this.buttonPanel.removeAll();
        int anchor = 0;
        switch (this.mode & 0xF00) {
            case 512: {
                anchor = 17;
                break;
            }
            case 0: {
                anchor = 10;
                break;
            }
            case 256: {
                anchor = 13;
            }
        }
        LayoutUtils.addGridBag(this, this.buttonPanel, this.dialogGbl, 0, 1, 1, 1, 1.0, 0.0, 0, anchor, new Insets(5, 10, 10, 10));
    }

    public void update(Graphics g) {
        ((Container)this).paint(g);
    }

    public int getResult() {
        return this.result;
    }

    public void clearResult() {
        this.result = -1;
    }

    protected int getMode() {
        return this.mode;
    }

    protected synchronized void setMode(int value) {
        this.mode = value;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = null;
        }
        this.defaultButton = null;
        int buttonType = this.mode & 0xF;
        this.initializeButtonPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        if (buttonType == 0 || buttonType == 1 || buttonType == 2) {
            this.createButton(COMMAND_OK, gbc);
        }
        if (buttonType == 3 || buttonType == 4) {
            this.createButton(COMMAND_YES, gbc);
            gbc.insets.left = 10;
            this.createButton(COMMAND_NO, gbc);
        }
        if (buttonType == 1 || buttonType == 2 || buttonType == 4 || buttonType == 5) {
            gbc.insets.left = 10;
            this.createButton(COMMAND_CANCEL, gbc);
        }
        if (buttonType == 2) {
            gbc.insets.left = 10;
            this.createButton(COMMAND_APPLY, gbc);
        }
        if ((this.mode & 0x1000) != 0) {
            gbc.insets.left = 10;
            this.createButton(COMMAND_HELP, gbc);
        }
        int start = 0;
        switch (this.mode & 0xF0) {
            case 16: {
                start = 1;
                break;
            }
            case 32: {
                start = 2;
                break;
            }
            case 48: {
                start = 3;
            }
        }
        for (int i = start; i < this.buttons.length + start; ++i) {
            Button button = this.buttons[i >= this.buttons.length ? i - this.buttons.length : i];
            if (button == null) continue;
            this.buttonPanel.add(button);
            if (this.defaultButton != null) continue;
            this.defaultButton = button;
        }
    }

    protected boolean dialogClosing(int result) {
        return true;
    }

    public void pack() {
        this.pack(0, 0);
    }

    public void pack(int width, int height) {
        super.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (width <= 0 || width > screenSize.width) {
            width = screenSize.width;
        }
        if (height <= 0 || height > screenSize.height) {
            height = screenSize.height;
        }
        Dimension size = this.getSize();
        boolean resize = false;
        if (size.width > width) {
            size.width = width;
            resize = true;
        }
        if (size.height > height) {
            size.height = height;
            resize = true;
        }
        if (resize) {
            ((Component)this).setSize(size.width, size.height);
        }
        this.setLocationToCenter();
    }

    public void setButtonLabel(int index, String label) {
        if (this.buttons[index] == null) {
            new ArrayIndexOutOfBoundsException(index);
        }
        this.buttons[index].setLabel(label);
    }

    public void addToPanel(Component comp, GridBagLayout gbl, int x, int y, int width, int height, double weightx, double weighty, int fill, int anchor, Insets insets) {
        LayoutUtils.addGridBag(this.mainPanel, comp, gbl, x, y, width, height, weightx, weighty, fill, anchor, insets);
    }

    public synchronized void addButtonComponentListener(ComponentListener l) {
        this.buttonComponentListener = AWTEventMulticaster.add(this.buttonComponentListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].addComponentListener(l);
        }
    }

    public synchronized void removeButtonComponentListener(ComponentListener l) {
        this.buttonComponentListener = AWTEventMulticaster.remove(this.buttonComponentListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].removeComponentListener(l);
        }
    }

    public synchronized void addButtonFocusListener(FocusListener l) {
        this.buttonFocusListener = AWTEventMulticaster.add(this.buttonFocusListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].addFocusListener(l);
        }
    }

    public synchronized void removeButtonFocusListener(FocusListener l) {
        this.buttonFocusListener = AWTEventMulticaster.remove(this.buttonFocusListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].removeFocusListener(l);
        }
    }

    public synchronized void addButtonKeyListener(KeyListener l) {
        this.buttonKeyListener = AWTEventMulticaster.add(this.buttonKeyListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].addKeyListener(l);
        }
    }

    public synchronized void removeButtonKeyListener(KeyListener l) {
        this.buttonKeyListener = AWTEventMulticaster.remove(this.buttonKeyListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].removeKeyListener(l);
        }
    }

    public synchronized void addButtonMouseListener(MouseListener l) {
        this.buttonMouseListener = AWTEventMulticaster.add(this.buttonMouseListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].addMouseListener(l);
        }
    }

    public synchronized void removeButtonMouseListener(MouseListener l) {
        this.buttonMouseListener = AWTEventMulticaster.remove(this.buttonMouseListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].removeMouseListener(l);
        }
    }

    public synchronized void addButtonMouseMotionListener(MouseMotionListener l) {
        this.buttonMouseMotionListener = AWTEventMulticaster.add(this.buttonMouseMotionListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].addMouseMotionListener(l);
        }
    }

    public synchronized void removeButtonMouseMotionListener(MouseMotionListener l) {
        this.buttonMouseMotionListener = AWTEventMulticaster.remove(this.buttonMouseMotionListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].removeMouseMotionListener(l);
        }
    }

    public synchronized void addButtonActionListener(ActionListener l) {
        this.buttonActionListener = AWTEventMulticaster.add(this.buttonActionListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].addActionListener(l);
        }
    }

    public synchronized void removeButtonActionListener(ActionListener l) {
        this.buttonActionListener = AWTEventMulticaster.remove(this.buttonActionListener, l);
        for (int i = 0; i < this.buttons.length && this.buttons[i] != null; ++i) {
            this.buttons[i].removeActionListener(l);
        }
    }

    protected void setLocationToCenter() {
        Point ownerLocation = this.owner.getLocationOnScreen();
        Dimension ownerSize = this.owner.getSize();
        Dimension size = this.getSize();
        ((Component)this).setLocation(ownerLocation.x + (ownerSize.width - size.width) / 2, ownerLocation.y + (ownerSize.height - size.height) / 2);
    }

    public synchronized void addComponentListener(ComponentListener l) {
        super.addComponentListener(l);
        this.mainPanel.addComponentListener(l);
        this.buttonPanel.addComponentListener(l);
    }

    public synchronized void removeComponentListener(ComponentListener l) {
        super.removeComponentListener(l);
        this.mainPanel.removeComponentListener(l);
        this.buttonPanel.removeComponentListener(l);
    }

    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        this.mainPanel.addFocusListener(l);
        this.buttonPanel.addFocusListener(l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        super.removeFocusListener(l);
        this.mainPanel.removeFocusListener(l);
        this.buttonPanel.removeFocusListener(l);
    }

    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.mainPanel.addKeyListener(l);
        this.buttonPanel.addKeyListener(l);
    }

    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.mainPanel.removeKeyListener(l);
        this.buttonPanel.removeKeyListener(l);
    }

    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.mainPanel.addMouseListener(l);
        this.buttonPanel.addMouseListener(l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.mainPanel.removeMouseListener(l);
        this.buttonPanel.removeMouseListener(l);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.mainPanel.addMouseMotionListener(l);
        this.buttonPanel.addMouseMotionListener(l);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.mainPanel.removeMouseMotionListener(l);
        this.buttonPanel.removeMouseMotionListener(l);
    }

    public synchronized void addContainerListener(ContainerListener l) {
        super.addContainerListener(l);
    }

    public synchronized void removeContainerListener(ContainerListener l) {
        super.removeContainerListener(l);
    }

    private void createButton(String command, GridBagConstraints gbc) {
        String label = Resource.getMessage(RESOURCE, "dialogbox.button." + command, null);
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font != null ? font : this.owner.getFont());
        SizedButton button = new SizedButton(label, new Dimension(fm.charWidth('\u4e9c') * 8, fm.getHeight() + 8));
        button.setActionCommand(command);
        if (this.buttonComponentListener != null) {
            button.addComponentListener(this.buttonComponentListener);
        }
        if (this.buttonFocusListener != null) {
            button.addFocusListener(this.buttonFocusListener);
        }
        if (this.buttonKeyListener != null) {
            button.addKeyListener(this.buttonKeyListener);
        }
        if (this.buttonMouseListener != null) {
            button.addMouseListener(this.buttonMouseListener);
        }
        if (this.buttonMouseMotionListener != null) {
            button.addMouseMotionListener(this.buttonMouseMotionListener);
        }
        if (this.buttonActionListener != null) {
            button.addActionListener(this.buttonActionListener);
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] != null) continue;
            this.buttons[i] = button;
            break;
        }
        this.buttonGbl.setConstraints(button, gbc);
        ++gbc.gridx;
    }
}

