/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import net.hizlab.kagetaka.awt.ColorConverter;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.Transparent;
import net.hizlab.kagetaka.token.Value;

public class Border {
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int ALL = 15;
    public Line top;
    public Line right;
    public Line bottom;
    public Line left;
    private FontData fd;
    private Insets widths = new Insets(0, 0, 0, 0);

    public void setBaseSize(FontData fd) {
        this.fd = fd;
        this.resize(15);
    }

    public Insets getWidths() {
        return (Insets)this.widths.clone();
    }

    public void setStyle(int target, Value value) {
        this.initialize(target);
        int type = value.getType();
        if ((target & 1) != 0) {
            this.top.style = type;
        }
        if ((target & 2) != 0) {
            this.right.style = type;
        }
        if ((target & 4) != 0) {
            this.bottom.style = type;
        }
        if ((target & 8) != 0) {
            this.left.style = type;
        }
        this.resize(target);
    }

    public void setWidth(int target, Value value) {
        this.initialize(target);
        if ((target & 1) != 0) {
            this.top.width = value;
        }
        if ((target & 2) != 0) {
            this.right.width = value;
        }
        if ((target & 4) != 0) {
            this.bottom.width = value;
        }
        if ((target & 8) != 0) {
            this.left.width = value;
        }
        this.resize(target);
    }

    public void setColor(int target, Color value) {
        this.initialize(target);
        if ((target & 1) != 0) {
            this.top.color = value;
        }
        if ((target & 2) != 0) {
            this.right.color = value;
        }
        if ((target & 4) != 0) {
            this.bottom.color = value;
        }
        if ((target & 8) != 0) {
            this.left.color = value;
        }
    }

    private void initialize(int target) {
        if ((target & 1) != 0 && this.top == null) {
            this.top = new Line();
        }
        if ((target & 2) != 0 && this.right == null) {
            this.right = new Line();
        }
        if ((target & 4) != 0 && this.bottom == null) {
            this.bottom = new Line();
        }
        if ((target & 8) != 0 && this.left == null) {
            this.left = new Line();
        }
    }

    private void resize(int target) {
        if (this.fd == null) {
            return;
        }
        if ((target & 1) != 0 && this.top != null && this.top.width != null) {
            int n = this.widths.top = this.top.style != 3 ? this.top.width.getValue(this.fd, 0, 2) : 0;
        }
        if ((target & 2) != 0 && this.right != null && this.right.width != null) {
            int n = this.widths.right = this.right.style != 3 ? this.right.width.getValue(this.fd, 0, 1) : 0;
        }
        if ((target & 4) != 0 && this.bottom != null && this.bottom.width != null) {
            int n = this.widths.bottom = this.bottom.style != 3 ? this.bottom.width.getValue(this.fd, 0, 2) : 0;
        }
        if ((target & 8) != 0 && this.left != null && this.left.width != null) {
            this.widths.left = this.left.style != 3 ? this.left.width.getValue(this.fd, 0, 1) : 0;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append('[');
        if (this.top != null) {
            sb.append(this.top.toString());
        }
        sb.append(", ");
        if (this.right != null) {
            sb.append(this.right.toString());
        }
        sb.append(", ");
        if (this.bottom != null) {
            sb.append(this.bottom.toString());
        }
        sb.append(", ");
        if (this.left != null) {
            sb.append(this.left.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public void draw(Graphics g, int x1, int y1, int x2, int y2, Color color) {
        if (!(this.widths.top <= 0 || this.top.color != null && this.top.color instanceof Transparent)) {
            this.fillRectangle(g, x1, y1, x2, y1, x2 - this.widths.right, y1 + this.widths.top, x1 + this.widths.left, y1 + this.widths.top, this.top.style, this.top.color != null ? this.top.color : color, 1);
        }
        if (!(this.widths.right <= 0 || this.right.color != null && this.right.color instanceof Transparent)) {
            this.fillRectangle(g, x2 - this.widths.right, y1 + this.widths.top, x2, y1, x2, y2, x2 - this.widths.right, y2 - this.widths.bottom, this.right.style, this.right.color != null ? this.right.color : color, 2);
        }
        if (!(this.widths.bottom <= 0 || this.bottom.color != null && this.bottom.color instanceof Transparent)) {
            this.fillRectangle(g, x1 + this.widths.left, y2 - this.widths.bottom, x2 - this.widths.right, y2 - this.widths.bottom, x2, y2, x1, y2, this.bottom.style, this.bottom.color != null ? this.bottom.color : color, 4);
        }
        if (!(this.widths.left <= 0 || this.left.color != null && this.left.color instanceof Transparent)) {
            this.fillRectangle(g, x1, y1, x1 + this.widths.left, y1 + this.widths.top, x1 + this.widths.left, y2 - this.widths.bottom, x1, y2, this.left.style, this.left.color != null ? this.left.color : color, 8);
        }
    }

    private void fillRectangle(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int style, Color color, int sense) {
        switch (style) {
            case 12: 
            case 13: {
                g.setColor(color);
                int n = 0;
                switch (sense) {
                    case 1: {
                        n = y4 - y1;
                        GraphicsUtils.drawDashed(g, x1, y1, x2 - x1, n, style == 12 ? n : n * 3, style == 12 ? n : n * 2, 1);
                        break;
                    }
                    case 2: {
                        n = x2 - x1;
                        GraphicsUtils.drawDashed(g, x1, y2, n, y3 - y2, style == 12 ? n : n * 3, style == 12 ? n : n * 2, 2);
                        break;
                    }
                    case 4: {
                        n = y4 - y1;
                        GraphicsUtils.drawDashed(g, x4, y1, x3 - x4, n, style == 12 ? n : n * 3, style == 12 ? n : n * 2, 1);
                        break;
                    }
                    case 8: {
                        n = x2 - x1;
                        GraphicsUtils.drawDashed(g, x1, y1, n, y4 - y1, style == 12 ? n : n * 3, style == 12 ? n : n * 2, 2);
                    }
                }
                break;
            }
            case 14: {
                g.setColor(color);
                this.fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
                break;
            }
            case 15: {
                g.setColor(color);
                int w = 0;
                w = sense == 1 || sense == 4 ? y4 - y1 : x2 - x1;
                if (w < 3) {
                    this.fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
                    break;
                }
                int n = w / 3 + (w % 3 == 2 ? 1 : 0);
                double d = (double)n / (double)w;
                switch (sense) {
                    case 1: {
                        this.fillRectanglePart(g, x1, y1, x2, y2, (int)((double)x2 - (double)(x2 - x3) * d), y2 + n, (int)((double)x1 + (double)(x4 - x1) * d), y1 + n);
                        this.fillRectanglePart(g, (int)((double)x4 - (double)(x4 - x1) * d), y4 - n, (int)((double)x3 + (double)(x2 - x3) * d), y3 - n, x3, y3, x4, y4);
                        break;
                    }
                    case 2: {
                        this.fillRectanglePart(g, x1, y1, x1 + n, (int)((double)y1 - (double)(y1 - y2) * d), x4 + n, (int)((double)y4 + (double)(y3 - y4) * d), x4, y4);
                        this.fillRectanglePart(g, x2 - n, (int)((double)y2 + (double)(y1 - y2) * d), x2, y2, x3, y3, x3 - n, (int)((double)y3 - (double)(y3 - y4) * d));
                        break;
                    }
                    case 4: {
                        this.fillRectanglePart(g, x1, y1, x2, y2, (int)((double)x2 + (double)(x3 - x2) * d), y2 + n, (int)((double)x1 - (double)(x1 - x4) * d), y1 + n);
                        this.fillRectanglePart(g, (int)((double)x4 + (double)(x1 - x4) * d), y4 - n, (int)((double)x3 - (double)(x3 - x2) * d), y3 - n, x3, y3, x4, y4);
                        break;
                    }
                    case 8: {
                        this.fillRectanglePart(g, x1, y1, x1 + n, (int)((double)y1 + (double)(y2 - y1) * d), x4 + n, (int)((double)y4 - (double)(y4 - y3) * d), x4, y4);
                        this.fillRectanglePart(g, x2 - n, (int)((double)y2 - (double)(y2 - y1) * d), x2, y2, x3, y3, x3 - n, (int)((double)y3 + (double)(y4 - y3) * d));
                    }
                }
                break;
            }
            case 16: 
            case 17: {
                int w = 0;
                w = sense == 1 || sense == 4 ? y4 - y1 : x2 - x1;
                if (w < 2) {
                    g.setColor(color);
                    this.fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
                    break;
                }
                int n = w / 2;
                double d = (double)n / (double)w;
                int x5 = 0;
                int y5 = 0;
                int x6 = 0;
                int y6 = 0;
                if (style == 16) {
                    g.setColor(ColorConverter.getDarker(color));
                } else {
                    g.setColor(ColorConverter.getBrighter(color));
                }
                switch (sense) {
                    case 1: {
                        x5 = (int)((double)x2 - (double)(x2 - x3) * d);
                        y5 = y2 + n;
                        x6 = (int)((double)x1 + (double)(x4 - x1) * d);
                        y6 = y1 + n;
                        this.fillRectanglePart(g, x1, y1, x2, y2, x5, y5, x6, y6);
                        break;
                    }
                    case 2: {
                        x5 = x2 - n;
                        y5 = (int)((double)y2 + (double)(y1 - y2) * d);
                        x6 = x3 - n;
                        y6 = (int)((double)y3 - (double)(y3 - y4) * d);
                        this.fillRectanglePart(g, x1, y1, x5, y5, x6, y6, x4, y4);
                        break;
                    }
                    case 4: {
                        x5 = (int)((double)x3 - (double)(x3 - x2) * d);
                        y5 = y3 - n;
                        x6 = (int)((double)x4 + (double)(x1 - x4) * d);
                        y6 = y4 - n;
                        this.fillRectanglePart(g, x1, y1, x2, y2, x5, y5, x6, y6);
                        break;
                    }
                    case 8: {
                        x5 = x1 + n;
                        y5 = (int)((double)y1 + (double)(y2 - y1) * d);
                        x6 = x4 + n;
                        y6 = (int)((double)y4 - (double)(y4 - y3) * d);
                        this.fillRectanglePart(g, x1, y1, x5, y5, x6, y6, x4, y4);
                    }
                }
                if (style == 16) {
                    g.setColor(ColorConverter.getBrighter(color));
                } else {
                    g.setColor(ColorConverter.getDarker(color));
                }
                switch (sense) {
                    case 1: {
                        this.fillRectanglePart(g, x6, y6, x5, y5, x3, y3, x4, y4);
                        break;
                    }
                    case 2: {
                        this.fillRectanglePart(g, x5, y5, x2, y2, x3, y3, x6, y6);
                        break;
                    }
                    case 4: {
                        this.fillRectanglePart(g, x6, y6, x5, y5, x3, y3, x4, y4);
                        break;
                    }
                    case 8: {
                        this.fillRectanglePart(g, x5, y5, x2, y2, x3, y3, x6, y6);
                    }
                }
                break;
            }
            case 18: {
                if (sense == 1 || sense == 8) {
                    g.setColor(ColorConverter.getDarker(color));
                } else {
                    g.setColor(ColorConverter.getBrighter(color));
                }
                this.fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
                break;
            }
            case 19: {
                if (sense == 1 || sense == 8) {
                    g.setColor(ColorConverter.getBrighter(color));
                } else {
                    g.setColor(ColorConverter.getDarker(color));
                }
                this.fillRectanglePart(g, x1, y1, x2, y2, x3, y3, x4, y4);
            }
        }
    }

    private void fillRectanglePart(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        if (y1 != y2 || x2 != x3 || y3 != y4 || x4 != x1) {
            Polygon polygon = new Polygon();
            polygon.addPoint(x1, y1);
            polygon.addPoint(x2, y2);
            polygon.addPoint(x3, y3);
            polygon.addPoint(x4, y4);
            g.fillPolygon(polygon);
        } else {
            g.fillRect(x1, y1, x3 - x1, y3 - y1);
        }
    }

    public class Line {
        public int style = 14;
        public Value width;
        public Color color;

        private Line() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName());
            sb.append('[');
            sb.append(this.style);
            if (this.width != null) {
                sb.append(' ');
                sb.append(this.width.toString());
            }
            if (this.color != null) {
                sb.append(' ');
                sb.append(this.color.toString());
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

