/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;

public class AlignLayout
implements LayoutManager2,
Serializable {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private int sense;
    private int nowtop = -1;
    private int top;
    private int last;
    private int hgap;
    private int vgap;
    private Vector components = new Vector();

    public AlignLayout(int sense) {
        this.sense = sense;
    }

    public AlignLayout(int sense, int hgap, int vgap) {
        this.sense = sense;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (!(constraints instanceof Integer)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a Integer");
            }
            int index = (Integer)constraints;
            if (index < 0) {
                this.components.addElement(comp);
            } else {
                this.components.insertElementAt(comp, index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            try {
                int index = Integer.parseInt(name);
                this.addLayoutComponent(comp, new Integer(index));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            this.components.removeElement(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = this.components.size();
            int w = 0;
            int h = 0;
            for (int i = 0; i < ncomponents; ++i) {
                Dimension size = ((Component)this.components.elementAt(i)).getPreferredSize();
                if (this.sense == 1) {
                    w += size.width;
                    h = Math.max(h, size.height);
                    continue;
                }
                w = Math.max(w, size.width);
                h += size.height;
            }
            return new Dimension(insets.left + insets.right + w + this.hgap * (ncomponents - this.top + 1), insets.top + insets.bottom + h + this.vgap * (ncomponents - this.top + 1));
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension realMinimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = this.components.size();
            int w = 0;
            int h = 0;
            for (int i = 0; i < ncomponents; ++i) {
                Dimension size = ((Component)this.components.elementAt(i)).getMinimumSize();
                w = Math.max(w, size.width);
                h = Math.max(h, size.height);
            }
            return new Dimension(insets.left + insets.right + w + this.hgap * 2, insets.top + insets.bottom + h + this.vgap * 2);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int i;
            Component comp;
            int i2;
            int ncomponents;
            Dimension tsize;
            Insets insets;
            block12: {
                insets = parent.getInsets();
                Dimension psize = parent.getSize();
                psize.width -= insets.left + insets.right;
                psize.height -= insets.top + insets.bottom;
                tsize = new Dimension(0, 0);
                ncomponents = this.components.size();
                if (ncomponents == 0) {
                    this.last = -1;
                    this.nowtop = -1;
                    return;
                }
                this.last = ncomponents - 1;
                i2 = this.top = Math.min(this.top, this.last);
                while (i2 < ncomponents) {
                    comp = (Component)this.components.elementAt(i2);
                    if (this.countSize(psize, comp.getPreferredSize(), tsize)) {
                        this.last = i2++;
                        continue;
                    }
                    break block12;
                }
                i2 = this.top - 1;
                while (i2 >= 0 && this.countSize(psize, (comp = (Component)this.components.elementAt(i2)).getPreferredSize(), tsize)) {
                    this.top = i2--;
                }
            }
            ++this.last;
            if (this.top >= this.last) {
                this.last = this.top + 1;
            }
            for (i2 = 0; i2 < this.top; ++i2) {
                ((Component)this.components.elementAt(i2)).setVisible(false);
            }
            Point p = new Point(this.hgap + insets.left, this.vgap + insets.top);
            for (i = this.top; i < this.last; ++i) {
                comp = (Component)this.components.elementAt(i);
                comp.setVisible(true);
                Dimension size = comp.getPreferredSize();
                if (this.sense == 1) {
                    comp.setBounds(p.x, p.y, size.width, tsize.height);
                    p.x += size.width + this.hgap;
                    continue;
                }
                comp.setBounds(p.x, p.y, tsize.width, size.height);
                p.y += size.height + this.vgap;
            }
            for (i = this.last; i < ncomponents; ++i) {
                ((Component)this.components.elementAt(i)).setVisible(false);
            }
            this.nowtop = this.top;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Container parent, int index) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            if (this.top <= index && index < this.last) {
                return;
            }
            this.top = index;
            if (index >= this.last) {
                int ncomponents = this.components.size();
                int w = parent.getSize().width;
                int i = index;
                while (i >= 0 && (w -= ((Component)this.components.elementAt((int)i)).getPreferredSize().width) >= 0) {
                    this.top = i--;
                }
            }
            parent.invalidate();
            parent.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void first(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            if (this.top == 0) {
                return;
            }
            this.top = 0;
            parent.invalidate();
            parent.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            if (this.last >= this.components.size()) {
                return;
            }
            ++this.top;
            parent.invalidate();
            parent.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previous(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            if (this.top == 0) {
                return;
            }
            --this.top;
            parent.invalidate();
            parent.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void last(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            if (this.last >= this.components.size()) {
                return;
            }
            this.top = this.components.size() - 1;
            parent.invalidate();
            parent.validate();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    public Status getStatus() {
        return new Status(this.nowtop, this.last - 1, this.components.size());
    }

    private boolean countSize(Dimension p, Dimension c, Dimension t) {
        if (this.sense == 1) {
            if (t.width + c.width > p.width) {
                return false;
            }
            t.width += c.width;
            t.height = Math.max(t.height, c.height);
        } else {
            if (t.height + c.height > p.height) {
                return false;
            }
            t.width = Math.max(t.width, c.width);
            t.height += c.height;
        }
        return true;
    }

    private void checkLayout(Container parent) {
        if (parent.getLayout() != this) {
            throw new IllegalArgumentException("wrong parent for AlignLayout");
        }
    }

    public class Status {
        public int top;
        public int last;
        public int total;

        private Status(int top, int last, int total) {
            this.total = total;
            this.top = top;
            this.last = last;
        }

        public String toString() {
            return this.getClass().getName() + "[top=" + this.top + ",last=" + this.last + ",total=" + this.total + "]";
        }
    }
}

