/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.cookie.CookieManager;
import net.hizlab.kagetaka.history.HistoryManager;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.theme.ThemeManager;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

/**
 * ӥ塼ѤΥץɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
public class ViewerOption
	extends Option
	implements Cloneable
{
	private static ExProperties defaultProperties = new ExProperties();
	private static String       defaultOptionPath =
		System.getProperty("user.home") + File.separator + ".kagetaka/options";
	
	private static final String DEFAULT_HISTORY_PATH     = "history.dat";
	private static final String DEFAULT_BOOKMARKS_PATH   = "bookmarks.html";
	private static final String DEFAULT_COOKIE_PATH      = "cookies.txt";
	private static final String DEFAULT_USER_THEMES_PATH = "themes";
	private static final String DEFAULT_IE_PATH          = "\"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\"";
	private static final String DEFAULT_MOZILLA_PATH     = "/usr/bin/mozilla";
	
	// ɸ४ץ
	private static final String KEY_PARSER_INPUT                = "parser.input";
	private static final String KEY_PARSER_FILTERS              = "parser.filters";
	private static final String KEY_FONT_DEFAULT                = "font.default";
	private static final String KEY_FONT_FIXED                  = "font.fixed";
	private static final String KEY_FONT_PIXEL                  = "font.pixel";
	private static final String KEY_CHARS_SPIN_RIGHT            = "chars.spin.right";
	private static final String KEY_CHARS_SPIN_LTRB             = "chars.spin.ltrb";
	private static final String KEY_CHARS_KINSOKU_HEAD          = "chars.kinsoku.head";
	private static final String KEY_CHARS_KINSOKU_TAIL          = "chars.kinsoku.tail";
	private static final String KEY_LOAD_IMAGE                  = "load.image";
	private static final String KEY_SHOW_SCROLLBAR              = "show.scrollbar";
	private static final String KEY_SPIN_IMAGE_GIF              = "spin.image.gif" ;
	private static final String KEY_SPIN_IMAGE_GIF_ASPECTRATIO  = "spin.image.gif.aspectratio";
	private static final String KEY_SPIN_IMAGE_GIF_MINWIDTH     = "spin.image.gif.minwidth";
	private static final String KEY_SPIN_IMAGE_JPEG             = "spin.image.jpeg" ;
	private static final String KEY_SPIN_IMAGE_JPEG_ASPECTRATIO = "spin.image.jpeg.aspectratio";
	private static final String KEY_SPIN_IMAGE_JPEG_MINWIDTH    = "spin.image.jpeg.minwidth";
	private static final String KEY_STYLE_DECORATION_SWAP       = "style.decoration.swap";
	static {
		Option option = new Option();
		defaultProperties.put(KEY_PARSER_INPUT               , option.getInputStreamParser  ());
		defaultProperties.put(KEY_PARSER_FILTERS             , option.getFilterParsers      ());
		defaultProperties.put(KEY_FONT_DEFAULT               , option.getDefaultFont        ());
		defaultProperties.put(KEY_FONT_FIXED                 , option.getDefaultFixedFont   ());
		defaultProperties.put(KEY_FONT_PIXEL                 , option.getFontPerPixel       ());
		defaultProperties.put(KEY_CHARS_SPIN_RIGHT           , option.getCharsSpinRight     ());
		defaultProperties.put(KEY_CHARS_SPIN_LTRB            , option.getCharsSpinLtrb      ());
		defaultProperties.put(KEY_CHARS_KINSOKU_HEAD         , option.getCharsKinsokuHead   ());
		defaultProperties.put(KEY_CHARS_KINSOKU_TAIL         , option.getCharsKinsokuTail   ());
		defaultProperties.put(KEY_LOAD_IMAGE                 , option.getLoadImage          ());
		defaultProperties.put(KEY_SHOW_SCROLLBAR             , option.getShowScrollbar      ());
		defaultProperties.put(KEY_SPIN_IMAGE_GIF             , true                           );
		defaultProperties.put(KEY_SPIN_IMAGE_GIF_ASPECTRATIO , option.getSpinGifAspectRatio ());
		defaultProperties.put(KEY_SPIN_IMAGE_GIF_MINWIDTH    , option.getSpinGifMinWidth    ());
		defaultProperties.put(KEY_SPIN_IMAGE_JPEG            , true                           );
		defaultProperties.put(KEY_SPIN_IMAGE_JPEG_ASPECTRATIO, option.getSpinJpegAspectRatio());
		defaultProperties.put(KEY_SPIN_IMAGE_JPEG_MINWIDTH   , option.getSpinJpegMinWidth   ());
		defaultProperties.put(KEY_STYLE_DECORATION_SWAP      , option.getSwapDecoration     ());
	}
	
	// ĥץ
	private static final String KEY_URL_HOME             = "url.home";
	private static final String KEY_LOG_LEVEL            = "log.level";
	private static final String KEY_WINDOW_POSITION      = "window.position";
	private static final String KEY_WINDOW_SIZE          = "window.size";
	private static final String KEY_SCREEN_RESOLUTION    = "screen.resolution";
	private static final String KEY_HTTP_STRICT          = "http.strict";
	private static final String KEY_SHOW_NAVIBAR         = "show.navibar";
	private static final String KEY_SHOW_NAVIBAR_BUTTONS = "show.navibar.buttons";
	private static final String KEY_SHOW_SEARCHBAR       = "show.searchbar";
	private static final String KEY_SHOW_LINKBAR         = "show.linkbar";
	private static final String KEY_SHOW_LINKBAR_BUTTONS = "show.linkbar.buttons";
	private static final String KEY_SHOW_STATUSBAR       = "show.statusbar";
	private static final String KEY_PROXY_USE            = "proxy.use";
	private static final String KEY_PROXY_HTTP_HOST      = "proxy.http.host";
	private static final String KEY_PROXY_HTTP_PORT      = "proxy.http.port";
	private static final String KEY_PROXY_HTTP_NONE      = "proxy.http.none";
	private static final String KEY_PROXY_FTP_HOST       = "proxy.ftp.host";
	private static final String KEY_PROXY_FTP_PORT       = "proxy.ftp.port";
	private static final String KEY_PROXY_FTP_NONE       = "proxy.ftp.none";
	private static final String KEY_PROXY_SOCKS_HOST     = "proxy.socks.host";
	private static final String KEY_PROXY_SOCKS_PORT     = "proxy.socks.port";
	static {
		defaultProperties.put(KEY_URL_HOME            , Resource.getMessage("kagetaka.homepage", null));
		defaultProperties.put(KEY_LOG_LEVEL           , Reporter.ERROR         );
		defaultProperties.put(KEY_WINDOW_SIZE         , new Dimension(640, 480));
		defaultProperties.put(KEY_SCREEN_RESOLUTION   , Toolkit.getDefaultToolkit().getScreenResolution());
		defaultProperties.put(KEY_HTTP_STRICT         , false                  );
		defaultProperties.put(KEY_SHOW_NAVIBAR        , true                   );
		defaultProperties.put(KEY_SHOW_NAVIBAR_BUTTONS, new String[]{ViewerToolbar.BACK   ,
		                                                             ViewerToolbar.FORWARD,
		                                                             ViewerToolbar.RELOAD ,
		                                                             ViewerToolbar.STOP   ,
		                                                             ViewerToolbar.ADDRESS,
		                                                             ViewerToolbar.GO     });
		defaultProperties.put(KEY_SHOW_SEARCHBAR      , true                   );
		defaultProperties.put(KEY_SHOW_LINKBAR        , true                   );
		defaultProperties.put(KEY_SHOW_LINKBAR_BUTTONS, new String[]{ViewerToolbar.HOME    ,
		                                                             ViewerToolbar.BOOKMARK,
		                                                             ViewerToolbar.PTF     });
		defaultProperties.put(KEY_SHOW_STATUSBAR      , true                   );
		defaultProperties.put(KEY_PROXY_USE           , false                  );
		defaultProperties.put(KEY_PROXY_HTTP_HOST     , System.getProperty("http.proxyHost"    ));
		defaultProperties.put(KEY_PROXY_HTTP_PORT     , System.getProperty("http.proxyPort"    ));
		defaultProperties.put(KEY_PROXY_HTTP_NONE     , System.getProperty("http.nonProxyHosts"));
		defaultProperties.put(KEY_PROXY_FTP_HOST      , System.getProperty("ftp.proxyHost"     ));
		defaultProperties.put(KEY_PROXY_FTP_PORT      , System.getProperty("ftp.proxyPort"     ));
		defaultProperties.put(KEY_PROXY_FTP_NONE      , System.getProperty("ftp.nonProxyHosts" ));
		defaultProperties.put(KEY_PROXY_SOCKS_HOST    , System.getProperty("socksProxyHost"    ));
		defaultProperties.put(KEY_PROXY_SOCKS_PORT    , System.getProperty("socksProxyPort"    ));
	}
	
	// ץꥱ
	private static final String KEY_APP_LIST     = "app.list";
	private static final String KEY_APP_NAME  [] = {"app.", ".name"  };
	private static final String KEY_APP_PATH  [] = {"app.", ".path"  };
	private static final String KEY_APP_OPTION[] = {"app.", ".option"};
	private static final String KEY_APP_ONLINE[] = {"app.", ".online"};
	static {
		if (Environment.isWindows)
			defaultProperties.put(KEY_APP_LIST, "ie");
		else
			defaultProperties.put(KEY_APP_LIST, "mozilla");
		defaultProperties.put(KEY_APP_NAME  [0] + "ie" + KEY_APP_NAME  [1], "Internet Explorer");
		defaultProperties.put(KEY_APP_PATH  [0] + "ie" + KEY_APP_PATH  [1], DEFAULT_IE_PATH    );
		defaultProperties.put(KEY_APP_OPTION[0] + "ie" + KEY_APP_OPTION[1], ""                 );
		defaultProperties.put(KEY_APP_ONLINE[0] + "ie" + KEY_APP_ONLINE[1], true               );
		defaultProperties.put(KEY_APP_NAME  [0] + "mozilla" + KEY_APP_NAME  [1], "Mozilla"           );
		defaultProperties.put(KEY_APP_PATH  [0] + "mozilla" + KEY_APP_PATH  [1], DEFAULT_MOZILLA_PATH);
		defaultProperties.put(KEY_APP_OPTION[0] + "mozilla" + KEY_APP_OPTION[1], ""                  );
		defaultProperties.put(KEY_APP_ONLINE[0] + "mozilla" + KEY_APP_ONLINE[1], true                );
	}
	
	// 
	private static final String KEY_HISTORY_PATH              = "history.path";
	private static final String KEY_HISTORY_SAVE_NUM          = "history.save.num";
	private static final String KEY_HISTORY_WINDOW_POSITION   = "history.window.position";
	private static final String KEY_HISTORY_WINDOW_SIZE       = "history.window.size";
	static {
		defaultProperties.put(KEY_HISTORY_PATH       , DEFAULT_HISTORY_PATH   );
		defaultProperties.put(KEY_HISTORY_SAVE_NUM   , 500                    );
		defaultProperties.put(KEY_HISTORY_WINDOW_SIZE, new Dimension(360, 300));
	}
	
	// ֥åޡ
	private static final String KEY_BOOKMARKS_PATH            = "bookmarks.path";
	private static final String KEY_BOOKMARKS_WINDOW_POSITION = "bookmarks.window.position";
	private static final String KEY_BOOKMARKS_WINDOW_SIZE     = "bookmarks.window.size";
	static {
		defaultProperties.put(KEY_BOOKMARKS_PATH       , DEFAULT_BOOKMARKS_PATH );
		defaultProperties.put(KEY_BOOKMARKS_WINDOW_SIZE, new Dimension(380, 250));
	}
	
	// å
	private static final String KEY_COOKIE_PATH              = "cookie.path";
	private static final String KEY_COOKIE_ACCEPT_STRICT     = "cookie.accept.strict";
	private static final String KEY_COOKIE_ACCEPT_SESSION    = "cookie.accept.session";
	private static final String KEY_COOKIE_ACCEPT_STRAGE     = "cookie.accept.strage";
	private static final String KEY_COOKIE_WINDOW_POSITION   = "cookie.window.position";
	private static final String KEY_COOKIE_WINDOW_SIZE       = "cookie.window.size";
	static {
		defaultProperties.put(KEY_COOKIE_PATH          , DEFAULT_COOKIE_PATH    );
		defaultProperties.put(KEY_COOKIE_ACCEPT_STRICT , false                  );
		defaultProperties.put(KEY_COOKIE_ACCEPT_SESSION, CookieManager.YES      );
		defaultProperties.put(KEY_COOKIE_ACCEPT_STRAGE , CookieManager.YES      );
		defaultProperties.put(KEY_COOKIE_WINDOW_SIZE   , new Dimension(360, 300));
	}
	
	// 
	private static final String KEY_DOWNLOAD_WINDOW_POSITION  = "download.window.position";
	private static final String KEY_DOWNLOAD_WINDOW_CLOSE     = "download.window.close";
	private static final String KEY_DOWNLOAD_SAVE_PATH        = "download.save.path";
	static {
		defaultProperties.put(KEY_DOWNLOAD_WINDOW_CLOSE, true);
	}
	
	// ơ
	private static final String KEY_USER_THEMES_PATH          = "theme.user.path";
	private static final String KEY_SYSTEM_THEMES_PATH        = "theme.system.path";
	private static final String KEY_THEME_KEY                 = "theme.key";
	static {
		defaultProperties.put(KEY_USER_THEMES_PATH, DEFAULT_USER_THEMES_PATH);
		defaultProperties.put(KEY_THEME_KEY       , "system"                );
	}
	
	/** @serial ץեΥѥ */
	private String  optionPath;
	/** @serial ץѥƥ */
	private ExProperties p;
	
	/** @serial ץꥱ */
	private Application[]   applications;
	
	/** @serial ۡ */
	private String          homeUrl;
	/** @serial ٥ */
	private int             logLevel;
	/** @serial ɥΰ */
	private Point           windowPosition;
	/** @serial ɥ礭 */
	private Dimension       windowSize;
	/** @serial 1 Υɥåȿ */
	private int             screenResolution;
	/** @serial HTTP β */
	private boolean         httpStrict;
	/** @serial ʥӥС */
	private boolean         showNavibar;
	/** @serial ʥӥСܥ */
	private String[]        showNavibarButtons;
	/** @serial С */
	private boolean         showSearchbar;
	/** @serial 󥯥С */
	private boolean         showLinkbar;
	/** @serial 󥯥Сܥ */
	private String[]        showLinkbarButtons;
	/** @serial ơС */
	private boolean         showStatusbar;
	
	/** @serial ץ */
	private boolean         proxyUse;
	/** @serial HTTP ץΥۥ */
	private String          proxyHttpHost;
	/** @serial HTTP ץΥۥ */
	private int             proxyHttpPort;
	/** @serial HTTP ץν */
	private String          proxyHttpNone;
	/** @serial FTP ץΥۥ */
	private String          proxyFtpHost;
	/** @serial FTP ץΥۥ */
	private int             proxyFtpPort;
	/** @serial FTP ץν */
	private String          proxyFtpNone;
	/** @serial SOCKS ץΥۥ */
	private String          proxySocksHost;
	/** @serial SOCKS ץΥۥ */
	private int             proxySocksPort;
	
	/** @serial ޥ͡ */
	private HistoryManager  historyManager;
	/** @serial Υѥ */
	private File            historyPath;
	/** @serial ¸ */
	private int             historySaveNum;
	/** @serial ޥ͡㥦ɥΰ */
	private Point           historyWindowPosition;
	/** @serial ޥ͡㥦ɥ礭 */
	private Dimension       historyWindowSize;
	
	/** @serial ֥åޡޥ͡ */
	private BookmarkManager bookmarkManager;
	/** @serial ֥åޡΥѥ */
	private File            bookmarksPath;
	/** @serial ֥åޡޥ͡㥦ɥΰ */
	private Point           bookmarksWindowPosition;
	/** @serial ֥åޡޥ͡㥦ɥ礭 */
	private Dimension       bookmarksWindowSize;
	
	/** @serial åޥ͡ */
	private CookieManager   cookieManager;
	/** @serial åΥѥ */
	private File            cookiePath;
	/** @serial ΤʥåΤ߼ */
	private boolean         cookieAcceptStrict;
	/** @serial å󥯥åư */
	private String          cookieAcceptSession;
	/** @serial ¸åư */
	private String          cookieAcceptStrage;
	/** @serial åޥ͡㥦ɥΰ */
	private Point           cookieWindowPosition;
	/** @serial åޥ͡㥦ɥ礭 */
	private Dimension       cookieWindowSize;
	
	/** @serial ɥɥΰ */
	private Point           downloadWindowPosition;
	/** @serial ɽλ˥ɥĤ뤫 */
	private boolean         downloadWindowClose;
	/** @serial ɤ¸ѥ */
	private String          downloadSavePath;
	
	/** @serial ơޥޥ͡ */
	private ThemeManager    themeManager;
	/** @serial 桼ơޤΥѥ */
	private File            userThemesPath;
	/** @serial ƥơޤΥѥ */
	private File            systemThemesPath;
	/** @serial ơޤΥ */
	private String          themeKey;
	
	/** @serial 륳󥽡 */
	private ViewerConsole   viewerConsole;
	
	/**
	 * ǥեȤΥץե򸵤ˡץޤ
	 * <p>
	 * ǥեȤΥץեΰ֤ϡ
	 * 桼Υۡǥ쥯ȥ <code>.kagetaka</code> Ȥǥ쥯ȥ
	 * <code>options</code> Ȥեˤʤޤ
	 */
	public ViewerOption()
	{
		this(defaultOptionPath);
	}
	
	/**
	 * ץޤ
	 * 
	 * @param     path ѥ
	 */
	public ViewerOption(String path)
	{
		p = new ExProperties(defaultProperties);
		load(path);
	}
	
	/**
	 * ޤ
	 * 
	 * @return    줿
	 */
	public Object clone()
	{
		try {
			return super.clone();
		} catch (CloneNotSupportedException e) {}
		
		return null;
	}
	
//### 
	/** ե뤫 */
	private void load(String path)
	{
		optionPath = path;
		
		try {
			p.load(path);
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
			//### ERROR
System.out.println(e);
e.printStackTrace(System.out);
		}
		
		// ɸ४ץ
		setInputStreamParser  (p.getPropertyString  (KEY_PARSER_INPUT               ));
		setFilterParsers      (p.getPropertyStrings (KEY_PARSER_FILTERS             ));
		setDefaultFont        (p.getPropertyFont    (KEY_FONT_DEFAULT               ));
		setDefaultFixedFont   (p.getPropertyFont    (KEY_FONT_FIXED                 ));
		setFontPerPixel       (p.getPropertyDouble  (KEY_FONT_PIXEL                 ));
		setCharsSpinRight     (p.getPropertyCharList(KEY_CHARS_SPIN_RIGHT           ));
		setCharsSpinLtrb      (p.getPropertyCharList(KEY_CHARS_SPIN_LTRB            ));
		setCharsKinsokuHead   (p.getPropertyCharList(KEY_CHARS_KINSOKU_HEAD         ));
		setCharsKinsokuTail   (p.getPropertyCharList(KEY_CHARS_KINSOKU_TAIL         ));
		setLoadImage          (p.getPropertyBoolean (KEY_LOAD_IMAGE                 ));
		setShowScrollbar      (p.getPropertyBoolean (KEY_SHOW_SCROLLBAR             ));
		setSpinGifImage       (p.getPropertyBoolean (KEY_SPIN_IMAGE_GIF             ));
		setSpinGifAspectRatio (p.getPropertyDouble  (KEY_SPIN_IMAGE_GIF_ASPECTRATIO ));
		setSpinGifMinWidth    (p.getPropertyInt     (KEY_SPIN_IMAGE_GIF_MINWIDTH    ));
		setSpinJpegImage      (p.getPropertyBoolean (KEY_SPIN_IMAGE_JPEG            ));
		setSpinJpegAspectRatio(p.getPropertyDouble  (KEY_SPIN_IMAGE_JPEG_ASPECTRATIO));
		setSpinJpegMinWidth   (p.getPropertyInt     (KEY_SPIN_IMAGE_JPEG_MINWIDTH   ));
		setSwapDecoration     (p.getPropertyBoolean (KEY_STYLE_DECORATION_SWAP      ));
		
		// ĥץ
		setHomeURL           (p.getPropertyString   (KEY_URL_HOME            ));
		setLogLevel          (p.getPropertyInt      (KEY_LOG_LEVEL           ));
		setWindowPosition    (p.getPropertyPoint    (KEY_WINDOW_POSITION     ));
		setWindowSize        (p.getPropertyDimension(KEY_WINDOW_SIZE         ));
		setScreenResolution  (p.getPropertyInt      (KEY_SCREEN_RESOLUTION   ));
		setHttpStrict        (p.getPropertyBoolean  (KEY_HTTP_STRICT         ));
		setShowNavibar       (p.getPropertyBoolean  (KEY_SHOW_NAVIBAR        ));
		setShowNavibarButtons(p.getPropertyStrings  (KEY_SHOW_NAVIBAR_BUTTONS));
		setShowSearchbar     (p.getPropertyBoolean  (KEY_SHOW_SEARCHBAR      ));
		setShowLinkbar       (p.getPropertyBoolean  (KEY_SHOW_LINKBAR        ));
		setShowLinkbarButtons(p.getPropertyStrings  (KEY_SHOW_LINKBAR_BUTTONS));
		setShowStatusbar     (p.getPropertyBoolean  (KEY_SHOW_STATUSBAR      ));
		setProxyUse          (p.getPropertyBoolean  (KEY_PROXY_USE           ));
		setProxyHttpHost     (p.getPropertyString   (KEY_PROXY_HTTP_HOST     ));
		setProxyHttpPort     (p.getPropertyInt      (KEY_PROXY_HTTP_PORT     ));
		setProxyHttpNone     (p.getPropertyString   (KEY_PROXY_HTTP_NONE     ));
		setProxyFtpHost      (p.getPropertyString   (KEY_PROXY_FTP_HOST      ));
		setProxyFtpPort      (p.getPropertyInt      (KEY_PROXY_FTP_PORT      ));
		setProxyFtpNone      (p.getPropertyString   (KEY_PROXY_FTP_NONE      ));
		setProxySocksHost    (p.getPropertyString   (KEY_PROXY_SOCKS_HOST    ));
		setProxySocksPort    (p.getPropertyInt      (KEY_PROXY_SOCKS_PORT    ));
		
		loadApplications(p);
		
		// 
		setHistoryPath            (p.getPropertyFile     (KEY_HISTORY_PATH             ));
		setHistorySaveNum         (p.getPropertyInt      (KEY_HISTORY_SAVE_NUM         ));
		setHistoryWindowPosition  (p.getPropertyPoint    (KEY_HISTORY_WINDOW_POSITION  ));
		setHistoryWindowSize      (p.getPropertyDimension(KEY_HISTORY_WINDOW_SIZE      ));
		
		// ֥åޡ
		setBookmarksPath          (p.getPropertyFile     (KEY_BOOKMARKS_PATH           ));
		setBookmarksWindowPosition(p.getPropertyPoint    (KEY_BOOKMARKS_WINDOW_POSITION));
		setBookmarksWindowSize    (p.getPropertyDimension(KEY_BOOKMARKS_WINDOW_SIZE    ));
		
		// å
		setCookiePath             (p.getPropertyFile     (KEY_COOKIE_PATH              ));
		setCookieAcceptStrict     (p.getPropertyBoolean  (KEY_COOKIE_ACCEPT_STRICT     ));
		setCookieAcceptSession    (p.getPropertyString   (KEY_COOKIE_ACCEPT_SESSION    ));
		setCookieAcceptStrage     (p.getPropertyString   (KEY_COOKIE_ACCEPT_STRAGE     ));
		setCookieWindowPosition   (p.getPropertyPoint    (KEY_COOKIE_WINDOW_POSITION   ));
		setCookieWindowSize       (p.getPropertyDimension(KEY_COOKIE_WINDOW_SIZE       ));
		
		// 
		setDownloadWindowPosition (p.getPropertyPoint    (KEY_DOWNLOAD_WINDOW_POSITION ));
		setDownloadWindowClose    (p.getPropertyBoolean  (KEY_DOWNLOAD_WINDOW_CLOSE    ));
		setDownloadSavePath       (p.getPropertyString   (KEY_DOWNLOAD_SAVE_PATH       ));
		
		// ơ
		setUserThemesPath         (p.getPropertyFile     (KEY_USER_THEMES_PATH         ));
		setSystemThemesPath       (p.getPropertyFile     (KEY_SYSTEM_THEMES_PATH       ));
		setThemeKey               (p.getPropertyString   (KEY_THEME_KEY                ));
		
		historyManager  = new HistoryManager (this);
		bookmarkManager = new BookmarkManager(this);
		cookieManager   = new CookieManager  (this);
		themeManager    = new ThemeManager   (this);
		viewerConsole   = new ViewerConsole  (this);
	}
	
	/** ץꥱɤޤ */
	private void loadApplications(ExProperties p)
	{
		Vector   v    = new Vector();
		String[] list = p.getPropertyStrings(KEY_APP_LIST);
		if (list != null) {
			for (int i = 0; i < list.length; i++) {
				String  id     = list[i];
				String  name   = p.getPropertyString (KEY_APP_NAME  [0] + id + KEY_APP_NAME  [1]);
				String  path   = p.getPropertyString (KEY_APP_PATH  [0] + id + KEY_APP_PATH  [1]);
				String  option = p.getPropertyString (KEY_APP_OPTION[0] + id + KEY_APP_OPTION[1]);
				boolean online = p.getPropertyBoolean(KEY_APP_ONLINE[0] + id + KEY_APP_ONLINE[1]);
				if (name == null || name.length() == 0 ||
				    path == null || path.length() == 0)
					continue;
				
				v.addElement(new Application(id, name, path, option, online));
			}
		}
		
		applications = new Application[v.size()];
		v.copyInto(applications);
	}
	
//### 
	/**
	 * ץɤ߹ե¸ޤ
	 */
	public void save()
	{
		save(optionPath);
	}
	
	/**
	 * ե¸ޤ
	 * 
	 * @param     path ¸եΥѥ
	 */
	public void save(String path)
	{
		// ɸ४ץ
		p.put(KEY_PARSER_INPUT               , getInputStreamParser  ());
		p.put(KEY_PARSER_FILTERS             , getFilterParsers      ());
		p.put(KEY_FONT_DEFAULT               , getDefaultFont        ());
		p.put(KEY_FONT_FIXED                 , getDefaultFixedFont   ());
		p.put(KEY_FONT_PIXEL                 , getFontPerPixel       ());
		p.put(KEY_CHARS_SPIN_RIGHT           , getCharsSpinRight     ());
		p.put(KEY_CHARS_SPIN_LTRB            , getCharsSpinLtrb      ());
		p.put(KEY_CHARS_KINSOKU_HEAD         , getCharsKinsokuHead   ());
		p.put(KEY_CHARS_KINSOKU_TAIL         , getCharsKinsokuTail   ());
		p.put(KEY_LOAD_IMAGE                 , getLoadImage          ());
		p.put(KEY_SHOW_SCROLLBAR             , getShowScrollbar      ());
		p.put(KEY_SPIN_IMAGE_GIF             , getSpinGifImage       ());
		p.put(KEY_SPIN_IMAGE_GIF_ASPECTRATIO , getSpinGifAspectRatio ());
		p.put(KEY_SPIN_IMAGE_GIF_MINWIDTH    , getSpinGifMinWidth    ());
		p.put(KEY_SPIN_IMAGE_JPEG            , getSpinJpegImage      ());
		p.put(KEY_SPIN_IMAGE_JPEG_ASPECTRATIO, getSpinJpegAspectRatio());
		p.put(KEY_SPIN_IMAGE_JPEG_MINWIDTH   , getSpinJpegMinWidth   ());
		p.put(KEY_STYLE_DECORATION_SWAP      , getSwapDecoration     ());
		
		// ĥץ
		p.put(KEY_URL_HOME            , getHomeURL           ());
		p.put(KEY_LOG_LEVEL           , getLogLevel          ());
		p.put(KEY_WINDOW_POSITION     , getWindowPosition    ());
		p.put(KEY_WINDOW_SIZE         , getWindowSize        ());
		p.put(KEY_SCREEN_RESOLUTION   , getScreenResolution  ());
		p.put(KEY_HTTP_STRICT         , getHttpStrict        ());
		p.put(KEY_SHOW_NAVIBAR        , getShowNavibar       ());
		p.put(KEY_SHOW_NAVIBAR_BUTTONS, getShowNavibarButtons());
		p.put(KEY_SHOW_SEARCHBAR      , getShowSearchbar     ());
		p.put(KEY_SHOW_LINKBAR        , getShowLinkbar       ());
		p.put(KEY_SHOW_LINKBAR_BUTTONS, getShowLinkbarButtons());
		p.put(KEY_SHOW_STATUSBAR      , getShowStatusbar     ());
		p.put(KEY_PROXY_USE           , getProxyUse          ());
		p.put(KEY_PROXY_HTTP_HOST     , getProxyHttpHost     ());
		p.put(KEY_PROXY_HTTP_PORT     , getProxyHttpPort     ());
		p.put(KEY_PROXY_HTTP_NONE     , getProxyHttpNone     ());
		p.put(KEY_PROXY_FTP_HOST      , getProxyFtpHost      ());
		p.put(KEY_PROXY_FTP_PORT      , getProxyFtpPort      ());
		p.put(KEY_PROXY_FTP_NONE      , getProxyFtpNone      ());
		p.put(KEY_PROXY_SOCKS_HOST    , getProxySocksHost    ());
		p.put(KEY_PROXY_SOCKS_PORT    , getProxySocksPort    ());
		
		saveApplications(p);
		
		// 
		p.put(KEY_HISTORY_PATH             , getHistoryPath            ());
		p.put(KEY_HISTORY_SAVE_NUM         , getHistorySaveNum         ());
		p.put(KEY_HISTORY_WINDOW_POSITION  , getHistoryWindowPosition  ());
		p.put(KEY_HISTORY_WINDOW_SIZE      , getHistoryWindowSize      ());
		
		// ֥åޡ
		p.put(KEY_BOOKMARKS_PATH           , getBookmarksPath          ());
		p.put(KEY_BOOKMARKS_WINDOW_POSITION, getBookmarksWindowPosition());
		p.put(KEY_BOOKMARKS_WINDOW_SIZE    , getBookmarksWindowSize    ());
		
		// å
		p.put(KEY_COOKIE_PATH              , getCookiePath             ());
		p.put(KEY_COOKIE_ACCEPT_STRICT     , getCookieAcceptStrict     ());
		p.put(KEY_COOKIE_ACCEPT_SESSION    , getCookieAcceptSession    ());
		p.put(KEY_COOKIE_ACCEPT_STRAGE     , getCookieAcceptStrage     ());
		p.put(KEY_COOKIE_WINDOW_POSITION   , getCookieWindowPosition   ());
		p.put(KEY_COOKIE_WINDOW_SIZE       , getCookieWindowSize       ());
		
		// 
		p.put(KEY_DOWNLOAD_WINDOW_POSITION , getDownloadWindowPosition ());
		p.put(KEY_DOWNLOAD_WINDOW_CLOSE    , getDownloadWindowClose    ());
		p.put(KEY_DOWNLOAD_SAVE_PATH       , getDownloadSavePath       ());
		
		// ơ
		p.put(KEY_USER_THEMES_PATH         , getUserThemesPath         ());
		p.put(KEY_SYSTEM_THEMES_PATH       , getSystemThemesPath       ());
		p.put(KEY_THEME_KEY                , getThemeKey               ());
		
		try {
			p.save(path, "Kagetaka Option");
		} catch (IOException e) {
			//### ERROR
System.out.println(e);
e.printStackTrace(System.out);
		}
		
		historyManager .save();
		bookmarkManager.save();
		cookieManager  .save();
	}
	
	/** ץꥱ򥻡֤ޤ */
	private void saveApplications(ExProperties p)
	{
		if (applications == null)
			return;
		
		StringBuffer sb = new StringBuffer();
		
		for (int i = 0; i < applications.length; i++) {
			Application application = applications[i];
			String id = application.getId();
			sb.append(id);
			sb.append(", ");
			
			p.put(KEY_SPIN_IMAGE_GIF , String.valueOf(getSpinGifImage ()));
			p.put(KEY_APP_NAME  [0] + id + KEY_APP_NAME  [1], application.getName  ());
			p.put(KEY_APP_PATH  [0] + id + KEY_APP_PATH  [1], application.getPath  ());
			p.put(KEY_APP_OPTION[0] + id + KEY_APP_OPTION[1], application.getOption());
			p.put(KEY_APP_ONLINE[0] + id + KEY_APP_ONLINE[1], String.valueOf(application.getOnline()));
		}
		
		if (sb.length() > 0)
			sb.setLength(sb.length() - 2);
		
		p.put(KEY_APP_LIST, sb.toString());
	}
	
//### ץѥƥ
	/**
	 * ץꥱ֤ޤ
	 * 
	 * @return    ץꥱ
	 */
	public Application[] getApplications()
	{
		return applications;
	}
	
	/**
	 * ֤ۡޤ
	 * 
	 * @return    ٥
	 */
	public String getHomeURL()
	{
		return homeUrl;
	}
	
	/**
	 * ۡꤷޤ
	 * 
	 * @param     url ۡ
	 */
	public void setHomeURL(String url)
	{
		homeUrl = url;
	}
	
	/**
	 * ٥֤ޤ
	 * 
	 * @return    ٥
	 */
	public int getLogLevel()
	{
		return logLevel;
	}
	
	/**
	 * ٥ꤷޤ
	 * 
	 * @param     level ٥
	 */
	public void setLogLevel(int level)
	{
		logLevel = level;
	}
	
	/**
	 * ɥΰ֤֤ޤ
	 * 
	 * @return    ɥΰ
	 */
	public Point getWindowPosition()
	{
		return windowPosition;
	}
	
	/**
	 * ɥΰ֤ꤷޤ
	 * 
	 * @param     position ɥΰ
	 */
	public void setWindowPosition(Point position)
	{
		windowPosition = position;
	}
	
	/**
	 * ɥΥ֤ޤ
	 * 
	 * @return    ɥΥ
	 */
	public Dimension getWindowSize()
	{
		return windowSize;
	}
	
	/**
	 * ɥΥꤷޤ
	 * 
	 * @param     size ɥΥ
	 */
	public void setWindowSize(Dimension size)
	{
		windowSize = size;
	}
	
	/**
	 * 1 Υɥåȿ֤ޤ
	 * 
	 * @return    1 Υɥåȿ
	 */
	public int getScreenResolution()
	{
		return screenResolution;
	}
	
	/**
	 * 1 Υɥåȿꤷޤ
	 * 
	 * @param     num 1 Υɥåȿ
	 */
	public void setScreenResolution(int num)
	{
		screenResolution = num;
		Environment.screenResolution = num;
	}
	
	/**
	 * HTTP ᤹뤫֤ޤ
	 * 
	 * @return    ᤹ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getHttpStrict()
	{
		return httpStrict;
	}
	
	/**
	 * HTTP ᤹뤫ꤷޤ
	 * 
	 * @param     b ᤹ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setHttpStrict(boolean b)
	{
		httpStrict = b;
	}
	
	/**
	 * ʥӥСɽɽ֤ޤ
	 * 
	 * @return    ɽ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getShowNavibar()
	{
		return showNavibar;
	}
	
	/**
	 * ʥӥСɽɽꤷޤ
	 * 
	 * @param     b ɽ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setShowNavibar(boolean b)
	{
		showNavibar = b;
	}
	
	/**
	 * ʥӥСɽܥ֤ޤ
	 * 
	 * @return    ɽܥ
	 */
	public String[] getShowNavibarButtons()
	{
		return showNavibarButtons;
	}
	
	/**
	 * ʥӥСɽܥꤷޤ
	 * 
	 * @param     buttons ɽܥ
	 */
	public void setShowNavibarButtons(String[] buttons)
	{
		showNavibarButtons = buttons;
	}
	
	/**
	 * Сɽɽ֤ޤ
	 * 
	 * @return    ɽ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getShowSearchbar()
	{
		return showSearchbar;
	}
	
	/**
	 * Сɽɽꤷޤ
	 * 
	 * @param     b ɽ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setShowSearchbar(boolean b)
	{
		showSearchbar = b;
	}
	
	/**
	 * 󥯥Сɽɽ֤ޤ
	 * 
	 * @return    ɽ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getShowLinkbar()
	{
		return showLinkbar;
	}
	
	/**
	 * 󥯥Сɽɽꤷޤ
	 * 
	 * @param     b ɽ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setShowLinkbar(boolean b)
	{
		showLinkbar = b;
	}
	
	/**
	 * 󥯥Сɽܥ֤ޤ
	 * 
	 * @return    ɽܥ
	 */
	public String[] getShowLinkbarButtons()
	{
		return showLinkbarButtons;
	}
	
	/**
	 * 󥯥Сɽܥꤷޤ
	 * 
	 * @param     buttons ɽܥ
	 */
	public void setShowLinkbarButtons(String[] buttons)
	{
		showLinkbarButtons = buttons;
	}
	
	/**
	 * ơСɽɽ֤ޤ
	 * 
	 * @return    ɽ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getShowStatusbar()
	{
		return showStatusbar;
	}
	
	/**
	 * ơСɽɽꤷޤ
	 * 
	 * @param     b ɽ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setShowStatusbar(boolean b)
	{
		showStatusbar = b;
	}
	
	/**
	 * ץѤ뤫ɤ֤ޤ
	 * 
	 * @return    ץѤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getProxyUse()
	{
		return proxyUse;
	}
	
	/**
	 * ץѤ뤫ɤꤷޤ
	 * 
	 * @param     b ץѤ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setProxyUse(boolean b)
	{
		proxyUse = b;
		if (proxyUse) {
			putSystemProperty("http.proxyHost", proxyHttpHost );
			putSystemProperty("ftp.proxyHost" , proxyFtpHost  );
			putSystemProperty("socksProxyHost", proxySocksHost);
		} else {
			putSystemProperty("http.proxyHost", null);
			putSystemProperty("ftp.proxyHost" , null);
			putSystemProperty("socksProxyHost", null);
		}
	}
	
	/**
	 * HTTP ץΥۥȤ֤ޤ
	 * 
	 * @return    HTTP ץΥۥ
	 */
	public String getProxyHttpHost()
	{
		return proxyHttpHost;
	}
	
	/**
	 * HTTP ץΥۥȤꤷޤ
	 * 
	 * @param     host HTTP ץΥۥ
	 */
	public void setProxyHttpHost(String host)
	{
		proxyHttpHost = host;
		if (proxyUse)
			putSystemProperty("http.proxyHost", host);
	}
	
	/**
	 * HTTP ץΥݡȤ֤ޤ
	 * 
	 * @return    HTTP ץΥݡ
	 */
	public int getProxyHttpPort()
	{
		return proxyHttpPort;
	}
	
	/**
	 * HTTP ץΥݡȤꤷޤ
	 * 
	 * @param     port HTTP ץΥݡ
	 */
	public void setProxyHttpPort(int port)
	{
		proxyHttpPort = port;
		if (proxyUse)
			putSystemProperty("http.proxyPort", String.valueOf(port));
	}
	
	/**
	 * HTTP ץѤʤ֤ޤ
	 * 
	 * @return    HTTP ץѤʤ
	 */
	public String getProxyHttpNone()
	{
		return proxyHttpNone;
	}
	
	/**
	 * HTTP ץѤʤꤷޤ
	 * 
	 * @param     none HTTP ץѤʤ
	 */
	public void setProxyHttpNone(String none)
	{
		proxyHttpNone = none;
		if (proxyUse)
			putSystemProperty("http.nonProxyHosts", none);
	}
	
	/**
	 * FTP ץΥۥȤ֤ޤ
	 * 
	 * @return    HTTP ץΥۥ
	 */
	public String getProxyFtpHost()
	{
		return proxyFtpHost;
	}
	
	/**
	 * FTP ץΥۥȤꤷޤ
	 * 
	 * @param     host FTP ץΥۥ
	 */
	public void setProxyFtpHost(String host)
	{
		proxyFtpHost = host;
		if (proxyUse)
			putSystemProperty("ftp.proxyHost", host);
	}
	
	/**
	 * FTP ץΥݡȤ֤ޤ
	 * 
	 * @return    FTP ץΥݡ
	 */
	public int getProxyFtpPort()
	{
		return proxyFtpPort;
	}
	
	/**
	 * FTP ץΥݡȤꤷޤ
	 * 
	 * @param     port FTP ץΥݡ
	 */
	public void setProxyFtpPort(int port)
	{
		proxyFtpPort = port;
		if (proxyUse)
			putSystemProperty("ftp.proxyPort", String.valueOf(port));
	}
	
	/**
	 * FTP ץѤʤ֤ޤ
	 * 
	 * @return    FTP ץѤʤ
	 */
	public String getProxyFtpNone()
	{
		return proxyFtpNone;
	}
	
	/**
	 * FTP ץѤʤꤷޤ
	 * 
	 * @param     none FTP ץѤʤ
	 */
	public void setProxyFtpNone(String none)
	{
		proxyFtpNone = none;
		if (proxyUse)
			putSystemProperty("ftp.nonProxyHosts", none);
	}
	
	/**
	 * SOCKS ץΥۥȤ֤ޤ
	 * 
	 * @return    SOCKS ץΥۥ
	 */
	public String getProxySocksHost()
	{
		return proxySocksHost;
	}
	
	/**
	 * SOCKS ץΥۥȤꤷޤ
	 * 
	 * @param     host SOCKS ץΥۥ
	 */
	public void setProxySocksHost(String host)
	{
		proxySocksHost = host;
		if (proxyUse)
			putSystemProperty("socksProxyHost", host);
	}
	
	/**
	 * SOCKS ץΥݡȤ֤ޤ
	 * 
	 * @return    SOCKS ץΥݡ
	 */
	public int getProxySocksPort()
	{
		return proxySocksPort;
	}
	
	/**
	 * SOCKS ץΥݡȤꤷޤ
	 * 
	 * @param     port SOCKS ץΥݡ
	 */
	public void setProxySocksPort(int port)
	{
		proxySocksPort = port;
		if (proxyUse)
			putSystemProperty("socksProxyPort", String.valueOf(port));
	}
	
//### 
	/**
	 * ޥ֤͡ޤ
	 * 
	 * @return    ޥ͡
	 */
	public HistoryManager getHistoryManager()
	{
		return historyManager;
	}
	
	/**
	 * Υѥ֤ޤ
	 * 
	 * @return    Υѥ
	 */
	public File getHistoryPath()
	{
		return historyPath;
	}
	
	/**
	 * Υѥꤷޤ
	 * 
	 * @param     path ѥ
	 */
	public void setHistoryPath(File path)
	{
		historyPath = path;
	}
	
	/**
	 * ¸֤ޤ
	 * 
	 * @return    ¸
	 */
	public int getHistorySaveNum()
	{
		return historySaveNum;
	}
	
	/**
	 * ¸ꤷޤ
	 * 
	 * @param     num ¸
	 */
	public void setHistorySaveNum(int num)
	{
		historySaveNum = num;
	}
	
	/**
	 * 򥦥ɥΰ֤֤ޤ
	 * 
	 * @return    ɥΰ
	 */
	public Point getHistoryWindowPosition()
	{
		return historyWindowPosition;
	}
	
	/**
	 * 򥦥ɥΰ֤ꤷޤ
	 * 
	 * @param     position ɥΰ
	 */
	public void setHistoryWindowPosition(Point position)
	{
		historyWindowPosition = position;
	}
	
	/**
	 * 򥦥ɥΥ֤ޤ
	 * 
	 * @return    ɥΥ
	 */
	public Dimension getHistoryWindowSize()
	{
		return historyWindowSize;
	}
	
	/**
	 * 򥦥ɥΥꤷޤ
	 * 
	 * @param     size ɥΥ
	 */
	public void setHistoryWindowSize(Dimension size)
	{
		historyWindowSize = size;
	}
	
//### ֥åޡ
	/**
	 * ֥åޡޥ֤͡ޤ
	 * 
	 * @return    ֥åޡޥ͡
	 */
	public BookmarkManager getBookmarkManager()
	{
		return bookmarkManager;
	}
	
	/**
	 * ֥åޡΥѥ֤ޤ
	 * 
	 * @return    ֥åޡΥѥ
	 */
	public File getBookmarksPath()
	{
		return bookmarksPath;
	}
	
	/**
	 * ֥åޡΥѥꤷޤ
	 * 
	 * @param     path ѥ
	 */
	public void setBookmarksPath(File path)
	{
		bookmarksPath = path;
	}
	
	/**
	 * ֥åޡɥΰ֤֤ޤ
	 * 
	 * @return    ɥΰ
	 */
	public Point getBookmarksWindowPosition()
	{
		return bookmarksWindowPosition;
	}
	
	/**
	 * ֥åޡɥΰ֤ꤷޤ
	 * 
	 * @param     position ɥΰ
	 */
	public void setBookmarksWindowPosition(Point position)
	{
		bookmarksWindowPosition = position;
	}
	
	/**
	 * ֥åޡɥΥ֤ޤ
	 * 
	 * @return    ɥΥ
	 */
	public Dimension getBookmarksWindowSize()
	{
		return bookmarksWindowSize;
	}
	
	/**
	 * ֥åޡɥΥꤷޤ
	 * 
	 * @param     size ɥΥ
	 */
	public void setBookmarksWindowSize(Dimension size)
	{
		bookmarksWindowSize = size;
	}
	
//### å
	/**
	 * åޥ֤͡ޤ
	 * 
	 * @return    åޥ͡
	 */
	public CookieManager getCookieManager()
	{
		return cookieManager;
	}
	
	/**
	 * åΥѥ֤ޤ
	 * 
	 * @return    åΥѥ
	 */
	public File getCookiePath()
	{
		return cookiePath;
	}
	
	/**
	 * åΥѥꤷޤ
	 * 
	 * @param     path ѥ
	 */
	public void setCookiePath(File path)
	{
		cookiePath = path;
	}
	
	/**
	 * ΤʥåΤ߼뤫֤ޤ
	 * 
	 * @return    ΤʥåΤ߼ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getCookieAcceptStrict()
	{
		return cookieAcceptStrict;
	}
	
	/**
	 * ΤʥåΤ߼뤫ꤷޤ
	 * 
	 * @param     b ΤʥåΤ߼ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setCookieAcceptStrict(boolean b)
	{
		cookieAcceptStrict = b;
	}
	
	/**
	 * å󥯥åäˤɤ뤫֤ޤ
	 * 
	 * @return    äȤư
	 */
	public String getCookieAcceptSession()
	{
		return cookieAcceptSession;
	}
	
	/**
	 * å󥯥åäˤɤ뤫ꤷޤ
	 * 
	 * @param     mode äȤư
	 */
	public void setCookieAcceptSession(String mode)
	{
		cookieAcceptSession = mode;
	}
	
	/**
	 * ¸åäˤɤ뤫֤ޤ
	 * 
	 * @return    äȤư
	 */
	public String getCookieAcceptStrage()
	{
		return cookieAcceptStrage;
	}
	
	/**
	 * ¸åäˤɤ뤫ꤷޤ
	 * 
	 * @param     mode äȤư
	 */
	public void setCookieAcceptStrage(String mode)
	{
		cookieAcceptStrage = mode;
	}
	
	/**
	 * åɥΰ֤֤ޤ
	 * 
	 * @return    ɥΰ
	 */
	public Point getCookieWindowPosition()
	{
		return cookieWindowPosition;
	}
	
	/**
	 * åɥΰ֤ꤷޤ
	 * 
	 * @param     position ɥΰ
	 */
	public void setCookieWindowPosition(Point position)
	{
		cookieWindowPosition = position;
	}
	
	/**
	 * åɥΥ֤ޤ
	 * 
	 * @return    ɥΥ
	 */
	public Dimension getCookieWindowSize()
	{
		return cookieWindowSize;
	}
	
	/**
	 * åɥΥꤷޤ
	 * 
	 * @param     size ɥΥ
	 */
	public void setCookieWindowSize(Dimension size)
	{
		cookieWindowSize = size;
	}
	
//### 
	/**
	 * ɥɥΰ֤֤ޤ
	 * 
	 * @return    ɥΰ
	 */
	public Point getDownloadWindowPosition()
	{
		return downloadWindowPosition;
	}
	
	/**
	 * ɥɥΰ֤ꤷޤ
	 * 
	 * @param     position ɥΰ
	 */
	public void setDownloadWindowPosition(Point position)
	{
		downloadWindowPosition = position;
	}
	
	/**
	 * ɽλ˥ɥĤ뤫֤ޤ
	 * 
	 * @return    ɴλ˥ɥĤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getDownloadWindowClose()
	{
		return downloadWindowClose;
	}
	
	/**
	 * ɽλ˥ɥĤ뤫ꤷޤ
	 * 
	 * @param     b ɴλ˥ɥĤ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setDownloadWindowClose(boolean b)
	{
		downloadWindowClose = b;
	}
	
	/**
	 * ɤ¸ѥ֤ޤ
	 * 
	 * @return    ɤ¸ѥ
	 */
	public String getDownloadSavePath()
	{
		return downloadSavePath;
	}
	
	/**
	 * ɤ¸ѥꤷޤ
	 * 
	 * @param     path ɤ¸ѥ
	 */
	public void setDownloadSavePath(String path)
	{
		downloadSavePath = path;
	}
	
//### ơ
	/**
	 * ơޥޥ֤͡ޤ
	 * 
	 * @return    ơޥޥ͡
	 */
	public ThemeManager getThemeManager()
	{
		return themeManager;
	}
	
	/**
	 * 桼ơޤΥѥ֤ޤ
	 * 
	 * @return    桼ơޤΥѥ
	 */
	public File getUserThemesPath()
	{
		return userThemesPath;
	}
	
	/**
	 * 桼ơޤΥѥꤷޤ
	 * 
	 * @param     path 桼ơޤΥѥ
	 */
	public void setUserThemesPath(File path)
	{
		userThemesPath = path;
	}
	
	/**
	 * ƥơޤΥѥ֤ޤ
	 * 
	 * @return    ƥơޤΥѥ
	 */
	public File getSystemThemesPath()
	{
		return systemThemesPath;
	}
	
	/**
	 * ƥơޤΥѥꤷޤ
	 * 
	 * @param     path ƥơޤΥѥ
	 */
	public void setSystemThemesPath(File path)
	{
		systemThemesPath = path;
	}
	
	/**
	 * ơޤΥ֤ޤ
	 * 
	 * @return    ơޤΥ
	 */
	public String getThemeKey()
	{
		return themeKey;
	}
	
	/**
	 * ơޤΥꤷޤ
	 * 
	 * @param     key ơޤΥ
	 */
	public void setThemeKey(String key)
	{
		themeKey = key;
	}
	
//### ¾
	/**
	 * 륳󥽡Υ󥹥󥹤֤ޤ
	 * 
	 * @return    륳󥽡
	 */
	public ViewerConsole getViewerConsole()
	{
		return viewerConsole;
	}
	
//### private
	/** ƥץѥƥ */
	private void putSystemProperty(String key, String value)
	{
		if (value != null)
			System.getProperties().put(key, value);
		else
			System.getProperties().remove(key);
	}
	
//### Applicaiton
	/**
	 * ץꥱɽ饹Ǥ
	 * 
	 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
	 * @version $Revision: 1.7 $
	 */
	public class Application
	{
		private String  id;
		private String  name;
		private String  path;
		private String  option;
		private boolean online;
		
		
		/**
		 * ץꥱޤ
		 * 
		 * @param     id ID
		 * @param     name ̾
		 * @param     path ѥ
		 * @param     option ץ
		 * @param     online 饤󥢥ץꥱξ <code>true</code>
		 *                   ʳξ <code>false</code>
		 */
		public Application(String id, String name, String path, String option, boolean online)
		{
			this.id     = id;
			this.name   = name;
			this.path   = path;
			this.option = option;
			this.online = online;
		}
		
		/**
		 * ץꥱ ID ֤ޤ
		 * 
		 * @return    ץꥱ ID
		 */
		public String getId()
		{
			return id;
		}
		
		/**
		 * ץꥱ֤̾ޤ
		 * 
		 * @return    ץꥱ̾
		 */
		public String getName()
		{
			return name;
		}
		
		/**
		 * ץꥱѥ֤ޤ
		 * 
		 * @return    ץꥱѥ
		 */
		public String getPath()
		{
			return path;
		}
		
		/**
		 * ץ֤ޤ
		 * 
		 * @return    ץ
		 */
		public String getOption()
		{
			return option;
		}
		
		/**
		 * ץϤѥʤɤץ֤ޤ
		 * 
		 * @param     path ѥ
		 * 
		 * @return    ѥʤɤץ
		 */
		public String getOption(String path)
		{
			if (option == null || option.length() == 0)
				return path;
			
			int p = option.indexOf("%s");
			if (p != -1)
				return option;
			
			return option.substring(0, p) + path + option.substring(p + 2);
		}
		
		/**
		 * 饤󥢥ץꥱ󤫤ɤ֤ޤ
		 * 
		 * @return    饤󥢥ץꥱξ <code>true</code>
		 *            ʳξ <code>false</code>
		 */
		public boolean getOnline()
		{
			return online;
		}
		
		/**
		 * ꤷ URL 򥢥ץꥱǳޤ
		 * 
		 * @param     url   URL
		 * @param     path ¹Ԥ륳ޥɥ饤Ǽޤ
		 *                 Ǽɬפʤ <code>null</code>
		 */
		public void exec(final URL url, final StringBuffer path)
			throws IOException
		{
			//### TODO Online ǤϤʤб
			String option  = getOption(url.toString());
			String command = this.path + " " + option;
			
			if (path != null)
				path.append(command);
			
			Runtime.getRuntime().exec(command);
		}
	}
}
