/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.Tree;

import java.awt.Frame;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

/**
 * ץꤹ뤿ΥǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class OptionDialog
	extends DialogBox
{
	private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
	private static final int    MARGIN   = 3;
	
	/**  ܥ */
	public static final int RESULT_OPEN = RESULT_OK;
	
	/** @serial ӥ塼ץ */
	private ViewerOption option;
	
	/** @serial ƥ */
	private Tree       tree;
	/** @serial ᥤѥͥ */
	private Panel      main;
	/** @serial ᥤѥͥ쥤ȥޥ͡ */
	private CardLayout mainLayout;
	
	/**
	 * ץܥåɽη̤֤ޤ
	 * 
	 * @param     owner ʡ
	 * @param     option ץ
	 * 
	 * @return    OK 򲡤줿 <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static boolean show(Frame owner, ViewerOption option)
	{
		OptionDialog dialog = new OptionDialog(owner, option);
		
		dialog.show();
		
		return (dialog.getResult() == RESULT_OK);
	}
	
	/**
	 *  Web ڡ򳫤ܥåޤ
	 * 
	 * @param     owner ʡ
	 * @param     option ץ
	 */
	public OptionDialog(final Frame owner, ViewerOption option)
	{
		super(owner, BUTTON_OKCANCEL | ALIGN_RIGHT);
		setTitle    (getMessage("title"));
		setResizable(true);
		setModal    (true);
		
		this.option = option;
		
		// ᥤѥͥ
		GridBagLayout gbl    = new GridBagLayout();
		Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
		mainPanel.setLayout(gbl);
		
		addToPanel(       new Label(getMessage("label.category" )), gbl, 0, 0, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
		addToPanel(tree = new Tree (10                           ), gbl, 0, 1, 1, 1, 0, 1, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
		addToPanel(main = new Panel(mainLayout = new CardLayout()), gbl, 1, 0, 1, 2, 1, 1, GridBagConstraints.BOTH      , GridBagConstraints.CENTER, insets);
		
		// ܥ̾ѹ
		setButtonLabel(0, getMessage("label.ok"    ));
		setButtonLabel(1, getMessage("label.cancel"));
		
		setSize(400, 60);
		
		// ֤
		setLocationToCenter();
	}
	
	/** ꥽ʸ */
	private String getMessage(String key)
	{
		if (key == null)
			return "";
		
		return Resource.getMessage(RESOURCE, "optiondialog." + key, null);
	}
}
