/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.SizedButton;

import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.MalformedURLException;

/**
 *  Web ڡ URL Ϥ뤿ΥǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class OpenDialog
	extends DialogBox
{
	private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
	private static final int    MARGIN   = 3;
	
	private static final String URL_FILE_SCHEME = "file:/";
	
	/**  ܥ */
	public static final int RESULT_OPEN = RESULT_OK;
	
	/** @serial ѥ */
	private TextField path;
	
	/**
	 *  Web ڡ򳫤ܥåޤ
	 * 
	 * @param     owner ʡ
	 */
	public OpenDialog(final Frame owner)
	{
		super(owner, BUTTON_OKCANCEL);
		setTitle    (getMessage("title"));
		setResizable(false);
		setModal    (true );
		
		// ᥤѥͥ
		GridBagLayout gbl    = new GridBagLayout();
		Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
		mainPanel.setLayout(gbl);
		
		Button file;
		addToPanel(       new Label    (getMessage("message"   )), gbl, 0, 0, 2, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
		addToPanel(path = new TextField(30                      ), gbl, 0, 1, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
		addToPanel(file = new Button   (getMessage("label.file")), gbl, 1, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, insets);
		
		file.addActionListener(
			new ActionListener()
			{
				public void actionPerformed(ActionEvent e)
				{
					// եܥ
					FileDialog fd = new FileDialog(owner,
					                               Resource.getMessage(RESOURCE, "dialog.file.open", null),
					                               FileDialog.LOAD);
					fd.show();
					
					String pathName = fd.getFile();
					if (pathName == null) {
						fd.dispose();
						return;
					}
					
					pathName = (fd.getDirectory() != null ? fd.getDirectory() : "") + pathName;
					fd.dispose();
					
					pathName = URL_FILE_SCHEME + pathName;
					try {
						path.setText((new URL(pathName)).toString());
					} catch (MalformedURLException ex) {
						path.setText(pathName);
					}
				}
			}
		);
		
		// ܥ̾ѹ
		setButtonLabel(0, getMessage("label.open"));
		
		setSize(400, 60);
		
		// ֤
		setLocationToCenter();
	}
	
	/** ꥽ʸ */
	private String getMessage(String key)
	{
		if (key == null)
			return "";
		
		return Resource.getMessage(RESOURCE, "opendialog." + key, null);
	}
	
	/**
	 * ꤵƤ֤ޤ
	 * 
	 * @return    
	 */
	public String getPath()
	{
		return path.getText();
	}
	
	/**
	 * ꤷޤ
	 * 
	 * @param     value 
	 */
	public void setPath(String value)
	{
		path.setText(value);
	}
}
