/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;

/**
 * ΥǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class Loader
{
	private ViewerOption option;
	
	/**
	 * Υ󥹥󥹤ޤ
	 */
	private Loader()
	{
	}
	
	/**
	 * ӥ塼Υȥåץ᥽åɤǤ
	 * 
	 * @param     args 
	 */
	public static final void main(String[] args)
	{
		(new Loader()).start(args);
	}
	
	/** ӥ塼򳫻Ϥ */
	private void start(String[] args)
	{
		option = new ViewerOption();
		
		HawkViewer.addDefaultWindowListener(new ViewerWindowListener());
		HawkViewer viewer = new HawkViewer(option);
		viewer.show();
		
		try {
			int index = HawkViewer.CURRENT_TAB;
			for (int i = 0; i < args.length; i++) {
				if (i > 0) {
					index = viewer.createTab(HawkViewer.LAST_TAB, false);
				}
				viewer.open(index, args[i], null);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
//### ViewerWindowListener
	/** ɥϥɥ */
	private class ViewerWindowListener
		extends WindowAdapter
	{
		int count = 0;
		
		/** 󥹥󥹤 */
		private ViewerWindowListener()
		{
		}
		
		/** ɥ줿Ȥ */
		public synchronized void windowOpened(WindowEvent e)
		{
			count++;
		}
		
		/** ɥĤ줿Ȥ */
		public synchronized void windowClosed(WindowEvent e)
		{
			if (--count == 0) {
				option.save();
				System.exit(0);
			}
		}
	}
}
