/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.util.CharList;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

/**
 * ĥץѥƥ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class ExProperties
	extends Properties
{
	private static final boolean DEFAULT_BOOLEAN = false;
	private static final int     DEFAULT_INT     = -1;
	private static final double  DEFAULT_DOUBLE  = -1;
	
	/** @serial ץѥƥե         */ private File   propertiesFile;
	/** @serial ץѥƥοƥǥ쥯ȥ */ private String propertiesParent;
	
	/**
	 * Υץѥƥޤ
	 */
	public ExProperties()
	{
		super();
	}
	
	/**
	 * ꤵ줿ǥեͤĶΥץѥƥޤ
	 * 
	 * @param     p ǥե
	 */
	public ExProperties(ExProperties p)
	{
		super(p);
	}
	
	/**
	 * ꤵ줿ե뤫ץѥƥꥹȤɤ߹ߤޤ
	 * 
	 * @param     path ѥ
	 */
	public synchronized void load(String path)
		throws IOException
	{
		propertiesFile = new File(path);
		try {
			propertiesParent = (new File(propertiesFile.getCanonicalPath())).getParent();
		} catch (IOException e) {}
		
		FileInputStream is = new FileInputStream(propertiesFile);
		load(is);
		is.close();
	}
	
	/**
	 * ꤵ줿ե˥ץѥƥꥹȤǼޤ
	 * 
	 * @param     path   ѥ
	 * @param     header ץѥƥꥹȤε
	 */
	public synchronized void save(String path, String header)
		throws IOException
	{
		File parent = new File((new File(propertiesFile.getCanonicalPath())).getParent());
		if (parent != null) {
			if (parent.exists()) {
				if (!parent.isDirectory())
					throw new IOException("Parent is not directory");
			} else if (!parent.mkdirs()) {
				throw new IOException("Can not create directory");
			}
		}
		
		FileOutputStream os = new FileOutputStream(path);
		save(os, header);
		os.flush();
		os.close();
	}
	
//### Converter ʸ => 饹
	/**
	 * ꤵ줿ĥץѥƥboolean ֤ޤ
	 * Ĥʤä <code>false</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public boolean getPropertyBoolean(String key)
	{
		String value = getProperty(key);
		if (value == null) {
			if (defaults != null)
				defaults.put(key, String.valueOf(DEFAULT_BOOLEAN));
			return DEFAULT_BOOLEAN;
		}
		
		return Boolean.valueOf(value).booleanValue();
	}
	
	/**
	 * ꤵ줿ĥץѥƥint ֤ޤ
	 * Ĥʤä <code>-1</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public int getPropertyInt(String key)
	{
		String value = getProperty(key);
		if (value == null) {
			if (defaults != null)
				defaults.put(key, String.valueOf(DEFAULT_INT));
			return DEFAULT_INT;
		}
		
		return Integer.valueOf(value).intValue();
	}
	
	/**
	 * ꤵ줿ĥץѥƥdouble ֤ޤ
	 * Ĥʤä <code>-1</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public double getPropertyDouble(String key)
	{
		String value = getProperty(key);
		if (value == null) {
			if (defaults != null)
				defaults.put(key, String.valueOf(DEFAULT_DOUBLE));
			return DEFAULT_DOUBLE;
		}
		
		return Double.valueOf(value).doubleValue();
	}
	
	/**
	 * ꤵ줿ĥץѥƥ{@link String} ֤ޤ
	 * Ĥʤä <code>null</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public String getPropertyString(String key)
	{
		return getProperty(key);
	}
	
	/**
	 * ꤵ줿ĥץѥƥ{@link String} ֤ޤ
	 * Ĥʤä <code>null</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public String[] getPropertyStrings(String key)
	{
		String value = getProperty(key);
		if (value == null)
			return null;
		
		StringTokenizer st = new StringTokenizer(value, ",");
		String[] values = new String[st.countTokens()];
		int      index  = 0;
		while (st.hasMoreTokens())
			values[index++] = st.nextToken().trim();
		
		return values;
	}
	
	/**
	 * ꤵ줿ĥץѥƥ{@link Dimension} ֤ޤ
	 * Ĥʤä <code>null</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public Dimension getPropertyDimension(String key)
	{
		String value = getProperty(key);
		if (value == null)
			return null;
		
		int p = value.indexOf(',');
		if (p == -1)
			return null;
		
		try {
			return new Dimension(
				Integer.valueOf(value.substring(0, p )).intValue(),
				Integer.valueOf(value.substring(p + 1)).intValue()
			);
		} catch (NumberFormatException e) {}
		return null;
	}
	
	/**
	 * ꤵ줿ĥץѥƥ{@link Font} ֤ޤ
	 * Ĥʤä <code>null</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public Font getPropertyFont(String key)
	{
		String value = getProperty(key);
		if (value == null)
			return null;
		
		return Font.decode(value);
	}
	
	/**
	 * ꤵ줿ĥץѥƥ{@link Point} ֤ޤ
	 * Ĥʤä <code>null</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public Point getPropertyPoint(String key)
	{
		String value = getProperty(key);
		if (value == null)
			return null;
		
		int p = value.indexOf(',');
		if (p == -1)
			return null;
		
		try {
			return new Point(
				Integer.valueOf(value.substring(0, p )).intValue(),
				Integer.valueOf(value.substring(p + 1)).intValue()
			);
		} catch (NumberFormatException e) {}
		return null;
	}
	
	/**
	 * ꤵ줿ĥץѥƥ{@link File} ֤ޤ
	 * Ĥʤä <code>null</code> ֤ޤ
	 * <p>
	 * ХѥꤵƤǡץѥƥե뤫ɤǤϡ
	 * ΥץѥƥեΥѥХѥ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public File getPropertyFile(String key)
	{
		String value = getProperty(key);
		if (value == null)
			return null;
		
		if (value == null || value.length() == 0)
			return null;
		
		if (propertiesParent == null ||
		    (Environment.isWindows && value.length() > 2 && value.charAt(1) == ':') ||
		    value.charAt(0) == '/' ||
		    value.charAt(0) == '\\') {
			return new File(value);
		} else {
			return new File(propertiesParent, value);
		}
	}
	
	/**
	 * ꤵ줿ĥץѥƥ{@link CharList} ֤ޤ
	 * Ĥʤä <code>null</code> ֤ޤ
	 * 
	 * @param     key ץѥƥ
	 * 
	 * @return    ץѥƥ
	 */
	public CharList getPropertyCharList(String key)
	{
		String value = getProperty(key);
		if (value == null)
			return null;
		
		return new CharList(value);
	}
	
//### Converter 饹 => ʸ
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, boolean value)
	{
		return putValue(key, String.valueOf(value));
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, int value)
	{
		return putValue(key, String.valueOf(value));
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, double value)
	{
		return putValue(key, String.valueOf(value));
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, String value)
	{
		if (value == null)
			return remove(key);
		
		return putValue(key, value);
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, String[] value)
	{
		if (value == null)
			return remove(key);
		
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < value.length; i++) {
			sb.append(value[i]);
			sb.append(',');
		}
		if (sb.length() > 0)
			sb.setLength(sb.length() - 1);
		
		return putValue(key, sb.toString());
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, Dimension value)
	{
		if (value == null)
			return remove(key);
		
		return putValue(key, value.width + "," + value.height);
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, Font value)
	{
		if (value == null)
			return remove(key);
		
		String style = "plain";
		int    code  = value.getStyle();
		
		if ((code & Font.BOLD) != 0 && (code & Font.ITALIC) != 0) {
			style = "bolditalic";
		} else if ((code & Font.BOLD) != 0) {
			style = "bold";
		} else if ((code & Font.ITALIC) != 0) {
			style = "italic";
		}
		
		return putValue(key, value.getName() + "-" + style + "-" + value.getSize());
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, Point value)
	{
		if (value == null)
			return remove(key);
		
		return putValue(key, value.x + "," + value.y);
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * <p>
	 * ץѥƥե뤫ɤƤơꤵ줿ե뤬
	 * ץѥƥեʲΰ֤֤Ƥϡ
	 * Хѥꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, File value)
	{
		if (value == null)
			return remove(key);
		
		if (propertiesParent != null) {
			try {
				String target = value.getCanonicalPath();
				if (target.startsWith(propertiesParent))
					return putValue(key, target.substring(propertiesParent.length() + 1));
			} catch (IOException e) {}
		}
		
		return putValue(key, value.toString());
	}
	
	/**
	 * ꤵ줿бץѥƥꤷޤ
	 * ץѥƥͤ {@link String} Ѵꤵޤ
	 * 
	 * @param     key   ץѥƥ
	 * @param     value ץѥƥ
	 * 
	 * @return    ꤵƤץѥƥ͡
	 *            ̵ <code>null</code>
	 */
	public Object put(String key, CharList value)
	{
		if (value == null)
			return remove(key);
		
		return putValue(key, value.toString());
	}
	
	/** Ʊʤꤷʤ */
	private Object putValue(String key, String value)
	{
		String def = null;
		
		if (defaults != null &&
		    (def = (String)defaults.get(key)) != null &&
		    value.compareTo(def) == 0)
			return remove(key);
		else
			return super.put(key, value);
	}
}
