/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.viewer;

/**
 * ӥ塼ѤΥƥȥꥹʤΥޥ㥹ȤԤ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
class ContextEventMulticaster
	implements ContextListener
{
	protected final ContextListener a;
	protected final ContextListener b;
	
	/**
	 * ꥹ <code>a</code> ȥꥹ <code>b</code> Ĥʤ
	 * ٥ȡޥ㥹ȡ󥹥󥹤ޤ
	 * 
	 * @param     a ꥹ <code>a</code>
	 * @param     b ꥹ <code>b</code>
	 */
	ContextEventMulticaster(ContextListener a, ContextListener b)
	{
		this.a = a;
		this.b = b;
	}
	
	/** {@inheritDoc} */
	public void activeChanged(ViewerContext context)
	{
		a.activeChanged(context);
		b.activeChanged(context);
	}
	
	/** {@inheritDoc} */
	public void documentLoading(ViewerContext context)
	{
		a.documentLoading(context);
		b.documentLoading(context);
	}
	
	/** {@inheritDoc} */
	public void documentLoaded(ViewerContext context)
	{
		a.documentLoaded(context);
		b.documentLoaded(context);
	}
	
	/** {@inheritDoc} */
	public void addressChanged(ViewerContext context, String address)
	{
		a.addressChanged(context, address);
		b.addressChanged(context, address);
	}
	
	/** {@inheritDoc} */
	public void titleChanged(ViewerContext context, String title)
	{
		a.titleChanged(context, title);
		b.titleChanged(context, title);
	}
	
	/** {@inheritDoc} */
	public void statusChanged(ViewerContext context, String status)
	{
		a.statusChanged(context, status);
		b.statusChanged(context, status);
	}
	
	/** {@inheritDoc} */
	public void historyChanged(ViewerContext context)
	{
		a.historyChanged(context);
		b.historyChanged(context);
	}
	
	public static ContextListener add(ContextListener a, ContextListener b)
	{
		return addInternal(a, b);
	}
	
	public static ContextListener remove(ContextListener l, ContextListener oldl)
	{
		return removeInternal(l, oldl);
	}
	
	protected static ContextListener addInternal(ContextListener a, ContextListener b)
	{
		if (a == null) return b;
		if (b == null) return a;
		
		return new ContextEventMulticaster(a, b);
	}
	
	protected static ContextListener removeInternal(ContextListener l, ContextListener oldl)
	{
		if (l == oldl || l == null) {
			return null;
		} else if (l instanceof ContextEventMulticaster) {
			return ((ContextEventMulticaster)l).remove(oldl);
		} else {
			return l;
		}
	}
	
	protected ContextListener remove(ContextListener oldl) {
		if (oldl == a) return b;
		if (oldl == b) return a;
		
		ContextListener a2 = removeInternal(a, oldl);
		ContextListener b2 = removeInternal(b, oldl);
		
		if (a2 == a && b2 == b)
			return this;
		
		return addInternal(a2, b2);
	}
}
