/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util.windows;

import net.hizlab.kagetaka.io.BinaryInputStream;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.EOFException;
import java.io.IOException;

/**
 * 硼ȥåȤԤ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class Shortcut
{
	private static final int    BUFFER_SIZE     = 512;
	private static final byte[] LNK_SIGNATURE   = {0x4C, 0, 0, 0};
	private static final int    LNK_HEADER_SIZE = 0x4C;
	private static final int    LNK_WORD_SIZE   = 0x2;
	private static final int    LNK_DWORD_SIZE  = 0x4;
	private static final int    LNK_QWORD_SIZE  = 0x8;
	private static final int    LNK_HEADER_FLAG = 0x14;
	private static final int    LNK_HEADER_FLAG_IDLIST    = 0x01;
	private static final int    LNK_HEADER_FLAG_FILE      = 0x02;
	private static final int    LNK_HEADER_FLAG_DESC      = 0x04;
	private static final int    LNK_HEADER_FLAG_PATH      = 0x08;
	private static final int    LNK_HEADER_FLAG_WD        = 0x10;
	private static final int    LNK_LOCATION_FLAG_LOCAL   = 0x01;
	private static final int    LNK_LOCATION_FLAG_NETWORK = 0x02;
	private static final String URL_HEADER_LC = "[internetshortcut]";
	private static final String URL_KEY_LC    = "url=";
	
	/** ߡ */
	private Shortcut()
	{
	}
	
	/**
	 * 硼ȥåȥե뤫顢֤褷ޤ
	 * 
	 * @param     path 硼ȥåȥեؤΥѥ
	 * 
	 * @return    åȥåȤμ֤ؤΥѥ硼ȥåȥեǤ
	 *            ̵Ǥʤä <code>null</code>
	 */
	public static String resolve(String path)
	{
		if (path.toLowerCase().endsWith(".lnk"))
			return resolveLnk(path);
		else if (path.toLowerCase().endsWith(".url"))
			return resolveUrl(path);
		
		return null;
	}
	
	/** lnk  */
	private static String resolveLnk(String path)
	{
		BinaryInputStream bis = null;
		
		try {
			bis = new BinaryInputStream(
			        new BufferedInputStream(
			          new FileInputStream(path),
			          BUFFER_SIZE),
			        BUFFER_SIZE);
		} catch (IOException e) {
			return null;
		}
		
		try {
			byte[] buffer = new byte[BUFFER_SIZE];
			int p = 0;
			int length;
			
			// إåɤ߹
			for (p = 0; p < LNK_HEADER_SIZE; p += length)
				if ((length = bis.read(buffer, p, LNK_HEADER_SIZE)) == -1)
					return null;
			// ͥθ
			for (int i = 0; i < LNK_SIGNATURE.length; i++)
				if (buffer[i] != LNK_SIGNATURE[i])
					return null;
			long headerFlags = BinaryInputStream.byteToLong(buffer, LNK_HEADER_FLAG, LNK_DWORD_SIZE);
			
			// ե־󤬤ʤ
			if ((headerFlags & LNK_HEADER_FLAG_FILE) == 0)
				return null;
			
			// ID LIST ɤФ
			if ((headerFlags & LNK_HEADER_FLAG_IDLIST) != 0)
				bis.skip(bis.readNumber(LNK_WORD_SIZE));
			
			// ե־
			long structureOffset         = bis.getOffset();
			long structureLength         = bis.readNumber(LNK_DWORD_SIZE);
			long maybe0x1C               = bis.readNumber(LNK_DWORD_SIZE);
			long fileFlags               = bis.readNumber(LNK_DWORD_SIZE);
			long offsetLocalVolume       = bis.readNumber(LNK_DWORD_SIZE);
			long offsetBasePathname      = bis.readNumber(LNK_DWORD_SIZE);
			long offsetNetworkVolume     = bis.readNumber(LNK_DWORD_SIZE);
			long offsetRemainingPathname = bis.readNumber(LNK_DWORD_SIZE);
			
			// ȥå
			if (maybe0x1C != 0x1C)
				return null;
			
			// ե
			if ((fileFlags & LNK_LOCATION_FLAG_LOCAL) != 0) {
				bis.skip(bis.getOffset() - structureOffset - offsetLocalVolume);
				long localVolumeStrSize = bis.readNumber(LNK_DWORD_SIZE);
				long localVolumeType    = bis.readNumber(LNK_DWORD_SIZE);
				long volumeSerialNumber = bis.readNumber(LNK_DWORD_SIZE);
				long maybe0x10          = bis.readNumber(LNK_DWORD_SIZE);
				String comment = bis.readString(null);
				String label   = bis.readString(null);
				bis.skip(1);
				return label;
			}
			
			String networkDrive1 = null;
			String networkDrive2 = null;
			
			// ͥåȥե
			if ((fileFlags & LNK_LOCATION_FLAG_NETWORK) != 0) {
				bis.skip(bis.getOffset() - structureOffset - offsetNetworkVolume);
				long networkVolumeStrSize = bis.readNumber(LNK_DWORD_SIZE);
				long maybe0x02            = bis.readNumber(LNK_DWORD_SIZE);
				long offsetShareName      = bis.readNumber(LNK_DWORD_SIZE);
				long maybe0x00            = bis.readNumber(LNK_DWORD_SIZE);
				long maybe0x2000          = bis.readNumber(LNK_DWORD_SIZE);
				networkDrive1 = bis.readString(null);
				networkDrive2 = bis.readString(null);
				if (networkDrive2.length() >= 2 && networkDrive2.charAt(1) != ':')
					return networkDrive1 + "\\" + networkDrive2;
			} else {
				// ǤͥåȥǤʤ
				return null;
			}
			
			// 
			if ((headerFlags & LNK_HEADER_FLAG_DESC) != 0) {
				bis.skip(bis.readNumber(LNK_WORD_SIZE));
			}
			// 쥤ƥ֥ѥ
			if ((headerFlags & LNK_HEADER_FLAG_PATH) != 0) {
				bis.skip(bis.readNumber(LNK_WORD_SIZE));
			}
			// ȥǥ쥯ȥ
			if ((headerFlags & LNK_HEADER_FLAG_WD  ) != 0) {
				// ȥǥ쥯ȥꡩʥɥ饤֤ѥ
				String networkDirectory = bis.readString(null);
				if (networkDrive2.length() >= 2 && networkDrive2.charAt(1) == ':')
					return networkDrive2 + "\\" + networkDirectory;
				else
					return networkDrive1 + "\\" + networkDirectory;
			}
		} catch (EOFException e) {
			// EOFException ̵
		} catch (IOException e) {
System.out.println(e);
		} finally {
			try {
				bis.close();
			} catch (IOException e) {}
		}
		
		return null;
	}
	
	/** url  */
	private static String resolveUrl(String path)
	{
		BufferedReader br = null;
		
		try {
			br = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
		} catch (IOException e) {
			return null;
		}
		
		try {
			String line = br.readLine();
			if (line == null || line.trim().toLowerCase().compareTo(URL_HEADER_LC) != 0)
				return null;
			
			while ((line = br.readLine()) != null)
				if (line.toLowerCase().startsWith(URL_KEY_LC))
					return line.substring(URL_KEY_LC.length()).trim();
		} catch (IOException e) {
System.out.println(e);
		} finally {
			try {
				br.close();
			} catch (IOException e) {}
		}
		
		return null;
	}
}
