/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

import net.hizlab.kagetaka.rendering.PostData;

import java.awt.Point;
import java.net.URL;

/**
 * URL ΥꥹȤǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class URLHistory
{
	private URL        url      = null;
	private PostData   pd       = null;
	private URL        realUrl  = null;
	private String     title    = null;
	private Point      position = null;
	private URLHistory next     = null;
	private URLHistory prev     = null;
	
	/**
	 * 󥹥󥹤ޤ
	 * 
	 * @param     url URL
	 * @param     realUrl ºݤ URL
	 * @param     pd      POST ǡ
	 */
	public URLHistory(URL url, PostData pd, URL realUrl)
	{
		this.url     = url;
		this.pd      = pd;
		this.realUrl = realUrl;
	}
	
	/**
	 * URL ֤ޤ
	 * 
	 * @return    URL
	 */
	public URL getURL()
	{
		return url;
	}
	
	/**
	 * POST ǡ֤ޤ
	 * 
	 * @return    POST ǡPOST Ǥ̵ <code>null</code>
	 */
	public PostData getPostData()
	{
		return pd;
	}
	
	/**
	 * ºݤ URL ֤ޤ
	 * 
	 * @return    ºݤ URL
	 */
	public URL getRealURL()
	{
		return realUrl;
	}
	
	/**
	 * ºݤ URL ꤷޤ
	 * 
	 * @param     url ºݤ URL
	 */
	public void setRealURL(URL url)
	{
		realUrl = url;
	}
	
	/**
	 * ȥꤷޤ
	 * 
	 * @param     title ȥ
	 */
	public void setTitle(String title)
	{
		this.title = title;
	}
	
	/**
	 * ȥ֤ޤ
	 * 
	 * @return    ȥ
	 */
	public String getTitle()
	{
		return title;
	}
	
	/**
	 * ̰֤ꤷޤ
	 * 
	 * @param     position ̰
	 */
	public void setPosition(Point position)
	{
		this.position = position;
	}
	
	/**
	 * ̰֤֤ޤ
	 * 
	 * @return    ̰
	 */
	public Point getPosition()
	{
		return position;
	}
	
	/**
	 * μäޤ
	 * ⤷¸ߤϡ֤ޤ
	 * 
	 * @param     h 
	 */
	public synchronized void append(URLHistory h)
	{
		if (next == null) {
			next = h;
			next.prev = this;
		} else {
			URLHistory top = h;
			while (top.prev != null) {
				top = top.prev;
				if (h == top)
					new IllegalArgumentException("looped list");
			}
			
			URLHistory last = h;
			while (last.next != null) {
				last = last.next;
				if (h == last)
					new IllegalArgumentException("looped list");
			}
			
			last.next = next;
			last.next.prev = last;
			next = top;
			next.prev = this;
		}
	}
	
	/**
	 * ֤ޤ
	 * 
	 * @return    
	 */
	public synchronized URLHistory getNextURLHistory()
	{
		return next;
	}
	
	/**
	 * ֤ޤ
	 * 
	 * @return    
	 */
	public synchronized URLHistory getPreviousURLHistory()
	{
		return prev;
	}
	
	/**
	 * μʹߤޤ
	 */
	public synchronized void removeAfter()
	{
		if (next != null) {
			next.prev = null;
			next = null;
		}
	}
}
