/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

/**
 * URL ΥꥹȤǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class URLEncoder
{
	static final int caseDiff = ('a' - 'A');
	static BitSet dontNeedEncoding;
	static {
		dontNeedEncoding = new BitSet(256);
		int i;
		for (i = 'a'; i <= 'z'; i++)
			dontNeedEncoding.set(i);
		for (i = 'A'; i <= 'Z'; i++)
			dontNeedEncoding.set(i);
		for (i = '0'; i <= '9'; i++)
			dontNeedEncoding.set(i);
		dontNeedEncoding.set(' ');
		dontNeedEncoding.set('-');
		dontNeedEncoding.set('_');
		dontNeedEncoding.set('.');
		dontNeedEncoding.set('*');
	}
	
	/** ߡ */
	private URLEncoder()
	{
	}
	
	/**
	 * ʸ <code>x-www-form-urlencoded</code> Ѵޤ
	 * 
	 * @param     s Ѵʸ
	 * @param     encoding ѴѤ륨󥳡ǥ
	 * 
	 * @return    Ѵʸ
	 */
	public static String encode(String s, String encoding)
	{
		int maxBytesPerChar = 10;
		int length = s.length();
		ByteArrayOutputStream out = new ByteArrayOutputStream(length);
		ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
		OutputStreamWriter writer = null;
		
		if (encoding != null) {
			try {
				writer = new OutputStreamWriter(buf, encoding);
			} catch (UnsupportedEncodingException e) {}
		}
		if (writer == null)
			writer = new OutputStreamWriter(buf);
		
		int c;
		char ch;
		byte[] bytes;
		for (int i = 0; i < length; i++) {
			c = (int)s.charAt(i);
			
			if (dontNeedEncoding.get(c)) {
				// Ѵʤ
				
				// ' ' -> '+' Ѵ
				if (c == ' ')
					c = '+';
				out.write(c);
			} else {
				// Ѵɬפ
				
				// 󥳡ǥ󥰤ѴΤˡ writer 
				try {
					writer.write(c);
					writer.flush();
				} catch(IOException e) {
					buf.reset();
					continue;
				}
				
				// Х %xx Ѵ
				bytes = buf.toByteArray();
				for (int j = 0; j < bytes.length; j++) {
					out.write('%');
					
					// ̥Х
					ch = Character.forDigit((bytes[j] >> 4) & 0xF, 16);
					if (Character.isLetter(ch))
						ch -= caseDiff;
					out.write(ch);
					
					// ̥Х
					ch = Character.forDigit(bytes[j] & 0xF, 16);
					if (Character.isLetter(ch))
						ch -= caseDiff;
					out.write(ch);
				}
				buf.reset();
			}
		}
		
		return out.toString();
	}
}
