/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;

import java.awt.Color;
import java.awt.Font;

/**
 * ʸŬڤ˥եޥåȤ뤿Υ桼ƥƥǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class TextFormat
{
	private static final String RESOURCE = "net.hizlab.kagetaka.util.TextFormat";
	
	/**
	 * ͣΥ󥹥ȥ饯Ǥ󥹥󥹤κϽޤ
	 */
	private TextFormat() {}
	
	/**
	 * ꤵ줿ʸXHTML ΥƥĤ˽ऺѴ򤷤֤ޤ
	 * ԥɤʤɤ򥹥ڡѴ&amp; ʤɤˤʸȤ䡢
	 * λȤ褷ڡͤԤޤ
	 * <p>
	 * ߡλȤϡXHTML 1.0 ƤʪͭǤ
	 * 
	 * @param     value оݤʸ
	 * @param     before   ʸκǽˤ륹ڡ
	 *                     <code>true</code>ʳ <code>false</code>
	 * @param     after    ʸκǸˤ륹ڡ
	 *                     <code>true</code>ʳ <code>false</code>
	 * @param     abbr   Ϣ³륹ڡͤ
	 *                   <code>true</code>ʳ <code>false</code>
	 * @param     reference Ȥ褹
	 *                      <code>true</code>ʳ <code>false</code>
	 * 
	 * @return    Ѵ줿ʸ
	 * 
	 * @see       <a href="http://www.w3.org/TR/2000/REC-xhtml1-20000126/#dtds">XHTML 1.0: A.2 Entity Sets</a>
	 */
	public static String convertXhtml(String value,
	                                  boolean before, boolean after,
	                                  boolean abbr, boolean reference)
	{
		return convertXhtml(null, 0, 0, value, before, after, abbr, reference);
	}
	
	/**
	 * ꤵ줿ʸXHTML ΥƥĤ˽ऺѴ򤷤֤ޤ
	 * ԥɤʤɤ򥹥ڡѴ&amp; ʤɤˤʸȤ䡢
	 * λȤ褷ڡͤԤޤ
	 * <p>
	 * ߡλȤϡXHTML 1.0 ƤʪͭǤ
	 * 
	 * @param     reporter 顼ݡ
	 * @param     line ֹ (<code>1</code> )
	 * @param     column  (<code>1</code> )
	 * @param     value оݤʸ
	 * @param     before ʸκǽˤ륹ڡ
	 *                   <code>true</code>ʳ <code>false</code>
	 * @param     after  ʸκǸˤ륹ڡ
	 *                   <code>true</code>ʳ <code>false</code>
	 * @param     abbr   Ϣ³륹ڡͤ
	 *                   <code>true</code>ʳ <code>false</code>
	 * @param     reference Ȥ褹
	 *                      <code>true</code>ʳ <code>false</code>
	 * 
	 * @return    Ѵ줿ʸ
	 * 
	 * @see       <a href="http://www.w3.org/TR/2000/REC-xhtml1-20000126/#dtds">XHTML 1.0: A.2 Entity Sets</a>
	 */
	public static String convertXhtml(Reporter reporter, int line, int column,
	                                  String value,
	                                  boolean before, boolean after,
	                                  boolean abbr, boolean reference)
	{
		int i, length = value.length();
		StringBuffer sb  = new StringBuffer(length);
		StringBuffer ref = null;
		char c;
		
		boolean passOne = before;               // ڡ true
		int space = 0;                          // Ϣ³Ƹ줿ڡο
		int lf = 0, pos = -1;                   // ݥ
		int check = 0;
		
		// ѴԤ
		for (i = 0; i < length; i++) {
			c = value.charAt(i);
			
			// /ȾǷ׻
			if (c <= 0xFF || (0xFF61 <= c && c <= 0xFF9F))
				pos += 1;
			else
				pos += 2;
			
			// ˻Ȥ褹
			if (reference && c == '&') {
				check = i;
				if (ref == null)
					ref = new StringBuffer();
				else
					ref.setLength(0);
				
				// ; 򸡺
				while (++i < length) {
					c = value.charAt(i);
					if (c == ';')
						break;
					ref.append(c);
				}
				
				if (i >= length) {
					addWarning(reporter, "tf.warning.entity.nosemicolon", null, line + lf, column + pos);
					i = check; sb.append('&');
					continue;
				}
				if (ref.length() == 0) {
					addWarning(reporter, "tf.warning.entity.zerolength", null, line + lf, column + pos);
					i = check; sb.append('&');
					continue;
				}
				
				if (ref.charAt(0) == '#') {
					try {
						c = referCharacter(ref.toString());
					} catch (NumberFormatException e) {
						addWarning(reporter, e.getMessage(), ref.toString(), line + lf, column + pos);
						i = check; sb.append('&');
						continue;
					}
				} else {
					try {
						c = referEntity(ref.toString());
					} catch (IllegalArgumentException e) {
						addWarning(reporter, e.getMessage(), ref.toString(), line + lf, column + pos);
						i = check; sb.append('&');
						continue;
					}
				}
			}
			
			// ڡѴ + ڡͤ
			switch (c) {
			case 0x0009:  // 
				space += 8;
				continue;
			case 0x0020:  // ڡ
			case 0x000D:  // 
			case 0x000C:  // Form feed
			case 0x200B:  // Zero-width space
				space++;
				continue;
			default:
				if (c == 0x000A) {  // 
					lf++;
					pos = -1;
					if (abbr) {
						space++;
						continue;
					}
				}
				
				if (space > 0) {
					// Ϣ³륹ڡͤ
					if (abbr)
						space = 1;
					
					// ƬΥڡ
					if (passOne)
						passOne = false;
					else
						while (space-- > 0)
							sb.append(' ');
					
					space = 0;
				} else
				if (passOne)
					passOne = false;
				
				// ̤ʸХåեɲ
				sb.append(c);
			}
		}
		
		// ڡǽäƤν
		if (space > 0) {
			if (sb.length() > 0) {
				// ǸΥڡάʤΤߥڡɲ
				if (!after) {
					// Ϣ³륹ڡͤ
					if (abbr)
						space = 1;
					
					while (space-- > 0)
						sb.append(' ');
				}
			} else {
				// ڡΤߤʸξ硢Ȥ⥹ڡάʤΤߥڡɲ
				if (!before && !after) {
					// Ϣ³륹ڡͤ
					if (abbr)
						space = 1;
					
					while (space-- > 0)
						sb.append(' ');
				}
			}
		}
		
		return sb.toString();
	}
	
	/** λȤ򥳡ɤѴ */
	private static char referEntity(String value)
		throws IllegalArgumentException
	{
		value = Resource.getMessage(RESOURCE, value, null, null);
		if (value != null)
			return value.charAt(0);
		
		throw new IllegalArgumentException("tf.warning.entity.invalidentity");
	}
	
	/** ʸȤ򥳡ɤѴ */
	private static char referCharacter(String value)
		throws NumberFormatException
	{
		int base    = 10;
		int current = 1;
		
		int length = value.length() - current;
		if (length == 0)
			throw new NumberFormatException("tf.warning.entity.zerolength");
		
		// 16 ʿξ
		if (value.charAt(current) == 'x') {
			base = 16;
			current++;
			length--;
			if (length == 0)
				throw new NumberFormatException("tf.warning.entity.zerolength");
			if (length > 4)
				throw new NumberFormatException("tf.warning.entity.overlength");
		} else {
			if (length > 5)
				throw new NumberFormatException("tf.warning.entity.overlength");
		}
		
		char c;
		int  num = 0;
		while (--length >= 0) {
			c = value.charAt(current++);
			if ('0' <= c && c <= '9') {
				num += (c - '0') * Math.pow(base, length);
				continue;
			}
			if (base == 16) {
				if ('A' <= c && c <= 'F') {
					num += (c - 'A' + 10) * Math.pow(base, length);
					continue;
				}
				if ('a' <= c && c <= 'f') {
					num += (c - 'a' + 10) * Math.pow(base, length);
					continue;
				}
			}
			throw new NumberFormatException("tf.warning.entity.invalidchar");
		}
		
		if (num > 0xFFFD)
			throw new NumberFormatException("tf.warning.entity.invalidref");
		
		return (char)num;
	}
	
	/**
	 * ʸʳʸäƤ뤫֤ޤ
	 * 
	 * @param     value оݤʸ
	 * 
	 * @return    ʸʳʸäƤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static boolean hasCharacters(String value)
	{
		int length = value.length();
		
		for (int i = 0; i < length; i++) {
			switch (value.charAt(i)) {
			case 0x0009:  // 
			case 0x000A:  // 
			case 0x0020:  // ڡ
			case 0x000D:  // 
			case 0x000C:  // Form feed
			case 0x200B:  // Zero-width space
				continue;
			default:
				return true;
			}
		}
		
		return false;
	}
	
	/** ٹϿ */
	private static void addWarning(Reporter reporter,
	                               String key, String arg, int line, int column)
	{
		if (reporter != null) {
			String[] args = null;
			if (arg != null)
				args = new String[]{arg};
			reporter.report(Reporter.WARNING,
			                Resource.getMessage(key, args),
			                line,
			                column);
		}
	}
}
