/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.StringTokenizer;

/**
 * Java ¹ԴĶˤĤƤξ󶡤ޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Environment
{
	/** Ư OS  Windows Ϥɤ */
	public static boolean   isWindows;
	/** JavaVM ΥС (major * 100 + minor) */
	public static int       javaVersion;
	/** Applet ɤ */
	public static boolean   isApplet;
	/** ɥν */
	public static Dimension windowSizeOffset = new Dimension(0, 0);
	/** 1 Υɥåȿ */
	public static int       screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
	
	
	/** static */
	static {
		boolean _isWindows   = false;
		int     _javaVersion = 101;
		try {
			String osname = System.getProperty("os.name");
			_isWindows = (osname != null &&
			              osname.toUpperCase().startsWith("WINDOWS"));
		} catch (Exception e) {}
		try {
			String javaversion = System.getProperty("java.version");
			if (javaversion != null) {
				StringTokenizer st = new StringTokenizer(javaversion, ".");
				int major = 100, minor = 1;
				if (st.hasMoreTokens())
					try { major = Integer.valueOf(st.nextToken()).intValue(); } catch (Exception e) {}
				if (st.hasMoreTokens())
					try { minor = Integer.valueOf(st.nextToken()).intValue(); } catch (Exception e) {}
				_javaVersion = major * 100 + minor;
			}
		} catch (Exception e) {}
		isWindows   = _isWindows;
		javaVersion = _javaVersion;
	}
	
	/** ߡ */
	private Environment()
	{
	}
}
