/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token.table;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;

import java.awt.Color;
import java.awt.Font;

/**
 * ơ֥ϤΥȡγϤɽ륹ѡ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class TableStartToken
	extends StartToken
{
	private TableStartToken tableToken = null;
	
	/**
	 * ơ֥ϤΥȡγϤޤ
	 * 
	 * @param     document ɥȾ
	 * @param     reporter 顼ݡ
	 * @param     line     ֹ (<code>1</code> )
	 *                     Ǥʤ <code>0</code>
	 * @param     column    (<code>1</code> )
	 *                     Ǥʤ <code>0</code>
	 * @param     type     ȡγϤɽ
	 * @param     complete 䴰ƺ줿 <code>true</code>
	 *                     ʳξ <code>false</code>
	 */
	public TableStartToken(Document document, Reporter reporter, int line, int column, int type, boolean complete)
	{
		super(document, reporter, line, column, type, complete);
	}
	
	/** {@inheritDoc} */
	protected boolean setAttributeImple(String key, String value)
		throws IllegalArgumentException
	{
		if (attribute == null) {
			switch (type) {
			case TokenTypes.TABLE_START: attribute = new TableAttribute(document, reporter, lineNumber, columnNumber); break;
			case TokenTypes.THEAD_START:
			case TokenTypes.TBODY_START:
			case TokenTypes.TFOOT_START: attribute = new TbodyAttribute(document, reporter, lineNumber, columnNumber); break;
			case TokenTypes.TR_START   : attribute = new TrAttribute   (document, reporter, lineNumber, columnNumber); break;
			case TokenTypes.TH_START   :
			case TokenTypes.TD_START   : attribute = new TdAttribute   (document, reporter, lineNumber, columnNumber); break;
			default                    : attribute = new Attribute     (document, reporter, lineNumber, columnNumber); break;
			}
		}
		
		return attribute.setAttribute(key, value);
	}
	
	/** {@inheritDoc} */
	protected StartToken getDefaultParentTokenImple()
	{
		int tokenType = TokenTypes.UNKNOWN;
		
		switch (type) {
		case TokenTypes.TABLE_START  : tokenType = TokenTypes.BODY_START ; break;
		case TokenTypes.CAPTION_START: tokenType = TokenTypes.TABLE_START; break;
		case TokenTypes.THEAD_START  : tokenType = TokenTypes.TABLE_START; break;
		case TokenTypes.TBODY_START  : tokenType = TokenTypes.TABLE_START; break;
		case TokenTypes.TFOOT_START  : tokenType = TokenTypes.TABLE_START; break;
		case TokenTypes.TR_START     : tokenType = TokenTypes.TABLE_START; break;
		case TokenTypes.TH_START     : tokenType = TokenTypes.TR_START   ; break;
		case TokenTypes.TD_START     : tokenType = TokenTypes.TR_START   ; break;
		default:
			return null;
		}
		
		return new TableStartToken(document, reporter, lineNumber, columnNumber, tokenType, true);
	}
	
	/** {@inheritDoc} */
	protected boolean isContentsImple(int childToken)
	{
		switch (type) {
		case TokenTypes.TABLE_START:
			switch (childToken) {
			case TokenTypes.CAPTION_START:
			case TokenTypes.THEAD_START  :
			case TokenTypes.TBODY_START  :
			case TokenTypes.TFOOT_START  :
			case TokenTypes.TR_START     :
				return true;
			}
			return TokenTypes.isInline(childToken);
		case TokenTypes.CAPTION_START:          // same P
			return TokenTypes.isInline(childToken);
		case TokenTypes.THEAD_START:
		case TokenTypes.TBODY_START:
		case TokenTypes.TFOOT_START:
			return (childToken == TokenTypes.TR_START ||
			        TokenTypes.isInline(childToken));
		case TokenTypes.TR_START:
			return (childToken == TokenTypes.TH_START ||
			        childToken == TokenTypes.TD_START ||
			        TokenTypes.isInline(childToken));
		case TokenTypes.TH_START:               // same LI
		case TokenTypes.TD_START:
			return (TokenTypes.isBlock (childToken) ||
			        TokenTypes.isInline(childToken));
		}
		
		return false;
	}
	
	/** {@inheritDoc} */
	protected void includeTokenImple(Token token)
	{
		if (token instanceof TableStartToken)
			((TableStartToken)token).tableToken = (type == TokenTypes.TABLE_START ? this : tableToken);
	}
	
	/** {@inheritDoc} */
	protected void renderImple(Render render)
	{
		Status status = render.getStatus();
		
		switch (type) {
		case TokenTypes.TABLE_START  :
			if (attribute != null) {
				TableAttribute attr = (TableAttribute)attribute;
				if (attr.getBorder() != null && attr.getBorder().intValue() > 0) {
					status.setBorderWidth(Status.TARGET_ALL, new Value(attr.getBorder().intValue(), Value.UNIT_PX));
					status.setBorderStyle(Status.TARGET_ALL, new Value(Value.TYPE_KEY_OUTSET));
				}
				status.borderVerticalSpacing = status.borderHorizontalSpacing = attr.getCellspacing();
				status.height = attr.getWidth();
				if (attr.getHspace() != null) status.setMargin(Status.TARGET_TOP | Status.TARGET_BOTTOM, new Value(attr.getHspace().intValue(), Value.UNIT_PX));
				if (attr.getVspace() != null) status.setMargin(Status.TARGET_RIGHT | Status.TARGET_LEFT, new Value(attr.getVspace().intValue(), Value.UNIT_PX));
				switch (attr.getAlign()) {
				case Value.ALIGN_LEFT : status.floatType = Value.FLOAT_LEFT ; break;
				case Value.ALIGN_RIGHT: status.floatType = Value.FLOAT_RIGHT; break;
				default               : status.floatType = Value.FLOAT_NONE ; break;
				}
				if (attr.getBgcolor() != null) status.backColor = attr.getBgcolor();
			}
			
			status.setFontWeight(new Value(Value.NONE));
			status.align   = Value.NONE;
			status.valign  = Value.VALIGN_MIDDLE;
			status.isTable = true;
			break;
		case TokenTypes.CAPTION_START:
			status.setFontWeight(new Value(Value.TYPE_KEY_NORMAL));
			status.align  = Value.ALIGN_LEFT;
			status.valign = Value.VALIGN_BASELINE;
			break;
		case TokenTypes.THEAD_START  :
		case TokenTypes.TBODY_START  :
		case TokenTypes.TFOOT_START  :
			// Ƥ°򥳥ԡ
			status.valign    = status.parent.valign;
			status.backColor = status.parent.backColor;
			
			if (attribute != null) {
				TbodyAttribute attr = (TbodyAttribute)attribute;
				if (attr.getAlign  () != Value.INHERIT) status.align  = attr.getAlign ();
				if (attr.getVAlign () != Value.INHERIT) status.valign = attr.getVAlign();
			}
			break;
		case TokenTypes.TR_START     :
			// Ƥ°򥳥ԡ
			status.valign    = status.parent.valign;
			status.backColor = status.parent.backColor;
			
			if (attribute != null) {
				TrAttribute attr = (TrAttribute)attribute;
				if (attr.getAlign  () != Value.INHERIT) status.align     = attr.getAlign  ();
				if (attr.getVAlign () != Value.INHERIT) status.valign    = attr.getVAlign ();
				if (attr.getBgcolor() != null         ) status.backColor = attr.getBgcolor();
			}
			render.createNewRow();
			break;
		case TokenTypes.TH_START     :
		case TokenTypes.TD_START     :
			{
				int   border  = 0;
				Value padding = new Value(1, Value.UNIT_PX);
				
				// Ƥ°򥳥ԡ
				status.valign    = status.parent.valign;
				status.backColor = status.parent.backColor;
				
				// TH/TD ѽ
				if (status.getFontWeight() < 0) status.setFontWeight(new Value(type == TokenTypes.TH_START ? Value.TYPE_KEY_BOLD: Value.TYPE_KEY_NORMAL));
				if (status.align == Value.NONE) status.align = (type == TokenTypes.TH_START ? Value.ALIGN_CENTER: Value.ALIGN_LEFT);
				
				// TH/TD °
				if (attribute != null) {
					TdAttribute attr = (TdAttribute)attribute;
					if (attr.getAlign  () != Value.INHERIT) status.align      = attr.getAlign ();
					if (attr.getVAlign () != Value.INHERIT) status.valign     = attr.getVAlign();
					if (attr.getBgcolor() != null         ) status.backColor  = attr.getBgcolor();
					if (attr.getNowrap ()                 ) status.whiteSpace = Value.WHITESPACE_NOWRAP;
					if (attr.getColspan() != null         ) status.colSpan    = attr.getColspan().intValue();
					if (attr.getRowspan() != null         ) status.rowSpan    = attr.getRowspan().intValue();
					if (attr.getWidth  () != null         ) status.height     = attr.getWidth ();
					if (attr.getHeight () != null         ) status.width      = attr.getHeight();
				}
				
				// TABLE °򥳥ԡ
				if (tableToken.attribute != null) {
					TableAttribute attr = (TableAttribute)tableToken.attribute;
					if (attr.getBorder     () != null) border  = attr.getBorder().intValue();
					if (attr.getCellpadding() != null) padding = attr.getCellpadding();
				}
				
				// °
				if (border > 0) {
					status.setBorderWidth(Status.TARGET_ALL, new Value(1, Value.UNIT_PX));
					status.setBorderStyle(Status.TARGET_ALL, new Value(Value.TYPE_KEY_INSET));
				}
				status.setPadding(Status.TARGET_ALL, padding);
			}
			status.isVertical = true;
			break;
		}
	}
}
