/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token.ruby;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;

/**
 * ӷϤΥȡγϤɽ륹ѡ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class RubyStartToken
	extends StartToken
{
	private boolean rubyHasRb = false;
	private boolean rubyHasRt = false;
	
	/**
	 * ӷϤΥȡγϤޤ
	 * 
	 * @param     document ɥȾ
	 * @param     reporter 顼ݡ
	 * @param     line     ֹ (<code>1</code> )
	 *                     Ǥʤ <code>0</code>
	 * @param     column    (<code>1</code> )
	 *                     Ǥʤ <code>0</code>
	 * @param     type     ȡγϤɽ
	 * @param     complete 䴰ƺ줿 <code>true</code>
	 *                     ʳξ <code>false</code>
	 */
	public RubyStartToken(Document document, Reporter reporter, int line, int column, int type, boolean complete)
	{
		super(document, reporter, line, column, type, complete);
	}
	
	/** {@inheritDoc} */
	protected boolean setAttributeImple(String key, String value)
		throws IllegalArgumentException
	{
		if (attribute == null)
			attribute = new Attribute(document, reporter, lineNumber, columnNumber);
		
		return attribute.setAttribute(key, value);
	}
	
	/** {@inheritDoc} */
	protected StartToken getDefaultParentTokenImple()
	{
		int tokenType = TokenTypes.UNKNOWN;
		
		switch (type) {
		case TokenTypes.RUBY_START: tokenType = TokenTypes.DIV_START ; break;
		case TokenTypes.RB_START  : tokenType = TokenTypes.RUBY_START; break;
		case TokenTypes.RP_START  : tokenType = TokenTypes.RUBY_START; break;
		case TokenTypes.RT_START  : tokenType = TokenTypes.RUBY_START; break;
		default:
			return null;
		}
		
		return new RubyStartToken(document, reporter, lineNumber, columnNumber, tokenType, true);
	}
	
	/** {@inheritDoc} */
	protected boolean isContentsImple(int childToken)
	{
		switch (type) {
		case TokenTypes.RUBY_START:
			switch (childToken) {
			case TokenTypes.RB_START:
				if (rubyHasRb) return false;
				rubyHasRb = true;
				return true;
			case TokenTypes.RP_START:
				return true;
			case TokenTypes.RT_START:
				if (rubyHasRt) return false;
				rubyHasRt = true;
				return true;
			}
			return false;
		case TokenTypes.RB_START:
		case TokenTypes.RP_START:
		case TokenTypes.RT_START:
			return (TokenTypes.isInline(childToken) && !TokenTypes.isRuby(childToken));
		}
		
		return false;
	}
	
	/** {@inheritDoc} */
	protected void renderImple(Render render)
	{
		Status status = render.getStatus();
		
		switch (type) {
		case TokenTypes.RUBY_START      :
			render.startRuby();
			break;
		case TokenTypes.RB_START        :
			render.startRubyRb();
			break;
		case TokenTypes.RP_START        :
			render.startRubyRp();
			break;
		case TokenTypes.RT_START        :
			status.setFontSize(new Value(50, Value.UNIT_PERCENT), Status.TOKEN);
			render.startRubyRt();
			break;
		}
	}
}
