/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token.form;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;

/**
 * TEXTAREA °ɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class TextareaAttribute
	extends Attribute
{
	private String  attributeName      = null;       // ̾
	private Integer attributeRows      = null;       // Կ
	private Integer attributeCols      = null;       // 
	private boolean attributeDisabled  = false;      // ̵
	private boolean attributeReadonly  = false;      // ɤ߹
	private String  attributeWrap      = null;       // ɥå
	
	/**
	 * TEXTAREA °ǥեͤǺޤ
	 * 
	 * @param     document ɥȾ
	 * @param     reporter 顼ݡ
	 * @param     line   ֹ (<code>1</code> )
	 *                   Ǥʤ <code>0</code>
	 * @param     column  (<code>1</code> )
	 *                   Ǥʤ <code>0</code>
	 */
	protected TextareaAttribute(Document document, Reporter reporter, int line, int column)
	{
		super(document, reporter, line, column);
	}
	
	/** {@inheritDoc} */
	public boolean setAttribute(String key, String value)
		throws IllegalArgumentException
	{
		if ("name"     .compareTo(key) == 0) { attributeName      = value; return true; }
		if ("rows"     .compareTo(key) == 0) { attributeRows      = AttributeConverter.convertToInteger(value); return true; }
		if ("cols"     .compareTo(key) == 0) { attributeCols      = AttributeConverter.convertToInteger(value); return true; }
		if ("disabled" .compareTo(key) == 0) { attributeDisabled  = (value.toLowerCase().compareTo(key) == 0 ); return true; }
		if ("readonly" .compareTo(key) == 0) { attributeReadonly  = (value.toLowerCase().compareTo(key) == 0 ); return true; }
		if ("wrap"     .compareTo(key) == 0) { attributeWrap      = value; return true; }
		
		return setBaseAttribute(key, value);
	}
	
//### Original Method
	/**
	 * ֤̾ޤ
	 * 
	 * @return    NAMEꤵƤʤ <code>null</code>
	 */
	public String getName()
	{
		return attributeName;
	}
	
	/**
	 * Կ֤ޤ
	 * 
	 * @return    ROWSꤵƤʤ <code>null</code>
	 */
	public Integer getRows()
	{
		return attributeRows;
	}
	
	/**
	 * ֤ޤ
	 * 
	 * @return    COLSꤵƤʤ <code>null</code>
	 */
	public Integer getCols()
	{
		return attributeCols;
	}
	
	/**
	 * ̵֤ޤ
	 * 
	 * @return    DISABLEDꤵƤʤ <code>false</code>
	 */
	public boolean getDisabled()
	{
		return attributeDisabled;
	}
	
	/**
	 * ɤ߹Ѥ֤ޤ
	 * 
	 * @return    READONLYꤵƤʤ <code>false</code>
	 */
	public boolean getReadonly()
	{
		return attributeReadonly;
	}
	
	/**
	 * ɥåפ֤ޤ
	 * 
	 * @return    WRAPꤵƤʤ <code>null</code>
	 */
	public String getWrap()
	{
		return attributeWrap;
	}
}
