/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Color;
import java.awt.Toolkit;
import java.text.DecimalFormat;

/**
 * CSS 礭ɽץѥƥͤǼ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.8 $
 */
public class Value
{
	/** 1in  cm1in  2.54cm  */
	private static final double CM_P_IN = 2.54;
	/** 1in  pt1pt  1/72in  */
	private static final double PT_P_IN = 72;
	/** 1in  pc1pc  12pt  */
	private static final double PC_P_IN = 6;
	/** 1pc  pt1pc  12pt  */
	private static final double PT_P_PC = 12;
	
	/** Υǡ         */ public static final int DATA_HORIZONTAL = 1;
	/** Υǡ         */ public static final int DATA_VERTICAL   = 2;
	/** ˰̣ʤǡ */ public static final int DATA_NONE       = 0;
	
	/** ñ̤ʤ   */ public static final int UNIT_NONE    =  0;
	/** ñ̡em */ public static final int UNIT_EM      =  1;
	/** ñ̡ex */ public static final int UNIT_EX      =  2;
	/** ñ̡px */ public static final int UNIT_PX      =  3;
	/** ñ̡in */ public static final int UNIT_IN      =  4;
	/** ñ̡cm */ public static final int UNIT_CM      =  5;
	/** ñ̡mm */ public static final int UNIT_MM      =  6;
	/** ñ̡pt */ public static final int UNIT_PT      =  7;
	/** ñ̡pc */ public static final int UNIT_PC      =  8;
	/** ñ̡%  */ public static final int UNIT_PERCENT =  9;
	
	/**        */ public static final int TYPE_INTEGER    =  -1;
	/** Ĺ       */ public static final int TYPE_LENGTH     =  -2;
	/** ѡ */ public static final int TYPE_PERCENTAGE =  -3;
	/** ʸ     */ public static final int TYPE_STRING     =  -4;
	/**          */ public static final int TYPE_COLOR      =  -5;
	/** URL        */ public static final int TYPE_URL        =  -6;
	
	/** inherit              */ public static final int TYPE_KEY_INHERIT              =   1;
	/** normal               */ public static final int TYPE_KEY_NORMAL               =   2;
	/** none                 */ public static final int TYPE_KEY_NONE                 =   3;
	/** hidden               */ public static final int TYPE_KEY_HIDDEN               =  11;
	/** dotted               */ public static final int TYPE_KEY_DOTTED               =  12;
	/** dashed               */ public static final int TYPE_KEY_DASHED               =  13;
	/** solid                */ public static final int TYPE_KEY_SOLID                =  14;
	/** double               */ public static final int TYPE_KEY_DOUBLE               =  15;
	/** groove               */ public static final int TYPE_KEY_GROOVE               =  16;
	/** ridge                */ public static final int TYPE_KEY_RIDGE                =  17;
	/** inset                */ public static final int TYPE_KEY_INSET                =  18;
	/** outset               */ public static final int TYPE_KEY_OUTSET               =  19;
	/** thin                 */ public static final int TYPE_KEY_THIN                 =  21;
	/** medium               */ public static final int TYPE_KEY_MEDIUM               =  22;
	/** thick                */ public static final int TYPE_KEY_THICK                =  23;
	/** left                 */ public static final int TYPE_KEY_LEFT                 =  31;
	/** right                */ public static final int TYPE_KEY_RIGHT                =  32;
	/** center               */ public static final int TYPE_KEY_CENTER               =  33;
	/** justify              */ public static final int TYPE_KEY_JUSTIFY              =  34;
	/** both                 */ public static final int TYPE_KEY_BOTH                 =  35;
	/** baseline             */ public static final int TYPE_KEY_BASELINE             =  41;
	/** sub                  */ public static final int TYPE_KEY_SUB                  =  42;
	/** super                */ public static final int TYPE_KEY_SUPER                =  43;
	/** top                  */ public static final int TYPE_KEY_TOP                  =  44;
	/** text-top             */ public static final int TYPE_KEY_TEXT_TOP             =  45;
	/** middle               */ public static final int TYPE_KEY_MIDDLE               =  46;
	/** bottom               */ public static final int TYPE_KEY_BOTTOM               =  47;
	/** bottom               */ public static final int TYPE_KEY_TEXT_BOTTOM          =  48;
	/** pre                  */ public static final int TYPE_KEY_PRE                  =  51;
	/** nowrap               */ public static final int TYPE_KEY_NOWRAP               =  52;
	/** xx-small             */ public static final int TYPE_KEY_XX_SMALL             =  61;
	/** x-small              */ public static final int TYPE_KEY_X_SMALL              =  62;
	/** small                */ public static final int TYPE_KEY_SMALL                =  63;
	/** large                */ public static final int TYPE_KEY_LARGE                =  65;
	/** x-large              */ public static final int TYPE_KEY_X_LARGE              =  66;
	/** xx-large             */ public static final int TYPE_KEY_XX_LARGE             =  67;
	/** smaller              */ public static final int TYPE_KEY_SMALLER              =  68;
	/** larger               */ public static final int TYPE_KEY_LARGER               =  69;
	/** oblique              */ public static final int TYPE_KEY_OBLIQUE              =  71;
	/** italic               */ public static final int TYPE_KEY_ITALIC               =  72;
	/** bold                 */ public static final int TYPE_KEY_BOLD                 =  75;
	/** bolder               */ public static final int TYPE_KEY_BOLDER               =  76;
	/** lighter              */ public static final int TYPE_KEY_LIGHTER              =  77;
	/** disc                 */ public static final int TYPE_KEY_DISC                 =  81;
	/** circle               */ public static final int TYPE_KEY_CIRCLE               =  82;
	/** square               */ public static final int TYPE_KEY_SQUARE               =  83;
	/** decimal              */ public static final int TYPE_KEY_DECIMAL              =  84;
	/** decimal-leading-zero */ public static final int TYPE_KEY_DECIMAL_LEADING_ZERO =  85;
	/** lower-roman          */ public static final int TYPE_KEY_LOWER_ROMAN          =  86;
	/** upper-roman          */ public static final int TYPE_KEY_UPPER_ROMAN          =  87;
	/** hebrew               */ public static final int TYPE_KEY_HEBREW               =  88;
	/** georgian             */ public static final int TYPE_KEY_GEORGIAN             =  89;
	/** armenian             */ public static final int TYPE_KEY_ARMENIAN             =  90;
	/** cjk-ideographic      */ public static final int TYPE_KEY_CJK_IDEOGRAPHIC      =  91;
	/** hiragana             */ public static final int TYPE_KEY_HIRAGANA             =  92;
	/** katakana             */ public static final int TYPE_KEY_KATAKANA             =  93;
	/** hiragana-iroha       */ public static final int TYPE_KEY_HIRAGANA_IROHA       =  94;
	/** katakana-iroha       */ public static final int TYPE_KEY_KATAKANA_IROHA       =  95;
	/** lower-latin          */ public static final int TYPE_KEY_LOWER_LATIN          =  96;
	/** upper-latin          */ public static final int TYPE_KEY_UPPER_LATIN          =  97;
	/** lower-alpha          */ public static final int TYPE_KEY_LOWER_ALPHA          =  98;
	/** upper-alpha          */ public static final int TYPE_KEY_UPPER_ALPHA          =  99;
	/** lower-greek          */ public static final int TYPE_KEY_LOWER_GREEK          = 100;
	/** inside               */ public static final int TYPE_KEY_INSIDE               = 101;
	/** outside              */ public static final int TYPE_KEY_OUTSIDE              = 102;
	/** underline            */ public static final int TYPE_KEY_UNDERLINE            =  0x001000;
	/** overline             */ public static final int TYPE_KEY_OVERLINE             =  0x002000;
	/** line-through         */ public static final int TYPE_KEY_LINE_THROUGH         =  0x004000;
	/** blink                */ public static final int TYPE_KEY_BLINK                =  0x008000;
	/** transparent          */ public static final int TYPE_KEY_TRANSPARENT          =  901;
	
	/** ƤƱ */ public static final int INHERIT = TYPE_KEY_INHERIT;
	/** ̵   */ public static final int NONE    = TYPE_KEY_NONE   ;
	
	/** ܡ̵             */ public static final int BORDER_NONE        = TYPE_KEY_NONE        ;
	/** ܡɽ           */ public static final int BORDER_HIDDEN      = TYPE_KEY_HIDDEN      ;
	/** ܡ             */ public static final int BORDER_DOTTED      = TYPE_KEY_DOTTED      ;
	/** ܡ             */ public static final int BORDER_DASHED      = TYPE_KEY_DASHED      ;
	/** ܡ             */ public static final int BORDER_SOLID       = TYPE_KEY_SOLID       ;
	/** ܡ           */ public static final int BORDER_DOUBLE      = TYPE_KEY_DOUBLE      ;
	/** ܡѥ */ public static final int BORDER_GROOVE      = TYPE_KEY_GROOVE      ;
	/** ܡѥδ */ public static final int BORDER_RIDGE       = TYPE_KEY_RIDGE       ;
	/** ܡ¦       */ public static final int BORDER_INSET       = TYPE_KEY_INSET       ;
	/** ܡ¦δ       */ public static final int BORDER_OUTSET      = TYPE_KEY_OUTSET      ;
	
	/** ʸ             */ public static final int TD_UNDERLINE       = TYPE_KEY_UNDERLINE   ;
	/** ʸ             */ public static final int TD_OVERLINE        = TYPE_KEY_OVERLINE    ;
	/** ʸǤä       */ public static final int TD_STRIKE          = TYPE_KEY_LINE_THROUGH;
	/** ʸǤä       */ public static final int TD_BLINK           = TYPE_KEY_BLINK       ;
	
	/** ·                 */ public static final int ALIGN_LEFT         = TYPE_KEY_LEFT        ;
	/** ·               */ public static final int ALIGN_CENTER       = TYPE_KEY_CENTER      ;
	/** ·                 */ public static final int ALIGN_RIGHT        = TYPE_KEY_RIGHT       ;
	/** ·ξü·           */ public static final int ALIGN_JUSTIFY      = TYPE_KEY_JUSTIFY     ;
	
	/** ·١饤       */ public static final int VALIGN_BASELINE    = TYPE_KEY_BASELINE    ;
	/** ·դʸ         */ public static final int VALIGN_SUB         = TYPE_KEY_SUB         ;
	/** ·դʸ         */ public static final int VALIGN_SUPER       = TYPE_KEY_SUPER       ;
	/** ··           */ public static final int VALIGN_TOP         = TYPE_KEY_TOP         ;
	/** ·եȾ·   */ public static final int VALIGN_TEXT_TOP    = TYPE_KEY_TEXT_TOP    ;
	/** ·               */ public static final int VALIGN_MIDDLE      = TYPE_KEY_MIDDLE      ;
	/** ··           */ public static final int VALIGN_BOTTOM      = TYPE_KEY_BOTTOM      ;
	/** ·եȲ·   */ public static final int VALIGN_TEXT_BOTTOM = TYPE_KEY_TEXT_BOTTOM ;
	
	/**                  */ public static final int WHITESPACE_NORMAL  = TYPE_KEY_NONE        ;
	/** 򡦺ػ             */ public static final int WHITESPACE_PRE     = TYPE_KEY_PRE         ;
	/** 򡦵ͤ뤬̵     */ public static final int WHITESPACE_NOWRAP  = TYPE_KEY_NOWRAP      ;
	
	/** եȡ̵             */ public static final int FLOAT_NONE         = TYPE_KEY_NONE        ;
	/** եȡ           */ public static final int FLOAT_LEFT         = TYPE_KEY_LEFT        ;
	/** եȡ           */ public static final int FLOAT_RIGHT        = TYPE_KEY_RIGHT       ;
	
	/** ꥢ̵               */ public static final int CLEAR_NONE         = TYPE_KEY_NONE        ;
	/** ꥢ             */ public static final int CLEAR_LEFT         = TYPE_KEY_LEFT        ;
	/** ꥢ             */ public static final int CLEAR_RIGHT        = TYPE_KEY_RIGHT       ;
	/** ꥢξ¦               */ public static final int CLEAR_BOTH         = TYPE_KEY_BOTH        ;
	
	/** ꥹȡʤ                                                                    */ public static final int LIST_NONE                 = TYPE_KEY_NONE                ;
	/** ꥹȡ                                                                */ public static final int LIST_CUSTOM               = 911                          ;
	/** ̵ꥹȡǥե                                                      */ public static final int LIST_MIX                  = 912                          ;
	/** ̵ꥹȡ                                                            */ public static final int LIST_DISC                 = TYPE_KEY_DISC                ;
	/** ̵ꥹȡ                                                            */ public static final int LIST_CIRCLE               = TYPE_KEY_CIRCLE              ;
	/** դꥹȡͳ                                                            */ public static final int LIST_SQUARE               = TYPE_KEY_SQUARE              ;
	/** դꥹȡʿ 1  <code>1,2,3,4,5, ...</code>                     */ public static final int LIST_DECIMAL              = TYPE_KEY_DECIMAL             ;
	/** դꥹȡʿǾ̷˥ղ <code>01,02,03,04,05, ..., 99</code> */ public static final int LIST_DECIMAL_LEADING_ZERO = TYPE_KEY_DECIMAL_LEADING_ZERO;
	/** դꥹȡʸΥ޿ <code>i,ii,iii,iv,v, ...</code>              */ public static final int LIST_LOWER_ROMAN          = TYPE_KEY_LOWER_ROMAN         ;
	/** դꥹȡʸΥ޿ <code>I,II,III,IV,V, ...</code>              */ public static final int LIST_UPPER_ROMAN          = TYPE_KEY_UPPER_ROMAN         ;
	/** դꥹȡŪʥإ֥饤̤б                                  */ public static final int LIST_HEBREW               = TYPE_KEY_HEBREW              ;
	/** դꥹȡŪʥ른̤б <code>an,ban,gan, ...</code>     */ public static final int LIST_GEORGIAN             = TYPE_KEY_GEORGIAN            ;
	/** դꥹȡŪʥ˥̤б                                */ public static final int LIST_ARMENIAN             = TYPE_KEY_ARMENIAN            ;
	/** դꥹȡ <code>, , , ...</code>                             */ public static final int LIST_CJK_IDEOGRAPHIC      = TYPE_KEY_CJK_IDEOGRAPHIC     ;
	/** դꥹȡʿ̾ <code>,,,,, ...</code>                         */ public static final int LIST_HIRAGANA             = TYPE_KEY_HIRAGANA            ;
	/** դꥹȡҲ̾ <code>,,,,, ...</code>                         */ public static final int LIST_KATAKANA             = TYPE_KEY_KATAKANA            ;
	/** դꥹȡʿ̾Τ <code>,,,, ...</code>                    */ public static final int LIST_HIRAGANA_IROHA       = TYPE_KEY_HIRAGANA_IROHA      ;
	/** դꥹȡҲ̾Τ <code>,,,, ...</code>                    */ public static final int LIST_KATAKANA_IROHA       = TYPE_KEY_KATAKANA_IROHA      ;
	/** դꥹȡʸΥ <code>a,b,c,d,e, ...</code>                    */ public static final int LIST_LOWER_LATIN          = TYPE_KEY_LOWER_LATIN         ;
	/** դꥹȡʸΥ <code>A,B,C,D,E, ...</code>                    */ public static final int LIST_UPPER_LATIN          = TYPE_KEY_UPPER_LATIN         ;
	/** դꥹȡʸΥ <code>a,b,c,d,e, ...</code>                    */ public static final int LIST_LOWER_ALPHA          = TYPE_KEY_LOWER_ALPHA         ;
	/** դꥹȡʸΥ <code>A,B,C,D,E, ...</code>                    */ public static final int LIST_UPPER_ALPHA          = TYPE_KEY_UPPER_ALPHA         ;
	/** դꥹȡʸθ奮ꥷʸ <code>&#941,&#942,&#943, ...</code>    */ public static final int LIST_LOWER_GREEK          = TYPE_KEY_LOWER_GREEK         ;
	
	/**  */ protected int     type      = 0;
	/** פ */ protected boolean important = false;
	/**    */ protected Number  number    = null;
	/** ʸ */ protected String  string    = null;
	/**      */ protected Color   color     = null;
	/** URL    */ protected String  url       = null;
	/** ñ   */ protected int     unit      = UNIT_NONE;
	
	/**
	 * Υץѥƥͤޤ
	 * ɬեɤͤꤷʤФʤޤ
	 */
	protected Value()
	{
	}
	
	/**
	 * ɥפΥץѥƥͤޤ
	 * ʸɽꤵʤΤǡ{@link #toString()} ᥽åɤǤϡ
	 * פ֤ͤ褦ˤʤޤ
	 * 
	 * @param     type   
	 */
	public Value(int type)
	{
		this.type = type;
	}
	
	/**
	 * ɥפΥץѥƥͤޤ
	 * 
	 * @param     type   
	 * @param     string ʸɽ
	 */
	public Value(int type, String string)
	{
		this.type   = type;
		this.string = string;
	}
	
	/**
	 * ͤ¿ͥפΥץѥƥͤޤ
	 * 
	 * @param     value ͡{@link Long}  {@link Double} Υ󥹥󥹤Τߡ
	 * @param     unit  ñ
	 */
	public Value(Number value, int unit)
	{
		if (!(value instanceof Long || value instanceof Double))
			throw new IllegalArgumentException("invalid value type");
		
		switch (unit) {
		case UNIT_NONE   : this.type = TYPE_INTEGER   ; break;
		case UNIT_PERCENT: this.type = TYPE_PERCENTAGE; break;
		default          : this.type = TYPE_LENGTH    ; break;
		}
		this.number = value;
		this.unit   = unit;
	}
	
	/**
	 * ͤ¿ͥפΥץѥƥͤޤ
	 * 
	 * @param     value 
	 * @param     unit  ñ
	 */
	public Value(long value, int unit)
	{
		switch (unit) {
		case UNIT_NONE   : this.type = TYPE_INTEGER   ; break;
		case UNIT_PERCENT: this.type = TYPE_PERCENTAGE; break;
		default          : this.type = TYPE_LENGTH    ; break;
		}
		this.number = new Long(value);
		this.unit   = unit;
	}
	
	/**
	 * ͤ¿ͥפΥץѥƥͤޤ
	 * 
	 * @param     value 
	 * @param     unit  ñ
	 */
	public Value(double value, int unit)
	{
		switch (unit) {
		case UNIT_NONE   : this.type = TYPE_INTEGER   ; break;
		case UNIT_PERCENT: this.type = TYPE_PERCENTAGE; break;
		default          : this.type = TYPE_LENGTH    ; break;
		}
		this.number = new Double(value);
		this.unit   = unit;
	}
	
	/**
	 * ʸ󥿥פΥץѥƥͤޤ
	 * 
	 * @param     value 
	 */
	public Value(String value)
	{
		this.type   = TYPE_STRING;
		this.string = value;
	}
	
	/**
	 * פΥץѥƥͤޤ
	 * 
	 * @param     value 
	 */
	public Value(Color value)
	{
		this.type  = TYPE_COLOR;
		this.color = value;
	}
	
	/**
	 * URL פΥץѥƥͤޤ
	 * 
	 * @param     value 
	 * @param     flag  ե饰ͽ
	 */
	public Value(String value, int flag)
	{
		this.type = TYPE_URL;
		this.url  = value;
	}
	
	/**
	 * ɥפɤ֤ޤ
	 * 
	 * @return    ɥפξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean isKeyword()
	{
		return (type > 0);
	}
	
	/**
	 * ɥפξΥפ֤ޤ
	 * 
	 * @return    
	 */
	public int getType()
	{
		return type;
	}
	
	/**
	 * ͤ¿ͥפξ֤ͤޤ
	 * ⤷ǽǤ {@link Long} Υ󥹥󥹡
	 * Ǥʤ {@link Double} Υ󥹥󥹤Ǥ
	 * ɥפξ <code>null</code> ֤ޤ
	 * 
	 * @return    
	 */
	public Number getNumber()
	{
		return number;
	}
	
	/**
	 * ͤ¿ͥפξǤС<code>int</code> ֤ͤޤ
	 * ⤷ΥפǤϤʤϡ<code>0</code> ֤ޤ
	 * 
	 * @return    
	 */
	public int intValue()
	{
		if (number == null)
			return 0;
		return number.intValue();
	}
	
	/**
	 * ʸ󥿥פξ֤ͤޤ
	 * 
	 * @return    
	 */
	public String getString()
	{
		return string;
	}
	
	/**
	 * פξ֤ͤޤ
	 * 
	 * @return    
	 */
	public Color getColor()
	{
		return color;
	}
	
	/**
	 * URL פξ֤ͤޤ
	 * 
	 * @return    
	 */
	public String getURL()
	{
		return url;
	}
	
	/**
	 * ͤ¿ͥפξñ̤֤ޤ
	 * 
	 * @return    ñ
	 */
	public int getUnit()
	{
		return unit;
	}
	
	/**
	 * ǽ׵§ꤵƤ뤫֤ޤ
	 * 
	 * @return    ꤵƤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getImportant()
	{
		return important;
	}
	
	/**
	 * ͡ĹѡȤξˡͤ׻ƥԥ֤ͤޤ
	 * 
	 * @param     fd ˤեȥǡ
	 * @param     px ˤԥ
	 * @param     sense 
	 * 
	 * @return    ԥ
	 */
	public int getValue(FontData fd, int px, int sense)
	{
		if (number == null)
			return 0;
		
		// 1in  px
		int PX_P_IN = Environment.screenResolution;
		
		switch (unit) {
		case UNIT_NONE   : return number.intValue();
		case UNIT_EM     : return (int)Math.round(number.doubleValue() * (sense == DATA_HORIZONTAL ? fd.getFullSize().width : fd.getFullSize().height));
		case UNIT_EX     : return (int)Math.round(number.doubleValue() * fd.getXHeight());
		case UNIT_PX     : return number.intValue();
		case UNIT_IN     : return (int)Math.round(number.doubleValue() * PX_P_IN               );
		case UNIT_CM     : return (int)Math.round(number.doubleValue() * PX_P_IN / CM_P_IN     );
		case UNIT_MM     : return (int)Math.round(number.doubleValue() * PX_P_IN / CM_P_IN / 10);
		case UNIT_PT     : return (int)Math.round(number.doubleValue() * PX_P_IN / PT_P_IN     );
		case UNIT_PC     : return (int)Math.round(number.doubleValue() * PX_P_IN / PC_P_IN     );
		case UNIT_PERCENT: return (int)Math.round(number.doubleValue() * px / 100              );
		}
		return 0;
	}
	
	/**
	 * ܡξˡͤ׻ƥԥ֤ͤޤ
	 * 
	 * @param     fd ˤեȥǡ
	 * @param     px ˤԥ
	 * @param     sense 
	 * 
	 * @return    ԥ
	 */
	public int getBorderWidth(FontData fd, int px, int sense)
	{
		switch (type) {
		case TYPE_KEY_THIN  : return 1;
		case TYPE_KEY_MEDIUM: return 2;
		case TYPE_KEY_THICK : return 3;
		}
		
		return getValue(fd, px, sense);
	}
	
	/**
	 * Υȡʸɽ֤ޤ
	 * 
	 * @return    ʸɽ
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		switch (type) {
		case TYPE_INTEGER   :
		case TYPE_LENGTH    :
		case TYPE_PERCENTAGE:
			{
				DecimalFormat df = new DecimalFormat("0.#");
				if (number instanceof Long)
					sb.append(df.format(number.longValue  ()));
				else
					sb.append(df.format(number.doubleValue()));
				switch (unit) {
				case UNIT_EM     : sb.append("em"); break;
				case UNIT_EX     : sb.append("ex"); break;
				case UNIT_PX     : sb.append("px"); break;
				case UNIT_IN     : sb.append("in"); break;
				case UNIT_CM     : sb.append("cm"); break;
				case UNIT_MM     : sb.append("mm"); break;
				case UNIT_PT     : sb.append("pt"); break;
				case UNIT_PC     : sb.append("pc"); break;
				case UNIT_PERCENT: sb.append("%" ); break;
				}
			}
			break;
		case TYPE_STRING:
			sb.append(string);
			break;
		case TYPE_COLOR:
			sb.append(color.toString());
			break;
		case TYPE_URL:
			sb.append(url);
			break;
		default:
			if (string == null)
				string = String.valueOf(type);
			sb.append(string);
			break;
		}
		
		if (important)
			sb.append(" !important");
		
		return sb.toString();
	}
}
