/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import java.util.Hashtable;

/**
 * ȡΥפ̤ޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class TokenTypes
{
	/** ̾ */
	public final static int CONTENT_NORMAL    = 0;
	/** ȡޤޤʤ */
	public final static int CONTENT_NOTOKEN   = 1;
	/** ڥΥȡǡǤ¾Υȡޤǽ */
	public final static int CONTENT_PAIRTOKEN = 2;
	
	/**                */ public final static int UNKNOWN          =   -1;
	/** ƥ           */ public final static int TEXT             =    2;
	/** DTD                */ public final static int DTD              =    3;
	/**            */ public final static int COMMENT          =    4;
	/** ̿           */ public final static int PI               =    5;
	/** ¾             */ public final static int MISC             =    0;
	
	/** ʸ񳫻           */ public final static int HTML_START       = 1001;
	/** ʸλ           */ public final static int HTML_END         = 1002;
	
	/** إå       */ public final static int HEAD_START       = 2001;
	/** إåλ       */ public final static int HEAD_END         = 2002;
	
	/** ȥ볫       */ public final static int TITLE_START      = 2011;
	/** ȥ뽪λ       */ public final static int TITLE_END        = 2012;
	/** ١             */ public final static int BASE             = 2013;
	/** ץȳ     */ public final static int SCRIPT_START     = 2015;
	/** ץȽλ     */ public final static int SCRIPT_END       = 2016;
	/** 볫       */ public final static int STYLE_START      = 2017;
	/** 뽪λ       */ public final static int STYLE_END        = 2018;
	/** ᥿           */ public final static int META             = 2019;
	/** 󥯾         */ public final static int LINK             = 2021;
	
	/** ե졼ॻåȳ */ public final static int FRAMESET_START   = 2041;
	/** ե졼ॻåȽλ */ public final static int FRAMESET_END     = 2042;
	/** ե졼           */ public final static int FRAME            = 2043;
	/** ե졼̵   */ public final static int NOFRAMES_START   = 2045;
	/** ե졼̵λ   */ public final static int NOFRAMES_END     = 2046;
	
	private final static int BODY_TYPE_START                           = 3001;
	/** ʸ           */ public final static int BODY_START       = 3001;
	/** ʸλ           */ public final static int BODY_END         = 3002;
	
	//### block
	private final static int BLOCK_TYPE_START                          = 3101;
	/**            */ public final static int P_START          = 3101;
	/** λ           */ public final static int P_END            = 3102;
	/** Ф1        */ public final static int H1_START         = 3103;
	/** Ф1λ        */ public final static int H1_END           = 3104;
	/** Ф2        */ public final static int H2_START         = 3105;
	/** Ф2λ        */ public final static int H2_END           = 3106;
	/** Ф3        */ public final static int H3_START         = 3107;
	/** Ф3λ        */ public final static int H3_END           = 3108;
	/** Ф4        */ public final static int H4_START         = 3109;
	/** Ф4λ        */ public final static int H4_END           = 3110;
	/** Ф5        */ public final static int H5_START         = 3111;
	/** Ф5λ        */ public final static int H5_END           = 3112;
	/** Ф6        */ public final static int H6_START         = 3113;
	/** Ф6λ        */ public final static int H6_END           = 3114;
	/** վ񤭳       */ public final static int UL_START         = 3115;
	/** վ񤭽λ       */ public final static int UL_END           = 3116;
	/** ꥹȳ     */ public final static int OL_START         = 3117;
	/** ꥹȽλ     */ public final static int OL_END           = 3118;
	/** ǥ쥯ȥ곫   */ public final static int DIR_START        = 3119;
	/** ǥ쥯ȥ꽪λ   */ public final static int DIR_END          = 3120;
	/** ˥塼       */ public final static int MENU_START       = 3121;
	/** ˥塼λ       */ public final static int MENU_END         = 3122;
	/** ꥹȹܳ     */ public final static int LI_START         = 3123;
	/** ꥹȹܽλ     */ public final static int LI_END           = 3124;
	/** ꥹȳ     */ public final static int DL_START         = 3125;
	/** ꥹȽλ     */ public final static int DL_END           = 3126;
	/** 쳫         */ public final static int DT_START         = 3127;
	/** 콪λ         */ public final static int DT_END           = 3128;
	/**      */ public final static int DD_START         = 3129;
	/** λ     */ public final static int DD_END           = 3130;
	/** Ѥ   */ public final static int PRE_START        = 3131;
	/** Ѥλ   */ public final static int PRE_END          = 3132;
	/** ֥å       */ public final static int DIV_START        = 3133;
	/** ֥åλ       */ public final static int DIV_END          = 3134;
	// NOSCRIPT ϥ饤Ͽ
	/** ʸ         */ public final static int BLOCKQUOTE_START = 3137;
	/** ʸλ         */ public final static int BLOCKQUOTE_END   = 3138;
	/**                  */ public final static int HR               = 3139;
	/** ɥ쥹       */ public final static int ADDRESS_START    = 3141;
	/** ɥ쥹λ       */ public final static int ADDRESS_END      = 3142;
	/** 󥿥󥰳   */ public final static int CENTER_START     = 3143;      // 侩
	/** 󥿥󥰽λ   */ public final static int CENTER_END       = 3144;      // 侩
	/** ۥ֥å   */ public final static int _BLOCK_START     = 3191;
	/** ۥ֥åλ   */ public final static int _BLOCK_END       = 3192;
	private final static int BLOCK_TYPE_END                            = 3200;
	
	//### inline
	private final static int INLINE_TYPE_START                         = 3201;
	/** 󥫡       */ public final static int A_START          = 3201;
	/** 󥫡λ       */ public final static int A_END            = 3202;
	/** ᡼           */ public final static int IMG              = 3203;
	/**                */ public final static int BR               = 3205;
	/** SPAN           */ public final static int SPAN_START       = 3207;
	/** SPAN λ          */ public final static int SPAN_END         = 3208;
	/** EM             */ public final static int EM_START         = 3221;
	/** EM λ            */ public final static int EM_END           = 3222;
	/** STRONG         */ public final static int STRONG_START     = 3223;
	/** STRONG λ        */ public final static int STRONG_END       = 3224;
	/** DFN            */ public final static int DFN_START        = 3225;
	/** DFN λ           */ public final static int DFN_END          = 3226;
	/** CODE           */ public final static int CODE_START       = 3227;
	/** CODE λ          */ public final static int CODE_END         = 3228;
	/** Q              */ public final static int Q_START          = 3229;
	/** Q λ             */ public final static int Q_END            = 3230;
	/** SUB            */ public final static int SUB_START        = 3231;
	/** SUB λ           */ public final static int SUB_END          = 3232;
	/** SUP            */ public final static int SUP_START        = 3233;
	/** SUP λ           */ public final static int SUP_END          = 3234;
	/** SAMP           */ public final static int SAMP_START       = 3235;
	/** SAMP λ          */ public final static int SAMP_END         = 3236;
	/** KBD            */ public final static int KBD_START        = 3237;
	/** KBD λ           */ public final static int KBD_END          = 3238;
	/** VAR            */ public final static int VAR_START        = 3239;
	/** VAR λ           */ public final static int VAR_END          = 3240;
	/** CITE           */ public final static int CITE_START       = 3241;
	/** CITE λ          */ public final static int CITE_END         = 3242;
	/** ABBR           */ public final static int ABBR_START       = 3243;
	/** ABBR λ          */ public final static int ABBR_END         = 3244;
	/** ACRONYM        */ public final static int ACRONYM_START    = 3245;
	/** ACRONYM λ       */ public final static int ACRONYM_END      = 3246;
	/** TT             */ public final static int TT_START         = 3261;
	/** TT λ            */ public final static int TT_END           = 3262;
	/** I              */ public final static int I_START          = 3263;
	/** I λ             */ public final static int I_END            = 3264;
	/** B              */ public final static int B_START          = 3265;
	/** B λ             */ public final static int B_END            = 3266;
	/** BIG            */ public final static int BIG_START        = 3267;
	/** BIG λ           */ public final static int BIG_END          = 3268;
	/** SMALL          */ public final static int SMALL_START      = 3269;
	/** SMALL λ         */ public final static int SMALL_END        = 3270;
	/** U              */ public final static int U_START          = 3271;    // 侩
	/** U λ             */ public final static int U_END            = 3272;    // 侩
	/** S              */ public final static int S_START          = 3273;    // 侩
	/** S λ             */ public final static int S_END            = 3274;    // 侩
	/** STRIKE         */ public final static int STRIKE_START     = 3275;    // 侩
	/** STRIKE λ        */ public final static int STRIKE_END       = 3276;    // 侩
	/** FONT           */ public final static int FONT_START       = 3277;    // 侩
	/** FONT λ          */ public final static int FONT_END         = 3278;    // 侩
	/** 󥹥ץȳ   */ public final static int NOSCRIPT_START   = 3291;    // ϥ֥å
	/** 󥹥ץȽλ   */ public final static int NOSCRIPT_END     = 3292;    // ϥ֥å
	private final static int INLINE_TYPE_END                           = 3300;
	
	//### ruby
	private final static int RUBY_TYPE_START                           = 3301;
	/** RUBY           */ public final static int RUBY_START       = 3301;
	/** RUBY λ          */ public final static int RUBY_END         = 3302;
	/** RB             */ public final static int RB_START         = 3303;
	/** RB λ            */ public final static int RB_END           = 3304;
	/** RP             */ public final static int RP_START         = 3305;
	/** RP λ            */ public final static int RP_END           = 3306;
	/** RT             */ public final static int RT_START         = 3307;
	/** RT λ            */ public final static int RT_END           = 3308;
	private final static int RUBY_TYPE_END                             = 3310;
	
	//### table
	private final static int TABLE_TYPE_START                          = 3401;
	/** TABLE          */ public final static int TABLE_START      = 3401;
	/** TABLE λ         */ public final static int TABLE_END        = 3402;
	/** CAPTION        */ public final static int CAPTION_START    = 3403;
	/** CAPTION λ       */ public final static int CAPTION_END      = 3404;
	/** THEAD          */ public final static int THEAD_START      = 3411;
	/** THEAD λ         */ public final static int THEAD_END        = 3412;
	/** TBODY          */ public final static int TBODY_START      = 3413;
	/** TBODY λ         */ public final static int TBODY_END        = 3414;
	/** TFOOT          */ public final static int TFOOT_START      = 3415;
	/** TFOOT λ         */ public final static int TFOOT_END        = 3416;
	/** TR             */ public final static int TR_START         = 3421;
	/** TR λ            */ public final static int TR_END           = 3422;
	/** TH             */ public final static int TH_START         = 3431;
	/** TH λ            */ public final static int TH_END           = 3432;
	/** TD             */ public final static int TD_START         = 3433;
	/** TD λ            */ public final static int TD_END           = 3434;
	private final static int TABLE_TYPE_END                            = 3450;
	
	//### form
	private final static int FORM_TYPE_START                           = 3501;
	/** FORM           */ public final static int FORM_START       = 3501;
	/** FORM λ          */ public final static int FORM_END         = 3502;
	/** INPUT          */ public final static int INPUT            = 3503;
	/** SELECT         */ public final static int SELECT_START     = 3505;
	/** SELECT λ        */ public final static int SELECT_END       = 3506;
	/** OPTGROUP       */ public final static int OPTGROUP_START   = 3507;
	/** OPTGROUP λ      */ public final static int OPTGROUP_END     = 3508;
	/** OPTION         */ public final static int OPTION_START     = 3509;
	/** OPTION λ        */ public final static int OPTION_END       = 3510;
	/** TEXTAREA       */ public final static int TEXTAREA_START   = 3511;
	/** TEXTAREA λ      */ public final static int TEXTAREA_END     = 3512;
	/** BUTTON         */ public final static int BUTTON_START     = 3513;
	/** BUTTON λ        */ public final static int BUTTON_END       = 3514;
	/** FIELDSET       */ public final static int FIELDSET_START   = 3515;
	/** FIELDSET λ      */ public final static int FIELDSET_END     = 3516;
	/** LEGEND         */ public final static int LEGEND_START     = 3517;
	/** LEGEND λ        */ public final static int LEGEND_END       = 3518;
	/** LABEL          */ public final static int LABEL_START      = 3519;
	/** LABEL λ         */ public final static int LABEL_END        = 3520;
	private final static int FORM_TYPE_END                             = 3550;
	
	private final static int BODY_TYPE_END                             = 4000;
	
	private final static Hashtable names = new Hashtable();
	
	/**
	 * ꤵ줿פ BODY ʬξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    BODY ʬξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isBody(int type)
	{
		return (BODY_TYPE_START <= type && type <= BODY_TYPE_END);
	}
	
	/**
	 * ꤵ줿פ֥åǤξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    ֥åǤξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isBlock(int type)
	{
		return ((BLOCK_TYPE_START <= type && type <= BLOCK_TYPE_END) ||
		        type == TABLE_START    ||
		        type == TABLE_END      ||
		        type == FORM_START     ||
		        type == FORM_END       ||
		        type == FIELDSET_START ||
		        type == FIELDSET_END);
	}
	
	/**
	 * ꤵ줿פΥ֥åǤȤư
	 * <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    Υ֥åǤȤư <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isBlockEx(int type)
	{
		return ((BLOCK_TYPE_START <= type && type <= BLOCK_TYPE_END) ||
		        type == TH_START       ||
		        type == TH_END         ||
		        type == TD_START       ||
		        type == TD_END         ||
		        type == BODY_START     ||
		        type == BODY_END       ||
		        type == FORM_START     ||
		        type == FORM_END       ||
		        type == FIELDSET_START ||
		        type == FIELDSET_END);
	}
	
	/**
	 * ꤵ줿פ饤Ǥξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    饤Ǥξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isInline(int type)
	{
		return ((INLINE_TYPE_START <= type && type <= INLINE_TYPE_END) ||
		        type == RUBY_START || type == RUBY_END);
	}
	
	/**
	 * ꤵ줿פǤξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    Ǥξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isRuby(int type)
	{
		return (RUBY_TYPE_START <= type && type <= RUBY_TYPE_END);
	}
	
	/**
	 * ꤵ줿פӤǤξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    ӤǤξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isRubyItem(int type)
	{
		return (RUBY_TYPE_START <= type && type <= RUBY_TYPE_END &&
		        type != RUBY_START && type != RUBY_END);
	}
	
	/**
	 * ꤵ줿פơ֥Ǥξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    ơ֥Ǥξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isTable(int type)
	{
		return (TABLE_TYPE_START <= type && type <= TABLE_TYPE_END);
	}
	
	/**
	 * ꤵ줿פơ֥Ǥξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    ơ֥Ǥξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isTableItem(int type)
	{
		return (TABLE_TYPE_START <= type && type <= TABLE_TYPE_END &&
		        type != TABLE_START && type != TABLE_END);
	}
	
	/**
	 * ꤵ줿פեǤξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    եǤξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isForm(int type)
	{
		return (FORM_TYPE_START <= type && type <= FORM_TYPE_END);
	}
	
	/**
	 * ꤵ줿פեǤξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    եǤξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isFormItem(int type)
	{
		return (FORM_TYPE_START <= type && type <= FORM_TYPE_END &&
		        type != FORM_START && type != FORM_END);
	}
	
	/**
	 * ꤵ줿פǤξ <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    Ǥξ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean isEmpty(int type)
	{
		switch (type) {
		// header
		case BASE :
		case META :
		case LINK :
		// frame
		case FRAME:
		// block
		case HR   :
		// inline
		case IMG  :
		case BR   :
		// form
		case INPUT:
			return true;
		}
		
		return false;
	}
	
	/**
	 * Ȥ᤻ˡȡȤȤ¸뤫֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    {@link #CONTENT_NORMAL}
	 *            {@link #CONTENT_NOTOKEN}
	 *            {@link #CONTENT_PAIRTOKEN} Τ줫
	 */
	public static final int isContent(int type)
	{
		switch (type) {
		case SCRIPT_START  :
		case STYLE_START   :
		case TITLE_START   :
		case TEXTAREA_START:
			return CONTENT_PAIRTOKEN;
		case OPTION_START  :
			return CONTENT_NOTOKEN;
		}
		
		return CONTENT_NORMAL;
	}
	
	/**
	 * ꤵ줿פƥȥȡޤळȤ
	 * <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    ޤळȤǽʾ <code>true</code>
	 *            Ǥʤ <code>false</code>
	 */
	public static final boolean canHaveText(int type)
	{
		switch (type) {
		case HTML_START      : return false;
		// header
		case HEAD_START      : return false;
		
		case TITLE_START     : return true;
		case BASE            : return false;
		case SCRIPT_START    : return true;
		case STYLE_START     : return true;
		case META            : return false;
		case LINK            : return false;
		// frame
		case FRAMESET_START  : return false;
		case FRAME           : return false;
		case NOFRAMES_START  : return true;
		// body
		case BODY_START      : return false;
		// block
		case P_START         : return true;
		case H1_START        : return true;
		case H2_START        : return true;
		case H3_START        : return true;
		case H4_START        : return true;
		case H5_START        : return true;
		case H6_START        : return true;
		case UL_START        : return false;
		case OL_START        : return false;
		case DIR_START       : return false;
		case MENU_START      : return false;
		case LI_START        : return true;
		case DL_START        : return false;
		case DT_START        : return true;
		case DD_START        : return true;
		case PRE_START       : return true;
		case DIV_START       : return true;
		case BLOCKQUOTE_START: return false;
		case HR              : return false;
		case ADDRESS_START   : return true;
		case CENTER_START    : return true;
		case _BLOCK_START    : return true;
		// inline
		case A_START         : return true;
		case IMG             : return false;
		case BR              : return false;
		case SPAN_START      : return true;
		case EM_START        : return true;
		case STRONG_START    : return true;
		case DFN_START       : return true;
		case CODE_START      : return true;
		case Q_START         : return true;
		case SUB_START       : return true;
		case SUP_START       : return true;
		case SAMP_START      : return true;
		case KBD_START       : return true;
		case VAR_START       : return true;
		case CITE_START      : return true;
		case ABBR_START      : return true;
		case ACRONYM_START   : return true;
		case TT_START        : return true;
		case I_START         : return true;
		case B_START         : return true;
		case BIG_START       : return true;
		case SMALL_START     : return true;
		case U_START         : return true;
		case S_START         : return true;
		case STRIKE_START    : return true;
		case FONT_START      : return true;
		case NOSCRIPT_START  : return true;
		// ruby
		case RUBY_START      : return false;
		case RB_START        : return true;
		case RP_START        : return true;
		case RT_START        : return true;
		// table
		case TABLE_START     : return true;
		case CAPTION_START   : return true;
		case THEAD_START     : return true;
		case TBODY_START     : return true;
		case TFOOT_START     : return true;
		case TR_START        : return true;
		case TH_START        : return true;
		case TD_START        : return true;
		// form
		case FORM_START      : return true;
		case INPUT           : return false;
		case SELECT_START    : return false;
		case OPTGROUP_START  : return false;
		case OPTION_START    : return true;
		case TEXTAREA_START  : return true;
		case BUTTON_START    : return true;
		case FIELDSET_START  : return true;
		case LEGEND_START    : return true;
		case LABEL_START     : return true;
		}
		return false;
	}
	
	/**
	 * ꤵ줿ˡ֥åǤƤ
	 * <code>true</code> ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    ֥åǤƤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static final boolean canHaveBlock(int type)
	{
		switch (type) {
		case NOFRAMES_START  :
		case NOFRAMES_END    :
		case BODY_START      :
		case BODY_END        :
		// block
		case LI_START        :
		case LI_END          :
		case DD_START        :
		case DD_END          :
		case DIV_START       :
		case DIV_END         :
		case BLOCKQUOTE_START:
		case BLOCKQUOTE_END  :
		case CENTER_START    :
		case CENTER_END      :
		case NOSCRIPT_START  :
		case NOSCRIPT_END    :
		// table
		case TH_START        :
		case TH_END          :
		case TD_START        :
		case TD_END          :
			return true;
		}
		return false;
	}
	
	/**
	 * ꤵ줿פʸɽ֤ޤ
	 * 
	 * @param     type ȡ󥿥
	 * 
	 * @return    ʸɽ
	 *            ʾ <code>null</code>
	 */
	public static final String getName(int type)
	{
		switch (type) {
		case HTML_START      : return "html"      ;
		case HTML_END        : return "html"      ;
		// header
		case HEAD_START      : return "head"      ;
		case HEAD_END        : return "head"      ;
		
		case TITLE_START     : return "title"     ;
		case TITLE_END       : return "title"     ;
		case BASE            : return "base"      ;
		case SCRIPT_START    : return "script"    ;
		case SCRIPT_END      : return "script"    ;
		case STYLE_START     : return "style"     ;
		case STYLE_END       : return "style"     ;
		case META            : return "meta"      ;
		case LINK            : return "link"      ;
		// frame
		case FRAMESET_START  : return "frameset"  ;
		case FRAMESET_END    : return "frameset"  ;
		case FRAME           : return "frame"     ;
		case NOFRAMES_START  : return "noframes"  ;
		case NOFRAMES_END    : return "noframes"  ;
		// body
		case BODY_START      : return "body"      ;
		case BODY_END        : return "body"      ;
		// block
		case P_START         : return "p"         ;
		case P_END           : return "p"         ;
		case H1_START        : return "h1"        ;
		case H1_END          : return "h1"        ;
		case H2_START        : return "h2"        ;
		case H2_END          : return "h2"        ;
		case H3_START        : return "h3"        ;
		case H3_END          : return "h3"        ;
		case H4_START        : return "h4"        ;
		case H4_END          : return "h4"        ;
		case H5_START        : return "h5"        ;
		case H5_END          : return "h5"        ;
		case H6_START        : return "h6"        ;
		case H6_END          : return "h6"        ;
		case UL_START        : return "ul"        ;
		case UL_END          : return "ul"        ;
		case OL_START        : return "ol"        ;
		case OL_END          : return "ol"        ;
		case DIR_START       : return "dir"       ;
		case DIR_END         : return "dir"       ;
		case MENU_START      : return "menu"      ;
		case MENU_END        : return "menu"      ;
		case LI_START        : return "li"        ;
		case LI_END          : return "li"        ;
		case DL_START        : return "dl"        ;
		case DL_END          : return "dl"        ;
		case DT_START        : return "dt"        ;
		case DT_END          : return "dt"        ;
		case DD_START        : return "dd"        ;
		case DD_END          : return "dd"        ;
		case PRE_START       : return "pre"       ;
		case PRE_END         : return "pre"       ;
		case DIV_START       : return "div"       ;
		case DIV_END         : return "div"       ;
		case BLOCKQUOTE_START: return "blockquote";
		case BLOCKQUOTE_END  : return "blockquote";
		case HR              : return "hr"        ;
		case ADDRESS_START   : return "address"   ;
		case ADDRESS_END     : return "address"   ;
		case CENTER_START    : return "center"    ;
		case CENTER_END      : return "center"    ;
		case _BLOCK_START    : return "_block"    ;
		case _BLOCK_END      : return "_block"    ;
		// inline
		case A_START         : return "a"         ;
		case A_END           : return "a"         ;
		case IMG             : return "img"       ;
		case BR              : return "br"        ;
		case SPAN_START      : return "span"      ;
		case SPAN_END        : return "span"      ;
		case EM_START        : return "em"        ;
		case EM_END          : return "em"        ;
		case STRONG_START    : return "strong"    ;
		case STRONG_END      : return "strong"    ;
		case DFN_START       : return "dfn"       ;
		case DFN_END         : return "dfn"       ;
		case CODE_START      : return "code"      ;
		case CODE_END        : return "code"      ;
		case Q_START         : return "q"         ;
		case Q_END           : return "q"         ;
		case SUB_START       : return "sub"       ;
		case SUB_END         : return "sub"       ;
		case SUP_START       : return "sup"       ;
		case SUP_END         : return "sup"       ;
		case SAMP_START      : return "samp"      ;
		case SAMP_END        : return "samp"      ;
		case KBD_START       : return "kbd"       ;
		case KBD_END         : return "kbd"       ;
		case VAR_START       : return "var"       ;
		case VAR_END         : return "var"       ;
		case CITE_START      : return "cite"      ;
		case CITE_END        : return "cite"      ;
		case ABBR_START      : return "abbr"      ;
		case ABBR_END        : return "abbr"      ;
		case ACRONYM_START   : return "acronym"   ;
		case ACRONYM_END     : return "acronym"   ;
		case TT_START        : return "tt"        ;
		case TT_END          : return "tt"        ;
		case I_START         : return "i"         ;
		case I_END           : return "i"         ;
		case B_START         : return "b"         ;
		case B_END           : return "b"         ;
		case BIG_START       : return "big"       ;
		case BIG_END         : return "big"       ;
		case SMALL_START     : return "small"     ;
		case SMALL_END       : return "small"     ;
		case U_START         : return "u"         ;
		case U_END           : return "u"         ;
		case S_START         : return "s"         ;
		case S_END           : return "s"         ;
		case STRIKE_START    : return "strike"    ;
		case STRIKE_END      : return "strike"    ;
		case FONT_START      : return "font"      ;
		case FONT_END        : return "font"      ;
		case NOSCRIPT_START  : return "noscript"  ;
		case NOSCRIPT_END    : return "noscript"  ;
		// ruby
		case RUBY_START      : return "ruby"      ;
		case RUBY_END        : return "ruby"      ;
		case RB_START        : return "rb"        ;
		case RB_END          : return "rb"        ;
		case RP_START        : return "rp"        ;
		case RP_END          : return "rp"        ;
		case RT_START        : return "rt"        ;
		case RT_END          : return "rt"        ;
		// table
		case TABLE_START     : return "table"     ;
		case TABLE_END       : return "table"     ;
		case CAPTION_START   : return "caption"   ;
		case CAPTION_END     : return "caption"   ;
		case THEAD_START     : return "thead"     ;
		case THEAD_END       : return "thead"     ;
		case TBODY_START     : return "tbody"     ;
		case TBODY_END       : return "tbody"     ;
		case TFOOT_START     : return "tfoot"     ;
		case TFOOT_END       : return "tfoot"     ;
		case TR_START        : return "tr"        ;
		case TR_END          : return "tr"        ;
		case TH_START        : return "th"        ;
		case TH_END          : return "th"        ;
		case TD_START        : return "td"        ;
		case TD_END          : return "td"        ;
		// table
		case FORM_START      : return "form"      ;
		case FORM_END        : return "form"      ;
		case INPUT           : return "input"     ;
		case SELECT_START    : return "select"    ;
		case SELECT_END      : return "select"    ;
		case OPTGROUP_START  : return "optgroup"  ;
		case OPTGROUP_END    : return "optgroup"  ;
		case OPTION_START    : return "option"    ;
		case OPTION_END      : return "option"    ;
		case TEXTAREA_START  : return "textarea"  ;
		case TEXTAREA_END    : return "textarea"  ;
		case BUTTON_START    : return "button"    ;
		case BUTTON_END      : return "button"    ;
		case FIELDSET_START  : return "fieldset"  ;
		case FIELDSET_END    : return "fieldset"  ;
		case LEGEND_START    : return "legend"    ;
		case LEGEND_END      : return "legend"    ;
		case LABEL_START     : return "label"     ;
		case LABEL_END       : return "label"     ;
		}
		
		return null;
	}
	
	/**
	 * ꤵ줿ʸ󤫤顢פ֤ޤ
	 * 
	 * @param     name ʸ
	 * 
	 * @return    ס
	 *            ʾ <code>UNKNOWN</code>
	 */
	public static final int getType(String name)
	{
		Integer i = (Integer)names.get(name.toUpperCase());
		
		if (i != null)
			return i.intValue();
		
		return UNKNOWN;
	}
	
	/** Ū */
	static {
		int[] typeList = {
			HTML_START      ,
			HTML_END        ,
			// header
			HEAD_START      ,
			HEAD_END        ,
			
			TITLE_START     ,
			TITLE_END       ,
			BASE            ,
			SCRIPT_START    ,
			SCRIPT_END      ,
			STYLE_START     ,
			STYLE_END       ,
			META            ,
			LINK            ,
			// frames
			FRAMESET_START  ,
			FRAMESET_END    ,
			FRAME           ,
			NOFRAMES_START  ,
			NOFRAMES_END    ,
			// body
			BODY_START      ,
			BODY_END        ,
			// block
			P_START         ,
			P_END           ,
			H1_START        ,
			H1_END          ,
			H2_START        ,
			H2_END          ,
			H3_START        ,
			H3_END          ,
			H4_START        ,
			H4_END          ,
			H5_START        ,
			H5_END          ,
			H6_START        ,
			H6_END          ,
			UL_START        ,
			UL_END          ,
			OL_START        ,
			OL_END          ,
			DIR_START       ,
			DIR_END         ,
			MENU_START      ,
			MENU_END        ,
			LI_START        ,
			LI_END          ,
			DL_START        ,
			DL_END          ,
			DT_START        ,
			DT_END          ,
			DD_START        ,
			DD_END          ,
			PRE_START       ,
			PRE_END         ,
			DIV_START       ,
			DIV_END         ,
			BLOCKQUOTE_START,
			BLOCKQUOTE_END  ,
			HR              ,
			ADDRESS_START   ,
			ADDRESS_END     ,
			CENTER_START    ,
			CENTER_END      ,
			//_BLOCK_START    ,
			//_BLOCK_END      ,
			// inline
			A_START         ,
			A_END           ,
			IMG             ,
			BR              ,
			SPAN_START      ,
			SPAN_END        ,
			EM_START        ,
			EM_END          ,
			STRONG_START    ,
			STRONG_END      ,
			DFN_START       ,
			DFN_END         ,
			CODE_START      ,
			CODE_END        ,
			Q_START         ,
			Q_END           ,
			SUB_START       ,
			SUB_END         ,
			SUP_START       ,
			SUP_END         ,
			SAMP_START      ,
			SAMP_END        ,
			KBD_START       ,
			KBD_END         ,
			VAR_START       ,
			VAR_END         ,
			CITE_START      ,
			CITE_END        ,
			ABBR_START      ,
			ABBR_END        ,
			ACRONYM_START   ,
			ACRONYM_END     ,
			TT_START        ,
			TT_END          ,
			I_START         ,
			I_END           ,
			B_START         ,
			B_END           ,
			BIG_START       ,
			BIG_END         ,
			SMALL_START     ,
			SMALL_END       ,
			U_START         ,
			U_END           ,
			S_START         ,
			S_END           ,
			STRIKE_START    ,
			STRIKE_END      ,
			FONT_START      ,
			FONT_END        ,
			NOSCRIPT_START  ,
			NOSCRIPT_END    ,
			// ruby
			RUBY_START      ,
			RUBY_END        ,
			RB_START        ,
			RB_END          ,
			RP_START        ,
			RP_END          ,
			RT_START        ,
			RT_END          ,
			// table
			TABLE_START     ,
			TABLE_END       ,
			CAPTION_START   ,
			CAPTION_END     ,
			THEAD_START     ,
			THEAD_END       ,
			TBODY_START     ,
			TBODY_END       ,
			TFOOT_START     ,
			TFOOT_END       ,
			TR_START        ,
			TR_END          ,
			TH_START        ,
			TH_END          ,
			TD_START        ,
			TD_END          ,
			// form
			FORM_START      ,
			FORM_END        ,
			INPUT           ,
			SELECT_START    ,
			SELECT_END      ,
			OPTGROUP_START  ,
			OPTGROUP_END    ,
			OPTION_START    ,
			OPTION_END      ,
			TEXTAREA_START  ,
			TEXTAREA_END    ,
			BUTTON_START    ,
			BUTTON_END      ,
			FIELDSET_START  ,
			FIELDSET_END    ,
			LEGEND_START    ,
			LEGEND_END      ,
			LABEL_START     ,
			LABEL_END       ,
		};
		String[] nameList = {
			"HTML_START"      ,
			"HTML_END"        ,
			// header
			"HEAD_START"      ,
			"HEAD_END"        ,
			
			"TITLE_START"     ,
			"TITLE_END"       ,
			"BASE_START"      ,
			"SCRIPT_START"    ,
			"SCRIPT_END"      ,
			"STYLE_START"     ,
			"STYLE_END"       ,
			"META_START"      ,
			"LINK_START"      ,
			// frame
			"FRAMESET_START"  ,
			"FRAMESET_END"    ,
			"FRAME_START"     ,
			"NOFRAMES_START"  ,
			"NOFRAMES_END"    ,
			// body
			"BODY_START"      ,
			"BODY_END"        ,
			// block
			"P_START"         ,
			"P_END"           ,
			"H1_START"        ,
			"H1_END"          ,
			"H2_START"        ,
			"H2_END"          ,
			"H3_START"        ,
			"H3_END"          ,
			"H4_START"        ,
			"H4_END"          ,
			"H5_START"        ,
			"H5_END"          ,
			"H6_START"        ,
			"H6_END"          ,
			"UL_START"        ,
			"UL_END"          ,
			"OL_START"        ,
			"OL_END"          ,
			"DIR_START"       ,
			"DIR_END"         ,
			"MENU_START"      ,
			"MENU_END"        ,
			"LI_START"        ,
			"LI_END"          ,
			"DL_START"        ,
			"DL_END"          ,
			"DT_START"        ,
			"DT_END"          ,
			"DD_START"        ,
			"DD_END"          ,
			"PRE_START"       ,
			"PRE_END"         ,
			"DIV_START"       ,
			"DIV_END"         ,
			"BLOCKQUOTE_START",
			"BLOCKQUOTE_END"  ,
			"HR_START"        ,
			"ADDRESS_START"   ,
			"ADDRESS_END"     ,
			"CENTER_START"    ,
			"CENTER_END"      ,
			//"_BLOCK_START"    ,
			//"_BLOCK_START"    ,
			// inline
			"A_START"         ,
			"A_END"           ,
			"IMG_START"       ,
			"BR_START"        ,
			"SPAN_START"      ,
			"SPAN_END"        ,
			"EM_START"        ,
			"EM_END"          ,
			"STRONG_START"    ,
			"STRONG_END"      ,
			"DFN_START"       ,
			"DFN_END"         ,
			"CODE_START"      ,
			"CODE_END"        ,
			"Q_START"         ,
			"Q_END"           ,
			"SUB_START"       ,
			"SUB_END"         ,
			"SUP_START"       ,
			"SUP_END"         ,
			"SAMP_START"      ,
			"SAMP_END"        ,
			"KBD_START"       ,
			"KBD_END"         ,
			"VAR_START"       ,
			"VAR_END"         ,
			"CITE_START"      ,
			"CITE_END"        ,
			"ABBR_START"      ,
			"ABBR_END"        ,
			"ACRONYM_START"   ,
			"ACRONYM_END"     ,
			"TT_START"        ,
			"TT_END"          ,
			"I_START"         ,
			"I_END"           ,
			"B_START"         ,
			"B_END"           ,
			"BIG_START"       ,
			"BIG_END"         ,
			"SMALL_START"     ,
			"SMALL_END"       ,
			"U_START"         ,
			"U_END"           ,
			"S_START"         ,
			"S_END"           ,
			"STRIKE_START"    ,
			"STRIKE_END"      ,
			"FONT_START"      ,
			"FONT_END"        ,
			"NOSCRIPT_START"  ,
			"NOSCRIPT_END"    ,
			// ruby
			"RUBY_START"      ,
			"RUBY_END"        ,
			"RB_START"        ,
			"RB_END"          ,
			"RP_START"        ,
			"RP_END"          ,
			"RT_START"        ,
			"RT_END"          ,
			// table
			"TABLE_START"     ,
			"TABLE_END"       ,
			"CAPTION_START"   ,
			"CAPTION_END"     ,
			"THEAD_START"     ,
			"THEAD_END"       ,
			"TBODY_START"     ,
			"TBODY_END"       ,
			"TFOOT_START"     ,
			"TFOOT_END"       ,
			"TR_START"        ,
			"TR_END"          ,
			"TH_START"        ,
			"TH_END"          ,
			"TD_START"        ,
			"TD_END"          ,
			// form
			"FORM_START"      ,
			"FORM_END"        ,
			"INPUT_START"     ,
			"SELECT_START"    ,
			"SELECT_END"      ,
			"OPTGROUP_START"  ,
			"OPTGROUP_END"    ,
			"OPTION_START"    ,
			"OPTION_END"      ,
			"TEXTAREA_START"  ,
			"TEXTAREA_END"    ,
			"BUTTON_START"    ,
			"BUTTON_END"      ,
			"FIELDSET_START"  ,
			"FIELDSET_END"    ,
			"LEGEND_START"    ,
			"LEGEND_END"      ,
			"LABEL_START"     ,
			"LABEL_END"       ,
		};
		
		if (typeList.length != nameList.length)
			throw new IllegalArgumentException("typelist != namelist");
		
		for (int i = 0; i < typeList.length; i++)
			names.put(nameList[i], new Integer(typeList[i]));
	}
}
