/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.util.TextFormat;

/**
 * ʸǡɽޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class TextToken
	extends Token
{
	private static final String TOKEN_NAME = "-strings-";     // ȡ̾
	private static final int    TOKEN_TYPE = TokenTypes.TEXT; // ȡ󥿥
	
	private String  text       = null;        // ƥ
	private String  thisString = null;        // Υȡʸɽ
	
	/**
	 * ʸǡޤ
	 * 
	 * @param     document ɥȾ
	 * @param     reporter 顼ݡ
	 * @param     line   ֹ (<code>1</code> )
	 *                   Ǥʤ <code>0</code>
	 * @param     column  (<code>1</code> )
	 *                   Ǥʤ <code>0</code>
	 * @param     text ʸǡ
	 */
	public TextToken(Document document, Reporter reporter, int line, int column, String text)
	{
		super(document, reporter, line, column);
		this.text = text;
	}
	
	/** {@inheritDoc} */
	public String getName()
	{
		return TOKEN_NAME;
	}
	
	/** {@inheritDoc} */
	public int getType()
	{
		return TOKEN_TYPE;
	}
	
	/**
	 * ʸǡ֤ޤ
	 * 
	 * @return    ʸǡ
	 */
	public String getText()
	{
		return text;
	}
	
	/**
	 * ʸʳʸäƤ뤫֤ޤ
	 * 
	 * @return    ʸʳʸäƤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public synchronized boolean hasCharacters()
	{
		return TextFormat.hasCharacters(text);
	}
	
	/**
	 * Υȡʸɽ֤ޤ
	 * 
	 * @return    ʸɽ
	 */
	public String toString()
	{
		if (thisString != null)
			return thisString;
		
		char[] c = new char[text.length()];
		text.getChars(0, c.length, c, 0);
		for (int i = 0; i < c.length; i++) {
			switch (c[i]) {
			case '\r': c[i] = ' ' ; continue;
			case '\n': c[i] = ''; continue;
			case '\t': c[i] = ''; continue;
			}
		}
		
		thisString = new String(c);
		
		return thisString;
	}
	
	/**
	 * ΥƥȥȡΥפ򸵤ˡԤޤ
	 * 
	 * @param     render 
	 */
	public void render(Render render)
	{
		render.drawText(text);
	}
}
