/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Status;

/**
 * ɽ󥿡եǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public interface Style
{
	/** ¾Υǥ */
	public static final int MEDIA__          = 0x000001;
	/** ԡ󥻥 */
	public static final int MEDIA_AURAL      = 0x000002;
	/** οեɥХåǥХ */
	public static final int MEDIA_BRAILLE    = 0x000004;
	/** ΥڡϤץ */
	public static final int MEDIA_EMBOSSED   = 0x000008;
	/** ݡ֥ǽǥХ */
	public static final int MEDIA_HANDHELD   = 0x000010;
	/** ڡդƩʪؤΰ䡢ץӥ塼⡼ɤβ */
	public static final int MEDIA_PRINT      = 0x000020;
	/** ̵ƩĤؤΰʤɡƤˤɽ */
	public static final int MEDIA_PROJECTION = 0x000040;
	/** ˥顼Υԥ塼 */
	public static final int MEDIA_SCREEN     = 0x000080;
	/** åζΰǼޤ롢ԥåʸѤ */
	public static final int MEDIA_TTY        = 0x000100;
	/** ƥӷΥǥХ */
	public static final int MEDIA_TV         = 0x000200;
	/** ٤ƤΥǥХ */
	public static final int MEDIA_ALL        = 0xFFFFFF;
	
	/**
	 * Υ򸵤ˡ襹ơѹޤ
	 * 
	 * @param     document ɥ
	 * @param     block    оݤ֥åξ <code>true</code>
	 *                     ʳξ <code>false</code>
	 * @param     status   襹ơ
	 */
	public abstract void changeStatus(Document document, boolean block, Status status);
}
