/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;

/**
 * UL,OL °ɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class LAttribute
	extends Attribute
{
	/** UL */
	public static final int TYPE_UL   = 0;
	/** OL */
	public static final int TYPE_OL   = 1;
	/** DIR */
	public static final int TYPE_DIR  = 2;
	/** MENU */
	public static final int TYPE_MENU = 3;
	
	private Integer attributeStart = null;
	private int     attributeType  = 0;
	
	/**
	 * UL,OL °ǥեͤǺޤ
	 * 
	 * @param     document ɥȾ
	 * @param     reporter 顼ݡ
	 * @param     line   ֹ (<code>1</code> )
	 *                   Ǥʤ <code>0</code>
	 * @param     column  (<code>1</code> )
	 *                   Ǥʤ <code>0</code>
	 * @param     ltype  {@link #TYPE_UL}  {@link #TYPE_OL}
	 */
	protected LAttribute(Document document, Reporter reporter, int line, int column, int ltype)
	{
		super(document, reporter, line, column);
		if (ltype == TYPE_OL)
			attributeType = Value.LIST_DECIMAL;
		else
			attributeType = Value.LIST_MIX;
	}
	
	/** {@inheritDoc} */
	public boolean setAttribute(String key, String value)
		throws IllegalArgumentException
	{
		if ("type".compareTo(key) == 0) {
			if (value.compareTo("1"     ) == 0) { attributeType  = Value.LIST_DECIMAL    ; return true; }
			if (value.compareTo("a"     ) == 0) { attributeType  = Value.LIST_LOWER_LATIN; return true; }
			if (value.compareTo("A"     ) == 0) { attributeType  = Value.LIST_UPPER_LATIN; return true; }
			if (value.compareTo("i"     ) == 0) { attributeType  = Value.LIST_LOWER_ROMAN; return true; }
			if (value.compareTo("I"     ) == 0) { attributeType  = Value.LIST_UPPER_ROMAN; return true; }
			value = value.toLowerCase();
			if (value.compareTo("disc"  ) == 0) { attributeType  = Value.LIST_DISC       ; return true; }
			if (value.compareTo("circle") == 0) { attributeType  = Value.LIST_CIRCLE     ; return true; }
			if (value.compareTo("square") == 0) { attributeType  = Value.LIST_SQUARE     ; return true; }
			return true;
		}
		if ("start".compareTo(key) == 0) { attributeStart = AttributeConverter.convertToInteger(value); return true; }
		
		return setBaseAttribute(key, value);
	}
	
//### Original Method
	/**
	 * פ֤ޤ
	 * 
	 * @return    
	 */
	public int getType()
	{
		return attributeType;
	}
	
	/**
	 * ֹ֤ޤ
	 * 
	 * @return    ֹ
	 */
	public Integer getStart()
	{
		return attributeStart;
	}
}
